/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.viewers.transfer;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.capella.common.ui.services.helper.AdapterManagerHelper;
import org.polarsys.capella.common.ui.toolkit.viewers.ITreeLabelAdapter;
import org.polarsys.capella.common.ui.toolkit.viewers.TreeAndListViewer;
import org.polarsys.capella.common.ui.toolkit.viewers.data.AbstractData;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataContentProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.ListData;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;
import org.polarsys.capella.common.ui.toolkit.viewers.transfer.AbstractTransferViewer2;

public class TransferTreeListViewer
extends AbstractTransferViewer2 {
    public TransferTreeListViewer(Composite parent, int style, int leftViewerStyleBits, int rightViewerStyleBits) {
        super(parent, style, leftViewerStyleBits, rightViewerStyleBits);
    }

    public TransferTreeListViewer(Composite parent, int style, int leftViewerStyleBits, int rightViewerStyleBits, int leftViewerExpandLevel, int rightViewerExpandLevel) {
        super(parent, style, leftViewerStyleBits, rightViewerStyleBits, leftViewerExpandLevel, rightViewerExpandLevel);
    }

    protected ListData createListDataWhenTreeViewModeClicked(TreeViewer viewer, List<?> displayedElements, Object context) {
        return new ListData((Collection<?>)displayedElements, context);
    }

    protected TreeData createTreeDataWhenTreeViewModeClicked(TreeViewer viewer, List<?> displayedElements, Object context) {
        return new TreeData(displayedElements, context);
    }

    @Override
    protected boolean doHandleAddAllButton() {
        boolean changed = false;
        List<Object> validElements = this.getLeftInput().getValidElements();
        this.applyViewerFilters((StructuredViewer)this.getLeftViewer(), this.getLeftContentProvider(), validElements);
        if (!validElements.isEmpty()) {
            changed = true;
            Object[] elements = validElements.toArray();
            this.getLeftContentProvider().inputChanged((Viewer)this.getLeftViewer(), elements, null);
            this.getRightContentProvider().inputChanged((Viewer)this.getRightViewer(), null, elements);
        }
        return changed;
    }

    @Override
    protected boolean doHandleRemoveAllButton() {
        boolean changed = false;
        List<Object> validElements = this.getRightInput().getValidElements();
        this.applyViewerFilters((StructuredViewer)this.getRightViewer(), this.getRightContentProvider(), validElements);
        if (!validElements.isEmpty()) {
            changed = true;
            Object[] elements = validElements.toArray();
            this.getLeftContentProvider().inputChanged((Viewer)this.getLeftViewer(), null, elements);
            this.getRightContentProvider().inputChanged((Viewer)this.getRightViewer(), elements, null);
        }
        return changed;
    }

    protected TreeViewer doLeftViewer(Composite composite) {
        TreeAndListViewer treeViewer = new TreeAndListViewer(composite, (2 & this.getLeftViewerStyleBits()) != 0, 4, this._leftViewerExpandLevel){

            @Override
            public String getContextMenuLocation() {
                return "org.polarsys.capella.common.ui.toolkit.dialogs.transferTreeListElements.leftPane";
            }
        };
        TreeViewer clientViewer = treeViewer.getClientViewer();
        clientViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (TransferTreeListViewer.this._addSelectedBtn.getEnabled()) {
                    TransferTreeListViewer.this.doHandleAddSelectedButton();
                }
            }
        });
        return clientViewer;
    }

    protected TreeViewer doRightViewer(Composite composite) {
        TreeAndListViewer treeViewer = new TreeAndListViewer(composite, (2 & this.getRightViewerStyleBits()) != 0, 4, this._rightViewerExpandLevel){

            @Override
            public String getContextMenuLocation() {
                return "org.polarsys.capella.common.ui.toolkit.dialogs.transferTreeListElements.rightPane";
            }
        };
        TreeViewer clientViewer = treeViewer.getClientViewer();
        clientViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (TransferTreeListViewer.this._removeSelectedBtn.getEnabled()) {
                    TransferTreeListViewer.this.doHandleRemoveSelectedButton();
                }
            }
        });
        return treeViewer.getClientViewer();
    }

    public DataContentProvider getLeftContentProvider() {
        return (DataContentProvider)super.getLeftContentProvider();
    }

    @Override
    public AbstractData getLeftInput() {
        return (AbstractData)super.getLeftInput();
    }

    public TreeViewer getLeftViewer() {
        return (TreeViewer)super.getLeftViewer();
    }

    public DataContentProvider getRightContentProvider() {
        return (DataContentProvider)super.getRightContentProvider();
    }

    @Override
    public AbstractData getRightInput() {
        return (AbstractData)super.getRightInput();
    }

    public TreeViewer getRightViewer() {
        return (TreeViewer)super.getRightViewer();
    }

    @Override
    protected String handleStatusLineUpdate(Object selectedElement, SelectionChangedEvent event) {
        String result = null;
        ITreeLabelAdapter treeLabelAdapter = (ITreeLabelAdapter)AdapterManagerHelper.getAdapter(selectedElement, ITreeLabelAdapter.class);
        result = treeLabelAdapter != null ? treeLabelAdapter.getFullLabel() : super.handleStatusLineUpdate(selectedElement, event);
        return result;
    }

    protected void applyViewerFilters(StructuredViewer viewer, ITreeContentProvider provider, List<?> elements) {
        Iterator<?> it = elements.iterator();
        block0: while (it.hasNext()) {
            Object elem = it.next();
            ViewerFilter[] viewerFilterArray = viewer.getFilters();
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                if (!filter.select((Viewer)viewer, provider.getParent(elem), elem)) {
                    it.remove();
                    continue block0;
                }
                ++n2;
            }
        }
    }
}

