/*******************************************************************************
 * Copyright (c) 2006, 2020 THALES GLOBAL SERVICES.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.data.fa.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.polarsys.capella.common.data.activity.AbstractAction;
import org.polarsys.capella.common.data.activity.AbstractActivity;
import org.polarsys.capella.common.data.activity.AcceptEventAction;
import org.polarsys.capella.common.data.activity.ActivityGroup;
import org.polarsys.capella.common.data.activity.ActivityPackage;
import org.polarsys.capella.common.data.activity.CallAction;
import org.polarsys.capella.common.data.activity.InvocationAction;
import org.polarsys.capella.common.data.activity.SendSignalAction;
import org.polarsys.capella.common.data.activity.util.ActivitySwitch;
import org.polarsys.capella.core.data.capellamodeller.provider.CapellaModellerEditPlugin;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.util.FaAdapterFactory;
import org.polarsys.kitalpha.emde.extension.ModelExtensionHelper;
import org.polarsys.kitalpha.emde.extension.edit.ChildCreationExtenderManager;
import org.polarsys.kitalpha.emde.model.edit.provider.NewChildDescriptorHelper;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class FaItemProviderAdapterFactory extends FaAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This helps manage the child creation extenders.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(CapellaModellerEditPlugin.INSTANCE, FaPackage.eNS_URI);

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FaItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.FunctionSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionSpecificationItemProvider functionSpecificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.FunctionSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionSpecificationAdapter() {
		if (functionSpecificationItemProvider == null) {
			functionSpecificationItemProvider = new FunctionSpecificationItemProvider(this);
		}

		return functionSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.ExchangeCategory} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExchangeCategoryItemProvider exchangeCategoryItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.ExchangeCategory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExchangeCategoryAdapter() {
		if (exchangeCategoryItemProvider == null) {
			exchangeCategoryItemProvider = new ExchangeCategoryItemProvider(this);
		}

		return exchangeCategoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.ExchangeLink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExchangeLinkItemProvider exchangeLinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.ExchangeLink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExchangeLinkAdapter() {
		if (exchangeLinkItemProvider == null) {
			exchangeLinkItemProvider = new ExchangeLinkItemProvider(this);
		}

		return exchangeLinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.ExchangeContainment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExchangeContainmentItemProvider exchangeContainmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.ExchangeContainment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExchangeContainmentAdapter() {
		if (exchangeContainmentItemProvider == null) {
			exchangeContainmentItemProvider = new ExchangeContainmentItemProvider(this);
		}

		return exchangeContainmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.FunctionalExchangeSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionalExchangeSpecificationItemProvider functionalExchangeSpecificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.FunctionalExchangeSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionalExchangeSpecificationAdapter() {
		if (functionalExchangeSpecificationItemProvider == null) {
			functionalExchangeSpecificationItemProvider = new FunctionalExchangeSpecificationItemProvider(this);
		}

		return functionalExchangeSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.FunctionalChain} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionalChainItemProvider functionalChainItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.FunctionalChain}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionalChainAdapter() {
		if (functionalChainItemProvider == null) {
			functionalChainItemProvider = new FunctionalChainItemProvider(this);
		}

		return functionalChainItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.FunctionalChainReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionalChainReferenceItemProvider functionalChainReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.FunctionalChainReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionalChainReferenceAdapter() {
		if (functionalChainReferenceItemProvider == null) {
			functionalChainReferenceItemProvider = new FunctionalChainReferenceItemProvider(this);
		}

		return functionalChainReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.FunctionInputPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionInputPortItemProvider functionInputPortItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.FunctionInputPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionInputPortAdapter() {
		if (functionInputPortItemProvider == null) {
			functionInputPortItemProvider = new FunctionInputPortItemProvider(this);
		}

		return functionInputPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.FunctionOutputPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionOutputPortItemProvider functionOutputPortItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.FunctionOutputPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionOutputPortAdapter() {
		if (functionOutputPortItemProvider == null) {
			functionOutputPortItemProvider = new FunctionOutputPortItemProvider(this);
		}

		return functionOutputPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentFunctionalAllocationItemProvider componentFunctionalAllocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentFunctionalAllocationAdapter() {
		if (componentFunctionalAllocationItemProvider == null) {
			componentFunctionalAllocationItemProvider = new ComponentFunctionalAllocationItemProvider(this);
		}

		return componentFunctionalAllocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.FunctionalChainRealization} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionalChainRealizationItemProvider functionalChainRealizationItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.FunctionalChainRealization}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionalChainRealizationAdapter() {
		if (functionalChainRealizationItemProvider == null) {
			functionalChainRealizationItemProvider = new FunctionalChainRealizationItemProvider(this);
		}

		return functionalChainRealizationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.FunctionalExchangeRealization} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionalExchangeRealizationItemProvider functionalExchangeRealizationItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.FunctionalExchangeRealization}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionalExchangeRealizationAdapter() {
		if (functionalExchangeRealizationItemProvider == null) {
			functionalExchangeRealizationItemProvider = new FunctionalExchangeRealizationItemProvider(this);
		}

		return functionalExchangeRealizationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.FunctionRealization} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionRealizationItemProvider functionRealizationItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.FunctionRealization}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionRealizationAdapter() {
		if (functionRealizationItemProvider == null) {
			functionRealizationItemProvider = new FunctionRealizationItemProvider(this);
		}

		return functionRealizationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.FunctionalExchange} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionalExchangeItemProvider functionalExchangeItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.FunctionalExchange}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionalExchangeAdapter() {
		if (functionalExchangeItemProvider == null) {
			functionalExchangeItemProvider = new FunctionalExchangeItemProvider(this);
		}

		return functionalExchangeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.ComponentExchange} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentExchangeItemProvider componentExchangeItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.ComponentExchange}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentExchangeAdapter() {
		if (componentExchangeItemProvider == null) {
			componentExchangeItemProvider = new ComponentExchangeItemProvider(this);
		}

		return componentExchangeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.ComponentExchangeAllocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentExchangeAllocationItemProvider componentExchangeAllocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.ComponentExchangeAllocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentExchangeAllocationAdapter() {
		if (componentExchangeAllocationItemProvider == null) {
			componentExchangeAllocationItemProvider = new ComponentExchangeAllocationItemProvider(this);
		}

		return componentExchangeAllocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.ComponentExchangeCategory} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentExchangeCategoryItemProvider componentExchangeCategoryItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.ComponentExchangeCategory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentExchangeCategoryAdapter() {
		if (componentExchangeCategoryItemProvider == null) {
			componentExchangeCategoryItemProvider = new ComponentExchangeCategoryItemProvider(this);
		}

		return componentExchangeCategoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.ComponentExchangeEnd} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentExchangeEndItemProvider componentExchangeEndItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.ComponentExchangeEnd}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentExchangeEndAdapter() {
		if (componentExchangeEndItemProvider == null) {
			componentExchangeEndItemProvider = new ComponentExchangeEndItemProvider(this);
		}

		return componentExchangeEndItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentExchangeFunctionalExchangeAllocationItemProvider componentExchangeFunctionalExchangeAllocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentExchangeFunctionalExchangeAllocationAdapter() {
		if (componentExchangeFunctionalExchangeAllocationItemProvider == null) {
			componentExchangeFunctionalExchangeAllocationItemProvider = new ComponentExchangeFunctionalExchangeAllocationItemProvider(this);
		}

		return componentExchangeFunctionalExchangeAllocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.ComponentExchangeRealization} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentExchangeRealizationItemProvider componentExchangeRealizationItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.ComponentExchangeRealization}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentExchangeRealizationAdapter() {
		if (componentExchangeRealizationItemProvider == null) {
			componentExchangeRealizationItemProvider = new ComponentExchangeRealizationItemProvider(this);
		}

		return componentExchangeRealizationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.ComponentPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentPortItemProvider componentPortItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.ComponentPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentPortAdapter() {
		if (componentPortItemProvider == null) {
			componentPortItemProvider = new ComponentPortItemProvider(this);
		}

		return componentPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.ComponentPortAllocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentPortAllocationItemProvider componentPortAllocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.ComponentPortAllocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentPortAllocationAdapter() {
		if (componentPortAllocationItemProvider == null) {
			componentPortAllocationItemProvider = new ComponentPortAllocationItemProvider(this);
		}

		return componentPortAllocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.ComponentPortAllocationEnd} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentPortAllocationEndItemProvider componentPortAllocationEndItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.ComponentPortAllocationEnd}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentPortAllocationEndAdapter() {
		if (componentPortAllocationEndItemProvider == null) {
			componentPortAllocationEndItemProvider = new ComponentPortAllocationEndItemProvider(this);
		}

		return componentPortAllocationEndItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionalChainInvolvementLinkItemProvider functionalChainInvolvementLinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionalChainInvolvementLinkAdapter() {
		if (functionalChainInvolvementLinkItemProvider == null) {
			functionalChainInvolvementLinkItemProvider = new FunctionalChainInvolvementLinkItemProvider(this);
		}

		return functionalChainInvolvementLinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.SequenceLink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SequenceLinkItemProvider sequenceLinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.SequenceLink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSequenceLinkAdapter() {
		if (sequenceLinkItemProvider == null) {
			sequenceLinkItemProvider = new SequenceLinkItemProvider(this);
		}

		return sequenceLinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionalChainInvolvementFunctionItemProvider functionalChainInvolvementFunctionItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionalChainInvolvementFunctionAdapter() {
		if (functionalChainInvolvementFunctionItemProvider == null) {
			functionalChainInvolvementFunctionItemProvider = new FunctionalChainInvolvementFunctionItemProvider(this);
		}

		return functionalChainInvolvementFunctionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.fa.ControlNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ControlNodeItemProvider controlNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.fa.ControlNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createControlNodeAdapter() {
		if (controlNodeItemProvider == null) {
			controlNodeItemProvider = new ControlNodeItemProvider(this);
		}

		return controlNodeItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List<IChildCreationExtender> getChildCreationExtenders() {
		return childCreationExtenderManager.getChildCreationExtenders();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
		return childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return childCreationExtenderManager;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (functionSpecificationItemProvider != null) functionSpecificationItemProvider.dispose();
		if (exchangeCategoryItemProvider != null) exchangeCategoryItemProvider.dispose();
		if (exchangeLinkItemProvider != null) exchangeLinkItemProvider.dispose();
		if (exchangeContainmentItemProvider != null) exchangeContainmentItemProvider.dispose();
		if (functionalExchangeSpecificationItemProvider != null) functionalExchangeSpecificationItemProvider.dispose();
		if (functionalChainItemProvider != null) functionalChainItemProvider.dispose();
		if (functionalChainReferenceItemProvider != null) functionalChainReferenceItemProvider.dispose();
		if (functionInputPortItemProvider != null) functionInputPortItemProvider.dispose();
		if (functionOutputPortItemProvider != null) functionOutputPortItemProvider.dispose();
		if (componentFunctionalAllocationItemProvider != null) componentFunctionalAllocationItemProvider.dispose();
		if (functionalChainRealizationItemProvider != null) functionalChainRealizationItemProvider.dispose();
		if (functionalExchangeRealizationItemProvider != null) functionalExchangeRealizationItemProvider.dispose();
		if (functionRealizationItemProvider != null) functionRealizationItemProvider.dispose();
		if (functionalExchangeItemProvider != null) functionalExchangeItemProvider.dispose();
		if (componentExchangeItemProvider != null) componentExchangeItemProvider.dispose();
		if (componentExchangeAllocationItemProvider != null) componentExchangeAllocationItemProvider.dispose();
		if (componentExchangeCategoryItemProvider != null) componentExchangeCategoryItemProvider.dispose();
		if (componentExchangeEndItemProvider != null) componentExchangeEndItemProvider.dispose();
		if (componentExchangeFunctionalExchangeAllocationItemProvider != null) componentExchangeFunctionalExchangeAllocationItemProvider.dispose();
		if (componentExchangeRealizationItemProvider != null) componentExchangeRealizationItemProvider.dispose();
		if (componentPortItemProvider != null) componentPortItemProvider.dispose();
		if (componentPortAllocationItemProvider != null) componentPortAllocationItemProvider.dispose();
		if (componentPortAllocationEndItemProvider != null) componentPortAllocationEndItemProvider.dispose();
		if (functionalChainInvolvementLinkItemProvider != null) functionalChainInvolvementLinkItemProvider.dispose();
		if (sequenceLinkItemProvider != null) sequenceLinkItemProvider.dispose();
		if (functionalChainInvolvementFunctionItemProvider != null) functionalChainInvolvementFunctionItemProvider.dispose();
		if (controlNodeItemProvider != null) controlNodeItemProvider.dispose();
	}

	/**
	 * A child creation extender for the {@link ActivityPackage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static class ActivityChildCreationExtender implements IChildCreationExtender {
		/**
		 * The switch for creating child descriptors specific to each extended class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		protected static class CreationSwitch extends ActivitySwitch<Object> {
			/**
			 * The child descriptors being populated.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected List<Object> newChildDescriptors;

			/**
			 * The domain in which to create the children.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected EditingDomain editingDomain;

			/**
			 * Creates the a switch for populating child descriptors in the given domain.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain) {
				this.newChildDescriptors = newChildDescriptors;
				this.editingDomain = editingDomain;
			}
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseAbstractActivity(AbstractActivity object) {
				// begin-extension-code
				if (ModelExtensionHelper.getInstance(object).isExtensionModelDisabled(EcoreUtil.getRootContainer(object).eClass().getEPackage().getNsURI(), "http://www.polarsys.org/capella/core/fa/6.0.0")) { //$NON-NLS-1$
					return null;				
				}
				// end-extension-code
                // begin-extension-code
                {
                    CommandParameter commandParameter = createChildParameter
                        (ActivityPackage.Literals.ABSTRACT_ACTIVITY__OWNED_NODES,
                         FaFactory.eINSTANCE.createFunctionInputPort());
                    if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
                        newChildDescriptors.add(commandParameter);      
                    }
                }
                // end-extension-code



                // begin-extension-code
                {
                    CommandParameter commandParameter = createChildParameter
                        (ActivityPackage.Literals.ABSTRACT_ACTIVITY__OWNED_NODES,
                         FaFactory.eINSTANCE.createFunctionOutputPort());
                    if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
                        newChildDescriptors.add(commandParameter);      
                    }
                }
                // end-extension-code



                // begin-extension-code
                {
                    CommandParameter commandParameter = createChildParameter
                        (ActivityPackage.Literals.ABSTRACT_ACTIVITY__OWNED_EDGES,
                         FaFactory.eINSTANCE.createFunctionalExchange());
                    if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
                        newChildDescriptors.add(commandParameter);      
                    }
                }
                // end-extension-code



				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseActivityGroup(ActivityGroup object) {
				// begin-extension-code
				if (ModelExtensionHelper.getInstance(object).isExtensionModelDisabled(EcoreUtil.getRootContainer(object).eClass().getEPackage().getNsURI(), "http://www.polarsys.org/capella/core/fa/6.0.0")) { //$NON-NLS-1$
					return null;				
				}
				// end-extension-code
                // begin-extension-code
                {
                    CommandParameter commandParameter = createChildParameter
                        (ActivityPackage.Literals.ACTIVITY_GROUP__OWNED_NODES,
                         FaFactory.eINSTANCE.createFunctionInputPort());
                    if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
                        newChildDescriptors.add(commandParameter);      
                    }
                }
                // end-extension-code



                // begin-extension-code
                {
                    CommandParameter commandParameter = createChildParameter
                        (ActivityPackage.Literals.ACTIVITY_GROUP__OWNED_NODES,
                         FaFactory.eINSTANCE.createFunctionOutputPort());
                    if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
                        newChildDescriptors.add(commandParameter);      
                    }
                }
                // end-extension-code



                // begin-extension-code
                {
                    CommandParameter commandParameter = createChildParameter
                        (ActivityPackage.Literals.ACTIVITY_GROUP__OWNED_EDGES,
                         FaFactory.eINSTANCE.createFunctionalExchange());
                    if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
                        newChildDescriptors.add(commandParameter);      
                    }
                }
                // end-extension-code



				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseAbstractAction(AbstractAction object) {
				// begin-extension-code
				if (ModelExtensionHelper.getInstance(object).isExtensionModelDisabled(EcoreUtil.getRootContainer(object).eClass().getEPackage().getNsURI(), "http://www.polarsys.org/capella/core/fa/6.0.0")) { //$NON-NLS-1$
					return null;				
				}
				// end-extension-code
                // begin-extension-code
                {
                    CommandParameter commandParameter = createChildParameter
                        (ActivityPackage.Literals.ABSTRACT_ACTION__INPUTS,
                         FaFactory.eINSTANCE.createFunctionInputPort());
                    if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
                        newChildDescriptors.add(commandParameter);      
                    }
                }
                // end-extension-code



                // begin-extension-code
                {
                    CommandParameter commandParameter = createChildParameter
                        (ActivityPackage.Literals.ABSTRACT_ACTION__OUTPUTS,
                         FaFactory.eINSTANCE.createFunctionOutputPort());
                    if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
                        newChildDescriptors.add(commandParameter);      
                    }
                }
                // end-extension-code



				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseAcceptEventAction(AcceptEventAction object) {
				// begin-extension-code
				if (ModelExtensionHelper.getInstance(object).isExtensionModelDisabled(EcoreUtil.getRootContainer(object).eClass().getEPackage().getNsURI(), "http://www.polarsys.org/capella/core/fa/6.0.0")) { //$NON-NLS-1$
					return null;				
				}
				// end-extension-code
                // begin-extension-code
                {
                    CommandParameter commandParameter = createChildParameter
                        (ActivityPackage.Literals.ACCEPT_EVENT_ACTION__RESULT,
                         FaFactory.eINSTANCE.createFunctionOutputPort());
                    if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
                        newChildDescriptors.add(commandParameter);      
                    }
                }
                // end-extension-code



				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseInvocationAction(InvocationAction object) {
				// begin-extension-code
				if (ModelExtensionHelper.getInstance(object).isExtensionModelDisabled(EcoreUtil.getRootContainer(object).eClass().getEPackage().getNsURI(), "http://www.polarsys.org/capella/core/fa/6.0.0")) { //$NON-NLS-1$
					return null;				
				}
				// end-extension-code
                // begin-extension-code
                {
                    CommandParameter commandParameter = createChildParameter
                        (ActivityPackage.Literals.INVOCATION_ACTION__ARGUMENTS,
                         FaFactory.eINSTANCE.createFunctionInputPort());
                    if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
                        newChildDescriptors.add(commandParameter);      
                    }
                }
                // end-extension-code



				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseSendSignalAction(SendSignalAction object) {
				// begin-extension-code
				if (ModelExtensionHelper.getInstance(object).isExtensionModelDisabled(EcoreUtil.getRootContainer(object).eClass().getEPackage().getNsURI(), "http://www.polarsys.org/capella/core/fa/6.0.0")) { //$NON-NLS-1$
					return null;				
				}
				// end-extension-code
                // begin-extension-code
                {
                    CommandParameter commandParameter = createChildParameter
                        (ActivityPackage.Literals.SEND_SIGNAL_ACTION__TARGET,
                         FaFactory.eINSTANCE.createFunctionInputPort());
                    if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
                        newChildDescriptors.add(commandParameter);      
                    }
                }
                // end-extension-code



				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseCallAction(CallAction object) {
				// begin-extension-code
				if (ModelExtensionHelper.getInstance(object).isExtensionModelDisabled(EcoreUtil.getRootContainer(object).eClass().getEPackage().getNsURI(), "http://www.polarsys.org/capella/core/fa/6.0.0")) { //$NON-NLS-1$
					return null;				
				}
				// end-extension-code
                // begin-extension-code
                {
                    CommandParameter commandParameter = createChildParameter
                        (ActivityPackage.Literals.CALL_ACTION__RESULTS,
                         FaFactory.eINSTANCE.createFunctionOutputPort());
                    if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
                        newChildDescriptors.add(commandParameter);      
                    }
                }
                // end-extension-code



				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected CommandParameter createChildParameter(Object feature, Object child) {
				return new CommandParameter(null, feature, child);
			}

		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
			ArrayList<Object> result = new ArrayList<Object>();
			new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
			return result;
		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public ResourceLocator getResourceLocator() {
			return CapellaModellerEditPlugin.INSTANCE;
		}
	}

}
