/*******************************************************************************
 * Copyright (c) 2006, 2021 THALES GLOBAL SERVICES.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.sirius.ui.handlers;

import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.common.ui.services.commands.AbstractUiHandler;

/**
 */
public abstract class AbstractDiagramCommandHandler extends AbstractUiHandler {

  protected IStructuredSelection getSelection() {
    IWorkbenchPart activePart = null;
    IWorkbench workbench = PlatformUI.getWorkbench();
    if (workbench != null) {
      IWorkbenchWindow windows = workbench.getActiveWorkbenchWindow();
      if (windows != null) {
        IWorkbenchPage page = windows.getActivePage();
        if (page != null) {
          activePart = page.getActivePart();
        }
      }
    }

    if (activePart != null) {
      ISelectionProvider selectionProvider = activePart.getSite().getSelectionProvider();
      if (selectionProvider != null) {
        ISelection selection = selectionProvider.getSelection();
        if (selection instanceof IStructuredSelection) {
          return (IStructuredSelection) selection;
        }
      }
    }
    return new StructuredSelection();
  }

  @Override
  public boolean isEnabled() {
    IStructuredSelection selection = getSelection();
    if (selection.size() == 0) {
      return false;
    }
    List<Couple<Session, IFile>> sessions = org.polarsys.capella.core.sirius.ui.helper.SessionHelper.getSessionsFromSelection(selection);
    return (sessions.size() == selection.size());

  }
}
