/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.core.validation.capellaelement.nameconflict;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.model.utils.CapellaSwitch;
import org.polarsys.capella.core.model.utils.NamingHelper;

public class DefaultNameConflictConstraint
extends AbstractModelConstraint {
    private CapellaSwitch<?> signatureSwitch;
    private CapellaSwitch<?> slotSwitch;

    public DefaultNameConflictConstraint(CapellaSwitch<?> signatureSwitch, CapellaSwitch<?> slotSwitch) {
        this.slotSwitch = slotSwitch;
        this.signatureSwitch = signatureSwitch;
    }

    public IStatus validate(IValidationContext ctx) {
        HashMap<Object, ArrayList<EObject>> slotEntries;
        EMFEventType eType = ctx.getEventType();
        if (eType != EMFEventType.NULL) {
            return Status.OK_STATUS;
        }
        IStatus result = Status.OK_STATUS;
        EObject container = ctx.getTarget();
        HashMap symbols = new HashMap();
        for (EObject child : container.eContents()) {
            Object signature;
            if (child instanceof CommunicationMean) continue;
            Object slot = this.slotSwitch.doSwitch(child);
            slotEntries = (HashMap<Object, ArrayList<EObject>>)symbols.get(slot);
            if (slotEntries == null) {
                slotEntries = new HashMap<Object, ArrayList<EObject>>();
                symbols.put(slot, slotEntries);
            }
            if ((signature = this.signatureSwitch.doSwitch(child)) == null || signature.equals("") || signature instanceof String && ((String)signature).equalsIgnoreCase("null")) continue;
            ArrayList<EObject> objectsForSignature = (ArrayList<EObject>)slotEntries.get(signature);
            if (objectsForSignature == null) {
                objectsForSignature = new ArrayList<EObject>();
                slotEntries.put(signature, objectsForSignature);
            }
            objectsForSignature.add(child);
        }
        ArrayList<IStatus> problems = new ArrayList<IStatus>();
        for (Map.Entry symbol : symbols.entrySet()) {
            slotEntries = (Map)symbol.getValue();
            for (Map.Entry slotEntry : slotEntries.entrySet()) {
                List objectsForSignature = (List)slotEntry.getValue();
                if (objectsForSignature.size() <= 1) continue;
                ctx.addResults((Collection)objectsForSignature);
                IStatus status = this.doCreateFailureStatus(ctx, container, objectsForSignature);
                problems.add(status);
            }
        }
        if (problems.size() > 0) {
            result = ConstraintStatus.createMultiStatus((IValidationContext)ctx, problems);
        }
        return result;
    }

    protected IStatus doCreateFailureStatus(IValidationContext ctx, EObject container, List<EObject> conflictingChildren) {
        StringBuilder builder = new StringBuilder();
        for (EObject child : conflictingChildren) {
            builder.append(", ");
            builder.append(NamingHelper.getValue((EObject)child, null));
        }
        String result = builder.substring(2);
        return ctx.createFailureStatus(new Object[]{NamingHelper.getValue((EObject)container, null), conflictingChildren.size(), result});
    }
}

