/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.Logger;
import org.eclipse.emf.diffmerge.EMFDiffMergePlugin;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.log.DiffMergeLogger;
import org.eclipse.emf.diffmerge.ui.setup.ComparisonSetupManager;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EMFDiffMergeUIPlugin
extends AbstractUIPlugin {
    public static final String UI_DIFF_DATA_FILE_EXTENSION = "edm";
    protected static final String ICON_PATH = "icons/full/";
    public static final String LABEL = Messages.EMFDiffMergeUIPlugin_Label;
    private static EMFDiffMergeUIPlugin __plugin;
    private final ComparisonSetupManager _comparisonSetupManager;
    private final DiffMergeLogger _diffMergeLogger = new DiffMergeLogger();
    private final EReference _ownershipFeature;
    private Color _veryDarkGray = null;
    private AdapterFactoryLabelProvider _composedAdapterFactoryLabelProvider = null;
    private final Map<ImageID, String> _sharedImageMap;

    public EMFDiffMergeUIPlugin() {
        this._comparisonSetupManager = new ComparisonSetupManager();
        this._ownershipFeature = this.createOwnershipFeature();
        this._sharedImageMap = this.createImageMap();
    }

    protected Map<ImageID, String> createImageMap() {
        HashMap<ImageID, String> result = new HashMap<ImageID, String>();
        result.put(ImageID.DELETE, "IMG_TOOL_DELETE");
        result.put(ImageID.LEFT, "IMG_TOOL_BACK");
        result.put(ImageID.REDO, "IMG_TOOL_REDO");
        result.put(ImageID.RIGHT, "IMG_TOOL_FORWARD");
        result.put(ImageID.SHOW, "IMG_OBJS_INFO_TSK");
        result.put(ImageID.UNDO, "IMG_TOOL_UNDO");
        result.put(ImageID.WARNING, "IMG_OBJS_WARN_TSK");
        return result;
    }

    protected EReference createOwnershipFeature() {
        EReference result = EcoreFactory.eINSTANCE.createEReference();
        result.setName("container");
        result.setEType((EClassifier)EcorePackage.eINSTANCE.getEObject());
        result.setLowerBound(0);
        result.setUpperBound(1);
        return result;
    }

    public AdapterFactoryLabelProvider getAdapterFactoryLabelProvider() {
        if (this._composedAdapterFactoryLabelProvider == null) {
            this._composedAdapterFactoryLabelProvider = new AdapterFactoryLabelProvider(EMFDiffMergePlugin.getDefault().getAdapterFactory());
        }
        return this._composedAdapterFactoryLabelProvider;
    }

    public static EMFDiffMergeUIPlugin getDefault() {
        return __plugin;
    }

    public Role getDefaultLeftRole() {
        return Role.TARGET;
    }

    public Logger getDiffMergeLogger() {
        return this._diffMergeLogger;
    }

    public Image getImage(ImageID id_p) {
        String sharedID = this._sharedImageMap.get((Object)id_p);
        Image result = sharedID != null ? PlatformUI.getWorkbench().getSharedImages().getImage(sharedID) : this.getImageRegistry().get(id_p.name());
        return result;
    }

    public ImageDescriptor getImageDescriptor(ImageID id_p) {
        String sharedID = this._sharedImageMap.get((Object)id_p);
        ImageDescriptor result = sharedID != null ? PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(sharedID) : this.getImageRegistry().getDescriptor(id_p.name());
        return result;
    }

    public EReference getOwnershipFeature() {
        return this._ownershipFeature;
    }

    public String getPluginId() {
        return this.getBundle().getSymbolicName();
    }

    public ComparisonSetupManager getSetupManager() {
        return this._comparisonSetupManager;
    }

    public Color getVeryDarkGray() {
        if (this._veryDarkGray == null) {
            this._veryDarkGray = new Color((Device)Display.getDefault(), 75, 75, 75);
        }
        return this._veryDarkGray;
    }

    protected void initializeImageRegistry(ImageRegistry reg_p) {
        super.initializeImageRegistry(reg_p);
        reg_p.put(ImageID.UP.name(), CompareUI.DESC_CTOOL_PREV);
        reg_p.put(ImageID.DOWN.name(), CompareUI.DESC_CTOOL_NEXT);
        HashSet<ImageID> toRegister = new HashSet<ImageID>(Arrays.asList(ImageID.values()));
        toRegister.removeAll(this._sharedImageMap.keySet());
        toRegister.removeAll(Arrays.asList(ImageID.DOWN, ImageID.UP));
        for (ImageID imageId : toRegister) {
            this.registerLocalIcon(imageId, reg_p);
        }
    }

    protected ImageDescriptor registerLocalIcon(ImageID imageID_p, ImageRegistry reg_p) {
        ImageDescriptor result = null;
        String path = ICON_PATH + imageID_p.toImageFileName();
        try {
            result = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)this.getBundle().getEntry(path)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result != null) {
            reg_p.put(imageID_p.name(), result);
        }
        return result;
    }

    public void start(BundleContext context_p) throws Exception {
        super.start(context_p);
        __plugin = this;
    }

    public void stop(BundleContext context_p) throws Exception {
        this._diffMergeLogger.close();
        if (this._veryDarkGray != null) {
            this._veryDarkGray.dispose();
        }
        if (this._composedAdapterFactoryLabelProvider != null) {
            this._composedAdapterFactoryLabelProvider.dispose();
        }
        __plugin = null;
        super.stop(context_p);
    }

    public static enum ImageID {
        CHECKED,
        CHECKED_DISABLED,
        CHECKIN_ACTION,
        CHECKOUT_ACTION,
        COLLAPSEALL,
        COMPARE,
        CONFLICT_STAT,
        DELETE,
        DOWN,
        EMPTY,
        EXPANDALL,
        FILTER(true),
        GIT_ADDED(true),
        GIT_DIRTY(true),
        GIT_REMOVED(true),
        GIT_STAGED(true),
        INC_STAT,
        INC_ADD_STAT,
        INC_REM_STAT,
        LEFT,
        LOCK,
        LOCK_CLOSED,
        LOCK_OPEN,
        MODIFIED_STAT,
        NEXT_CHANGE_NAV,
        NEXT_DIFF_NAV,
        OUT_STAT,
        OUT_ADD_STAT,
        OUT_REM_STAT,
        PLUS,
        PREV_CHANGE_NAV,
        PREV_DIFF_NAV,
        REDO,
        RIGHT,
        SHOW,
        SORT,
        SWAP,
        SYNCED,
        TREE,
        UNCHECKED,
        UNCHECKED_DISABLED,
        UNDO,
        UP,
        UPDATE,
        VIEW_MENU(true),
        WARNING;

        private boolean _isPNG;

        private ImageID() {
            this(false);
        }

        private ImageID(boolean isPNG_p) {
            this._isPNG = isPNG_p;
        }

        public String toImageFileName() {
            String ext = this._isPNG ? "png" : "gif";
            String result = String.valueOf(this.name().toLowerCase()) + '.' + ext;
            return result;
        }
    }
}

