/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.IEdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.activity.Pin;
import org.polarsys.capella.common.data.behavior.AbstractEvent;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.FinalizableElement;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.common.menu.dynamic.util.INamePrefixService;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.core.data.capellacommon.ChangeEvent;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacommon.StateEvent;
import org.polarsys.capella.core.data.capellacommon.StateTransition;
import org.polarsys.capella.core.data.capellacommon.TimeEvent;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.Allocation;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellacore.ModellingBlock;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellacore.PropertyValueGroup;
import org.polarsys.capella.core.data.capellacore.Relationship;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkCategory;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.ConfigurationItemPkg;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeCategory;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortAllocation;
import org.polarsys.capella.core.data.fa.ComponentPortAllocationEnd;
import org.polarsys.capella.core.data.fa.ComponentPortKind;
import org.polarsys.capella.core.data.fa.ControlNode;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.SequenceLink;
import org.polarsys.capella.core.data.fa.SequenceLinkEnd;
import org.polarsys.capella.core.data.helpers.cache.ModelCache;
import org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt;
import org.polarsys.capella.core.data.helpers.information.services.CommunicationLinkExt;
import org.polarsys.capella.core.data.helpers.information.services.ExchangeItemExt;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.MultiplicityElement;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.PortAllocation;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkExchanger;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.information.datatype.NumericType;
import org.polarsys.capella.core.data.information.datatype.PhysicalQuantity;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.data.information.util.PropertyNamingHelper;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.data.pa.deployment.PartDeploymentLink;
import org.polarsys.capella.core.diagram.helpers.ContextualDiagramHelper;
import org.polarsys.capella.core.diagram.helpers.DiagramHelper;
import org.polarsys.capella.core.diagram.helpers.traceability.DiagramTraceabilityHelper;
import org.polarsys.capella.core.diagram.helpers.traceability.IDiagramTraceability;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.helpers.AbstractDependenciesPkgExt;
import org.polarsys.capella.core.model.helpers.AssociationExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapabilityRealizationExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeCategoryExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ComponentPkgExt;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.model.helpers.PhysicalLinkCategoryExt;
import org.polarsys.capella.core.model.helpers.PortExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.sirius.analysis.ABServices;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.sirius.analysis.FunctionalChainServices;
import org.polarsys.capella.core.sirius.analysis.IBServices;
import org.polarsys.capella.core.sirius.analysis.InformationServices;
import org.polarsys.capella.core.sirius.analysis.Messages;
import org.polarsys.capella.core.sirius.analysis.ModeStateMachineServices;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.helpers.FilterHelper;
import org.polarsys.capella.core.sirius.analysis.queries.QueryIdentifierConstants;

public class CsServices {
    private static CsServices service = null;
    private static final String TRANSITION_TRACEABILITY = "org.polarsys.capella.core.transition.diagram";
    private static final String TRANSITION_TRACEABILITY_COMMAND = "org.polarsys.capella.core.transition.diagram";
    @Deprecated
    public static final String PREFERENCE_LISTENER_ID = "org.polarsys.capella.core.preferences.Listener";
    @Deprecated
    public static final String PREFERENCE_LISTENER_ID_PREFERENCE_MULTIPART = "multipart.allowed";
    @Deprecated
    public static final String[] PREFERENCE_LISTENER_ID_PREFERENCES = new String[]{"multipart.allowed"};
    @Deprecated
    public EObject preferenceListener = null;
    private ComponentExchangeWrapper connectionWrapper = null;
    private FunctionalExchangeWrapper functionalExchangeWrapper = null;
    private PortAllocationWrapper portAllocationWrapper = null;
    private ComponentPortAllocationWrapper componentPortAllocationWrapper = null;
    private PhysicalLinkWrapper linkWrapper = null;

    public static CsServices getService() {
        if (service == null) {
            service = new CsServices();
        }
        return service;
    }

    public boolean isValidInitializeDiagramFromExistingDiagram(DSemanticDecorator diagram) {
        return diagram instanceof DRepresentation;
    }

    public boolean isFilterInitializeDiagramFromExistingDiagram(DSemanticDecorator diagram) {
        if (!(diagram instanceof DRepresentation)) {
            return true;
        }
        IDiagramTraceability handler = DiagramTraceabilityHelper.getService().getTraceabilityHandler((DRepresentation)diagram, "org.polarsys.capella.core.transition.diagram");
        if (handler == null) {
            return true;
        }
        DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)((DRepresentation)diagram));
        if (handler.isRealizingable(descriptor)) {
            handler.dispose();
            return diagram instanceof DDiagram && (DiagramHelper.getService().isA((DRepresentation)((DDiagram)diagram), "System Architecture Blank") ? ((DDiagram)diagram).getOwnedDiagramElements().size() > 1 : (DiagramHelper.getService().isA((DRepresentation)((DDiagram)diagram), "Logical Architecture Blank") ? ((DDiagram)diagram).getOwnedDiagramElements().size() > 1 : !((DDiagram)diagram).getOwnedDiagramElements().isEmpty()));
        }
        return true;
    }

    public EObject initializeDiagramFromExistingDiagram(DSemanticDecorator diagram, DSemanticDecorator sourceDiagram) {
        Logger logger = Logger.getLogger((String)"Diagrams Management");
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (handlerService == null || commandService == null) {
            logger.error((Object)"Cannot access to diagram initialization tool");
            return diagram;
        }
        if (sourceDiagram == null) {
            logger.error((Object)"Cannot retrieve source diagram for diagram initialization");
            return diagram;
        }
        Command command = commandService.getCommand("org.polarsys.capella.core.transition.diagram");
        ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, null);
        EvaluationContext context = new EvaluationContext(null, Collections.singleton(sourceDiagram));
        context.addVariable("TARGET_DIAGRAM", (Object)diagram);
        try {
            handlerService.executeCommandInContext(parameterizedCommand, null, (IEvaluationContext)context);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException exception) {
            logger.error((Object)"Errors occured while diagram initialization", exception);
        }
        return diagram;
    }

    public List<DRepresentation> getScopeInitializeDiagramFromExistingDiagram(DRepresentation diagram) {
        ArrayList<DRepresentation> scope = new ArrayList<DRepresentation>();
        IDiagramTraceability handler = DiagramTraceabilityHelper.getService().getTraceabilityHandler(diagram, "org.polarsys.capella.core.transition.diagram");
        Session session = DiagramHelper.getService().getSession(diagram);
        DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
        for (DRepresentationDescriptor representationDescriptor : DialectManager.INSTANCE.getAllRepresentationDescriptors(session)) {
            if (!handler.isRealizable(representationDescriptor, descriptor) || scope.contains(representationDescriptor.getRepresentation())) continue;
            scope.add(representationDescriptor.getRepresentation());
        }
        handler.dispose();
        return scope;
    }

    public boolean isFilterContextualElement(EObject object, DDiagram diagram) {
        DRepresentationDescriptor descriptor = new DRepresentationQuery((DRepresentation)diagram).getRepresentationDescriptor();
        if (ContextualDiagramHelper.getService().hasContextualElements(descriptor)) {
            for (FilterDescription filter : diagram.getActivatedFilters()) {
                if (!"Show Contextual Elements".equals(filter.getName()) || !ContextualDiagramHelper.getService().getContextualElements(descriptor).contains(object)) continue;
                return true;
            }
        }
        return false;
    }

    public EObject setInterpreterVariable(EObject context, String name, EObject value) {
        InterpreterUtil.getInterpreter((EObject)context).setVariable(name, (Object)value);
        return context;
    }

    public EObject setInterpreterVariable(EObject context, String name, Collection<EObject> values) {
        InterpreterUtil.getInterpreter((EObject)context).setVariable(name, values);
        return context;
    }

    public Object getInterpreterVariable(EObject context, String name) {
        return InterpreterUtil.getInterpreter((EObject)context).getVariable(name);
    }

    @Deprecated
    public EObject setVariableA(EObject context, String name, EObject value) {
        return this.setInterpreterVariable(context, name, value);
    }

    @Deprecated
    public boolean isPreferenceEnabled(EObject object, String preference) {
        DSemanticDecorator decorator;
        if (object instanceof DSemanticDecorator && (decorator = (DSemanticDecorator)object).getTarget() instanceof ModelElement) {
            return this.isMultipartMode((ModelElement)decorator.getTarget());
        }
        return true;
    }

    public boolean isMultipartMode(ModelElement object) {
        return CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)object));
    }

    @Deprecated
    public EObject getPreferenceListener(EObject object) {
        return object;
    }

    public boolean myDebug(EObject object) {
        MessageDialog.openInformation(null, (String)object.getClass().getName(), (String)object.toString());
        return true;
    }

    public Collection<Component> getRelatedComponents(Interface itf) {
        return InterfaceExt.getRelatedComponents((Interface)itf);
    }

    public DSemanticDecorator getRelatedFunctionView(DSemanticDecorator element) {
        if (element.getTarget() instanceof AbstractFunction) {
            return element;
        }
        if (element.eContainer() instanceof DSemanticDecorator) {
            return this.getRelatedFunctionView((DSemanticDecorator)element.eContainer());
        }
        return null;
    }

    public DSemanticDecorator getRelatedPartView(DSemanticDecorator element) {
        if (element.getTarget() != null && (element.getTarget() instanceof Part || element.getTarget() instanceof Entity)) {
            return element;
        }
        if (element.eContainer() instanceof DSemanticDecorator) {
            return this.getRelatedPartView((DSemanticDecorator)element.eContainer());
        }
        return null;
    }

    public InformationsExchanger getRelatedPart(DSemanticDecorator element) {
        if (element.getTarget() != null && (element.getTarget() instanceof Part || element.getTarget() instanceof Entity)) {
            return (InformationsExchanger)element.getTarget();
        }
        if (element.eContainer() instanceof DSemanticDecorator) {
            return this.getRelatedPart((DSemanticDecorator)element.eContainer());
        }
        return null;
    }

    public Collection<CommunicationLinkExchanger> getRelatedExchangers(AbstractExchangeItem item) {
        return ExchangeItemExt.getRelatedExchangers((AbstractExchangeItem)item);
    }

    public Collection<Interface> getTIDInterfaces(Component root) {
        return this.getAllRelatedInterfaces(root);
    }

    public String getTIDInterfaceLabel(Interface itf) {
        return itf.getName();
    }

    public String getTIDLabel(EObject itf, EObject line, EObject column) {
        Component component = (Component)((DSemanticDecorator)column).getTarget();
        Interface relatedItf = (Interface)((DSemanticDecorator)line).getTarget();
        StringBuilder res = new StringBuilder();
        if (ComponentExt.getAllImplementedInterfaces((Component)component).contains(relatedItf)) {
            res.append(Messages.Diagram_TID_Implemented);
            res.append("\n");
        }
        if (ComponentExt.getAllUsedInterfaces((Component)component).contains(relatedItf)) {
            res.append(Messages.Diagram_TID_Used);
            res.append("\n");
        }
        if (ComponentExt.getAllProvidedInterfaces((Component)component).contains(relatedItf)) {
            res.append(Messages.Diagram_TID_Provided);
            res.append("\n");
        }
        if (ComponentExt.getAllRequiredInterfaces((Component)component).contains(relatedItf)) {
            res.append(Messages.Diagram_TID_Required);
            res.append("\n");
        }
        if (res.length() > 0) {
            res.deleteCharAt(res.length() - 1);
        }
        return res.toString();
    }

    public boolean isAnAncestor(EObject current, EObject parent) {
        EObject object = current;
        object = object.eContainer();
        while (object != null) {
            if (object == parent) {
                return true;
            }
            object = object.eContainer();
        }
        return false;
    }

    public boolean oneIsAncestorAnother(EObject current, EObject e1, EObject e2) {
        return EcoreUtil.isAncestor((EObject)e1, (EObject)e2) || EcoreUtil.isAncestor((EObject)e1, (EObject)e2);
    }

    public EObject getParentContainer(EObject current) {
        EObject object = current;
        object = current.eContainer();
        while (object != null) {
            if (object instanceof Component || object instanceof BlockArchitecture) {
                return object;
            }
            object = object.eContainer();
        }
        return null;
    }

    public EObject getSemanticParentContainer(EObject current, boolean isActorContext) {
        EObject object = current;
        object = current.eContainer();
        while (object != null) {
            if (object instanceof BlockArchitecture) {
                return object;
            }
            if (isActorContext ? ComponentExt.canCreateABActor((EObject)object) : ComponentExt.canCreateABComponent((EObject)object)) {
                return object;
            }
            object = object.eContainer();
        }
        return null;
    }

    public Collection<EObject> getParentContainers(EObject current) {
        LinkedList<EObject> elements = new LinkedList<EObject>();
        elements.add(current);
        return this.getParentContainers(elements);
    }

    protected Collection<EObject> getParentContainers(Collection<EObject> currents) {
        LinkedList<EObject> toVisits = new LinkedList<EObject>(currents);
        HashSet<EObject> parents = new HashSet<EObject>();
        while (!toVisits.isEmpty()) {
            EObject owner = toVisits.removeFirst();
            EObject parent = this.getParentContainer(owner);
            if (parent == null || parents.contains(parent)) continue;
            parents.add(parent);
            toVisits.addLast(parent);
        }
        return parents;
    }

    public EObject getFirstParentContainer(EObject current) {
        EObject object = current;
        while (object != null) {
            if (object instanceof Component || object instanceof BlockArchitecture) {
                return current;
            }
            object = object.eContainer();
        }
        return null;
    }

    public Collection<Component> getContainersOfParts(Component component) {
        HashSet<Component> containers = new HashSet<Component>();
        for (Part part : component.getRepresentingParts()) {
            EObject parent = this.getParentContainer((EObject)part);
            if (parent instanceof Component) {
                containers.add((Component)parent);
            }
            for (DeploymentTarget deploment : (List)ModelCache.getCache(PartExt::getDeployingElements, (Object)part)) {
                AbstractType type;
                if (!(deploment instanceof Part) || !((type = ((Part)deploment).getAbstractType()) instanceof Component)) continue;
                containers.add((Component)type);
            }
        }
        return containers;
    }

    public Collection<Component> getContainersOfPart(Part part) {
        HashSet<Component> containers = new HashSet<Component>();
        EObject parent = this.getParentContainer((EObject)part);
        if (parent instanceof Component) {
            containers.add((Component)parent);
        }
        for (DeploymentTarget deploment : (List)ModelCache.getCache(PartExt::getDeployingElements, (Object)part)) {
            AbstractType type;
            if (!(deploment instanceof Part) || !((type = ((Part)deploment).getAbstractType()) instanceof Component)) continue;
            containers.add((Component)type);
        }
        return containers;
    }

    public boolean isAvailableInterface(Component component, Interface inter) {
        return this.getCCEIInsertInterface((EObject)component).contains(inter);
    }

    public Collection<EObject> getParentContainersByParts(Component component) {
        LinkedList<Component> elements = new LinkedList<Component>();
        elements.add(component);
        return this.getParentContainersByParts(elements);
    }

    public Collection<EObject> getParentContainersByParts(Collection<Component> currents) {
        LinkedList<Component> toVisits = new LinkedList<Component>(currents);
        HashSet<EObject> parents = new HashSet<EObject>();
        while (!toVisits.isEmpty()) {
            EObject owner = (EObject)toVisits.removeFirst();
            if (!(owner instanceof Component)) continue;
            EObject parent = this.getParentContainer(owner);
            if (parent != null && !parents.contains(parent)) {
                parents.add(parent);
                toVisits.addLast((Component)parent);
            }
            for (EObject eObject : this.getContainersOfParts((Component)owner)) {
                if (eObject == null || parents.contains(eObject)) continue;
                parents.add(eObject);
                toVisits.addLast((Component)eObject);
            }
        }
        return parents;
    }

    public Collection<EObject> getAvailableComponentsByNamespaceOfParts(Component component) {
        LinkedList<Component> ownerParts = new LinkedList<Component>();
        ownerParts.addAll(this.getContainersOfParts(component));
        return ComponentExt.getAvailableComponentsByNamespaceOfParts(ownerParts);
    }

    public Collection<Interface> getCCIIInsertInterface(EObject object) {
        Collection<Interface> res = this.getCCEIInsertInterface(object);
        if (object instanceof Component) {
            res.addAll(this.getSubDefinedInterfaces((Component)object));
            res.addAll(this.getRelatedInterfaces((Component)object));
        } else if (object instanceof BlockArchitecture) {
            res.addAll(this.getSubDefinedInterfaces((BlockArchitecture)object));
        }
        return res;
    }

    public Collection<Interface> getIBInsertInterface(EObject object) {
        return this.getCCIIInsertInterface(object);
    }

    public Collection<Interface> getCCEIInsertInterface(EObject context) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_CCE_INSERT_INTERFACE_FOR_LIB, (Object)context);
    }

    public Collection<CommunicationLink> getRelatedCommunicationLinks(Component component) {
        return CommunicationLinkExt.getAllCommunicationLinks((CommunicationLinkExchanger)component);
    }

    public Collection<Interface> getRelatedInterfaces(Component component) {
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        if (component != null) {
            interfaces.addAll(ComponentExt.getImplementedAndProvidedInterfaces((Component)component));
            interfaces.addAll(ComponentExt.getUsedAndRequiredInterfaces((Component)component));
        }
        return interfaces;
    }

    public Collection<Interface> getAllRelatedInterfaces(Component component) {
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        if (component != null) {
            interfaces.addAll(ComponentExt.getAllImplementedAndProvidedInterfaces((Component)component));
            interfaces.addAll(ComponentExt.getAllUsedAndRequiredInterfaces((Component)component));
        }
        return interfaces;
    }

    public void removeAllAllocatedInterfaces(Collection<Interface> interfaces) {
        HashSet<Interface> toRemove = new HashSet<Interface>();
        for (Interface inter : interfaces) {
            if (inter.getAllocatedInterfaces() == null) continue;
            for (Interface allocated : inter.getAllocatedInterfaces()) {
                toRemove.add(allocated);
            }
        }
        interfaces.removeAll(toRemove);
    }

    public Collection<Interface> getInterfacesFromAllocatedComponent(Component subComponent) {
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        if (subComponent.getRealizedComponents() != null) {
            LinkedList<Component> allocateds = new LinkedList<Component>();
            for (Component allocated : subComponent.getRealizedComponents()) {
                allocateds.add(allocated);
            }
            while (!allocateds.isEmpty()) {
                Component allocated;
                allocated = (Component)allocateds.removeFirst();
                interfaces.addAll(this.getSubDefinedInterfaces(allocated));
                if (allocated.getRealizedComponents() == null) continue;
                for (Component suballocated : allocated.getRealizedComponents()) {
                    allocateds.add(suballocated);
                }
            }
        }
        return interfaces;
    }

    public Collection<Interface> getRelatedInterfacesFromAllocatedComponent(Component subComponent) {
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        if (subComponent.getRealizedComponents() != null) {
            LinkedList<Component> allocateds = new LinkedList<Component>();
            for (Component allocated : subComponent.getRealizedComponents()) {
                allocateds.add(allocated);
            }
            while (!allocateds.isEmpty()) {
                Component allocated;
                allocated = (Component)allocateds.removeFirst();
                interfaces.addAll(this.getRelatedInterfaces(allocated));
            }
        }
        return interfaces;
    }

    public Collection<Interface> getInterfacesFromAllocatedArchitecture(BlockArchitecture architecture) {
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        if (architecture.getAllocatedArchitectures() != null) {
            LinkedList<BlockArchitecture> allocateds = new LinkedList<BlockArchitecture>();
            for (BlockArchitecture allocated : architecture.getAllocatedArchitectures()) {
                allocateds.add(allocated);
            }
            while (!allocateds.isEmpty()) {
                BlockArchitecture allocated;
                allocated = (BlockArchitecture)allocateds.removeFirst();
                interfaces.addAll(this.getSubDefinedInterfaces(allocated));
                if (allocated.getAllocatedArchitectures() == null) continue;
                for (BlockArchitecture suballocated : allocated.getAllocatedArchitectures()) {
                    allocateds.add(suballocated);
                }
            }
        }
        return interfaces;
    }

    public boolean isSameArchitecture(NamedElement source, NamedElement target) {
        BlockArchitecture architectureSource = ComponentExt.getRootBlockArchitecture((ModelElement)source);
        BlockArchitecture architectureTarget = ComponentExt.getRootBlockArchitecture((ModelElement)target);
        return architectureSource != null && architectureSource.equals(architectureTarget) || architectureSource == null && architectureTarget == null;
    }

    public BlockArchitecture getArchitecture(EObject current) {
        return BlockArchitectureExt.getRootBlockArchitecture((EObject)current);
    }

    public CapellaElement getContext(Component component) {
        EObject parent = this.getParentContainer((EObject)component);
        if (parent instanceof BlockArchitecture) {
            return this.getContext((BlockArchitecture)parent);
        }
        return (Component)parent;
    }

    public CapellaElement getContext(Part part) {
        EObject parent = this.getParentContainer((EObject)part);
        if (parent instanceof BlockArchitecture) {
            return this.getContext((BlockArchitecture)parent);
        }
        return (Component)parent;
    }

    public ComponentPkg getContext(BlockArchitecture architecture) {
        return BlockArchitectureExt.getContext((BlockArchitecture)architecture);
    }

    public Collection<Component> getCCIIInsertComponent(Component component) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_CCII_SHOW_HIDE_COMPONENTS_FOR_LIB, (Object)component).stream().filter(comp -> comp instanceof Component && !ComponentExt.isActor((Component)((Component)comp))).map(Component.class::cast).collect(Collectors.toList());
    }

    public Collection<Component> getCCIIInsertActor(Component component) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_CCII_SHOW_HIDE_COMPONENTS_FOR_LIB, (Object)component).stream().filter(comp -> comp instanceof Component && ComponentExt.isActor((Component)((Component)comp))).map(Component.class::cast).collect(Collectors.toList());
    }

    public Collection<Component> filterPhysicalComponentsByNature(PhysicalComponent component, Collection<Component> components) {
        ArrayList<Component> result = new ArrayList<Component>();
        PhysicalComponentNature natureComponent = component.getNature();
        for (Component sub : components) {
            PhysicalComponentNature nature;
            if (!(sub instanceof PhysicalComponent) || (nature = ((PhysicalComponent)sub).getNature()) != PhysicalComponentNature.UNSET && natureComponent != PhysicalComponentNature.UNSET && nature != natureComponent) continue;
            result.add(sub);
        }
        return result;
    }

    public Collection<Component> filterNotActors(Collection<? extends EObject> components) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (EObject eObject : components) {
            Component component;
            if (!(eObject instanceof Component) || (component = (Component)eObject).isActor() || result.contains(eObject)) continue;
            result.add(component);
        }
        return result;
    }

    public Collection<Component> filterActors(Collection<? extends EObject> components) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (EObject eObject : components) {
            Component component;
            if (!(eObject instanceof Component) || !(component = (Component)eObject).isActor()) continue;
            result.add(component);
        }
        return result;
    }

    public Collection<Component> getCCEIInsertComponent(Component component) {
        Collection<Component> result = null;
        EObject element = this.getParentContainer((EObject)component);
        result = element instanceof Component ? this.getCCIIInsertComponent((Component)element) : this.getCCIIInsertComponent(component);
        result.remove(component);
        return result;
    }

    public Collection<Component> getCCEIInsertActor(Component component) {
        HashSet<Component> components = new HashSet<Component>();
        components.addAll(ComponentExt.getSubDefinedActors((BlockArchitecture)this.getArchitecture((EObject)component)));
        components.removeAll(PartExt.getComponentsOfParts((Collection)this.getContext(this.getArchitecture((EObject)component)).getOwnedParts()));
        components.remove(component);
        components.removeAll(this.getParentContainersByParts(component));
        return components;
    }

    public Collection<AbstractExchangeItem> getIBShowHideExchangeItems(Component component) {
        return CapellaServices.getService().getAllExchangeItems((EObject)component);
    }

    public Collection<AbstractExchangeItem> getIBReuseExchangeItems(Interface itf) {
        return CapellaServices.getService().getAllExchangeItems((EObject)itf);
    }

    public Collection<? extends EObject> getFilterHideChildComponents(Component component) {
        Collection<EObject> list = this.getAvailableComponentsByNamespaceOfParts(component);
        list.addAll(this.getBrothersComponents(component));
        list.removeAll(this.getParentContainersByParts(component));
        list.add((EObject)component);
        return list;
    }

    public Collection<Component> getBrothersComponents(Component component) {
        HashSet<Component> components = new HashSet<Component>();
        for (Part part : component.getRepresentingParts()) {
            Component container = ComponentExt.getDirectParent((Part)part);
            if (container != null) {
                Component ownerPart = container;
                for (Part siblingPart : ownerPart.getContainedParts()) {
                    components.add((Component)siblingPart.getType());
                }
                continue;
            }
            if (!(part.eContainer() instanceof ComponentPkg)) continue;
            for (Part siblingPart : ((ComponentPkg)part.eContainer()).getOwnedParts()) {
                components.add((Component)siblingPart.getType());
            }
        }
        return components;
    }

    public Collection<Component> getCCEIShowHideComponent(Component component) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_CCEI_SHOW_HIDE_COMPONENTS_FOR_LIB, (Object)component);
    }

    public Collection<Component> getCCEIShowHideActors(Component component) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_CCEI_SHOW_HIDE_ACTORS_FOR_LIB, (Object)component);
    }

    public Collection<Component> getCCEIShowHideActors(DSemanticDecorator decorator) {
        if (!(decorator.getTarget() instanceof Component)) {
            return Collections.emptyList();
        }
        Component target = (Component)decorator.getTarget();
        Collection<Component> siblingActors = this.getCCEIShowHideActors(target);
        EObject rootActorContainer = this.getIBTarget(decorator, true);
        List firstLevelRootActors = QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_CCII_SHOW_HIDE_ACTORS, (Object)rootActorContainer);
        return Streams.concat((Stream[])new Stream[]{siblingActors.stream(), firstLevelRootActors.stream()}).collect(Collectors.toSet());
    }

    public Collection<Component> getIBShowHideActor(DSemanticDecorator decorator) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_IB_SHOW_HIDE_ACTORS_FOR_LIB, (Object)decorator);
    }

    public Collection<Component> getCCIIShowHideComponent(DSemanticDecorator decorator) {
        if (!(decorator.getTarget() instanceof Component)) {
            return Collections.emptyList();
        }
        EObject target = this.getCCIITarget(decorator);
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_CCII_SHOW_HIDE_COMPONENTS_FOR_LIB, (Object)target);
    }

    public Collection<Component> getCCIIShowHideActor(DSemanticDecorator decorator) {
        if (!(decorator.getTarget() instanceof Component)) {
            return Collections.emptyList();
        }
        EObject directContainer = this.getCCIITarget(decorator);
        EObject rootActorContainer = this.getIBTarget(decorator, true);
        List siblingActors = QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_CCII_SHOW_HIDE_ACTORS_FOR_LIB, (Object)directContainer);
        if (directContainer == rootActorContainer) {
            return siblingActors;
        }
        List firstLevelRootActors = QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_CCII_SHOW_HIDE_ACTORS, (Object)rootActorContainer);
        return Streams.concat((Stream[])new Stream[]{siblingActors.stream(), firstLevelRootActors.stream()}).collect(Collectors.toSet());
    }

    public Collection<Component> getSubComponents(EObject target) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (target == null) {
            return components;
        }
        if (target instanceof BlockArchitecture) {
            components.addAll(ComponentExt.getSubDefinedComponents((BlockArchitecture)((BlockArchitecture)target)));
        } else if (target instanceof Component) {
            components.addAll(ComponentExt.getSubDefinedComponents((Component)((Component)target)));
            components.addAll(ComponentExt.getSubUsedComponents((Component)((Component)target)));
        }
        components.remove(target);
        return this.filterNotActors(components);
    }

    public Collection<Component> getSubActors(EObject target) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (target == null) {
            return components;
        }
        if (target instanceof BlockArchitecture) {
            components.addAll(ComponentExt.getSubDefinedComponents((BlockArchitecture)((BlockArchitecture)target)));
        } else if (target instanceof Component) {
            components.addAll(ComponentExt.getSubDefinedComponents((Component)((Component)target)));
            components.addAll(ComponentExt.getSubUsedComponents((Component)((Component)target)));
        }
        components.remove(target);
        return this.filterActors(components);
    }

    public Collection<? extends CapellaElement> getABShowHidePureComponent(DSemanticDecorator decorator) {
        return this.getABShowHideComponent(decorator).stream().filter(part -> !ComponentExt.isActor((EObject)part)).collect(Collectors.toList());
    }

    public Collection<? extends CapellaElement> getABShowHideComponent(DSemanticDecorator decorator) {
        EObject target = this.getABTarget(decorator);
        return this.getABShowHideComponent(decorator, target);
    }

    public Collection<? extends CapellaElement> getABShowHideComponentForActor(DSemanticDecorator decorator) {
        EObject target = this.getABActorTarget(decorator);
        return this.getABShowHideComponent(decorator, target);
    }

    public Collection<? extends CapellaElement> getABShowHideComponent(DSemanticDecorator decorator, EObject target) {
        if (this.isMultipartMode((ModelElement)target) || this.getComponentType(decorator) instanceof ConfigurationItem || this.getComponentType(decorator) instanceof ConfigurationItemPkg) {
            ArrayList<Part> parts = new ArrayList<Part>();
            Component targetComponent = null;
            if (target instanceof Component) {
                targetComponent = (Component)target;
            }
            if (target instanceof Part) {
                targetComponent = (Component)((Part)target).getAbstractType();
            }
            if (decorator instanceof DDiagram) {
                if (targetComponent != null) {
                    parts.addAll(this.getParts((CapellaElement)targetComponent, CsPackage.Literals.COMPONENT, null));
                    parts.addAll((Collection<Part>)targetComponent.getRepresentingParts());
                } else if (target instanceof BlockArchitecture) {
                    parts.addAll(this.getParts((CapellaElement)this.getContext((BlockArchitecture)target), CsPackage.Literals.COMPONENT, null));
                } else if (target instanceof ComponentPkg) {
                    parts.addAll(this.getParts((CapellaElement)((ComponentPkg)target), CsPackage.Literals.COMPONENT, null));
                }
            } else if (targetComponent != null) {
                parts.addAll(this.getParts((CapellaElement)targetComponent, CsPackage.Literals.COMPONENT, null));
            }
            return parts;
        }
        ModelElement root = (ModelElement)this.getComponentType(decorator);
        List<Object> components = new ArrayList();
        if (decorator instanceof DDiagram) {
            BlockArchitecture architecture = ComponentExt.getRootBlockArchitecture((ModelElement)root);
            components = CsServices.getService().getAllSubDefinedComponents(architecture);
        } else if (root instanceof Component) {
            Part part = (Part)decorator.getTarget();
            components = PartExt.getComponentsOfParts((Collection)ComponentExt.getAllSubUsedParts((Component)((Component)root), (boolean)false));
            for (DeployableElement deployed : PartExt.getDeployedElements((Part)part)) {
                if (!(deployed instanceof Part) || !(((Part)deployed).getAbstractType() instanceof Component)) continue;
                Part deployedPart = (Part)deployed;
                Component abstractType = (Component)deployedPart.getAbstractType();
                Collection allSubUsedParts = ComponentExt.getAllSubUsedParts((Component)abstractType, (boolean)false);
                components.addAll(PartExt.getComponentsOfParts((Collection)allSubUsedParts));
            }
        }
        return components.stream().filter(c -> !c.getRepresentingParts().isEmpty()).collect(Collectors.toList());
    }

    public Collection<Component> getIBShowHideComponent(DSemanticDecorator decorator) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_IB_SHOW_HIDE_COMPONENTS_FOR_LIB, (Object)decorator);
    }

    public EObject getCCIITarget(DSemanticDecorator decorator) {
        if (decorator instanceof DDiagram) {
            return this.getParentContainer(decorator.getTarget());
        }
        return decorator.getTarget();
    }

    public EObject getABTarget(DSemanticDecorator decorator) {
        if (decorator instanceof DDiagram) {
            ContainerMapping cMapping = FaServices.getFaServices().getMappingABComponent(decorator.getTarget(), (DDiagram)decorator);
            for (DDiagramElement element : ((DDiagram)decorator).getOwnedDiagramElements()) {
                if (!DiagramServices.getDiagramServices().isMapping(element, (DiagramElementMapping)cMapping)) continue;
                if (element.getTarget() == decorator.getTarget()) {
                    return this.getSemanticParentContainer(decorator.getTarget(), false);
                }
                if (!(element.getTarget() instanceof Part) || ((Part)element.getTarget()).getAbstractType() != decorator.getTarget()) continue;
                return this.getSemanticParentContainer(decorator.getTarget(), false);
            }
            if (ABServices.getService().isValidCreationABComponent((EObject)decorator)) {
                return decorator.getTarget();
            }
            EObject parent = this.getSemanticParentContainer(decorator.getTarget(), false);
            if (parent instanceof BlockArchitecture && ABServices.getService().isValidCreationABComponent((EObject)((BlockArchitecture)parent).getSystem())) {
                return ((BlockArchitecture)parent).getSystem();
            }
            return parent;
        }
        return decorator.getTarget();
    }

    public EObject getABActorTarget(DSemanticDecorator decorator) {
        EObject target = decorator.getTarget();
        if (decorator instanceof DDiagram) {
            BlockArchitecture rootBlockArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
            return BlockArchitectureExt.getComponentPkg((BlockArchitecture)rootBlockArchitecture);
        }
        return target;
    }

    public EObject getCBDActorTarget(DSemanticDecorator decorator) {
        if (decorator instanceof DDiagram) {
            ContainerMapping cMapping = FaServices.getFaServices().getMappingABComponent(decorator.getTarget(), (DDiagram)decorator);
            for (DDiagramElement element : ((DDiagram)decorator).getOwnedDiagramElements()) {
                if (!DiagramServices.getDiagramServices().isMapping(element, (DiagramElementMapping)cMapping)) continue;
                if (element.getTarget() == decorator.getTarget()) {
                    return this.getSemanticParentContainer(decorator.getTarget(), true);
                }
                if (!(element.getTarget() instanceof Part) || ((Part)element.getTarget()).getAbstractType() != decorator.getTarget()) continue;
                return this.getSemanticParentContainer(decorator.getTarget(), true);
            }
            if (ABServices.getService().isValidCreationABActor((EObject)decorator)) {
                return decorator.getTarget();
            }
            EObject parent = this.getSemanticParentContainer(decorator.getTarget(), true);
            if (parent instanceof BlockArchitecture && ABServices.getService().isValidCreationABComponent((EObject)((BlockArchitecture)parent).getSystem())) {
                return ((BlockArchitecture)parent).getSystem();
            }
            return parent;
        }
        return decorator.getTarget();
    }

    public boolean isABTargetPresent(DSemanticDecorator decorator) {
        if (decorator instanceof DDiagram) {
            ContainerMapping cMapping = FaServices.getFaServices().getMappingABComponent(decorator.getTarget(), (DDiagram)decorator);
            for (DDiagramElement element : ((DDiagram)decorator).getOwnedDiagramElements()) {
                if (!DiagramServices.getDiagramServices().isMapping(element, (DiagramElementMapping)cMapping)) continue;
                if (element.getTarget() == decorator.getTarget()) {
                    return true;
                }
                if (!(element.getTarget() instanceof Part) || ((Part)element.getTarget()).getAbstractType() != decorator.getTarget()) continue;
                return true;
            }
        }
        return false;
    }

    public EObject getIBTarget(DSemanticDecorator decorator) {
        if (decorator instanceof DDiagram) {
            for (DDiagramElement element : ((DDiagram)decorator).getOwnedDiagramElements()) {
                if (element.getTarget() != decorator.getTarget()) continue;
                return this.getParentContainer(decorator.getTarget());
            }
            if (decorator.getTarget() instanceof ComponentPkg) {
                return this.getParentContainer(decorator.getTarget());
            }
            return decorator.getTarget();
        }
        return decorator.getTarget();
    }

    public EObject getIBTarget(DSemanticDecorator decorator, boolean isActorContext) {
        if (decorator instanceof DDiagram) {
            if (isActorContext) {
                EObject target = decorator.getTarget();
                BlockArchitecture rootBlockArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
                return BlockArchitectureExt.getComponentPkg((BlockArchitecture)rootBlockArchitecture);
            }
            for (DDiagramElement element : ((DDiagram)decorator).getOwnedDiagramElements()) {
                if (element.getTarget() != decorator.getTarget()) continue;
                return this.getSemanticParentContainer(decorator.getTarget(), false);
            }
            if (ABServices.getService().isValidCreationABComponent((EObject)decorator)) {
                return decorator.getTarget();
            }
            EObject parent = this.getSemanticParentContainer(decorator.getTarget(), false);
            if (parent instanceof BlockArchitecture && ABServices.getService().isValidCreationABComponent((EObject)((BlockArchitecture)parent).getSystem())) {
                return ((BlockArchitecture)parent).getSystem();
            }
            return parent;
        }
        return decorator.getTarget();
    }

    public boolean isGeneralizableForReConnect(EObject context, EObject newSource, EObject newTarget) {
        if (newSource instanceof Class && newTarget instanceof Class && ((Class)newSource).isIsPrimitive() && !((Class)newTarget).isIsPrimitive()) {
            return false;
        }
        if (newSource instanceof Class && newTarget instanceof Class && !((Class)newSource).isIsPrimitive() && ((Class)newTarget).isIsPrimitive()) {
            return false;
        }
        if (newSource instanceof PhysicalQuantity && newTarget instanceof NumericType) {
            return true;
        }
        if (context instanceof Generalization && newSource instanceof GeneralizableElement && newTarget instanceof GeneralizableElement && newTarget instanceof Class && !((Class)newTarget).isIsPrimitive() && newSource.eClass().equals(newTarget.eClass())) {
            Generalization generalization = (Generalization)context;
            GeneralizableElement newSourceClazz = (GeneralizableElement)newSource;
            GeneralizableElement newTargetClazz = (GeneralizableElement)newTarget;
            boolean notExistCycle = true;
            boolean superSourcesContainsTarget = CapellaServices.getService().getSuperClassifiers(newSourceClazz, generalization).contains(newTargetClazz);
            boolean subTargetConatinsSource = CapellaServices.getService().getSubClassifiers(newTargetClazz, generalization).contains(newSourceClazz);
            boolean superTargetsContainsSource = CapellaServices.getService().getSuperClassifiers(newTargetClazz, generalization).contains(newSourceClazz);
            boolean subSourcesConatinsTarget = CapellaServices.getService().getSubClassifiers(newSourceClazz, generalization).contains(newTargetClazz);
            if (newSourceClazz.equals(newTargetClazz)) {
                return false;
            }
            if (superTargetsContainsSource) {
                return !subSourcesConatinsTarget;
            }
            if (superSourcesContainsTarget) {
                return !subTargetConatinsSource;
            }
            if (subSourcesConatinsTarget) {
                return superTargetsContainsSource;
            }
            if (!CapellaModelPreferencesPlugin.getDefault().isMultipleInheritanceAllowed()) {
                if (CapellaServices.getService().getSuperClassifiers(newSourceClazz, generalization).size() == 1) {
                    return true;
                }
                return !this.containMultipleIheritence(newSourceClazz, generalization);
            }
            return notExistCycle;
        }
        if (newSource instanceof PhysicalQuantity && newTarget instanceof NumericType || newSource instanceof Component && newTarget instanceof Component || newSource instanceof GeneralizableElement && newTarget instanceof GeneralizableElement && newSource.eClass().equals(newTarget.eClass())) {
            boolean existCycle;
            GeneralizableElement targetClass = (GeneralizableElement)newTarget;
            GeneralizableElement sourceClass = (GeneralizableElement)newSource;
            boolean bl = existCycle = !CapellaServices.getService().getSuperClassifiers(sourceClass).contains(targetClass) && !CapellaServices.getService().getSuperClassifiers(targetClass).contains(sourceClass);
            if (!CapellaModelPreferencesPlugin.getDefault().isMultipleInheritanceAllowed()) {
                if (existCycle) {
                    if (CapellaServices.getService().getSuperClassifiers(sourceClass).size() == 1) {
                        return true;
                    }
                    if (context instanceof Generalization) {
                        return true;
                    }
                }
            } else {
                return existCycle;
            }
        }
        if (newSource instanceof AbstractCapability && newTarget instanceof AbstractCapability && newSource.eClass().equals(newTarget.eClass())) {
            boolean cond;
            boolean bl = cond = !CapellaServices.getService().getAllSuperCapabilities(context, (AbstractCapability)newTarget).contains(newSource) && !CapellaServices.getService().getAllSuperCapabilities(context, (AbstractCapability)newSource).contains(newTarget);
            if (cond) {
                return true;
            }
        }
        return false;
    }

    private boolean containMultipleIheritence(GeneralizableElement newSourceClazz, Generalization generalisation) {
        EList generalisations = newSourceClazz.getOwnedGeneralizations();
        for (Generalization generalization : generalisations) {
            if (!generalization.getSub().equals(newSourceClazz)) continue;
            return true;
        }
        return false;
    }

    public boolean isGeneralizableForReConnectOld(EObject context, EObject source, EObject target) {
        if (source instanceof Class && target instanceof Class && ((Class)source).isIsPrimitive() && !((Class)target).isIsPrimitive()) {
            return false;
        }
        if (source instanceof Class && target instanceof Class && !((Class)source).isIsPrimitive() && ((Class)target).isIsPrimitive()) {
            return false;
        }
        if (source instanceof PhysicalQuantity && target instanceof NumericType) {
            return true;
        }
        if (context instanceof Generalization && source instanceof GeneralizableElement && target instanceof GeneralizableElement && !((Class)target).isIsPrimitive() && source.eClass().equals(target.eClass())) {
            GeneralizableElement sourceClazz = (GeneralizableElement)source;
            GeneralizableElement targetClazz = (GeneralizableElement)target;
            boolean notExistCycle = true;
            boolean superSourcesContainsTarget = CapellaServices.getService().getSuperClassifiers(sourceClazz).contains(targetClazz);
            boolean subTargetConatinsSource = CapellaServices.getService().getSubClassifiers(targetClazz).contains(sourceClazz);
            boolean superTargetsContainsSource = CapellaServices.getService().getSuperClassifiers(targetClazz).contains(sourceClazz);
            boolean subSourcesConatinsTarget = CapellaServices.getService().getSubClassifiers(sourceClazz).contains(targetClazz);
            if (superSourcesContainsTarget) {
                return !subTargetConatinsSource;
            }
            if (subSourcesConatinsTarget) {
                return CapellaModelPreferencesPlugin.getDefault().isMultipleInheritanceAllowed() && superTargetsContainsSource;
            }
            return notExistCycle;
        }
        if (source instanceof PhysicalQuantity && target instanceof NumericType || source instanceof Component && target instanceof Component || source instanceof GeneralizableElement && target instanceof GeneralizableElement && source.eClass().equals(target.eClass())) {
            boolean existCycle;
            GeneralizableElement targetClass = (GeneralizableElement)target;
            GeneralizableElement sourceClass = (GeneralizableElement)source;
            boolean bl = existCycle = !CapellaServices.getService().getSuperClassifiers(sourceClass).contains(targetClass) && !CapellaServices.getService().getSuperClassifiers(targetClass).contains(sourceClass);
            if (!CapellaModelPreferencesPlugin.getDefault().isMultipleInheritanceAllowed()) {
                if (existCycle) {
                    if (CapellaServices.getService().getSuperClassifiers(sourceClass).size() == 1) {
                        return true;
                    }
                    if (context instanceof Generalization) {
                        return true;
                    }
                }
            } else {
                return existCycle;
            }
        }
        return false;
    }

    public boolean preGeneralization(EObject generalization, EObject preSource) {
        if (preSource instanceof Component && !((Component)preSource).isActor()) {
            return CapellaModelPreferencesPlugin.getDefault().isComponentNonActorInheritanceAllowed();
        }
        return true;
    }

    public boolean canReconnectGeneralization(EObject generalization, EObject subObject, EObject targetObject) {
        EObject source = subObject;
        EObject target = targetObject;
        if (!this.isGeneralizableForReConnect(generalization, source, target)) {
            return false;
        }
        if (source instanceof FinalizableElement && target instanceof FinalizableElement) {
            return !((FinalizableElement)target).isFinal();
        }
        if (!(source instanceof Component) || !(target instanceof Component)) {
            AbstractDependenciesPkg targetPkg;
            AbstractDependenciesPkg sourcePkg;
            source = this.getParentContainer(source);
            target = this.getParentContainer(target);
            if (source instanceof ModellingArchitecture && target instanceof ModellingArchitecture ? AbstractDependenciesPkgExt.isADependencyAvailable((AbstractDependenciesPkg)(sourcePkg = (AbstractDependenciesPkg)CapellaServices.getService().getParent(subObject, CapellacorePackage.Literals.ABSTRACT_DEPENDENCIES_PKG)), (AbstractDependenciesPkg)(targetPkg = (AbstractDependenciesPkg)CapellaServices.getService().getParent(targetObject, CapellacorePackage.Literals.ABSTRACT_DEPENDENCIES_PKG))) : source instanceof ModellingArchitecture || target instanceof ModellingArchitecture) {
                return true;
            }
        }
        if (source instanceof Component && target instanceof Component) {
            if (!(((Component)source).isActor() && ((Component)target).isActor() || CapellaModelPreferencesPlugin.getDefault().isComponentNonActorInheritanceAllowed())) {
                return false;
            }
            if (((Component)source).isActor() && ((Component)target).isActor()) {
                return source.getClass().equals(target.getClass());
            }
            if (!(((Component)source).isActor() || ((Component)target).isActor() || ((List)ModelCache.getCache(ComponentExt::getAllSubUsedAndDeployedComponents, (Object)((Component)source))).contains(target) || ((List)ModelCache.getCache(ComponentExt::getAllSubUsedAndDeployedComponents, (Object)((Component)target))).contains(source))) {
                return source.getClass().equals(target.getClass());
            }
        }
        return false;
    }

    public boolean linkReconnectSource(EObject current, EObject sourceObject, EObject targetObject) {
        EObject tAncestor;
        EObject source = sourceObject;
        EObject target = targetObject;
        if (!(source instanceof Component) && !(source instanceof ComponentPort) || source instanceof ConfigurationItem) {
            return false;
        }
        if (!(target instanceof Component) && !(target instanceof ComponentPort) || target instanceof ConfigurationItem) {
            return false;
        }
        if (source instanceof Component && ((Component)source).isActor() && target instanceof Component) {
            return true;
        }
        if (target instanceof Component && ((Component)target).isActor() && source instanceof Component) {
            return true;
        }
        if (source instanceof ComponentPort) {
            source = source.eContainer();
        }
        if (target instanceof ComponentPort) {
            target = target.eContainer();
        }
        if (source instanceof Component && ((Component)source).isActor() && target instanceof Component) {
            return true;
        }
        if (target instanceof Component && ((Component)target).isActor() && source instanceof Component) {
            return true;
        }
        EObject sAncestor = CapellaServices.getService().getAncestor(source, CsPackage.Literals.COMPONENT);
        if (sAncestor == (tAncestor = CapellaServices.getService().getAncestor(target, CsPackage.Literals.COMPONENT))) {
            return true;
        }
        return this.isAnAncestor(source, target);
    }

    public Collection<Interface> getSubDefinedInterfaces(Component component) {
        return InterfacePkgExt.getAllInterfaces((InterfacePkg)component.getOwnedInterfacePkg());
    }

    public Collection<Interface> getSubDefinedInterfaces(BlockArchitecture block) {
        return InterfacePkgExt.getAllInterfaces((InterfacePkg)block.getOwnedInterfacePkg());
    }

    public boolean isASubProvidedLink(DEdge edge) {
        if (edge.getSourceNode() instanceof DSemanticDecorator && edge.getTargetNode() instanceof DSemanticDecorator) {
            ComponentPort port = (ComponentPort)((DSemanticDecorator)edge.getSourceNode()).getTarget();
            Interface inter = (Interface)((DSemanticDecorator)edge.getTargetNode()).getTarget();
            ArrayList<ComponentPort> ports = new ArrayList<ComponentPort>();
            ArrayList<ComponentPort> portsVisited = new ArrayList<ComponentPort>();
            portsVisited.add(port);
            for (PortAllocation allocation : port.getOutgoingPortAllocations()) {
                if (!(allocation.getAllocatedPort() instanceof ComponentPort) || portsVisited.contains(allocation.getAllocatedPort())) continue;
                ports.add((ComponentPort)allocation.getAllocatedPort());
            }
            while (!ports.isEmpty()) {
                port = (ComponentPort)ports.remove(0);
                if (port.getProvidedInterfaces().contains((Object)inter) && DiagramServices.getDiagramServices().isOnDiagram(edge.getParentDiagram(), (EObject)port)) {
                    return false;
                }
                portsVisited.add(port);
                for (PortAllocation allocation : port.getOutgoingPortAllocations()) {
                    if (!(allocation.getAllocatedPort() instanceof ComponentPort) || portsVisited.contains(allocation.getAllocatedPort())) continue;
                    ports.add((ComponentPort)allocation.getAllocatedPort());
                }
            }
        }
        return true;
    }

    public boolean isASuperProvidedLink(DEdge edge) {
        if (edge.getSourceNode() instanceof DSemanticDecorator && edge.getTargetNode() instanceof DSemanticDecorator) {
            ComponentPort port = (ComponentPort)((DSemanticDecorator)edge.getSourceNode()).getTarget();
            Interface inter = (Interface)((DSemanticDecorator)edge.getTargetNode()).getTarget();
            ArrayList<ComponentPort> ports = new ArrayList<ComponentPort>();
            ArrayList<ComponentPort> portsVisited = new ArrayList<ComponentPort>();
            portsVisited.add(port);
            for (PortAllocation allocation : port.getIncomingPortAllocations()) {
                if (!(allocation.getAllocatingPort() instanceof ComponentPort) || portsVisited.contains(allocation.getAllocatingPort())) continue;
                ports.add((ComponentPort)allocation.getAllocatingPort());
            }
            while (!ports.isEmpty()) {
                port = (ComponentPort)ports.remove(0);
                if (port.getProvidedInterfaces().contains((Object)inter) && DiagramServices.getDiagramServices().isOnDiagram(edge.getParentDiagram(), (EObject)port)) {
                    return false;
                }
                portsVisited.add(port);
                for (PortAllocation allocation : port.getOutgoingPortAllocations()) {
                    if (!(allocation.getAllocatedPort() instanceof ComponentPort) || portsVisited.contains(allocation.getAllocatedPort())) continue;
                    ports.add((ComponentPort)allocation.getAllocatedPort());
                }
            }
        }
        return true;
    }

    public boolean isASubRequiredLink(DEdge edge) {
        if (edge.getSourceNode() instanceof DSemanticDecorator && edge.getTargetNode() instanceof DSemanticDecorator) {
            ComponentPort port = (ComponentPort)((DSemanticDecorator)edge.getSourceNode()).getTarget();
            Interface inter = (Interface)((DSemanticDecorator)edge.getTargetNode()).getTarget();
            ArrayList<ComponentPort> ports = new ArrayList<ComponentPort>();
            ArrayList<ComponentPort> portsVisited = new ArrayList<ComponentPort>();
            portsVisited.add(port);
            for (PortAllocation allocation : port.getOutgoingPortAllocations()) {
                if (!(allocation.getAllocatedPort() instanceof ComponentPort) || portsVisited.contains(allocation.getAllocatedPort())) continue;
                ports.add((ComponentPort)allocation.getAllocatedPort());
            }
            while (!ports.isEmpty()) {
                port = (ComponentPort)ports.remove(0);
                if (port.getRequiredInterfaces().contains((Object)inter) && DiagramServices.getDiagramServices().isOnDiagram(edge.getParentDiagram(), (EObject)port)) {
                    return false;
                }
                portsVisited.add(port);
                for (PortAllocation allocation : port.getOutgoingPortAllocations()) {
                    if (!(allocation.getAllocatedPort() instanceof ComponentPort) || portsVisited.contains(allocation.getAllocatedPort())) continue;
                    ports.add((ComponentPort)allocation.getAllocatedPort());
                }
            }
        }
        return true;
    }

    public boolean isASuperRequiredLink(DEdge edge) {
        if (edge.getSourceNode() instanceof DSemanticDecorator && edge.getTargetNode() instanceof DSemanticDecorator) {
            ComponentPort port = (ComponentPort)((DSemanticDecorator)edge.getSourceNode()).getTarget();
            Interface inter = (Interface)((DSemanticDecorator)edge.getTargetNode()).getTarget();
            ArrayList<ComponentPort> ports = new ArrayList<ComponentPort>();
            ArrayList<ComponentPort> portsVisited = new ArrayList<ComponentPort>();
            portsVisited.add(port);
            for (PortAllocation allocation : port.getIncomingPortAllocations()) {
                if (!(allocation.getAllocatingPort() instanceof ComponentPort) || portsVisited.contains(allocation.getAllocatingPort())) continue;
                ports.add((ComponentPort)allocation.getAllocatingPort());
            }
            while (!ports.isEmpty()) {
                port = (ComponentPort)ports.remove(0);
                if (port.getRequiredInterfaces().contains((Object)inter) && DiagramServices.getDiagramServices().isOnDiagram(edge.getParentDiagram(), (EObject)port)) {
                    return false;
                }
                portsVisited.add(port);
                for (PortAllocation allocation : port.getOutgoingPortAllocations()) {
                    if (!(allocation.getAllocatedPort() instanceof ComponentPort) || portsVisited.contains(allocation.getAllocatedPort())) continue;
                    ports.add((ComponentPort)allocation.getAllocatedPort());
                }
            }
        }
        return true;
    }

    protected List<Component> getSuperComponents(Component component) {
        ArrayList<Component> comps = new ArrayList<Component>();
        Component item = component;
        if (item == null) {
            return comps;
        }
        item = item.eContainer();
        while (item != null) {
            if (item instanceof Component) {
                comps.add(item);
                break;
            }
            item = item.eContainer();
        }
        return comps;
    }

    public List<Component> getSubUsedComponents(CapellaElement capellaElement) {
        if (capellaElement instanceof Component) {
            return ComponentExt.getSubUsedComponents((Component)((Component)capellaElement));
        }
        if (capellaElement instanceof ComponentPkg) {
            return ComponentPkgExt.getSubUsedComponents((ComponentPkg)((ComponentPkg)capellaElement));
        }
        return Collections.emptyList();
    }

    public Collection<Component> getAllSubUsedComponents(Component component) {
        return ComponentExt.getAllSubUsedComponents((Component)component);
    }

    public List<Component> getAllSubDefinedComponents(Component component) {
        return ComponentExt.getAllSubDefinedComponents((Component)component);
    }

    public List<Component> getAllSubDefinedComponents(BlockArchitecture architecture) {
        ArrayList<Component> comps = new ArrayList<Component>();
        LinkedList subs = new LinkedList();
        subs.addAll(ComponentExt.getSubDefinedComponents((BlockArchitecture)architecture));
        while (!subs.isEmpty()) {
            Component sub = (Component)subs.removeFirst();
            comps.add(sub);
            List internal = ComponentExt.getSubDefinedComponents((Component)sub);
            comps.addAll(internal);
            subs.addAll(internal);
        }
        return comps;
    }

    public boolean isASubImplementedLink(DEdge edge) {
        if (edge.getSourceNode() instanceof DSemanticDecorator && edge.getTargetNode() instanceof DSemanticDecorator) {
            Component comp = (Component)((DSemanticDecorator)edge.getSourceNode()).getTarget();
            Interface inter = (Interface)((DSemanticDecorator)edge.getTargetNode()).getTarget();
            ArrayList<Component> comps = new ArrayList<Component>();
            ArrayList<Component> compsVisited = new ArrayList<Component>();
            comps.addAll(this.getSuperComponents(comp));
            while (!comps.isEmpty()) {
                comp = (Component)comps.remove(0);
                if (comp.getImplementedInterfaces().contains((Object)inter) && DiagramServices.getDiagramServices().isOnDiagram(edge.getParentDiagram(), (EObject)comp)) {
                    return false;
                }
                compsVisited.add(comp);
                for (Component component : this.getSuperComponents(comp)) {
                    if (compsVisited.contains(comp)) continue;
                    comps.add(component);
                }
            }
        }
        return true;
    }

    public boolean isASuperImplementedLink(DEdge edge) {
        if (edge.getSourceNode() instanceof DSemanticDecorator && edge.getTargetNode() instanceof DSemanticDecorator) {
            Component comp = (Component)((DSemanticDecorator)edge.getSourceNode()).getTarget();
            Interface inter = (Interface)((DSemanticDecorator)edge.getTargetNode()).getTarget();
            ArrayList<Component> comps = new ArrayList<Component>();
            ArrayList<Component> compsVisited = new ArrayList<Component>();
            comps.addAll(ComponentExt.getSubUsedComponents((Component)comp));
            while (!comps.isEmpty()) {
                comp = (Component)comps.remove(0);
                if (comp.getImplementedInterfaces().contains((Object)inter) && DiagramServices.getDiagramServices().isOnDiagram(edge.getParentDiagram(), (EObject)comp)) {
                    return false;
                }
                compsVisited.add(comp);
                for (Component component : ComponentExt.getSubUsedComponents((Component)comp)) {
                    if (compsVisited.contains(comp)) continue;
                    comps.add(component);
                }
            }
        }
        return true;
    }

    public boolean isASubUsedLink(DEdge edge) {
        if (edge.getSourceNode() instanceof DSemanticDecorator && edge.getTargetNode() instanceof DSemanticDecorator) {
            Component comp = (Component)((DSemanticDecorator)edge.getSourceNode()).getTarget();
            Interface inter = (Interface)((DSemanticDecorator)edge.getTargetNode()).getTarget();
            ArrayList<Component> comps = new ArrayList<Component>();
            ArrayList<Component> compsVisited = new ArrayList<Component>();
            comps.addAll(this.getSuperComponents(comp));
            while (!comps.isEmpty()) {
                comp = (Component)comps.remove(0);
                if (comp.getUsedInterfaces().contains((Object)inter) && DiagramServices.getDiagramServices().isOnDiagram(edge.getParentDiagram(), (EObject)comp)) {
                    return false;
                }
                compsVisited.add(comp);
                for (Component component : this.getSuperComponents(comp)) {
                    if (compsVisited.contains(comp)) continue;
                    comps.add(component);
                }
            }
        }
        return true;
    }

    public boolean isASuperUsedLink(DEdge edge) {
        if (edge.getSourceNode() instanceof DSemanticDecorator && edge.getTargetNode() instanceof DSemanticDecorator) {
            Component comp = (Component)((DSemanticDecorator)edge.getSourceNode()).getTarget();
            Interface inter = (Interface)((DSemanticDecorator)edge.getTargetNode()).getTarget();
            ArrayList<Component> comps = new ArrayList<Component>();
            ArrayList<Component> compsVisited = new ArrayList<Component>();
            comps.addAll(ComponentExt.getSubUsedComponents((Component)comp));
            while (!comps.isEmpty()) {
                comp = (Component)comps.remove(0);
                if (comp.getUsedInterfaces().contains((Object)inter) && DiagramServices.getDiagramServices().isOnDiagram(edge.getParentDiagram(), (EObject)comp)) {
                    return false;
                }
                compsVisited.add(comp);
                for (Component component : ComponentExt.getSubUsedComponents((Component)comp)) {
                    if (compsVisited.contains(comp)) continue;
                    comps.add(component);
                }
            }
        }
        return true;
    }

    public boolean isStandardPort(EObject port) {
        return PortExt.isStandardPort((Object)port);
    }

    public boolean isFlowPort(EObject port) {
        return PortExt.isFlowPort((EObject)port);
    }

    public boolean isInFlowPort(EObject port) {
        return PortExt.isInFlowPort((EObject)port);
    }

    public boolean isInStrictFlowPort(EObject port) {
        return PortExt.isInStrictFlowPort((EObject)port);
    }

    public boolean isOutFlowPort(EObject port) {
        return PortExt.isOutFlowPort((EObject)port);
    }

    public boolean isOutStrictFlowPort(EObject port) {
        return PortExt.isOutStrictFlowPort((EObject)port);
    }

    public boolean isInoutStrictFlowPort(EObject port) {
        return PortExt.isInoutStrictFlowPort((EObject)port);
    }

    public boolean isValidCreationABComponentExchange(EObject root, DSemanticDecorator preSourceView, DSemanticDecorator preTargetView) {
        ComponentPort port;
        boolean sourceValid = true;
        boolean targetValid = true;
        EObject preSource = preSourceView.getTarget();
        EObject preTarget = preTargetView.getTarget();
        EObject sourceComponent = this.getComponentType(preSourceView);
        EObject targetComponent = this.getComponentType(preTargetView);
        if (preSource instanceof ComponentPort) {
            port = (ComponentPort)preSource;
            boolean bl = sourceValid = PortExt.isOutFlowPort((EObject)port) || PortExt.isStandardPort((Object)port);
        }
        if (preTarget instanceof ComponentPort) {
            port = (ComponentPort)preTarget;
            boolean bl = targetValid = PortExt.isInFlowPort((EObject)port) || PortExt.isStandardPort((Object)port);
        }
        if (sourceComponent instanceof PhysicalComponent) {
            boolean bl = sourceValid ? ((PhysicalComponent)sourceComponent).getNature() != PhysicalComponentNature.NODE || ComponentExt.isActor((EObject)sourceComponent) : (sourceValid = false);
        }
        if (targetComponent instanceof PhysicalComponent) {
            boolean bl = targetValid ? ((PhysicalComponent)targetComponent).getNature() != PhysicalComponentNature.NODE || ComponentExt.isActor((EObject)targetComponent) : (targetValid = false);
        }
        return sourceValid && targetValid;
    }

    public static String getPartUniqueName(Part part) {
        String racine;
        int i = 0;
        boolean isCorrectlyNamed = false;
        AbstractType type = part.getAbstractType();
        String name = racine = type.getName();
        while (!isCorrectlyNamed) {
            boolean nameExist = false;
            for (EObject object : part.eContainer().eContents()) {
                if (!(object instanceof Part) || !((Part)object).getName().equals(name)) continue;
                name = String.valueOf(racine) + ' ' + ++i;
                nameExist = true;
                break;
            }
            if (nameExist) continue;
            isCorrectlyNamed = true;
        }
        return name;
    }

    public boolean isValidCreationPABComponentExchange(EObject container, DSemanticDecorator sourceView) {
        if (sourceView == null || sourceView.getTarget() == null) {
            return false;
        }
        if (sourceView.getTarget() instanceof PhysicalPort) {
            return false;
        }
        EObject source = this.getComponentType(sourceView);
        return this.isAbstractActorOrNotNodeComponent(source);
    }

    public boolean isValidCreationPABComponentExchange(EObject container, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        if (!this.isValidCreationABComponentExchange(container, sourceView, targetView)) {
            return false;
        }
        EObject source = this.getComponentType(sourceView);
        EObject target = this.getComponentType(targetView);
        return this.isAbstractActorOrNotNodeComponent(source) && this.isAbstractActorOrNotNodeComponent(target);
    }

    public boolean isValidCreationPABDelegationExchange(EObject container, DSemanticDecorator sourceView) {
        if (sourceView == null || sourceView.getTarget() == null) {
            return false;
        }
        if (sourceView.getTarget() instanceof PhysicalPort) {
            return false;
        }
        EObject source = this.getComponentType(sourceView);
        return this.isAbstractActorOrNotNodeComponent(source);
    }

    public boolean isValidCreationPABDelegationExchange(EObject container, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        EObject target;
        if (!this.isValidCreationABDelegationExchange(container, sourceView, targetView)) {
            return false;
        }
        EObject source = this.getComponentType(sourceView);
        return source != (target = this.getComponentType(targetView)) && this.isAbstractActorOrNotNodeComponent(source) && this.isAbstractActorOrNotNodeComponent(target);
    }

    public boolean isValidCreationABPhysicalLink(EObject container, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        Type type;
        boolean sourceValid = false;
        boolean targetValid = false;
        DSemanticDecorator sourceElement = sourceView;
        DSemanticDecorator targetElement = targetView;
        EObject preSource = sourceElement.getTarget();
        EObject preTarget = targetElement.getTarget();
        if (CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)preSource))) {
            if (preSource == preTarget) {
                return false;
            }
        } else if (preSource == preTarget) {
            return !(preSource instanceof PhysicalPort);
        }
        if (preSource instanceof PhysicalPort) {
            sourceValid = true;
        } else if (preSource instanceof Part) {
            type = ((Part)preSource).getType();
            if (type instanceof Component) {
                sourceValid = true;
            }
        } else if (preSource instanceof Component) {
            sourceValid = true;
        }
        if (preTarget instanceof PhysicalPort) {
            targetValid = true;
        } else if (preTarget instanceof Part) {
            type = ((Part)preTarget).getType();
            if (type instanceof Component) {
                targetValid = true;
            }
        } else if (preTarget instanceof Component) {
            targetValid = true;
        }
        if (!sourceValid || !targetValid) {
            return false;
        }
        EObject source = this.getComponentType(sourceView);
        EObject target = this.getComponentType(targetView);
        if (source instanceof PhysicalPort && target instanceof PhysicalPort) {
            if (CapellaProjectHelper.TriStateBoolean.False.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)source))) {
                return source.eContainer() != target.eContainer();
            }
            return source.eContainer() == target.eContainer();
        }
        if (source instanceof PhysicalPort) {
            if (CapellaProjectHelper.TriStateBoolean.False.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)source)) && source.eContainer() == target) {
                return false;
            }
            return this.isNodeComponent(source.eContainer()) && this.isNodeComponent(target);
        }
        if (target instanceof PhysicalPort) {
            if (CapellaProjectHelper.TriStateBoolean.False.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)source)) && source == target.eContainer()) {
                return false;
            }
            return this.isNodeComponent(source) && this.isNodeComponent(target.eContainer());
        }
        return this.isNodeComponent(source) && this.isNodeComponent(target);
    }

    protected boolean isAbstractActorOrNotNodeComponent(EObject source) {
        return source instanceof Component && ((Component)source).isActor() || source instanceof PhysicalComponent && ((PhysicalComponent)source).getNature() != PhysicalComponentNature.NODE;
    }

    protected boolean isNodeComponent(EObject source) {
        return source instanceof PhysicalComponent && ((PhysicalComponent)source).getNature() == PhysicalComponentNature.NODE;
    }

    public boolean isValidCreationABDelegationExchange(EObject root, DSemanticDecorator preSourceView, DSemanticDecorator preTargetView) {
        EObject preTarget;
        EObject preSource = preSourceView.getTarget();
        if (preSource == (preTarget = preTargetView.getTarget())) {
            return false;
        }
        if (preSource instanceof Port && !(preSource instanceof ComponentPort)) {
            return false;
        }
        if (preTarget instanceof Port && !(preTarget instanceof ComponentPort)) {
            return false;
        }
        DSemanticDecorator sourcePart = preSourceView;
        DSemanticDecorator targetPart = preTargetView;
        if (preSource instanceof Port && sourcePart.eContainer() != null && sourcePart.eContainer() instanceof AbstractDNode) {
            sourcePart = (DSemanticDecorator)sourcePart.eContainer();
        }
        if (preTarget instanceof Port && targetPart.eContainer() != null && targetPart.eContainer() instanceof AbstractDNode) {
            targetPart = (DSemanticDecorator)targetPart.eContainer();
        }
        return !(!(sourcePart instanceof AbstractDNode) || !(sourcePart.getTarget() instanceof Part) && !(sourcePart.getTarget() instanceof Component) || !(targetPart instanceof AbstractDNode) || !(targetPart.getTarget() instanceof Part) && !(targetPart.getTarget() instanceof Component) || !sourcePart.eContents().contains((Object)targetPart));
    }

    public boolean isValidCreationABComponentExchangeWithoutPorts(EObject root, DSemanticDecorator preSourceView, DSemanticDecorator preTargetView) {
        boolean sourceValid = false;
        boolean targetValid = false;
        EObject preSource = preSourceView.getTarget();
        EObject preTarget = preTargetView.getTarget();
        EObject sourceComponent = this.getComponentType(preSourceView);
        EObject targetComponent = this.getComponentType(preTargetView);
        if (preSource == preTarget) {
            return false;
        }
        if (preSource instanceof ComponentPort) {
            sourceValid = false;
        } else if (sourceComponent instanceof Component) {
            sourceValid = true;
        }
        if (preTarget instanceof ComponentPort) {
            targetValid = false;
        } else if (targetComponent instanceof Component) {
            targetValid = true;
        }
        return sourceValid && targetValid;
    }

    public boolean isValidCreationPABComponentExchangeWithoutPorts(EObject container, DSemanticDecorator sourceView) {
        if (sourceView == null || sourceView.getTarget() == null) {
            return false;
        }
        if (sourceView.getTarget() instanceof PhysicalPort) {
            return false;
        }
        EObject source = this.getComponentType(sourceView);
        return this.isAbstractActorOrNotNodeComponent(source);
    }

    public boolean isValidCreationPABComponentExchangeWithoutPorts(EObject root, DSemanticDecorator preSourceView, DSemanticDecorator preTargetView) {
        if (!this.isValidCreationABComponentExchangeWithoutPorts(root, preSourceView, preTargetView)) {
            return false;
        }
        EObject source = this.getComponentType(preSourceView);
        EObject target = this.getComponentType(preTargetView);
        if (source == null || target == null) {
            return false;
        }
        if (source instanceof PhysicalComponent && target instanceof PhysicalComponent) {
            return this.isAbstractActorOrNotNodeComponent(source) && this.isAbstractActorOrNotNodeComponent(target);
        }
        return false;
    }

    public Component getFirstComponent(BlockArchitecture architecture) {
        return BlockArchitectureExt.getOrCreateSystem((BlockArchitecture)architecture);
    }

    public List<Component> getFirstComponents(BlockArchitecture architecture) {
        return BlockArchitectureExt.getFirstComponents((BlockArchitecture)architecture);
    }

    public List<Component> getFirstComponents(ModellingBlock block) {
        ArrayList<Component> result = new ArrayList<Component>();
        result.add((Component)block);
        return result;
    }

    public EObject getComponentType(Component element) {
        return element;
    }

    public EObject getComponentType(Port element) {
        return element.eContainer();
    }

    public EObject getComponentType(DSemanticDecorator targetView) {
        if (targetView.getTarget() != null) {
            if (targetView.getTarget() instanceof Component) {
                return this.getComponentType((Component)targetView.getTarget());
            }
            if (targetView.getTarget() instanceof Port) {
                return this.getComponentType((Port)targetView.getTarget());
            }
            if (targetView.getTarget() instanceof Part) {
                return this.getComponentType((Part)targetView.getTarget());
            }
            if (targetView.getTarget() instanceof AbstractPropertyValue) {
                return this.getComponentType((DSemanticDecorator)targetView.eContainer());
            }
            if (targetView.getTarget() instanceof ComponentPkg) {
                return targetView.getTarget();
            }
        }
        return null;
    }

    public EObject getComponentType(EObject target) {
        if (target instanceof Component) {
            return this.getComponentType((Component)target);
        }
        if (target instanceof Port) {
            return this.getComponentType((Port)target);
        }
        if (target instanceof Part) {
            return this.getComponentType((Part)target);
        }
        if (target instanceof ComponentPkg) {
            return target;
        }
        return null;
    }

    @Deprecated
    public EObject getRelatedComponent(Part element) {
        return element.getAbstractType();
    }

    @Deprecated
    public EObject getRelatedComponent(Port element) {
        return element.eContainer();
    }

    public AbstractType getComponentType(Part element) {
        return element.getAbstractType();
    }

    public Component createComponent(CapellaElement container, String nameVariable) {
        Component component = this.createComponent(container, false, nameVariable);
        INamePrefixService prefixService = (INamePrefixService)PlatformUI.getWorkbench().getService(INamePrefixService.class);
        String createdElementPrefix = prefixService.getPrefix((EObject)component);
        component.setName(CapellaServices.getService().getUniqueName((AbstractNamedElement)component, createdElementPrefix));
        return component;
    }

    private Component createComponentInternal(CapellaElement container, String nameVariable) {
        LogicalComponent element = null;
        EReference containerFeature = null;
        CapellaElement containerObject = null;
        if (container instanceof LogicalComponent || container instanceof LogicalComponentPkg || container instanceof LogicalArchitecture) {
            element = LaFactory.eINSTANCE.createLogicalComponent();
            if (container instanceof LogicalComponent) {
                containerFeature = LaPackage.Literals.LOGICAL_COMPONENT__OWNED_LOGICAL_COMPONENTS;
                containerObject = container;
            } else if (container instanceof LogicalComponentPkg) {
                containerFeature = LaPackage.Literals.LOGICAL_COMPONENT_PKG__OWNED_LOGICAL_COMPONENTS;
                containerObject = container;
            } else if (container instanceof LogicalArchitecture) {
                LogicalComponentPkg pkg = ((LogicalArchitecture)container).getOwnedLogicalComponentPkg();
                if (pkg == null) {
                    pkg = LaFactory.eINSTANCE.createLogicalComponentPkg();
                    ((LogicalArchitecture)container).setOwnedLogicalComponentPkg(pkg);
                }
                containerFeature = LaPackage.Literals.LOGICAL_COMPONENT_PKG__OWNED_LOGICAL_COMPONENTS;
                containerObject = pkg;
            }
        } else if (container instanceof PhysicalComponent || container instanceof PhysicalComponentPkg || container instanceof PhysicalArchitecture) {
            element = PaFactory.eINSTANCE.createPhysicalComponent();
            if (container instanceof PhysicalComponent) {
                containerFeature = PaPackage.Literals.PHYSICAL_COMPONENT__OWNED_PHYSICAL_COMPONENTS;
                containerObject = container;
            } else if (container instanceof PhysicalComponentPkg) {
                containerFeature = PaPackage.Literals.PHYSICAL_COMPONENT_PKG__OWNED_PHYSICAL_COMPONENTS;
                containerObject = container;
            } else if (container instanceof PhysicalArchitecture) {
                PhysicalComponentPkg pkg = ((PhysicalArchitecture)container).getOwnedPhysicalComponentPkg();
                if (pkg == null) {
                    pkg = PaFactory.eINSTANCE.createPhysicalComponentPkg();
                    ((PhysicalArchitecture)container).setOwnedPhysicalComponentPkg(pkg);
                }
                containerFeature = PaPackage.Literals.PHYSICAL_COMPONENT_PKG__OWNED_PHYSICAL_COMPONENTS;
                containerObject = pkg;
            }
        } else if (container instanceof Entity || container instanceof EntityPkg || container instanceof OperationalAnalysis) {
            element = OaFactory.eINSTANCE.createEntity();
            if (container instanceof Entity) {
                containerFeature = OaPackage.Literals.ENTITY__OWNED_ENTITIES;
                containerObject = container;
            } else if (container instanceof EntityPkg) {
                containerFeature = OaPackage.Literals.ENTITY_PKG__OWNED_ENTITIES;
                containerObject = container;
            } else if (container instanceof OperationalAnalysis) {
                EntityPkg pkg = ((OperationalAnalysis)container).getOwnedEntityPkg();
                if (pkg == null) {
                    pkg = OaFactory.eINSTANCE.createEntityPkg();
                    ((OperationalAnalysis)container).setOwnedEntityPkg(pkg);
                }
                containerFeature = OaPackage.Literals.ENTITY_PKG__OWNED_ENTITIES;
                containerObject = pkg;
            }
        } else if (container instanceof SystemComponent || container instanceof SystemComponentPkg || container instanceof SystemAnalysis) {
            element = CtxFactory.eINSTANCE.createSystemComponent();
            if (container instanceof SystemComponent) {
                containerFeature = CtxPackage.Literals.SYSTEM_COMPONENT__OWNED_SYSTEM_COMPONENTS;
                containerObject = container;
            } else if (container instanceof SystemComponentPkg) {
                containerFeature = CtxPackage.Literals.SYSTEM_COMPONENT_PKG__OWNED_SYSTEM_COMPONENTS;
                containerObject = container;
            } else if (container instanceof SystemAnalysis) {
                SystemComponentPkg pkg = ((SystemAnalysis)container).getOwnedSystemComponentPkg();
                if (pkg == null) {
                    pkg = CtxFactory.eINSTANCE.createSystemComponentPkg();
                    ((SystemAnalysis)container).setOwnedSystemComponentPkg(pkg);
                }
                containerFeature = CtxPackage.Literals.SYSTEM_COMPONENT_PKG__OWNED_SYSTEM_COMPONENTS;
                containerObject = pkg;
            }
        }
        if (element != null && containerObject != null && containerFeature != null) {
            ((EList)containerObject.eGet((EStructuralFeature)containerFeature)).add((Object)element);
        }
        if (nameVariable != null) {
            InterpreterUtil.getInterpreter((EObject)container).setVariable(nameVariable, (Object)element);
        }
        return element;
    }

    public Component createComponent(CapellaElement container, boolean creationService, String nameVariable) {
        Component component = this.createComponentInternal(container, nameVariable);
        if (creationService) {
            CapellaServices.getService().creationService((EObject)component);
        }
        return component;
    }

    public Component createComponent(CapellaElement container) {
        return this.createComponent(container, true, null);
    }

    public Component createActor(CapellaElement container, String nameVariable) {
        return this.createActor(container, false, nameVariable);
    }

    public Component createActor(CapellaElement container) {
        return this.createActor(container, true, null);
    }

    public Component createActor(CapellaElement container, boolean creationService, String nameVariable) {
        Component component = this.createComponent(container, nameVariable);
        if (component instanceof Entity) {
            component.setHuman(true);
        } else if (component instanceof PhysicalComponent) {
            PhysicalComponent physicalComponent = (PhysicalComponent)component;
            PhysicalComponentNature nature = this.computePhysicalActorNature(container);
            physicalComponent.setNature(nature);
        }
        component.setActor(true);
        if (creationService) {
            CapellaServices.getService().creationService((EObject)component);
        } else {
            INamePrefixService prefixService = (INamePrefixService)PlatformUI.getWorkbench().getService(INamePrefixService.class);
            String createdElementPrefix = prefixService.getPrefix((EObject)component);
            component.setName(CapellaServices.getService().getUniqueName((AbstractNamedElement)component, createdElementPrefix));
        }
        return component;
    }

    public PhysicalComponentNature computePhysicalActorNature(CapellaElement container) {
        PhysicalComponentNature nature = PhysicalComponentNature.NODE;
        PhysicalComponent parentComponent = null;
        if (container instanceof PhysicalComponent) {
            parentComponent = (PhysicalComponent)container;
        } else if (container instanceof PhysicalComponentPkg) {
            PhysicalComponentPkg pkg = (PhysicalComponentPkg)container;
            parentComponent = (PhysicalComponent)ComponentPkgExt.getParentComponent((ComponentPkg)pkg);
        }
        if (parentComponent != null && parentComponent.getNature() != PhysicalComponentNature.UNSET) {
            nature = parentComponent.getNature();
        }
        return nature;
    }

    public Collection<CapellaElement> PVinPVG(CapellaElement elem) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        for (EObject content : elem.eContents()) {
            if (!(content instanceof AbstractPropertyValue) && !(content instanceof PropertyValueGroup)) continue;
            result.add((CapellaElement)content);
        }
        return result;
    }

    public Collection<CapellaElement> computeValuedElements(CapellaElement elem) {
        ArrayList<CapellaElement> result;
        block5: {
            block4: {
                result = new ArrayList<CapellaElement>();
                if (!(elem instanceof AbstractPropertyValue)) break block4;
                AbstractPropertyValue abstractPropertyValue = (AbstractPropertyValue)elem;
                for (CapellaElement element : abstractPropertyValue.getValuedElements()) {
                    result.add(element);
                    if (!(element instanceof Component)) continue;
                    Component comp = (Component)element;
                    for (Part part : comp.getRepresentingParts()) {
                        result.add((CapellaElement)part);
                    }
                }
                break block5;
            }
            if (!(elem instanceof PropertyValueGroup)) break block5;
            PropertyValueGroup propertyValueGroup = (PropertyValueGroup)elem;
            for (CapellaElement element : propertyValueGroup.getValuedElements()) {
                result.add(element);
                if (!(element instanceof Component)) continue;
                Component comp = (Component)element;
                for (Part part : comp.getRepresentingParts()) {
                    result.add((CapellaElement)part);
                }
            }
        }
        return result;
    }

    public Collection<CapellaElement> computeAppliedPV(CapellaElement elem) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        result.addAll((Collection<CapellaElement>)elem.getAppliedPropertyValueGroups());
        result.addAll((Collection<CapellaElement>)elem.getAppliedPropertyValues());
        if (elem instanceof Part) {
            Part part = (Part)elem;
            result.addAll((Collection<CapellaElement>)part.getType().getAppliedPropertyValueGroups());
            result.addAll((Collection<CapellaElement>)part.getType().getAppliedPropertyValues());
        }
        return result;
    }

    public String computePVLabel(EObject PV) {
        return EObjectExt.getText((EObject)PV);
    }

    public String computeComponentLabel(EObject component) {
        return EObjectExt.getText((EObject)component);
    }

    public String computePartLabelMultiPartOnly(Part part) {
        if (this.isMultipartMode((ModelElement)part)) {
            return this.computePartLabel(part);
        }
        return "";
    }

    public String computePartLabel(Part part) {
        if (this.isMultipartMode((ModelElement)part)) {
            String mul = PropertyNamingHelper.multiplicityToStringDisplay((MultiplicityElement)part);
            NumericValue ownedMaxCard = part.getOwnedMaxCard();
            NumericValue ownedMinCard = part.getOwnedMinCard();
            if (ownedMinCard == null && ownedMaxCard == null) {
                return this.getDefaultKindLabel(part);
            }
            if (this.getCardValue(part, ownedMinCard).equalsIgnoreCase("1") && this.getCardValue(part, ownedMaxCard).equalsIgnoreCase("1")) {
                return this.getDefaultKindLabel(part);
            }
            if (this.getCardValue(part, ownedMinCard).equalsIgnoreCase("") && this.getCardValue(part, ownedMaxCard).equalsIgnoreCase("")) {
                return this.getDefaultKindLabel(part);
            }
            return String.valueOf(mul) + ' ' + EObjectExt.getText((EObject)part);
        }
        if (part.getName().length() == 0) {
            return "[" + part.eClass().getName() + "]";
        }
        return EObjectExt.getText((EObject)part.getType());
    }

    public String computePartLabelMultiPartMode(Part part) {
        if (this.isMultipartMode((ModelElement)part)) {
            String mul = PropertyNamingHelper.multiplicityToStringDisplay((MultiplicityElement)part);
            NumericValue ownedMaxCard = part.getOwnedMaxCard();
            NumericValue ownedMinCard = part.getOwnedMinCard();
            if (ownedMinCard == null && ownedMaxCard == null) {
                return this.getDefaultKindLabel(part);
            }
            if (this.getCardValue(part, ownedMinCard).equalsIgnoreCase("1") && this.getCardValue(part, ownedMaxCard).equalsIgnoreCase("1")) {
                return this.getDefaultKindLabel(part);
            }
            if (this.getCardValue(part, ownedMinCard).equalsIgnoreCase("") && this.getCardValue(part, ownedMaxCard).equalsIgnoreCase("")) {
                return this.getDefaultKindLabel(part);
            }
            return String.valueOf(mul) + ' ' + EObjectExt.getText((EObject)part);
        }
        String result = "";
        if (part.getAbstractType() instanceof ConfigurationItem) {
            ConfigurationItem type = (ConfigurationItem)part.getAbstractType();
            result = String.valueOf(result) + "[" + type.getKind().getName() + "] ";
        }
        result = part.getName().length() == 0 ? String.valueOf(result) + "[" + part.eClass().getName() + "]" : String.valueOf(result) + part.getName();
        return result;
    }

    private String getDefaultKindLabel(Part part) {
        return String.valueOf(' ') + EObjectExt.getText((EObject)part);
    }

    private String getCardValue(Part part, NumericValue card) {
        return PropertyNamingHelper.getCardValue((NumericValue)card);
    }

    public Collection<EObject> getComponentExchangeByGroupTargets(EObject source) {
        HashSet<EObject> semantics = new HashSet<EObject>();
        EObject related = source;
        if (related instanceof Part) {
            Part sourcePart = (Part)related;
            Component sourceComponent = (Component)((Part)related).getAbstractType();
            HashSet relatedExchanges = new HashSet();
            relatedExchanges.addAll((Collection)ModelCache.getCache(ComponentExt::getAllRelatedComponentExchange, (Object)sourcePart));
            relatedExchanges.addAll(ComponentExt.getAllRelatedComponentExchange((Component)sourceComponent, (boolean)false));
            for (ComponentExchange relatedExchange : relatedExchanges) {
                if (ComponentExchangeKind.DELEGATION.equals((Object)relatedExchange.getKind())) continue;
                Part src = this.getSourcePart(relatedExchange);
                if (src == null) {
                    semantics.addAll((Collection)ModelCache.getCache(ComponentExt::getRepresentingParts, (Object)ComponentExchangeExt.getSourceComponent((ComponentExchange)relatedExchange)));
                } else {
                    semantics.add((EObject)src);
                }
                Part target = this.getTargetPart(relatedExchange);
                if (target == null) {
                    semantics.addAll((Collection)ModelCache.getCache(ComponentExt::getRepresentingParts, (Object)ComponentExchangeExt.getTargetComponent((ComponentExchange)relatedExchange)));
                    continue;
                }
                semantics.add((EObject)src);
            }
        }
        semantics.remove(related);
        return semantics;
    }

    public Collection<CapellaElement> getComponentExchangeByGroupSemantics(EObject source) {
        Object sourceView = this.getInterpreterVariable(source, "sourceView");
        Object targetView = this.getInterpreterVariable(source, "targetView");
        return this.getComponentExchangeByGroupSemantics(source, (DSemanticDecorator)sourceView, (DSemanticDecorator)targetView);
    }

    public Collection<CapellaElement> getComponentExchangeByGroupSemantics(EObject source, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        Part sourcePart = (Part)sourceView.getTarget();
        Part targetPart = (Part)targetView.getTarget();
        Component sourceComponent = (Component)sourcePart.getAbstractType();
        Component targetComponent = (Component)targetPart.getAbstractType();
        ArrayList<CapellaElement> sources = new ArrayList<CapellaElement>();
        for (CapellaElement element : (Collection)ModelCache.getCache(ComponentExt::getAllRelatedComponentExchange, (Object)sourcePart)) {
            if (sources.contains(element)) continue;
            sources.add(element);
        }
        for (CapellaElement element : ComponentExt.getAllRelatedComponentExchange((Component)sourceComponent, (boolean)false)) {
            if (sources.contains(element)) continue;
            sources.add(element);
        }
        ArrayList<CapellaElement> targets = new ArrayList<CapellaElement>();
        for (CapellaElement element : ComponentExt.getAllRelatedComponentExchange((Part)targetPart)) {
            if (targets.contains(element)) continue;
            targets.add(element);
        }
        for (CapellaElement element : ComponentExt.getAllRelatedComponentExchange((Component)targetComponent, (boolean)false)) {
            if (targets.contains(element)) continue;
            targets.add(element);
        }
        sources.retainAll(targets);
        ArrayList<CapellaElement> target2 = new ArrayList<CapellaElement>(sources);
        Collections.sort(target2, this.getComparator());
        return target2;
    }

    public Collection<CapellaElement> getComponentExchangeByGroupOrientedSemanticElts(EObject source) {
        Object sourceView = this.getInterpreterVariable(source, "sourceView");
        Object targetView = this.getInterpreterVariable(source, "targetView");
        return this.getComponentExchangeByGroupOrientedSemanticElts(source, (DSemanticDecorator)sourceView, (DSemanticDecorator)targetView);
    }

    public Collection<CapellaElement> getComponentExchangeByGroupOrientedSemanticElts(final EObject source, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        Collection<CapellaElement> componentExchanges = this.getComponentExchangeByGroupSemantics(source, sourceView, targetView);
        Predicate<EObject> isPartSourceForCE = new Predicate<EObject>(){

            public boolean apply(EObject eObj) {
                if (eObj instanceof ComponentExchange) {
                    ComponentExchange ce = (ComponentExchange)eObj;
                    Part sourcePart = (Part)source;
                    ComponentPort cpSource = ComponentExchangeExt.getAttachingPort((Part)sourcePart, (ComponentExchange)ce);
                    ComponentPort cpTarget = (ComponentPort)ComponentExchangeExt.getOppositePort((ComponentExchange)ce, (Port)cpSource);
                    if (!(cpTarget instanceof ComponentPort) || !(cpSource instanceof ComponentPort)) {
                        return false;
                    }
                    if (PortExt.isInStrict((ComponentPort)cpSource)) {
                        return false;
                    }
                    if (PortExt.isOutStrict((ComponentPort)cpTarget)) {
                        return false;
                    }
                }
                return true;
            }
        };
        return Lists.newArrayList((Iterable)Iterables.filter(componentExchanges, (Predicate)isPartSourceForCE));
    }

    public EObject getComponentExchangeByGroupTarget(EObject related) {
        return related;
    }

    public boolean isValidComponentExchangeByGroupOrientedEdge(EObject semantic, DSemanticDecorator source, DSemanticDecorator target) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)source);
        DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
        if (!FilterHelper.isDesactivatedOnce("hide.simplified.oriented.grouped.component.exchanges.filter", descriptor)) {
            return false;
        }
        Collection<CapellaElement> result = this.getComponentExchangeByGroupOrientedSemanticElts(source.getTarget(), source, target);
        if (result.isEmpty()) {
            return false;
        }
        CapellaElement firstCE = result.iterator().next();
        if (firstCE instanceof ComponentExchange) {
            Part part = this.getSourcePart((ComponentExchange)firstCE);
            Part viewPart = (Part)source.getTarget();
            if (part != null && !part.equals(viewPart)) {
                return false;
            }
        }
        return true;
    }

    public boolean isValidComponentExchangeByGroupEdge(EObject communication, DSemanticDecorator source, DSemanticDecorator target) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)source);
        DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
        if (!FilterHelper.isDesactivatedOnce("hide.simplified.group.of.component.exchanges.filter", descriptor)) {
            return false;
        }
        EObject semantic = communication;
        Collection<CapellaElement> result = this.getComponentExchangeByGroupSemantics(source.getTarget(), source, target);
        semantic = (EObject)result.iterator().next();
        if (semantic instanceof ComponentExchange) {
            Part part = this.getSourcePart((ComponentExchange)semantic);
            Part viewPart = (Part)source.getTarget();
            if (part != null) {
                if (!part.equals(viewPart)) {
                    return false;
                }
            } else {
                Component cps = ComponentExchangeExt.getSourceComponent((ComponentExchange)((ComponentExchange)semantic));
                AbstractType type = viewPart.getAbstractType();
                if (cps != null && !cps.equals(type)) {
                    return false;
                }
            }
        }
        return true;
    }

    @Deprecated
    public boolean isFirstFilterActive(FilterDescription filter, DDiagram diagram) {
        DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
        return FilterHelper.isDesactivatedOnce(filter.getName(), descriptor);
    }

    public boolean isValidComponentExchangeByDelegationEdge(EObject communication, DSemanticDecorator source, DSemanticDecorator target) {
        DNodeContainer pNode;
        EObject parent;
        Collection delegating;
        boolean isValid;
        ComponentPort sourcePort;
        EObject viewTarget;
        EdgeTarget view;
        if (!(communication instanceof ComponentPort)) {
            return false;
        }
        if (source == null || target == null || source == target) {
            return false;
        }
        if (source.eContainer() == null || target.eContainer() == null) {
            return false;
        }
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)source);
        DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
        if (!FilterHelper.isDesactivatedOnce("hide.simplified.diagram.based.component.exchanges.filter", descriptor)) {
            return false;
        }
        Collection<? extends EObject> semantics = this.getComponentExchangeByDelegationSemantics(communication, source, target);
        if (semantics.isEmpty()) {
            return false;
        }
        if (source instanceof EdgeTarget) {
            view = (EdgeTarget)source;
            viewTarget = source.getTarget();
            if (viewTarget instanceof ComponentPort) {
                sourcePort = (ComponentPort)viewTarget;
                isValid = true;
                delegating = PortExt.getAllDelegatingComponentPorts((ComponentPort)sourcePort);
                parent = view.eContainer().eContainer();
                while (isValid && parent != null && parent instanceof DNodeContainer) {
                    pNode = (DNodeContainer)parent;
                    for (DNode border : pNode.getOwnedBorderedNodes()) {
                        if (border == target) {
                            return true;
                        }
                        if (!delegating.contains(border.getTarget())) continue;
                        isValid = false;
                    }
                    parent = parent.eContainer();
                }
                if (!isValid) {
                    return false;
                }
            }
        }
        if (target instanceof EdgeTarget) {
            view = (EdgeTarget)target;
            viewTarget = target.getTarget();
            if (viewTarget instanceof ComponentPort) {
                sourcePort = (ComponentPort)viewTarget;
                isValid = true;
                delegating = PortExt.getAllDelegatingComponentPorts((ComponentPort)sourcePort);
                parent = view.eContainer().eContainer();
                while (isValid && parent != null && parent instanceof DNodeContainer) {
                    pNode = (DNodeContainer)parent;
                    for (DNode border : pNode.getOwnedBorderedNodes()) {
                        if (border == source) {
                            return true;
                        }
                        if (!delegating.contains(border.getTarget())) continue;
                        isValid = false;
                    }
                    parent = parent.eContainer();
                }
                if (!isValid) {
                    return false;
                }
            }
        }
        return this.isUndoublonLink(source, target);
    }

    @Deprecated
    public boolean isValidConnectionEdge(ComponentExchange communication, DSemanticDecorator source, DSemanticDecorator target) {
        return this.isValidComponentExchangeEdge((EObject)communication, source, target);
    }

    public boolean isValidComponentExchangeEdge(EObject communication, DSemanticDecorator source, DSemanticDecorator target) {
        if (communication instanceof ComponentExchange) {
            return this.isValidLinkEdge(this.getComponentExchangeWrapper((ComponentExchange)communication), source, target, true) && !this.isComponentExchangeCategoryEdgeDisplayed((ComponentExchange)communication, source, target);
        }
        return false;
    }

    public boolean isComponentExchangeCategoryEdgeDisplayed(ComponentExchange exchange, DSemanticDecorator source, DSemanticDecorator target) {
        Set<DEdge> edgesOfSource = this.getEdgesOnOwnedBoderedNodesOfContainer(source);
        Set<DEdge> edgesOfTarget = this.getEdgesOnOwnedBoderedNodesOfContainer(target);
        if (edgesOfTarget.isEmpty() || edgesOfSource.isEmpty()) {
            return false;
        }
        edgesOfTarget.retainAll(edgesOfSource);
        Set<DEdge> commonEdges = edgesOfTarget;
        for (DEdge edge : commonEdges) {
            ComponentExchangeCategory category;
            EObject edgeTarget = edge.getTarget();
            if (!(edgeTarget instanceof ComponentExchangeCategory) || !ComponentExchangeCategoryExt.getCoveredComponentExchanges((ComponentExchangeCategory)(category = (ComponentExchangeCategory)edgeTarget)).contains(exchange)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidPortAllocationEdge(PortAllocation communication, DSemanticDecorator source, DSemanticDecorator target) {
        return this.isValidLinkEdge(this.getPortAllocationWrapper((Allocation)communication), source, target, true);
    }

    public boolean isValidComponentPortAllocationEdge(ComponentPortAllocation communication, DSemanticDecorator source, DSemanticDecorator target) {
        return this.isValidLinkEdge(this.getComponentPortAllocationWrapper((Allocation)communication), source, target, true) && !this.isPhysicalCategoryEdgeDisplayed(communication, source, target);
    }

    public boolean isValidInteractionEdge(FunctionalExchange communication, DSemanticDecorator source, DSemanticDecorator target) {
        return this.isValidLinkEdge(this.getFunctionalExchangeWrapper(communication), source, target, true);
    }

    public boolean isValidFunctionalExchangeEdge(FunctionalExchange communication, DSemanticDecorator source, DSemanticDecorator target) {
        return this.isValidLinkEdge(this.getFunctionalExchangeWrapper(communication), source, target, true);
    }

    public boolean isValidPhysicalLinkEdge(PhysicalLink link, DSemanticDecorator source, DSemanticDecorator target) {
        return this.isValidLinkEdge(this.getPhysicalLinkWrapper(link), source, target, true) && !this.isPhysicalCategoryEdgeDisplayed(link, source, target);
    }

    public boolean isPhysicalCategoryEdgeDisplayed(PhysicalLink link, DSemanticDecorator source, DSemanticDecorator target) {
        Set<DEdge> edgesOfSource = this.getEdgesOnOwnedBoderedNodesOfContainer(source);
        Set<DEdge> edgesOfTarget = this.getEdgesOnOwnedBoderedNodesOfContainer(target);
        if (edgesOfTarget.isEmpty() || edgesOfSource.isEmpty()) {
            return false;
        }
        edgesOfTarget.retainAll(edgesOfSource);
        Set<DEdge> commonEdges = edgesOfTarget;
        for (DEdge edge : commonEdges) {
            PhysicalLinkCategory category;
            EObject edgeTarget = edge.getTarget();
            if (!(edgeTarget instanceof PhysicalLinkCategory) || !PhysicalLinkCategoryExt.getCoveredPhysicalLinks((PhysicalLinkCategory)(category = (PhysicalLinkCategory)edgeTarget)).contains(link)) continue;
            return true;
        }
        return false;
    }

    public boolean isPhysicalCategoryEdgeDisplayed(ComponentPortAllocation cpa, DSemanticDecorator source, DSemanticDecorator target) {
        Set<DEdge> edgesOfSource = this.getEdgesOnOwnedBoderedNodesOfContainer(source);
        Set<DEdge> edgesOfTarget = this.getEdgesOnOwnedBoderedNodesOfContainer(target);
        if (edgesOfTarget.isEmpty() || edgesOfSource.isEmpty()) {
            return false;
        }
        edgesOfTarget.retainAll(edgesOfSource);
        Set<DEdge> commonEdges = edgesOfTarget;
        for (DEdge edge : commonEdges) {
            PhysicalLinkCategory category;
            EObject edgeTarget = edge.getTarget();
            if (!(edgeTarget instanceof PhysicalLinkCategory) || !PhysicalLinkCategoryExt.getCoveredComponentPortAllocations((PhysicalLinkCategory)(category = (PhysicalLinkCategory)edgeTarget)).contains(cpa)) continue;
            return true;
        }
        return false;
    }

    private Set<DEdge> getEdgesOnOwnedBoderedNodesOfContainer(DSemanticDecorator source) {
        HashSet<DEdge> edges = new HashSet<DEdge>();
        if (source instanceof DNode) {
            AbstractDNode portContainer = (AbstractDNode)source.eContainer();
            for (DNode borderedNode : portContainer.getOwnedBorderedNodes()) {
                edges.addAll((Collection<DEdge>)borderedNode.getOutgoingEdges());
                edges.addAll((Collection<DEdge>)borderedNode.getIncomingEdges());
            }
        }
        return edges;
    }

    AbstractLink getPortAllocationWrapper(Allocation object) {
        if (this.portAllocationWrapper == null) {
            this.portAllocationWrapper = new PortAllocationWrapper();
        }
        this.portAllocationWrapper.setData((EObject)object);
        return this.portAllocationWrapper;
    }

    AbstractLink getComponentPortAllocationWrapper(Allocation object) {
        if (this.componentPortAllocationWrapper == null) {
            this.componentPortAllocationWrapper = new ComponentPortAllocationWrapper();
        }
        this.componentPortAllocationWrapper.setData((EObject)object);
        return this.componentPortAllocationWrapper;
    }

    AbstractLink getComponentExchangeWrapper(ComponentExchange object) {
        if (this.connectionWrapper == null) {
            this.connectionWrapper = new ComponentExchangeWrapper();
        }
        this.connectionWrapper.setData((EObject)object);
        return this.connectionWrapper;
    }

    AbstractLink getPhysicalLinkWrapper(PhysicalLink object) {
        if (this.linkWrapper == null) {
            this.linkWrapper = new PhysicalLinkWrapper();
        }
        this.linkWrapper.setData((EObject)object);
        return this.linkWrapper;
    }

    AbstractLink getFunctionalExchangeWrapper(FunctionalExchange object) {
        if (this.functionalExchangeWrapper == null) {
            this.functionalExchangeWrapper = new FunctionalExchangeWrapper();
        }
        this.functionalExchangeWrapper.setData((EObject)object);
        return this.functionalExchangeWrapper;
    }

    public boolean isOrientationAllowed(EObject context) {
        Port sourcePort = this.getSourcePort(context);
        Port targetPort = this.getTargetPort(context);
        return sourcePort instanceof ComponentPort && targetPort instanceof ComponentPort && ((ComponentPort)sourcePort).getKind() == ComponentPortKind.STANDARD && ((ComponentPort)targetPort).getKind() == ComponentPortKind.STANDARD;
    }

    public Port getSourcePort(EObject context) {
        if (context instanceof ComponentExchange) {
            ComponentExchangeWrapper linkConnection = new ComponentExchangeWrapper();
            linkConnection.setData(context);
            return linkConnection.getSourcePort();
        }
        if (context instanceof PhysicalLink) {
            PhysicalLinkWrapper linkConnection = new PhysicalLinkWrapper();
            linkConnection.setData(context);
            return linkConnection.getSourcePort();
        }
        return null;
    }

    public Port getTargetPort(EObject context) {
        if (context instanceof ComponentExchange) {
            ComponentExchangeWrapper linkConnection = new ComponentExchangeWrapper();
            linkConnection.setData(context);
            return linkConnection.getTargetPort();
        }
        if (context instanceof PhysicalLink) {
            PhysicalLinkWrapper linkConnection = new PhysicalLinkWrapper();
            linkConnection.setData(context);
            return linkConnection.getTargetPort();
        }
        return null;
    }

    public boolean isValidLinkEdge(AbstractLink link, DSemanticDecorator source, DSemanticDecorator target, boolean strict) {
        boolean valid = false;
        DSemanticDecorator sourceElement = source;
        DSemanticDecorator targetElement = target;
        if (link.getData() == null) {
            return false;
        }
        if (link.getData().eContainer() == null) {
            return false;
        }
        if (strict) {
            if (link.getSource() instanceof Port && sourceElement.getTarget() instanceof Part) {
                return false;
            }
            if (link.getTarget() instanceof Port && targetElement.getTarget() instanceof Part) {
                return false;
            }
            if (link.getSourcePort() != null && link.getSourcePort() != sourceElement.getTarget()) {
                return false;
            }
            if (link.getTargetPort() != null && link.getTargetPort() != targetElement.getTarget()) {
                return false;
            }
        }
        if (sourceElement.getTarget() instanceof Port) {
            sourceElement = (DSemanticDecorator)sourceElement.eContainer();
        }
        if (targetElement.getTarget() instanceof Port) {
            targetElement = (DSemanticDecorator)targetElement.eContainer();
        }
        if (link.getSourcePart() != null && link.getSourcePart() != sourceElement.getTarget()) {
            return false;
        }
        if (link.getTargetPart() != null && link.getTargetPart() != targetElement.getTarget()) {
            return false;
        }
        valid = true;
        if (link.getKind() == ComponentExchangeKind.DELEGATION) {
            return targetElement.eContainer() == sourceElement;
        }
        if (!this.isMultipartMode(link.getData()) && !(BlockArchitectureExt.getRootBlockArchitecture((EObject)link.getData()) instanceof OperationalAnalysis)) {
            return valid;
        }
        return this.isUndoublonLink(source, target);
    }

    private boolean isUndoublonLink(DSemanticDecorator source, DSemanticDecorator target) {
        DSemanticDecorator sourceElement = source;
        DSemanticDecorator targetElement = target;
        boolean valid = true;
        if (sourceElement.getTarget() instanceof Port) {
            sourceElement = (DSemanticDecorator)sourceElement.eContainer();
        }
        if (targetElement.getTarget() instanceof Port) {
            targetElement = (DSemanticDecorator)targetElement.eContainer();
        }
        LinkedList<EObject> sourceParents = this.getParents((EObject)source, DiagramPackage.Literals.DDIAGRAM);
        LinkedList<EObject> targetParents = this.getParents((EObject)target, DiagramPackage.Literals.DDIAGRAM);
        sourceParents.remove(sourceElement);
        targetParents.remove(targetElement);
        HashSet<EObject> targetParentSet = new HashSet<EObject>(targetParents);
        Object current = null;
        if (!sourceParents.isEmpty()) {
            current = sourceParents.removeLast();
            while (current != null && targetParentSet.contains(current)) {
                current = !sourceParents.isEmpty() ? sourceParents.removeLast() : null;
            }
        }
        if (current != null && current instanceof DDiagramElement) {
            for (DSemanticDecorator dSemanticDecorator : DiagramServices.getDiagramServices().getDiagramElements((EObject)current)) {
                if (dSemanticDecorator.getTarget() == null || !dSemanticDecorator.getTarget().equals(targetElement.getTarget())) continue;
                valid = false;
            }
        }
        return valid;
    }

    public Collection<Component> getSubDefinedByUsedComponents(Component component) {
        LinkedList<Component> toVisit = new LinkedList<Component>();
        HashSet<Component> components = new HashSet<Component>();
        toVisit.add(component);
        while (!toVisit.isEmpty()) {
            Component visited = (Component)toVisit.removeFirst();
            components.add(visited);
            for (Component c : ComponentExt.getSubDefinedComponents((Component)visited)) {
                toVisit.addLast(c);
            }
            for (Part part : this.getParts((CapellaElement)visited, CsPackage.Literals.COMPONENT, null)) {
                AbstractType type = this.getComponentType(part);
                if (!(type instanceof Component)) continue;
                toVisit.addLast((Component)type);
            }
        }
        components.remove(component);
        return components;
    }

    protected LinkedList<EObject> getParents(EObject object, EClass clazz) {
        LinkedList<EObject> parents = new LinkedList<EObject>();
        EObject current = object;
        if (current == null) {
            return parents;
        }
        current = current.eContainer();
        while (current != null && !clazz.isInstance((Object)current)) {
            parents.addLast(current);
            current = current.eContainer();
        }
        return parents;
    }

    public Collection<? extends EObject> getComponentExchangeSources(ComponentExchange connection) {
        Collection<? extends Port> source = this.getComponentExchangeWrapper(connection).getSourcePorts();
        if (source == null) {
            source = Collections.singletonList(this.getComponentExchangeWrapper(connection).getSourcePart());
        }
        return source;
    }

    public String getComponentExchangeLabelByDelegation(DSemanticDecorator view) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        EList sems = ((DRepresentationElement)view).getSemanticElements();
        ArrayList<ComponentExchange> exchanges = new ArrayList<ComponentExchange>();
        for (EObject semantic : sems) {
            if (!(semantic instanceof ComponentExchange)) continue;
            if (((ComponentExchange)semantic).getKind() == ComponentExchangeKind.DELEGATION) {
                return " ";
            }
            exchanges.add((ComponentExchange)semantic);
        }
        StringBuilder result = new StringBuilder();
        int index = 0;
        for (ComponentExchange exchange : exchanges) {
            result.append(FaServices.getFaServices().getComponentExchangeLabel(exchange, diagram));
            if (++index >= exchanges.size()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public String getComponentExchangeLabelByDelegationOriented(DSemanticDecorator view) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        EList sems = ((DRepresentationElement)view).getSemanticElements();
        ArrayList exchanges = Lists.newArrayList();
        for (EObject semantic : sems) {
            if (!(semantic instanceof ComponentExchange)) continue;
            if (((ComponentExchange)semantic).getKind() == ComponentExchangeKind.DELEGATION) {
                return " ";
            }
            exchanges.add((ComponentExchange)semantic);
        }
        StringBuilder result = new StringBuilder();
        int index = 0;
        for (ComponentExchange exchange : exchanges) {
            result.append(FaServices.getFaServices().getComponentExchangeLabel(exchange, diagram));
            if (++index >= exchanges.size()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public String getComponentExchangeLabelByDelegationReversed(DSemanticDecorator view) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        EList sems = ((DRepresentationElement)view).getSemanticElements();
        ArrayList exchanges = Lists.newArrayList();
        Part part = (Part)view.getTarget();
        PhysicalComponent physicalComponent = (PhysicalComponent)part.getAbstractType();
        for (EObject semantic : sems) {
            if (!(semantic instanceof ComponentExchange)) continue;
            if (((ComponentExchange)semantic).getKind() == ComponentExchangeKind.DELEGATION) {
                return " ";
            }
            InformationsExchanger port = ((ComponentExchange)semantic).getSource();
            EObject ownerComponent = port.eContainer();
            if (physicalComponent.equals(ownerComponent)) continue;
            exchanges.add((ComponentExchange)semantic);
        }
        StringBuilder result = new StringBuilder();
        int index = 0;
        for (ComponentExchange exchange : exchanges) {
            result.append(FaServices.getFaServices().getComponentExchangeLabel(exchange, diagram));
            if (++index >= exchanges.size()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public Collection<ComponentPort> getAllLinkedDelegatedComponentPorts(ComponentPort port) {
        return PortExt.getAllLinkedDelegatedComponentPorts((ComponentPort)port);
    }

    public List<ComponentExchange> getAssemblyComponentExchanges(ComponentPort port) {
        return PortExt.getAssemblyComponentExchanges((ComponentPort)port);
    }

    public List<ComponentExchange> getFlowComponentExchanges(ComponentPort port) {
        return PortExt.getFlowComponentExchanges((ComponentPort)port);
    }

    public Collection<CapellaElement> getAllRelatedLinks(Port port) {
        ArrayList<CapellaElement> target = new ArrayList<CapellaElement>();
        if (port instanceof ComponentPort) {
            for (Port port2 : this.getAllLinkedDelegatedComponentPorts((ComponentPort)port)) {
                if (!(port2 instanceof ComponentPort)) continue;
                for (ComponentExchange exchange : this.getAssemblyComponentExchanges((ComponentPort)port2)) {
                    if (target.contains(exchange)) continue;
                    target.add((CapellaElement)exchange);
                }
                for (ComponentExchange exchange : this.getFlowComponentExchanges((ComponentPort)port2)) {
                    if (target.contains(exchange)) continue;
                    target.add((CapellaElement)exchange);
                }
            }
        }
        return target;
    }

    public Collection<? extends EObject> getComponentExchangeByDelegationSemantics(EObject related) {
        Object sourceView = this.getInterpreterVariable(related, "sourceView");
        Object targetView = this.getInterpreterVariable(related, "targetView");
        return this.getComponentExchangeByDelegationSemantics(related, sourceView, targetView);
    }

    public Collection<? extends EObject> getComponentExchangeByDelegationSemantics(EObject related, Object sourceView, Object targetView) {
        Collection<Object> target = new ArrayList();
        if (sourceView instanceof EdgeTarget && targetView instanceof EdgeTarget) {
            EdgeTarget sourceNode = (EdgeTarget)sourceView;
            EdgeTarget targetNode = (EdgeTarget)targetView;
            if (sourceNode instanceof DSemanticDecorator && targetNode instanceof DSemanticDecorator) {
                EObject sourcePort = ((DSemanticDecorator)sourceNode).getTarget();
                EObject targetPort = ((DSemanticDecorator)targetNode).getTarget();
                if (sourcePort != null && targetPort != null && sourcePort instanceof Port && targetPort instanceof Port) {
                    Collection<CapellaElement> sourceLinks = this.getAllRelatedLinks((Port)sourcePort);
                    Collection<CapellaElement> targetLinks = this.getAllRelatedLinks((Port)targetPort);
                    sourceLinks.retainAll(targetLinks);
                    target = sourceLinks;
                    ArrayList<EObject> a = new ArrayList<EObject>();
                    for (EObject eObject : target) {
                        if (!(eObject instanceof ComponentExchange)) continue;
                        ComponentExchange cee = (ComponentExchange)eObject;
                        Part sourcePart = this.getSourcePart(cee);
                        Part targetPart = this.getTargetPart(cee);
                        if (sourcePart != null && this.getRelatedPart((DSemanticDecorator)sourceNode) != sourcePart) {
                            a.add(eObject);
                        }
                        if (targetPart == null || this.getRelatedPart((DSemanticDecorator)targetNode) == targetPart) continue;
                        a.add(eObject);
                    }
                    target.removeAll(a);
                }
            }
        }
        ArrayList target2 = new ArrayList(target);
        Collections.sort(target2, this.getComparator());
        return target2;
    }

    public Part getSourcePart(ComponentExchange connection) {
        return ComponentExchangeExt.getSourcePart((ComponentExchange)connection);
    }

    public Part getTargetPart(ComponentExchange connection) {
        return ComponentExchangeExt.getTargetPart((ComponentExchange)connection);
    }

    public Port getSourcePort(ComponentExchange connection) {
        return ComponentExchangeExt.getSourcePort((ComponentExchange)connection);
    }

    public Port getTargetPort(ComponentExchange connection) {
        return ComponentExchangeExt.getTargetPort((ComponentExchange)connection);
    }

    public EObject getComponentExchangeByDelegationTarget(EObject related) {
        if (related instanceof ComponentPort) {
            return related;
        }
        if (related instanceof ComponentExchange) {
            return this.getComponentExchangeByDelegationTarget((EObject)((ComponentExchange)related).getSource());
        }
        return related;
    }

    public Collection<? extends EObject> getComponentExchangeLowestTargets(EObject related) {
        ArrayList<ComponentPort> target = new ArrayList<ComponentPort>();
        if (related instanceof ComponentPort) {
            ComponentPort port = (ComponentPort)related;
            for (ComponentPort connectedPort : PortExt.getConnectedComponentPortsWithoutDelegation((ComponentPort)port)) {
                if (target.contains(connectedPort)) continue;
                target.add(connectedPort);
            }
            Collection delegateds = PortExt.getAllLinkedDelegatedComponentPorts((ComponentPort)port);
            delegateds.remove(port);
            for (Port relatedPort : delegateds) {
                if (!(relatedPort instanceof ComponentPort)) continue;
                for (Port connectedPort : PortExt.getConnectedComponentPortsWithoutDelegation((ComponentPort)((ComponentPort)relatedPort))) {
                    Collection ports = PortExt.getAllDelegatedComponentPorts((ComponentPort)((ComponentPort)connectedPort));
                    ports.add((ComponentPort)connectedPort);
                    for (ComponentPort delegatedPort : ports) {
                        if (!PortExt.getDelegatedComponentPorts((ComponentPort)delegatedPort).isEmpty() || target.contains(delegatedPort)) continue;
                        target.add(delegatedPort);
                    }
                }
            }
            Iterator objects = target.iterator();
            while (objects.hasNext()) {
                ComponentPort result = (ComponentPort)objects.next();
                Collection resultPort = PortExt.getDelegatingComponentPorts((ComponentPort)result);
                resultPort.retainAll(target);
                if (resultPort.isEmpty()) continue;
                objects.remove();
            }
        }
        return target;
    }

    public Collection<? extends EObject> getComponentExchangeByDelegationTargets(EObject related) {
        ArrayList<Port> target = new ArrayList<Port>();
        if (related instanceof ComponentPort) {
            ComponentPort port = (ComponentPort)related;
            for (Port relatedPort : PortExt.getAllLinkedDelegatedComponentPorts((ComponentPort)port)) {
                Collection<? extends Port> a;
                if (!(relatedPort instanceof ComponentPort)) continue;
                for (ComponentExchange exchange : PortExt.getAssemblyComponentExchanges((ComponentPort)((ComponentPort)relatedPort))) {
                    a = this.getComponentExchangeWrapper(exchange).getTargetPorts();
                    if (a.contains(related)) continue;
                    for (Port port2 : a) {
                        if (target.contains(port2)) continue;
                        target.add(port2);
                    }
                }
                for (ComponentExchange exchange : PortExt.getFlowComponentExchanges((ComponentPort)((ComponentPort)relatedPort))) {
                    a = this.getComponentExchangeWrapper(exchange).getTargetPorts();
                    if (a.contains(related)) continue;
                    for (Port port3 : a) {
                        if (target.contains(port3)) continue;
                        target.add(port3);
                    }
                }
            }
        } else if (related instanceof ComponentExchange) {
            return this.getComponentExchangeByDelegationTargets((EObject)((ComponentExchange)related).getSource());
        }
        return target;
    }

    public EObject getComponentExchangeSource(ComponentExchange connection) {
        Port source = this.getComponentExchangeWrapper(connection).getSourcePort();
        if (source == null) {
            source = this.getComponentExchangeWrapper(connection).getSourcePart();
        }
        return source;
    }

    public EObject getComponentPortAllocationSource(ComponentPortAllocation connection) {
        Port source = this.getComponentPortAllocationWrapper((Allocation)connection).getSourcePort();
        if (source == null) {
            source = this.getComponentPortAllocationWrapper((Allocation)connection).getSourcePart();
        }
        return source;
    }

    public EObject getComponentPortAllocationTarget(ComponentPortAllocation connection) {
        Port source = this.getComponentPortAllocationWrapper((Allocation)connection).getTargetPort();
        if (source == null) {
            source = this.getComponentPortAllocationWrapper((Allocation)connection).getTargetPart();
        }
        return source;
    }

    public EObject getComponentExchangeTarget(ComponentExchange connection) {
        Port target = this.getComponentExchangeWrapper(connection).getTargetPort();
        if (target == null) {
            target = this.getComponentExchangeWrapper(connection).getTargetPart();
        }
        return target;
    }

    public EObject getPhysicalLinkSource(PhysicalLink connection) {
        return this.getPhysicalLinkWrapper(connection).getSourcePort();
    }

    public EObject getPhysicalLinkTarget(PhysicalLink connection) {
        return this.getPhysicalLinkWrapper(connection).getTargetPort();
    }

    public Comparator<CapellaElement> getComparator() {
        return new Comparator<CapellaElement>(){

            @Override
            public int compare(CapellaElement o1, CapellaElement o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null || o1.getId() == null) {
                    return -1;
                }
                if (o2 == null || o2.getId() == null) {
                    return 1;
                }
                if (o1 instanceof AbstractNamedElement && o2 instanceof AbstractNamedElement) {
                    AbstractNamedElement a1 = (AbstractNamedElement)o1;
                    AbstractNamedElement a2 = (AbstractNamedElement)o2;
                    if (a1.getName() != null && a2.getName() != null) {
                        return a1.getName().compareTo(a2.getName());
                    }
                }
                return o1.getId().compareTo(o2.getId());
            }
        };
    }

    public Collection<CapellaElement> getComponentExchangeSemantics(EObject element) {
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>();
        if (element instanceof Component) {
            list.addAll(ComponentExt.getAllOwnedComponentExchanges((Component)((Component)element)));
        } else if (element instanceof BlockArchitecture) {
            list.addAll(BlockArchitectureExt.getAllComponentExchanges((BlockArchitecture)((BlockArchitecture)element)));
        }
        return list;
    }

    public List<EObject> getPartSemanticElements(NamedElement element) {
        ArrayList<EObject> elements = new ArrayList<EObject>();
        if (element instanceof Part) {
            elements.add((EObject)element);
            elements.add((EObject)((Part)element).getAbstractType());
        } else if (element instanceof Component) {
            elements.add((EObject)element);
            elements.addAll((Collection<EObject>)((Component)element).getRepresentingParts());
        }
        return elements;
    }

    public List<AbstractFunction> getAllocatedFunctions(Part part) {
        if (part.getAbstractType() instanceof Component) {
            return this.getAllocatedFunctions((Component)part.getAbstractType());
        }
        return Collections.emptyList();
    }

    public List<AbstractFunction> getAllocatedFunctions(Component component) {
        ArrayList<AbstractFunction> list = new ArrayList<AbstractFunction>();
        for (ComponentFunctionalAllocation alloc : component.getFunctionalAllocations()) {
            if (alloc.getFunction() != null) {
                list.add(alloc.getFunction());
            }
            if (alloc.getFunction() == null || alloc.getFunction().eContainer() == null || !(alloc.getFunction().eContainer() instanceof AbstractFunction)) continue;
            list.add((AbstractFunction)alloc.getFunction().eContainer());
        }
        return list;
    }

    public Collection<? extends Component> getABInsertActor(CapellaElement capellaElement) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_AB_INSERT_ACTOR_FOR_LIB, (Object)capellaElement);
    }

    public Collection<? extends Component> getABInsertComponent(CapellaElement capellaElement) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_AB_INSERT_COMPONENT_FOR_LIB, (Object)capellaElement);
    }

    public Collection<PhysicalComponent> getPABInsertNodeComponent(CapellaElement capellaElement) {
        List initialCollection = QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_AB_INSERT_COMPONENT_FOR_LIB, (Object)capellaElement);
        return initialCollection.stream().filter(PhysicalComponentExt::isNode).collect(Collectors.toList());
    }

    public Collection<PhysicalComponent> getPABInsertBehaviourComponent(CapellaElement capellaElement) {
        List initialCollection = QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_AB_INSERT_COMPONENT_FOR_LIB, (Object)capellaElement);
        return initialCollection.stream().filter(PhysicalComponentExt::isBehaviour).collect(Collectors.toList());
    }

    public Collection<? extends CapellaElement> getABShowHideActor(DSemanticDecorator view) {
        return this.getABShowHideComponentForActor(view).stream().filter(ComponentExt::isActor).collect(Collectors.toList());
    }

    protected List<Part> getParts(CapellaElement element, EClass eClass, EClass excludeEClass) {
        ArrayList<Part> parts = new ArrayList<Part>();
        List subParts = new ArrayList();
        if (element instanceof Component) {
            subParts = ComponentExt.getSubParts((Component)((Component)element));
        } else if (element instanceof ComponentPkg) {
            subParts = ((ComponentPkg)element).getOwnedParts();
        }
        for (Part part : subParts) {
            if (!(part instanceof Part) || !eClass.isInstance((Object)part.getAbstractType()) || excludeEClass != null && excludeEClass.isInstance((Object)part.getAbstractType())) continue;
            parts.add(part);
        }
        return parts;
    }

    Couple<DNode, Boolean> createViewOrGetPort(DNodeContainer parent, Port target) {
        for (DNode node : parent.getOwnedBorderedNodes()) {
            if (node.getTarget() == null || !node.getTarget().equals(target)) continue;
            return new Couple((Object)node, (Object)Boolean.FALSE);
        }
        DNode created = FaServices.getFaServices().createViewComponentPort(target, (DragAndDropTarget)parent, parent.getParentDiagram());
        return new Couple((Object)created, (Object)Boolean.TRUE);
    }

    Couple<DNode, Boolean> createViewOrGetPhysicalPort(DNodeContainer parent, Port target) {
        for (DNode node : parent.getOwnedBorderedNodes()) {
            if (node.getTarget() == null || !node.getTarget().equals(target)) continue;
            return new Couple((Object)node, (Object)Boolean.FALSE);
        }
        DNode created = FaServices.getFaServices().createViewPhysicalPort(target, (DragAndDropTarget)parent, parent.getParentDiagram());
        return new Couple((Object)created, (Object)Boolean.TRUE);
    }

    @Deprecated
    Couple<DNodeContainer, Boolean> createViewOrGetPart(DragAndDropTarget parent, EObject target) {
        EList elements = null;
        if (parent instanceof DDiagram) {
            elements = ((DDiagram)parent).getOwnedDiagramElements();
        } else if (parent instanceof DNodeContainer) {
            elements = ((DNodeContainer)parent).getOwnedDiagramElements();
        }
        if (elements != null) {
            for (DDiagramElement node : elements) {
                if (!(node instanceof DNodeContainer) || node.getTarget() == null || !node.getTarget().equals(target)) continue;
                return new Couple((Object)((DNodeContainer)node), (Object)Boolean.FALSE);
            }
        }
        DNodeContainer created = FaServices.getFaServices().createViewPart(target, parent, CapellaServices.getService().getDiagramContainer((EObject)parent));
        return new Couple((Object)created, (Object)Boolean.TRUE);
    }

    @Deprecated
    Couple<DNodeContainer, Boolean> createViewOrGetDeployedPart(DragAndDropTarget parent, EObject target) {
        EList elements = null;
        if (parent instanceof DDiagram) {
            elements = ((DDiagram)parent).getOwnedDiagramElements();
        } else if (parent instanceof DNodeContainer) {
            elements = ((DNodeContainer)parent).getOwnedDiagramElements();
        }
        if (elements != null) {
            for (DDiagramElement node : elements) {
                if (!(node instanceof DNodeContainer) || node.getTarget() == null || !node.getTarget().equals(target)) continue;
                return new Couple((Object)((DNodeContainer)node), (Object)Boolean.FALSE);
            }
        }
        DNodeContainer created = FaServices.getFaServices().createViewDeployedPart(target, parent, CapellaServices.getService().getDiagramContainer((EObject)parent));
        return new Couple((Object)created, (Object)Boolean.TRUE);
    }

    @Deprecated
    public boolean isDeployed(DNodeContainer view) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        String mappingName = MappingConstantsHelper.getMappingABDeployedElement(diagram);
        return view.getMapping().getName().equals(mappingName);
    }

    public List<EObject> getDeployableLocations(DeployableElement element) {
        ArrayList<EObject> parents = new ArrayList<EObject>();
        for (AbstractDeploymentLink linka : element.getDeployingLinks()) {
            parents.add((EObject)linka.getLocation());
        }
        return parents;
    }

    public void showABContextualElements(DDiagram diagram) {
        DDiagramContents context = FaServices.getFaServices().getDDiagramContents(diagram);
        DRepresentationDescriptor descriptor = new DRepresentationQuery((DRepresentation)diagram).getRepresentationDescriptor();
        this.showABContextualElements(context, ContextualDiagramHelper.getService().getContextualElements(descriptor));
    }

    public void showABContextualElements(DDiagramContents context, Collection<EObject> contextualElements) {
        if (!contextualElements.isEmpty()) {
            DDiagram diagram = context.getDDiagram();
            HashSet<EObject> contextualParts = new HashSet<EObject>();
            HashSet<AbstractFunction> contextualFunctions = new HashSet<AbstractFunction>();
            HashSet<FunctionalExchange> contextualFunctionExchanges = new HashSet<FunctionalExchange>();
            HashSet<EObject> contextualFunctionalChains = new HashSet<EObject>();
            HashSet<EObject> contextualConnections = new HashSet<EObject>();
            HashSet<EObject> contextualPhysicalLinks = new HashSet<EObject>();
            HashSet<EObject> contextualModes = new HashSet<EObject>();
            HashSet<EObject> contextualScenarios = new HashSet<EObject>();
            for (EObject contextualElement : contextualElements) {
                if (contextualElement instanceof Entity) {
                    contextualParts.add(contextualElement);
                    continue;
                }
                if (contextualElement instanceof Component) {
                    Collection parts = (Collection)ModelCache.getCache(ComponentExt::getRepresentingParts, (Object)((Component)contextualElement));
                    contextualParts.addAll(parts);
                    continue;
                }
                if (contextualElement instanceof Part) {
                    contextualParts.add(contextualElement);
                    continue;
                }
                if (contextualElement instanceof AbstractFunction) {
                    contextualFunctions.add((AbstractFunction)contextualElement);
                    continue;
                }
                if (contextualElement instanceof FunctionalChain) {
                    for (FunctionalChainInvolvement involvement : FunctionalChainExt.getFlatInvolvementsOf((FunctionalChain)((FunctionalChain)contextualElement), (EClass)FaPackage.Literals.ABSTRACT_FUNCTION)) {
                        contextualFunctions.add((AbstractFunction)involvement.getInvolved());
                    }
                    for (FunctionalChainInvolvement involvement : FunctionalChainExt.getFlatInvolvementsOf((FunctionalChain)((FunctionalChain)contextualElement), (EClass)FaPackage.Literals.FUNCTIONAL_EXCHANGE)) {
                        contextualFunctionExchanges.add((FunctionalExchange)involvement.getInvolved());
                    }
                    contextualFunctionalChains.add(contextualElement);
                    continue;
                }
                if (contextualElement instanceof Scenario) {
                    contextualScenarios.add(contextualElement);
                    continue;
                }
                if (!(contextualElement instanceof State)) continue;
                contextualModes.add(contextualElement);
            }
            for (EObject contextualPart : contextualParts) {
                for (ComponentExchange flow : (Collection)ModelCache.getCache(ABServices::getRelatedComponentExchanges2, (Object)contextualPart)) {
                    if (flow.getKind() == ComponentExchangeKind.DELEGATION) continue;
                    contextualConnections.add((EObject)flow);
                }
                Collection<PhysicalLink> delagatesPhysicalLink = this.getAllDelegatesPhysicalLink(contextualPart);
                for (PhysicalLink physicalLink : ABServices.getService().getRelatedPhysicalLink(contextualPart)) {
                    if (delagatesPhysicalLink.contains(physicalLink)) continue;
                    contextualPhysicalLinks.add((EObject)physicalLink);
                }
            }
            ABServices.getService().showABComponent(contextualParts, context);
            CsServices.getService().showABFunctionalExchange(contextualFunctionExchanges, (DSemanticDecorator)diagram);
            CsServices.getService().showABComponentExchange(contextualConnections, (DSemanticDecorator)diagram);
            CsServices.getService().showABPhysicalLink(contextualPhysicalLinks, (DSemanticDecorator)diagram);
            FaServices.getFaServices().showABFunctionalChains(diagram, contextualFunctionalChains, context);
            ABServices.getService().showABScenarios((DSemanticDecorator)diagram, contextualScenarios);
            ABServices.getService().showABStateModes((DSemanticDecorator)diagram, contextualModes);
        }
    }

    public Collection<PhysicalLink> getAllDelegatesPhysicalLink(EObject contextualPart) {
        ArrayList<PhysicalLink> result = new ArrayList<PhysicalLink>();
        for (PhysicalPort port : this.getContainedPhysicalPorts(contextualPart)) {
            result.addAll(PortExt.getDelegatedPhysicalLinks((PhysicalPort)port));
            result.addAll(PortExt.getDelegatingPhysicalLinks((PhysicalPort)port));
        }
        return result;
    }

    public List<PhysicalPort> getContainedPhysicalPorts(EObject contextualPart) {
        Part part;
        if (contextualPart instanceof Component) {
            return ((Component)contextualPart).getContainedPhysicalPorts();
        }
        if (contextualPart instanceof Part && (part = (Part)contextualPart).getAbstractType() instanceof Component) {
            Component component = (Component)part.getAbstractType();
            return component.getContainedPhysicalPorts();
        }
        return Collections.emptyList();
    }

    public EObject showABPhysicalLink(Collection<EObject> contextualPhysicalLinks, DSemanticDecorator currentElementView) {
        ABServices.getService().showABPhysicalLink(contextualPhysicalLinks, new DDiagramContents(CapellaServices.getService().getDiagramContainer((EObject)currentElementView)));
        return currentElementView;
    }

    public EObject showABComponentPortAllocations(Collection<EObject> contextualComponentPortAllocations, DSemanticDecorator currentElementView) {
        ABServices.getService().showABComponentPortAllocations(contextualComponentPortAllocations, new DDiagramContents(CapellaServices.getService().getDiagramContainer((EObject)currentElementView)));
        return currentElementView;
    }

    public EObject hideABComponentPortAllocations(Collection<EObject> contextualComponentPortAllocations, DSemanticDecorator currentElementView) {
        ABServices.getService().hideABComponentPortAllocations(contextualComponentPortAllocations, new DDiagramContents(CapellaServices.getService().getDiagramContainer((EObject)currentElementView)));
        return currentElementView;
    }

    public EObject showABPortAllocations(Collection<EObject> contextualPortAllocations, DSemanticDecorator currentElementView) {
        ABServices.getService().showABPortAllocations(contextualPortAllocations, new DDiagramContents(CapellaServices.getService().getDiagramContainer((EObject)currentElementView)));
        return currentElementView;
    }

    public EObject hideABPortAllocations(Collection<EObject> contextualPortAllocations, DSemanticDecorator currentElementView) {
        ABServices.getService().hideABPortAllocations(contextualPortAllocations, new DDiagramContents(CapellaServices.getService().getDiagramContainer((EObject)currentElementView)));
        return currentElementView;
    }

    public EObject showABComponentExchange(Collection<EObject> exchanges, DSemanticDecorator currentElementView) {
        ABServices.getService().showABComponentExchange(exchanges, new DDiagramContents(CapellaServices.getService().getDiagramContainer((EObject)currentElementView)));
        return currentElementView;
    }

    public EObject showABComponentExchange(EObject exchange, DSemanticDecorator currentElementView) {
        return this.showABComponentExchange(Collections.singletonList(exchange), currentElementView);
    }

    public EObject showABPhysicalLink(EObject physicalLinkToShow, DSemanticDecorator currentElementView) {
        return this.showABPhysicalLink(Collections.singleton(physicalLinkToShow), currentElementView);
    }

    public EObject showABComponentPortAllocations(EObject componentPortAllocationToShow, DSemanticDecorator currentElementView) {
        return this.showABComponentPortAllocations(Collections.singleton(componentPortAllocationToShow), currentElementView);
    }

    public EObject hideABComponentPortAllocations(EObject portAllocationToHide, DSemanticDecorator currentElementView) {
        return this.hideABComponentPortAllocations(Collections.singleton(portAllocationToHide), currentElementView);
    }

    public EObject showABPortAllocations(EObject portAllocationToShow, DSemanticDecorator currentElementView) {
        return this.showABPortAllocations(Collections.singleton(portAllocationToShow), currentElementView);
    }

    public EObject hideABPortAllocations(EObject portAllocationToHide, DSemanticDecorator currentElementView) {
        return this.hideABPortAllocations(Collections.singleton(portAllocationToHide), currentElementView);
    }

    @Deprecated
    public EObject showABComponent(Collection<EObject> components, DSemanticDecorator diagram) {
        ABServices.getService().showABComponent(components, new DDiagramContents(CapellaServices.getService().getDiagramContainer((EObject)diagram)));
        return diagram;
    }

    public EObject showABFunctionalExchange(Collection<FunctionalExchange> exchanges, DSemanticDecorator currentElementView) {
        ABServices.getService().showABFunctionalExchange(exchanges, new DDiagramContents(CapellaServices.getService().getDiagramContainer((EObject)currentElementView)));
        return currentElementView;
    }

    public EObject showABFunctionalExchange(FunctionalExchange exchangeToShow, DSemanticDecorator currentElementView) {
        return this.showABFunctionalExchange(Collections.singletonList(exchangeToShow), currentElementView);
    }

    public EObject showFunctionalExchangeInArchitectureBlank2(FunctionalExchange exchangeToShow, DSemanticDecorator currentElementView) {
        return this.showABFunctionalExchange(exchangeToShow, currentElementView);
    }

    Couple<DNode, Boolean> createViewOrGetFunction(DNodeContainer parent, AbstractFunction target) {
        for (DDiagramElement node : parent.getOwnedDiagramElements()) {
            if (!(node instanceof DNode) || node.getTarget() == null || !node.getTarget().equals(target)) continue;
            return new Couple((Object)((DNode)node), (Object)Boolean.FALSE);
        }
        DNode created = FaServices.getFaServices().createViewABAbstractFunction(target, (DragAndDropTarget)parent, parent.getParentDiagram());
        return new Couple((Object)created, (Object)Boolean.TRUE);
    }

    @Deprecated
    Couple<DNode, Boolean> createViewOrGetFunctionPort(DNode parent, Pin target) {
        for (DNode node : parent.getOwnedBorderedNodes()) {
            if (node.getTarget() == null || !node.getTarget().equals(target)) continue;
            return new Couple((Object)node, (Object)Boolean.FALSE);
        }
        DNode created = FaServices.getFaServices().createViewFunctionPort((ActivityNode)target, (DragAndDropTarget)parent, parent.getParentDiagram());
        return new Couple((Object)created, (Object)Boolean.TRUE);
    }

    public void createRepresentingPartIfNone(Component component) {
        if (component.getRepresentingParts().isEmpty()) {
            Part part = CsFactory.eINSTANCE.createPart();
            EObject parentContainer = this.getParentContainer((EObject)component);
            if (parentContainer instanceof BlockArchitecture) {
                ComponentPkg context = this.getContext((BlockArchitecture)parentContainer);
                context.getOwnedParts().add((Object)part);
            } else if (parentContainer instanceof Component) {
                ((Component)parentContainer).getOwnedFeatures().add((Object)part);
            }
            CapellaServices.getService().creationService((EObject)part);
            part.setAbstractType((AbstractType)component);
        }
    }

    public int getTypeOfTheLinkToCreate(ComponentPort port, Interface itf) {
        int value = 0;
        boolean flag = false;
        if (port != null && itf != null) {
            EList requiredInterfaces;
            EList proviededInterfaces = port.getProvidedInterfaces();
            if (!proviededInterfaces.isEmpty() && proviededInterfaces.contains((Object)itf)) {
                flag = true;
                value = 1;
            }
            if (!(requiredInterfaces = port.getRequiredInterfaces()).isEmpty() && requiredInterfaces.contains((Object)itf)) {
                value = flag ? 3 : 2;
            }
        }
        return value;
    }

    public List<Component> getOppositeCompsOfUseAndSendingCommLink(EObject context) {
        ArrayList<Component> result = new ArrayList<Component>(1);
        if (context instanceof Component) {
            Component comp = (Component)context;
            List allUsedInterfaces = ComponentExt.getUsedAndRequiredInterfaces((Component)comp);
            for (Interface interface1 : allUsedInterfaces) {
                List providerComponent;
                EList implementerComponents = interface1.getImplementorComponents();
                if (!implementerComponents.isEmpty()) {
                    result.addAll((Collection<Component>)implementerComponents);
                }
                if ((providerComponent = InterfaceExt.getProviderComponent((Interface)interface1)).isEmpty()) continue;
                result.addAll(providerComponent);
            }
            Collection<AbstractExchangeItem> exchangeItemsByKinds = this.getExchangeItemsByTransmitkinds(comp);
            for (AbstractExchangeItem abstractExchangeItem : exchangeItemsByKinds) {
                List<Component> oppositeComponentUsingCrossref;
                if (!(abstractExchangeItem instanceof ExchangeItem) || (oppositeComponentUsingCrossref = this.getCompOfReceivingCommLinkUsingCrossRef((EObject)abstractExchangeItem)).isEmpty()) continue;
                result.addAll(oppositeComponentUsingCrossref);
            }
        }
        return result;
    }

    public String getInterfaceExchangeItemLabel(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        StringBuilder result = new StringBuilder();
        if (sourceView == null || targetView == null) {
            return result.toString();
        }
        EObject src = sourceView.getTarget();
        EObject tar = targetView.getTarget();
        if (src != null && tar != null && src instanceof Component && tar instanceof Component) {
            Component source = (Component)src;
            Component target = (Component)tar;
            List allUsedInterfaces = ComponentExt.getUsedAndRequiredInterfaces((Component)source);
            for (Interface interface1 : allUsedInterfaces) {
                ArrayList components = new ArrayList();
                components.addAll(interface1.getImplementorComponents());
                List providerComponent = InterfaceExt.getProviderComponent((Interface)interface1);
                if (!providerComponent.isEmpty()) {
                    components.addAll(providerComponent);
                }
                for (Component component : components) {
                    if (!target.equals(component)) continue;
                    if (result.toString().isEmpty()) {
                        result.append(interface1.getName());
                        continue;
                    }
                    result.append(", ");
                    result.append(interface1.getName());
                }
            }
            Collection<AbstractExchangeItem> exchangeItemsByKinds = this.getExchangeItemsByTransmitkinds(source);
            for (AbstractExchangeItem abstractExchangeItem : exchangeItemsByKinds) {
                if (!(abstractExchangeItem instanceof ExchangeItem)) continue;
                List<Component> oppositeComponentUsingCrossref = this.getCompOfReceivingCommLinkUsingCrossRef((EObject)abstractExchangeItem);
                for (Component component : oppositeComponentUsingCrossref) {
                    if (!target.equals(component)) continue;
                    if (result.toString().isEmpty()) {
                        result.append(abstractExchangeItem.getName());
                        continue;
                    }
                    result.append(", ");
                    result.append(abstractExchangeItem.getName());
                }
            }
        }
        return result.toString();
    }

    public String getInterfaceExchangeItemLabelDiagramBased(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        StringBuilder result = new StringBuilder();
        if (sourceView == null || targetView == null) {
            return result.toString();
        }
        EObject src = sourceView.getTarget();
        EObject tar = targetView.getTarget();
        if (src != null && tar != null && src instanceof Component && tar instanceof Component) {
            Component source = (Component)src;
            Component target = (Component)tar;
            DiagramServices diagramService = DiagramServices.getDiagramServices();
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceView);
            if (diagram == null) {
                return result.toString();
            }
            List allUsedInterfaces = ComponentExt.getUsedAndRequiredInterfaces((Component)source);
            for (Interface interface1 : allUsedInterfaces) {
                ArrayList components = new ArrayList();
                components.addAll(interface1.getImplementorComponents());
                List providerComponent = InterfaceExt.getProviderComponent((Interface)interface1);
                if (!providerComponent.isEmpty()) {
                    components.addAll(providerComponent);
                }
                for (Component component : components) {
                    if (!target.equals(component) || !diagramService.isOnDiagram(diagram, (EObject)interface1)) continue;
                    if (result.toString().isEmpty()) {
                        result.append(interface1.getName());
                        continue;
                    }
                    result.append(", ");
                    result.append(interface1.getName());
                }
            }
            Collection<AbstractExchangeItem> exchangeItemsByKinds = this.getExchangeItemsByTransmitkinds(source);
            for (AbstractExchangeItem abstractExchangeItem : exchangeItemsByKinds) {
                if (!(abstractExchangeItem instanceof ExchangeItem)) continue;
                List<Component> oppositeComponentUsingCrossref = this.getCompOfReceivingCommLinkUsingCrossRef((EObject)abstractExchangeItem);
                for (Component component : oppositeComponentUsingCrossref) {
                    if (!target.equals(component) || !diagramService.isOnDiagram(diagram, (EObject)abstractExchangeItem)) continue;
                    if (result.toString().isEmpty()) {
                        result.append(abstractExchangeItem.getName());
                        continue;
                    }
                    result.append(", ");
                    result.append(abstractExchangeItem.getName());
                }
            }
        }
        return result.toString();
    }

    public boolean isInterfaceExchangeItemLabelDiagramBasedEmpty(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        if (sourceView == null || targetView == null) {
            return false;
        }
        EObject src = sourceView.getTarget();
        EObject tar = targetView.getTarget();
        if (src != null && tar != null && src instanceof Component && tar instanceof Component) {
            Component source = (Component)src;
            Component target = (Component)tar;
            DiagramServices diagramService = DiagramServices.getDiagramServices();
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceView);
            if (diagram == null) {
                return false;
            }
            List allUsedInterfaces = ComponentExt.getUsedAndRequiredInterfaces((Component)source);
            for (Interface interface1 : allUsedInterfaces) {
                ArrayList components = new ArrayList();
                components.addAll(interface1.getImplementorComponents());
                List providerComponent = InterfaceExt.getProviderComponent((Interface)interface1);
                if (!providerComponent.isEmpty()) {
                    components.addAll(providerComponent);
                }
                for (Component component : components) {
                    if (!target.equals(component) || !diagramService.isOnDiagram(diagram, (EObject)interface1)) continue;
                    return true;
                }
            }
            Collection<AbstractExchangeItem> exchangeItemsByKinds = this.getExchangeItemsByTransmitkinds(source);
            for (AbstractExchangeItem abstractExchangeItem : exchangeItemsByKinds) {
                if (!(abstractExchangeItem instanceof ExchangeItem)) continue;
                List<Component> oppositeComponentUsingCrossref = this.getCompOfReceivingCommLinkUsingCrossRef((EObject)abstractExchangeItem);
                for (Component component : oppositeComponentUsingCrossref) {
                    if (!target.equals(component) || !diagramService.isOnDiagram(diagram, (EObject)abstractExchangeItem)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<Component> getCompOfReceivingCommLinkUsingCrossRef(EObject eObj) {
        ArrayList<Component> result = new ArrayList<Component>();
        Collection inverseReferences = CapellaElementExt.getInverseReferencesOfEObject((EObject)eObj);
        for (EStructuralFeature.Setting setting : inverseReferences) {
            EObject container;
            CommunicationLink link;
            EObject eObject = setting.getEObject();
            if (!(eObject instanceof CommunicationLink) || !CommunicationLinkExt.isReceiver((CommunicationLink)(link = (CommunicationLink)eObject)) || !((container = this.getParentContainer((EObject)link)) instanceof Component)) continue;
            result.add((Component)container);
        }
        return result;
    }

    public Collection<AbstractExchangeItem> getExchangeItemsByTransmitkinds(Component comp) {
        EList ownedCommunicationLinks = comp.getOwnedCommunicationLinks();
        CommunicationLinkKind[] sending = new CommunicationLinkKind[]{CommunicationLinkKind.SEND, CommunicationLinkKind.CALL, CommunicationLinkKind.WRITE, CommunicationLinkKind.PRODUCE, CommunicationLinkKind.TRANSMIT};
        return CommunicationLinkExt.getExchangeItemsByKinds((Collection)ownedCommunicationLinks, (CommunicationLinkKind[])sending);
    }

    public boolean isShowTriggerSourceFunctionEnable(EObject transition, EObject view) {
        return InformationServices.getService().isDiagramFilterEnable(transition, view, "show.triggerfe.source.filter");
    }

    public String getStateTransitionLabel(EObject context, EObject view) {
        StringBuilder result = new StringBuilder();
        if (context instanceof StateTransition) {
            String constraintLabel;
            String triggerDescription;
            StateTransition transition = (StateTransition)context;
            EList triggers = transition.getTriggers();
            boolean firstTriggerToDisplay = true;
            for (AbstractEvent trigger : triggers) {
                if (trigger == null) continue;
                String name = "";
                name = trigger instanceof FunctionalExchange && this.isShowTriggerSourceFunctionEnable(context, view) ? ModeStateMachineServices.getService().getIncomingFunctionalExchangeLabel((FunctionalExchange)trigger) : EObjectExt.getText((EObject)trigger);
                if (trigger instanceof ChangeEvent) {
                    ChangeEvent changeEvent = (ChangeEvent)trigger;
                    name = "(" + changeEvent.getKind() + ") ";
                }
                if (trigger instanceof TimeEvent) {
                    TimeEvent timeEvent = (TimeEvent)trigger;
                    name = "(" + timeEvent.getKind() + ") ";
                }
                if (firstTriggerToDisplay) {
                    firstTriggerToDisplay = false;
                } else {
                    result.append(", ");
                }
                result.append(name);
                if (!(trigger instanceof StateEvent)) continue;
                Constraint triggerCondition = ((StateEvent)trigger).getExpression();
                if (triggerCondition != null) {
                    result.append(CapellaServices.getService().getConstraintLabel(triggerCondition));
                    continue;
                }
                result.append(trigger.getName());
            }
            if (triggers.isEmpty() && (triggerDescription = transition.getTriggerDescription()) != null && !triggerDescription.equalsIgnoreCase("")) {
                result.append(triggerDescription);
            }
            if (transition.getGuard() != null && (constraintLabel = CapellaServices.getService().getConstraintLabel(transition.getGuard())) != null && !constraintLabel.isEmpty()) {
                result.append(" [" + constraintLabel + "] ");
            }
            if (!transition.getEffect().isEmpty()) {
                result.append(" / ");
                boolean firstEffectToDisplay = true;
                for (AbstractEvent effect : transition.getEffect()) {
                    if (effect == null) continue;
                    if (firstEffectToDisplay) {
                        firstEffectToDisplay = false;
                    } else {
                        result.append(", ");
                    }
                    if (effect instanceof FunctionalExchange) {
                        result.append(ModeStateMachineServices.getService().getOutgoingFunctionalExchangeLabel((FunctionalExchange)effect));
                        continue;
                    }
                    result.append(EObjectExt.getText((EObject)effect));
                }
            }
        }
        return result.toString();
    }

    public void refreshEntitiesArchitecture(ContainerMapping mapping, DDiagram diagram) {
        DNodeContainer parentContainer;
        Component parentComponent;
        Component component;
        if (mapping == null) {
            return;
        }
        HashMap<Component, DNodeContainer> componentContainerMap = new HashMap<Component, DNodeContainer>();
        HashSet<DNodeContainer> containersToAnalyze = new HashSet<DNodeContainer>();
        for (DDiagramElementContainer container : diagram.getContainers()) {
            boolean shouldAnalyze;
            boolean bl = shouldAnalyze = container instanceof DNodeContainer && container.getTarget() instanceof Component && container.getDiagramElementMapping().equals(mapping);
            if (!shouldAnalyze) continue;
            component = (Component)container.getTarget();
            DNodeContainer nodeContainer = (DNodeContainer)container;
            componentContainerMap.put(component, nodeContainer);
            if (!CapellaServices.getService().isVisibleInDiagram(diagram, (DDiagramElement)container)) continue;
            containersToAnalyze.add(nodeContainer);
        }
        HashSet<DNodeContainer> containersToMove = new HashSet<DNodeContainer>();
        for (DNodeContainer container : containersToAnalyze) {
            boolean shouldMove;
            component = (Component)container.getTarget();
            parentComponent = ComponentExt.getParent((Component)component);
            parentContainer = (DNodeContainer)componentContainerMap.get(parentComponent);
            boolean bl = shouldMove = parentContainer == null || !parentContainer.getOwnedDiagramElements().contains((Object)container);
            if (!shouldMove) continue;
            diagram.getOwnedDiagramElements().add((Object)container);
            containersToMove.add(container);
        }
        block2: for (DNodeContainer container : containersToMove) {
            component = (Component)container.getTarget();
            parentComponent = ComponentExt.getParent((Component)component);
            while (parentComponent != null) {
                boolean parentIsValid;
                parentContainer = (DNodeContainer)componentContainerMap.get(parentComponent);
                boolean bl = parentIsValid = parentContainer != null && !parentContainer.getOwnedDiagramElements().contains((Object)container) && CapellaServices.getService().isVisibleInDiagram(diagram, (DDiagramElement)parentContainer);
                if (parentIsValid) {
                    parentContainer.getOwnedDiagramElements().add((Object)container);
                    continue block2;
                }
                parentComponent = ComponentExt.getParent((Component)parentComponent);
            }
        }
    }

    public List<CapellaElement> getAllComponentFromBlockArchitecture(EObject context, BlockArchitecture arch) {
        return BlockArchitectureExt.getAllComponents((BlockArchitecture)arch).stream().collect(Collectors.toList());
    }

    public EObject showHideActors(EObject context, List<CapellaElement> selectedOperations, DDiagram diagram) {
        if (selectedOperations == null) {
            selectedOperations = new ArrayList<CapellaElement>();
        }
        HashMap<CapellaElement, AbstractDNode> visibleElements = new HashMap<CapellaElement, AbstractDNode>();
        for (DDiagramElement aNode : DiagramServices.getDiagramServices().getDiagramElements((EObject)diagram)) {
            EObject target = aNode.getTarget();
            if (!(aNode instanceof AbstractDNode) || target == null || !(target instanceof Component) || !((Component)target).isActor()) continue;
            visibleElements.put((CapellaElement)target, (AbstractDNode)aNode);
        }
        this.removeAndCreateActorsAndCapabilities(selectedOperations, diagram, visibleElements);
        return context;
    }

    public EObject showHideCapabilityRealizations(EObject context, List<CapellaElement> selectedOperations, DDiagram diagram) {
        HashMap<CapellaElement, AbstractDNode> visibleElements = new HashMap<CapellaElement, AbstractDNode>();
        for (DDiagramElement aNode : DiagramServices.getDiagramServices().getDiagramElements((EObject)diagram)) {
            EObject target = aNode.getTarget();
            if (!(aNode instanceof AbstractDNode) || target == null || !(target instanceof CapabilityRealization)) continue;
            visibleElements.put((CapellaElement)target, (AbstractDNode)aNode);
        }
        this.removeAndCreateActorsAndCapabilities(selectedOperations, diagram, visibleElements);
        return context;
    }

    private void removeAndCreateActorsAndCapabilities(List<CapellaElement> selectedOperations, DDiagram diagram, Map<CapellaElement, AbstractDNode> visibleElements) {
        for (Map.Entry<CapellaElement, AbstractDNode> me : visibleElements.entrySet()) {
            if (selectedOperations.contains(me.getKey())) continue;
            if (me.getValue() instanceof DDiagramElementContainer || me.getValue() instanceof DDiagram) {
                DiagramServices.getDiagramServices().removeContainerView((EObject)me.getValue());
                continue;
            }
            if (!(me.getValue() instanceof DNode)) continue;
            DiagramServices.getDiagramServices().removeNodeView((DNode)me.getValue());
        }
        for (CapellaElement anElement : selectedOperations) {
            AbstractNodeMapping mapping;
            EObject container = CapellaServices.getService().getBestGraphicalContainer((EObject)anElement, diagram, anElement.eClass());
            if (visibleElements.containsKey(anElement)) continue;
            if (anElement instanceof Component) {
                mapping = IBServices.getService().getMappingIDComponent((EObject)anElement, diagram);
                if (mapping == null) {
                    mapping = this.getMappingCRBActor((EObject)anElement, diagram);
                }
                DiagramServices.getDiagramServices().createAbstractDNode(mapping, (EObject)anElement, (DragAndDropTarget)container, diagram);
                continue;
            }
            if (!(anElement instanceof AbstractCapability)) continue;
            mapping = this.getMappingCRBCapability((EObject)anElement, diagram);
            DiagramServices.getDiagramServices().createAbstractDNode(mapping, (EObject)anElement, (DragAndDropTarget)container, diagram);
        }
    }

    public AbstractNodeMapping getMappingCRBActor(EObject element, DDiagram diagram) {
        String mappingName = "";
        if ("Capability Realization Blank".equals(diagram.getDescription().getName()) && element instanceof Component && ((Component)element).isActor()) {
            mappingName = "CRB Component";
        }
        return DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
    }

    public AbstractNodeMapping getMappingCRBCapability(EObject element, DDiagram diagram) {
        boolean isContainerMapping = true;
        String mappingName = "";
        if ("Capability Realization Blank".equals(diagram.getDescription().getName()) && element instanceof CapabilityRealization) {
            mappingName = "CRB CapabilityRealization";
            isContainerMapping = false;
        }
        if (isContainerMapping) {
            return DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
        }
        return DiagramServices.getDiagramServices().getNodeMapping(diagram, mappingName);
    }

    public EObject getFirstAbstractCapPkg(EObject context) {
        BlockArchitecture arch = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)((ModelElement)context));
        if (arch != null) {
            return arch.getOwnedAbstractCapabilityPkg();
        }
        return null;
    }

    public void removeCapellaElement(EObject capellaElement) {
        if (capellaElement instanceof CapellaElement) {
            CapellaServices.getService().removeElement((CapellaElement)capellaElement);
        }
    }

    public boolean isPrimitive(EObject context) {
        if (context instanceof Class) {
            return ((Class)context).isIsPrimitive();
        }
        return false;
    }

    public boolean isAbstract(EObject context) {
        if (context instanceof GeneralizableElement) {
            GeneralizableElement genEle = (GeneralizableElement)context;
            return genEle.isAbstract();
        }
        if (context instanceof DataValue) {
            DataValue value = (DataValue)context;
            return value.isAbstract();
        }
        if (context instanceof Feature) {
            Feature feature = (Feature)context;
            return feature.isIsAbstract();
        }
        return false;
    }

    public boolean isPartOfKey(EObject context) {
        if (context instanceof Property) {
            Property property = (Property)context;
            return property.isIsPartOfKey();
        }
        return false;
    }

    public boolean isComponentTargetAvailableForCapInvolvement(EObject context, EObject preSource, EObject preTarget) {
        return CapabilityRealizationExt.isComponentTargetAvailableForCapInvolvement((EObject)context, (EObject)preSource, (EObject)preTarget);
    }

    public boolean isARootComponent(EObject context) {
        Component firstComponent;
        BlockArchitecture arch;
        return context instanceof CapellaElement && (arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)context)) != null && (firstComponent = this.getFirstComponent(arch)) != null && firstComponent.equals(context);
    }

    public Collection<Component> getCRBShowHideComponent(DSemanticDecorator decorator) {
        Component firstComponent;
        ArrayList<Component> components = new ArrayList<Component>();
        if (decorator.getTarget() instanceof Component) {
            return this.getCCIIShowHideComponent(decorator);
        }
        EObject parentContainer = this.getParentContainer(decorator.getTarget());
        if (parentContainer == null) {
            return components;
        }
        if (parentContainer instanceof Component) {
            return this.getSubComponents(parentContainer);
        }
        if (parentContainer instanceof BlockArchitecture && (firstComponent = ((BlockArchitecture)parentContainer).getSystem()) != null) {
            return this.getSubComponents((EObject)firstComponent);
        }
        return components;
    }

    public Collection<Component> getCRBShowHideActors(EObject context) {
        ArrayList components = new ArrayList();
        components.addAll(ComponentExt.getSubDefinedActors((BlockArchitecture)this.getArchitecture(context)));
        return this.filterActors(components);
    }

    public Collection<CapabilityRealization> getCRBShowHideCapabilityRealizations(EObject context) {
        ArrayList<CapabilityRealization> elements = new ArrayList<CapabilityRealization>();
        if (context instanceof CapellaElement) {
            BlockArchitecture arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)context);
            elements.addAll(CapabilityRealizationExt.getAllCapabilityRealizations((BlockArchitecture)arch));
        }
        return elements;
    }

    public boolean isDiagramAndElementFromSameLayer(EObject context, EObject diagram) {
        if (context == null || diagram == null || !(context instanceof ModelElement) && !(diagram instanceof DSemanticDiagram)) {
            return false;
        }
        boolean laLayer = CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)context));
        boolean paLayer = CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)((CapellaElement)context));
        boolean epbsLayer = CapellaLayerCheckingExt.isInEPBSLayer((CapellaElement)((CapellaElement)context));
        EObject parentContainer = this.getParentContainer(((DSemanticDiagram)diagram).getTarget());
        if (parentContainer != null) {
            if (laLayer && CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)parentContainer))) {
                return true;
            }
            if (paLayer && CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)((CapellaElement)parentContainer))) {
                return true;
            }
            if (epbsLayer && CapellaLayerCheckingExt.isInEPBSLayer((CapellaElement)((CapellaElement)parentContainer))) {
                return true;
            }
        }
        return false;
    }

    public List<? extends EObject> getConstraintToInsertInDiagram(EObject context) {
        DDiagramElement element;
        EObject target;
        ArrayList result = new ArrayList(0);
        if (context instanceof DDiagram) {
            DSemanticDecorator diagram = (DSemanticDecorator)context;
            EObject target2 = diagram.getTarget();
            if (target2 instanceof ModelElement) {
                BlockArchitecture arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)target2);
                return BlockArchitectureExt.getAllConstraints((EObject)arch);
            }
        } else if (context instanceof DDiagramElement && (target = (element = (DDiagramElement)context).getTarget()) instanceof ModelElement) {
            ModelElement capellaElement = (ModelElement)target;
            result.addAll(capellaElement.getConstraints());
        }
        return result;
    }

    public void createConstraintWithConstaintedElementInDiagram(EObject context, EObject constraint, DDiagram dDiagram, List<Constraint> constraintsInDiagram, boolean kindDiagram) {
        EObject target;
        if (constraintsInDiagram == null) {
            constraintsInDiagram = new ArrayList<Constraint>();
        }
        if (context == null || constraint == null || dDiagram == null) {
            return;
        }
        DiagramServices diagramServices = DiagramServices.getDiagramServices();
        NodeMapping constraintNodeMapping = null;
        EdgeMapping constaintEdgeMapping = null;
        if (kindDiagram) {
            constraintNodeMapping = diagramServices.getNodeMapping(dDiagram, "DT_Contraint");
            constaintEdgeMapping = diagramServices.getEdgeMapping(dDiagram, "DT_ContrainedElements");
        } else {
            constraintNodeMapping = diagramServices.getNodeMapping(dDiagram, "Scenario_Constraint");
            constaintEdgeMapping = diagramServices.getEdgeMapping(dDiagram, "Scenario_ContrainedElements");
        }
        DNode constraintNode = null;
        if (constraintsInDiagram.contains(constraint) && constraintNodeMapping != null) {
            Iterable<DDiagramElement> diagramElements = diagramServices.getDiagramElements((EObject)dDiagram);
            for (DDiagramElement dDiagramElement : diagramElements) {
                RepresentationElementMapping mapping;
                EObject target2 = dDiagramElement.getTarget();
                if (target2 == null || !target2.equals(constraint) || !(dDiagramElement instanceof DNode) || (mapping = dDiagramElement.getMapping()) == null || !mapping.equals(constraintNodeMapping)) continue;
                constraintNode = (DNode)dDiagramElement;
            }
        } else {
            constraintNode = diagramServices.createNode(constraintNodeMapping, constraint, (DragAndDropTarget)dDiagram, dDiagram);
        }
        if (!dDiagram.isSynchronized() && constaintEdgeMapping != null && constraintNode != null && (target = constraintNode.getTarget()) instanceof Constraint) {
            Constraint cst = (Constraint)target;
            EList constrainedElements = cst.getConstrainedElements();
            for (ModelElement modelElement : constrainedElements) {
                DDiagramElement diagramElement;
                if (!diagramServices.isOnDiagram(dDiagram, (EObject)modelElement)) continue;
                EList outgoingEdges = constraintNode.getOutgoingEdges();
                boolean edgeExist = false;
                for (DEdge dEdge : outgoingEdges) {
                    EObject edgeTargetNodeTarget;
                    EdgeTarget edgeTargetNode = dEdge.getTargetNode();
                    if (edgeTargetNode == null || (edgeTargetNodeTarget = ((DDiagramElement)edgeTargetNode).getTarget()) == null || !edgeTargetNodeTarget.equals(modelElement)) continue;
                    edgeExist = true;
                    break;
                }
                if (edgeExist || (diagramElement = diagramServices.getDiagramElement(dDiagram, (EObject)modelElement)) == null) continue;
                diagramServices.createEdge(constaintEdgeMapping, (EdgeTarget)constraintNode, (EdgeTarget)diagramElement, target);
            }
        }
    }

    public void createConstraintElement(EObject context, EObject target, DDiagramElement targetDiagramEle) {
        Constraint constraint;
        EList constrainedElements;
        if (context == null || target == null || targetDiagramEle == null) {
            return;
        }
        if (context instanceof Constraint && target instanceof ModelElement && (constrainedElements = (constraint = (Constraint)context).getConstrainedElements()) != null) {
            if (constrainedElements.isEmpty()) {
                constrainedElements.addAll(this.getTargetToAddAsConstraintedElement((ModelElement)target, targetDiagramEle));
                ModelElement properTargetToMoveConstraint = this.getProperTargetToMoveConstraint((ModelElement)target, targetDiagramEle);
                if (properTargetToMoveConstraint != null) {
                    properTargetToMoveConstraint.getConstraints().add((Object)constraint);
                }
            } else {
                constrainedElements.addAll(this.getTargetToAddAsConstraintedElement((ModelElement)target, targetDiagramEle));
            }
        }
    }

    private ModelElement getProperTargetToMoveConstraint(ModelElement target, DDiagramElement targetDiagramEle) {
        DiagramElementMapping diagramElementMapping = targetDiagramEle.getDiagramElementMapping();
        if (diagramElementMapping != null && diagramElementMapping.getName().equals("PAB_Deployment")) {
            return null;
        }
        return target;
    }

    private List<ModelElement> getTargetToAddAsConstraintedElement(ModelElement target, DDiagramElement targetDiagramEle) {
        Part part;
        EList deployingLinks;
        ArrayList<ModelElement> result = new ArrayList<ModelElement>();
        boolean flag = false;
        DiagramElementMapping diagramElementMapping = targetDiagramEle.getDiagramElementMapping();
        if (diagramElementMapping != null && diagramElementMapping.getName().equals("PAB_Deployment") && target instanceof Part && (deployingLinks = (part = (Part)target).getDeployingLinks()) != null && !deployingLinks.isEmpty()) {
            result.addAll((Collection<ModelElement>)deployingLinks);
            flag = true;
        }
        if (!flag) {
            result.add(target);
        }
        return result;
    }

    public List<EObject> targeFinderExpressionForConstraint(Constraint context) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        LinkedList<DeployableElement> toVisit = new LinkedList<DeployableElement>();
        toVisit.addAll((Collection<DeployableElement>)context.getConstrainedElements());
        while (!toVisit.isEmpty()) {
            EObject object = (EObject)toVisit.removeFirst();
            if (result.contains(object)) continue;
            result.add(object);
            if (object instanceof PartDeploymentLink) {
                PartDeploymentLink link = (PartDeploymentLink)object;
                DeployableElement deployedElement = link.getDeployedElement();
                if (deployedElement == null) continue;
                toVisit.add(deployedElement);
                continue;
            }
            if (object instanceof Component) {
                toVisit.addAll((Collection<DeployableElement>)((Component)object).getRepresentingParts());
                continue;
            }
            if (!(object instanceof Part)) continue;
            result.add((EObject)((Part)object).getAbstractType());
        }
        return result;
    }

    public boolean isValidConstrainedElementsEdge(EObject semantic, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        if (semantic instanceof Constraint) {
            Constraint constraint = (Constraint)semantic;
            EList elements = constraint.getConstrainedElements();
            return elements != null && !elements.isEmpty();
        }
        return false;
    }

    public boolean isPropertyDerived(EObject capellaElement) {
        if (capellaElement instanceof Property) {
            Property property = (Property)capellaElement;
            if (property.isIsDerived()) {
                return true;
            }
        } else if (capellaElement instanceof Association) {
            Association ass = (Association)capellaElement;
            Collection properties = AssociationExt.getProperties((Association)ass);
            for (Property property : properties) {
                if (!property.isIsDerived()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean doesCommunicationLinkEdgeIsNotRepresentedInComponentChildren(EObject object) {
        DEdge currentEdge;
        EObject target;
        if (object instanceof DEdge && (target = (currentEdge = (DEdge)object).getTarget()) instanceof CommunicationLink) {
            CommunicationLink link = (CommunicationLink)target;
            EdgeTarget sourceNode = currentEdge.getSourceNode();
            if (sourceNode instanceof DNodeContainer) {
                for (DDiagramElement child : ((DNodeContainer)sourceNode).getElements()) {
                    if (!(child.getTarget() instanceof Component) || !(child instanceof DNodeContainer)) continue;
                    for (DEdge edge : ((DNodeContainer)child).getOutgoingEdges()) {
                        CommunicationLink childLink;
                        target = edge.getTarget();
                        if (!(target instanceof CommunicationLink) || !CommunicationLinkExt.isSameCommunication((CommunicationLink)(childLink = (CommunicationLink)target), (CommunicationLink)link)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean doesUseOrImplementOrRequireOrProvideLinkEdgeIsNotRepresentedInComponentChildren(EObject object) {
        if (object instanceof DEdge) {
            DEdge currentEdge = (DEdge)object;
            EObject target = currentEdge.getTarget();
            if (target instanceof ComponentPort && this.isProvidedEdge(object) || target instanceof InterfaceImplementation) {
                return this.isImplementedOrProvidedLinkEdgeNotRepresentedInChildrenComponent(object);
            }
            if (target instanceof ComponentPort && this.isRequiredEdge(object) || target instanceof InterfaceUse) {
                return this.isUsedOrRequiredLinkEdgeNotRepresentedInChildrenComponent(object);
            }
        }
        return true;
    }

    public boolean isImplementedOrProvidedLinkEdgeNotRepresentedInChildrenComponent(EObject object) {
        block9: {
            EObject sourceNode;
            EObject target;
            DEdge currentEdge;
            block10: {
                if (!(object instanceof DEdge)) break block9;
                currentEdge = (DEdge)object;
                target = currentEdge.getTarget();
                if (!(target instanceof InterfaceImplementation)) break block10;
                Relationship link = (Relationship)target;
                EdgeTarget sourceNode2 = currentEdge.getSourceNode();
                if (!(sourceNode2 instanceof DNodeContainer)) break block9;
                for (DDiagramElement child : ((DNodeContainer)sourceNode2).getElements()) {
                    if (!(child.getTarget() instanceof Component) || !(child instanceof DNodeContainer)) continue;
                    for (DEdge edge : ((DNodeContainer)child).getOutgoingEdges()) {
                        target = edge.getTarget();
                        if (!(target instanceof InterfaceImplementation)) continue;
                        Relationship childLink = (Relationship)target;
                        if (!(link instanceof InterfaceImplementation) || !(childLink instanceof InterfaceImplementation) || ((InterfaceImplementation)link).getImplementedInterface() != ((InterfaceImplementation)childLink).getImplementedInterface()) continue;
                        return false;
                    }
                    for (DNode borderedNode : ((DNodeContainer)child).getOwnedBorderedNodes()) {
                        if (!(borderedNode.getTarget() instanceof ComponentPort)) continue;
                        for (DEdge outgoingEdge : borderedNode.getOutgoingEdges()) {
                            if (!this.isProvidedEdge((EObject)outgoingEdge) || currentEdge.getTargetNode() != outgoingEdge.getTargetNode()) continue;
                            return false;
                        }
                    }
                }
                break block9;
            }
            if (target instanceof ComponentPort && this.isProvidedEdge((EObject)currentEdge) && (sourceNode = currentEdge.getSourceNode().eContainer()) instanceof DNodeContainer) {
                for (DDiagramElement child : ((DNodeContainer)sourceNode).getElements()) {
                    if (!(child.getTarget() instanceof Component) || !(child instanceof DNodeContainer)) continue;
                    for (DNode borderedNode : ((DNodeContainer)child).getOwnedBorderedNodes()) {
                        if (!(borderedNode.getTarget() instanceof ComponentPort)) continue;
                        for (DEdge outgoingEdge : borderedNode.getOutgoingEdges()) {
                            if (!this.isProvidedEdge((EObject)outgoingEdge) || currentEdge.getTargetNode() != outgoingEdge.getTargetNode()) continue;
                            return false;
                        }
                    }
                    if (((DNodeContainer)child).getOutgoingEdges().isEmpty()) continue;
                    for (DEdge edge : ((DNodeContainer)child).getOutgoingEdges()) {
                        target = edge.getTarget();
                        if (!(target instanceof InterfaceImplementation) || currentEdge.getTargetNode() != edge.getTargetNode()) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isUsedOrRequiredLinkEdgeNotRepresentedInChildrenComponent(EObject object) {
        block9: {
            EObject sourceNode;
            EObject target;
            DEdge currentEdge;
            block10: {
                if (!(object instanceof DEdge)) break block9;
                currentEdge = (DEdge)object;
                target = currentEdge.getTarget();
                if (!(target instanceof InterfaceUse)) break block10;
                Relationship link = (Relationship)target;
                EdgeTarget sourceNode2 = currentEdge.getSourceNode();
                if (!(sourceNode2 instanceof DNodeContainer)) break block9;
                for (DDiagramElement child : ((DNodeContainer)sourceNode2).getElements()) {
                    if (!(child.getTarget() instanceof Component) || !(child instanceof DNodeContainer)) continue;
                    for (DEdge edge : ((DNodeContainer)child).getOutgoingEdges()) {
                        target = edge.getTarget();
                        if (!(target instanceof InterfaceUse)) continue;
                        Relationship childLink = (Relationship)target;
                        if (!(link instanceof InterfaceUse) || !(childLink instanceof InterfaceUse) || ((InterfaceUse)link).getUsedInterface() != ((InterfaceUse)childLink).getUsedInterface()) continue;
                        return false;
                    }
                    for (DNode borderedNode : ((DNodeContainer)child).getOwnedBorderedNodes()) {
                        if (!(borderedNode.getTarget() instanceof ComponentPort)) continue;
                        for (DEdge outgoingEdge : borderedNode.getOutgoingEdges()) {
                            if (!this.isRequiredEdge((EObject)outgoingEdge) || currentEdge.getTargetNode() != outgoingEdge.getTargetNode()) continue;
                            return false;
                        }
                    }
                }
                break block9;
            }
            if (target instanceof ComponentPort && this.isRequiredEdge((EObject)currentEdge) && (sourceNode = currentEdge.getSourceNode().eContainer()) instanceof DNodeContainer) {
                for (DDiagramElement child : ((DNodeContainer)sourceNode).getElements()) {
                    if (!(child.getTarget() instanceof Component) || !(child instanceof DNodeContainer)) continue;
                    for (DNode borderedNode : ((DNodeContainer)child).getOwnedBorderedNodes()) {
                        if (!(borderedNode.getTarget() instanceof ComponentPort)) continue;
                        for (DEdge outgoingEdge : borderedNode.getOutgoingEdges()) {
                            if (!this.isRequiredEdge((EObject)outgoingEdge) || currentEdge.getTargetNode() != outgoingEdge.getTargetNode()) continue;
                            return false;
                        }
                    }
                    if (((DNodeContainer)child).getOutgoingEdges().isEmpty()) continue;
                    for (DEdge edge : ((DNodeContainer)child).getOutgoingEdges()) {
                        target = edge.getTarget();
                        if (!(target instanceof InterfaceUse) || currentEdge.getTargetNode() != edge.getTargetNode()) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isProvidedEdge(EObject object) {
        String featureDef;
        IEdgeMapping mapping;
        DEdge currentEdge;
        EObject target;
        return object instanceof DEdge && (target = (currentEdge = (DEdge)object).getTarget()) instanceof ComponentPort && (mapping = currentEdge.getActualMapping()) instanceof EdgeMapping && (featureDef = ((EdgeMapping)mapping).getTargetFinderExpression()).equals("feature:" + CsPackage.Literals.COMPONENT__PROVIDED_INTERFACES.getName());
    }

    public boolean isRequiredEdge(EObject object) {
        String featureDef;
        IEdgeMapping mapping;
        DEdge currentEdge;
        EObject target;
        return object instanceof DEdge && (target = (currentEdge = (DEdge)object).getTarget()) instanceof ComponentPort && (mapping = currentEdge.getActualMapping()) instanceof EdgeMapping && (featureDef = ((EdgeMapping)mapping).getTargetFinderExpression()).equals("feature:" + CsPackage.Literals.COMPONENT__REQUIRED_INTERFACES.getName());
    }

    public boolean isAPhysicalPort(EObject port) {
        return port instanceof PhysicalPort;
    }

    public Collection<EObject> getComputedComponentExchangeSource(EObject related, DDiagram diagram) {
        if (related instanceof ComponentExchange) {
            ComponentExchange connection = (ComponentExchange)related;
            EObject componentExchangeSource = this.getComponentExchangeSource(connection);
            return this.getVisibleEdgeEnds(diagram, componentExchangeSource);
        }
        return Collections.singletonList(related);
    }

    public Collection<EObject> getComputedComponentExchangeTarget(EObject related, DDiagram diagram) {
        if (related instanceof ComponentExchange) {
            ComponentExchange connection = (ComponentExchange)related;
            EObject componentExchangeTarget = this.getComponentExchangeTarget(connection);
            return this.getVisibleEdgeEnds(diagram, componentExchangeTarget);
        }
        return Collections.singletonList(related);
    }

    public Object getComputedComponentExchangeSemanticCandidates(DDiagram diagram) {
        HashSet result = new HashSet();
        DDiagramContents context = new DDiagramContents(diagram);
        for (DDiagramElement dNode : context.getDiagramElements()) {
            EObject target = dNode.getTarget();
            if (target instanceof Part) {
                result.addAll(ComponentExt.getAllRelatedComponentExchange((Part)((Part)target), (boolean)true));
                Collection allSubUsedParts = ComponentExt.getAllSubUsedParts((Part)((Part)target), (boolean)true);
                for (Part part : allSubUsedParts) {
                    result.addAll(ComponentExt.getAllRelatedComponentExchange((Part)part, (boolean)true));
                }
                continue;
            }
            if (!(target instanceof Component)) continue;
            result.addAll((Collection)ModelCache.getCache(ComponentExt::getAllRelatedComponentExchange, (Object)((Component)target)));
            Collection allSubUsedComponents = ComponentExt.getAllSubUsedComponents((Component)((Component)target));
            for (Component component : allSubUsedComponents) {
                result.addAll((Collection)ModelCache.getCache(ComponentExt::getAllRelatedComponentExchange, (Object)component));
            }
        }
        return result;
    }

    public Collection<EObject> getComputedPhysicalLinkSource(EObject related, DDiagram diagram) {
        if (related instanceof PhysicalLink) {
            EObject physicalLinkSource = this.getPhysicalLinkSource((PhysicalLink)related);
            return this.getVisibleEdgeEnds(diagram, physicalLinkSource);
        }
        return Collections.singletonList(related);
    }

    public Collection<EObject> getComputedPhysicalLinkTarget(EObject related, DDiagram diagram) {
        if (related instanceof PhysicalLink) {
            EObject physicalLinkTarget = this.getPhysicalLinkTarget((PhysicalLink)related);
            return this.getVisibleEdgeEnds(diagram, physicalLinkTarget);
        }
        return Collections.singletonList(related);
    }

    public Object getComputedPhysicalLinkSemanticCandidates(DDiagram diagram) {
        ArrayList result = new ArrayList();
        DDiagramContents context = new DDiagramContents(diagram);
        for (DDiagramElement dNode : context.getDiagramElements()) {
            EObject target = dNode.getTarget();
            if (target instanceof Part) {
                result.addAll((Collection)ModelCache.getCache(PhysicalLinkExt::getAllRelatedPhysicalLinks, (Object)((Part)target)));
                Collection allSubUsedParts = ComponentExt.getAllSubUsedParts((Part)((Part)target), (boolean)true);
                for (Part part : allSubUsedParts) {
                    result.addAll((Collection)ModelCache.getCache(PhysicalLinkExt::getAllRelatedPhysicalLinks, (Object)part));
                }
                continue;
            }
            if (!(target instanceof Component)) continue;
            result.addAll((Collection)ModelCache.getCache(PhysicalLinkExt::getAllRelatedPhysicalLinks, (Object)((Component)target)));
            Collection allSubUsedComponents = ComponentExt.getAllSubUsedComponents((Component)((Component)target));
            for (Component component : allSubUsedComponents) {
                result.addAll(PhysicalLinkExt.getAllRelatedPhysicalLinks((Component)component));
            }
        }
        return result;
    }

    public boolean isValidComputedPhysicalLinkEdge(EObject communication, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        if (!(communication instanceof PhysicalLink)) {
            return false;
        }
        PhysicalLink pl = (PhysicalLink)communication;
        return this.isValidComputedLink(communication, (Port)pl.getSourcePhysicalPort(), (Port)pl.getTargetPhysicalPort(), sourceView, targetView, "LAB_ComputedPhysicalLink", "PAB_ComputedPhysicalLink", "hide.computed.physical.links.filter");
    }

    public boolean isValidComputedComponentExchangeEdge(EObject communication, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        AbstractType targetType;
        AbstractType sourceType;
        if (!(communication instanceof ComponentExchange)) {
            return false;
        }
        ComponentExchange ce = (ComponentExchange)communication;
        if (ce.getKind() == ComponentExchangeKind.DELEGATION) {
            return false;
        }
        EObject source = sourceView.getTarget();
        if (source instanceof Part && (sourceType = ((Part)source).getAbstractType()) instanceof PhysicalComponent && ((PhysicalComponent)sourceType).getNature() == PhysicalComponentNature.NODE) {
            return false;
        }
        EObject target = targetView.getTarget();
        if (target instanceof Part && (targetType = ((Part)target).getAbstractType()) instanceof PhysicalComponent && ((PhysicalComponent)targetType).getNature() == PhysicalComponentNature.NODE) {
            return false;
        }
        return this.isValidComputedLink(communication, ce.getSourcePort(), ce.getTargetPort(), sourceView, targetView, "LAB_ComputedComponentExchange", "PAB_ComputedComponentExchange", "hide.computed.component.exchanges.filter");
    }

    private boolean isValidComputedLink(EObject communication, Port sourcePort, Port targetPort, DSemanticDecorator sourceView, DSemanticDecorator targetView, String labMappingName, String pabMappingName, String filterName) {
        Part sourcePart;
        EObject portParentNodeTarget;
        DNodeContainer portParentNode;
        AbstractType targetComponent;
        AbstractType sourceComponent;
        EObject source = sourceView.getTarget();
        EObject target = targetView.getTarget();
        if (sourceView == targetView) {
            return false;
        }
        if (source instanceof Port && target instanceof Port) {
            return false;
        }
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceView);
        DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
        if (!FilterHelper.isDesactivatedOnce(filterName, descriptor)) {
            return false;
        }
        if (source instanceof Port && target instanceof Part) {
            Part targetPart = (Part)target;
            sourceComponent = (AbstractType)source.eContainer();
            if (sourceComponent == (targetComponent = targetPart.getAbstractType())) {
                return false;
            }
            if (this.isAnAncestor((EObject)sourceComponent, (EObject)targetComponent)) {
                return false;
            }
            portParentNode = (DNodeContainer)sourceView.eContainer();
            portParentNodeTarget = portParentNode.getTarget();
            if (portParentNodeTarget instanceof Part && PartExt.isDeploying((Part)targetPart, (Part)((Part)portParentNodeTarget))) {
                return false;
            }
        }
        if (source instanceof Part && target instanceof Port) {
            sourcePart = (Part)source;
            sourceComponent = sourcePart.getAbstractType();
            targetComponent = (AbstractType)target.eContainer();
            if (targetComponent == sourceComponent) {
                return false;
            }
            if (this.isAnAncestor((EObject)targetComponent, (EObject)sourceComponent)) {
                return false;
            }
            portParentNode = (DNodeContainer)targetView.eContainer();
            portParentNodeTarget = portParentNode.getTarget();
            if (portParentNodeTarget instanceof Part && PartExt.isDeploying((Part)sourcePart, (Part)((Part)portParentNodeTarget))) {
                return false;
            }
        }
        if (source instanceof Part && target instanceof Part) {
            sourcePart = (Part)source;
            Part targetPart = (Part)target;
            AbstractType sourceComponent2 = sourcePart.getAbstractType();
            AbstractType targetComponent2 = targetPart.getAbstractType();
            if (PartExt.isDeploying((Part)sourcePart, (Part)targetPart) || PartExt.isDeploying((Part)targetPart, (Part)sourcePart)) {
                return false;
            }
            if (this.isAnAncestor((EObject)targetComponent2, (EObject)sourceComponent2) || this.isAnAncestor((EObject)sourceComponent2, (EObject)targetComponent2)) {
                return false;
            }
            if (this.isInnerPort((AbstractDNode)sourceView, sourcePort)) {
                return false;
            }
            if (this.isInnerPort((AbstractDNode)targetView, targetPort)) {
                return false;
            }
        }
        if (diagram != null) {
            DSemanticDecorator sourceElement = sourceView;
            DSemanticDecorator targetElement = targetView;
            if (sourceElement.getTarget() instanceof Port) {
                sourceElement = (DSemanticDecorator)sourceElement.eContainer();
            }
            if (targetElement.getTarget() instanceof Port) {
                targetElement = (DSemanticDecorator)targetElement.eContainer();
            }
            Collection<DSemanticDecorator> elements = DiagramServices.getDiagramServices().getDiagramElements((DRepresentation)diagram, communication);
            for (DSemanticDecorator view : elements) {
                DEdge edge;
                if (!(view instanceof DEdge) || !(edge = (DEdge)view).isVisible() || edge.getMapping().getName().equals(labMappingName) || edge.getMapping().getName().equals(pabMappingName)) continue;
                boolean hasSrc = false;
                DSemanticDecorator sourceNode = (DSemanticDecorator)edge.getSourceNode();
                if (sourceNode.getTarget() instanceof Port) {
                    sourceNode = (DSemanticDecorator)sourceNode.eContainer();
                }
                ArrayList<DDiagramElement> toCheck = new ArrayList<DDiagramElement>();
                toCheck.add((DDiagramElement)sourceElement);
                toCheck.addAll((Collection<DDiagramElement>)((DNodeContainer)sourceElement).getOwnedDiagramElements());
                Iterator sourceElementContents = toCheck.iterator();
                while (!hasSrc && sourceElementContents.hasNext()) {
                    EObject next = (EObject)sourceElementContents.next();
                    if (next != sourceNode) continue;
                    hasSrc = true;
                }
                toCheck.clear();
                boolean hasTrgt = false;
                DSemanticDecorator targetNode = (DSemanticDecorator)edge.getTargetNode();
                if (targetNode.getTarget() instanceof Port) {
                    targetNode = (DSemanticDecorator)targetNode.eContainer();
                }
                toCheck.add((DDiagramElement)targetElement);
                toCheck.addAll((Collection<DDiagramElement>)((DNodeContainer)targetElement).getOwnedDiagramElements());
                Iterator targetElementContents = toCheck.iterator();
                while (!hasTrgt && targetElementContents.hasNext()) {
                    EObject next = (EObject)targetElementContents.next();
                    if (next != targetNode) continue;
                    hasTrgt = true;
                }
                if (!hasSrc || !hasTrgt) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isInnerPort(AbstractDNode node, Port port) {
        for (DDiagramElement diagramElement : node.getOwnedBorderedNodes()) {
            if (diagramElement.getTarget() != port || !diagramElement.isVisible()) continue;
            return true;
        }
        if (node instanceof DNodeContainer) {
            for (DDiagramElement next : ((DNodeContainer)node).getOwnedDiagramElements()) {
                if (!(next instanceof AbstractDNode) || !this.isInnerPort((AbstractDNode)next, port)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<EObject> getVisibleEdgeEnds(DDiagram diagram, EObject source) {
        if (source instanceof Port) {
            Collection representingParts;
            DDiagramElement diagramElement = DiagramServices.getDiagramServices().getDiagramElement(diagram, source);
            if (diagramElement != null) {
                Collection representingParts2;
                ArrayList<EObject> result = new ArrayList<EObject>();
                if (diagramElement.isVisible()) {
                    result.add(source);
                }
                if (source.eContainer() instanceof Component && !(representingParts2 = (Collection)ModelCache.getCache(ComponentExt::getRepresentingParts, (Object)((Component)source.eContainer()))).isEmpty()) {
                    Part portParent = (Part)representingParts2.iterator().next();
                    result.addAll(this.getVisibleEdgeEnds(diagram, portParent, false));
                }
                return result;
            }
            if (source.eContainer() instanceof Component && !(representingParts = ComponentExt.getRepresentingParts((Component)((Component)source.eContainer()))).isEmpty()) {
                Part portParent = (Part)representingParts.iterator().next();
                return this.getVisibleEdgeEnds(diagram, portParent, true);
            }
        } else if (source instanceof Part) {
            return this.getVisibleEdgeEnds(diagram, (Part)source, true);
        }
        return Collections.emptyList();
    }

    private Collection<EObject> getVisibleEdgeEnds(DDiagram diagram, Part mainPart, boolean handleMainPart) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        ArrayList<DeploymentTarget> toHandle = new ArrayList<DeploymentTarget>();
        if (handleMainPart) {
            toHandle.add((DeploymentTarget)mainPart);
        }
        this.addRelevantParts(diagram, mainPart, toHandle);
        for (DeploymentTarget element : (List)ModelCache.getCache(PartExt::getDeployingElements, (Object)mainPart)) {
            if (this.isChildView(diagram, mainPart, element)) continue;
            toHandle.add(element);
        }
        for (DeploymentTarget deploymentTarget : toHandle) {
            ArrayList<Part> relevantParts = new ArrayList<Part>();
            relevantParts.add((Part)deploymentTarget);
            relevantParts.addAll(ComponentExt.getPartAncestors((Part)((Part)deploymentTarget)));
            EObject firstVisibleAncestor = this.getFirstVisibleAncestor(diagram, relevantParts);
            if (!(firstVisibleAncestor instanceof Part)) continue;
            result.add(firstVisibleAncestor);
        }
        return result;
    }

    private boolean isChildView(DDiagram diagram, Part mainPart, DeploymentTarget element) {
        for (DSemanticDecorator view : DiagramServices.getDiagramServices().getDiagramElements((DRepresentation)diagram, (EObject)element)) {
            if (!(view instanceof DNodeContainer)) continue;
            DNodeContainer node = (DNodeContainer)view;
            for (DDiagramElement child : node.getOwnedDiagramElements()) {
                if (!mainPart.equals(child.getTarget()) || !child.isVisible()) continue;
                return true;
            }
        }
        return false;
    }

    private void addRelevantParts(DDiagram diagram, Part mainPart, List<DeploymentTarget> toHandle) {
        if (mainPart.eContainer() instanceof Component) {
            for (Part parentPart : (Collection)ModelCache.getCache(ComponentExt::getRepresentingParts, (Object)((Component)mainPart.eContainer()))) {
                Collection<DSemanticDecorator> diagramElements = DiagramServices.getDiagramServices().getDiagramElements((DRepresentation)diagram, (EObject)parentPart);
                int foundCount = 0;
                for (DSemanticDecorator diagElt : diagramElements) {
                    if (!(diagElt instanceof DNodeContainer)) continue;
                    DNodeContainer node = (DNodeContainer)diagElt;
                    for (DDiagramElement elt : node.getOwnedDiagramElements()) {
                        if (!mainPart.equals(elt.getTarget()) || !elt.isVisible()) continue;
                        ++foundCount;
                    }
                }
                if (diagramElements.size() == foundCount) continue;
                toHandle.add((DeploymentTarget)parentPart);
            }
        }
    }

    private EObject getFirstVisibleAncestor(DDiagram diagram, Collection<Part> relevantParts) {
        for (Part part : relevantParts) {
            DDiagramElement diagramElement = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)part);
            if (diagramElement == null || !diagramElement.isVisible()) continue;
            return part;
        }
        return null;
    }

    public Collection<ControlNode> getAvailableControlNodes(DDiagram diagram) {
        Set<FunctionalChain> displayedFunctionalChains = FunctionalChainServices.getFunctionalChainServices().getDisplayedFunctionalChainsOnDiagram(diagram);
        return displayedFunctionalChains.stream().flatMap(fc -> FunctionalChainExt.getFlatControlNodes((FunctionalChain)fc).stream()).collect(Collectors.toList());
    }

    public Collection<SequenceLink> getAvailableSequenceLinks(DDiagram diagram) {
        Set<FunctionalChain> displayedFunctionalChains = FunctionalChainServices.getFunctionalChainServices().getDisplayedFunctionalChainsOnDiagram(diagram);
        return displayedFunctionalChains.stream().flatMap(fc -> FunctionalChainExt.getFlatSequenceLinks((FunctionalChain)fc).stream()).collect(Collectors.toList());
    }

    public EObject getSequenceLinkSource(SequenceLink sequenceLink) {
        SequenceLinkEnd source = sequenceLink.getSource();
        if (source instanceof ControlNode) {
            return source;
        }
        if (source instanceof FunctionalChainInvolvementFunction) {
            return ((FunctionalChainInvolvementFunction)source).getInvolved();
        }
        return null;
    }

    public EObject getSequenceLinkTarget(SequenceLink sequenceLink) {
        SequenceLinkEnd target = sequenceLink.getTarget();
        if (target instanceof ControlNode) {
            return target;
        }
        if (target instanceof FunctionalChainInvolvementFunction) {
            return ((FunctionalChainInvolvementFunction)target).getInvolved();
        }
        return null;
    }

    public boolean isActor(EObject context) {
        return ComponentExt.isActor((EObject)context);
    }

    public Object getConstraintLocation(EObject context, EObject target) {
        if (context == null) {
            return null;
        }
        if (this.isMultipartMode((ModelElement)target)) {
            return target;
        }
        if (target instanceof Part) {
            return ((Part)target).getAbstractType();
        }
        return target;
    }

    static interface AbstractLink {
        public EObject getSource();

        public EObject getTarget();

        public Port getSourcePort();

        public Port getTargetPort();

        public Collection<? extends Port> getSourcePorts();

        public Collection<? extends Port> getTargetPorts();

        public Part getSourcePart();

        public Part getTargetPart();

        public ComponentExchangeKind getKind();

        public ModelElement getData();

        public void setData(EObject var1);
    }

    private class ComponentExchangeWrapper
    implements AbstractLink {
        private ComponentExchange componentExchange;

        ComponentExchangeWrapper() {
        }

        @Override
        public EObject getSource() {
            return this.componentExchange.getSource();
        }

        @Override
        public EObject getTarget() {
            return this.componentExchange.getTarget();
        }

        @Override
        public Port getSourcePort() {
            return ComponentExchangeExt.getSourcePort((ComponentExchange)this.componentExchange);
        }

        @Override
        public Port getTargetPort() {
            return ComponentExchangeExt.getTargetPort((ComponentExchange)this.componentExchange);
        }

        @Override
        public Collection<? extends Port> getSourcePorts() {
            Port source = this.getSourcePort();
            if (source instanceof ComponentPort) {
                return PortExt.getAllLinkedDelegatedComponentPorts((ComponentPort)((ComponentPort)source));
            }
            return Collections.singletonList(this.getSourcePort());
        }

        @Override
        public Collection<? extends Port> getTargetPorts() {
            Port source = this.getTargetPort();
            if (source instanceof ComponentPort) {
                return PortExt.getAllLinkedDelegatedComponentPorts((ComponentPort)((ComponentPort)source));
            }
            return Collections.singletonList(this.getTargetPort());
        }

        @Override
        public Part getSourcePart() {
            return ComponentExchangeExt.getSourcePart((ComponentExchange)this.componentExchange);
        }

        @Override
        public Part getTargetPart() {
            return ComponentExchangeExt.getTargetPart((ComponentExchange)this.componentExchange);
        }

        @Override
        public ComponentExchangeKind getKind() {
            return this.componentExchange.getKind();
        }

        @Override
        public ModelElement getData() {
            return this.componentExchange;
        }

        @Override
        public void setData(EObject obj) {
            if (obj instanceof ComponentExchange) {
                this.componentExchange = (ComponentExchange)obj;
            }
        }
    }

    private class ComponentPortAllocationWrapper
    implements AbstractLink {
        private Allocation exchange;

        ComponentPortAllocationWrapper() {
        }

        @Override
        public EObject getSource() {
            return this.exchange.getSourceElement();
        }

        @Override
        public EObject getTarget() {
            return this.exchange.getTargetElement();
        }

        @Override
        public Port getSourcePort() {
            if (this.exchange.getSourceElement() instanceof Port) {
                return (Port)this.exchange.getSourceElement();
            }
            if (this.exchange.getSourceElement() instanceof ComponentPortAllocationEnd) {
                return ((ComponentPortAllocationEnd)this.exchange.getSourceElement()).getPort();
            }
            return null;
        }

        @Override
        public Port getTargetPort() {
            if (this.exchange.getTargetElement() instanceof Port) {
                return (Port)this.exchange.getTargetElement();
            }
            if (this.exchange.getTargetElement() instanceof ComponentPortAllocationEnd) {
                return ((ComponentPortAllocationEnd)this.exchange.getTargetElement()).getPort();
            }
            return null;
        }

        @Override
        public Collection<? extends Port> getSourcePorts() {
            return Collections.singletonList(this.getSourcePort());
        }

        @Override
        public Collection<? extends Port> getTargetPorts() {
            return Collections.singletonList(this.getTargetPort());
        }

        @Override
        public Part getSourcePart() {
            return null;
        }

        @Override
        public Part getTargetPart() {
            return null;
        }

        @Override
        public ModelElement getData() {
            return this.exchange;
        }

        @Override
        public void setData(EObject obj) {
            if (obj instanceof Allocation) {
                this.exchange = (Allocation)obj;
            }
        }

        @Override
        public ComponentExchangeKind getKind() {
            return null;
        }
    }

    private class FunctionalExchangeWrapper
    implements AbstractLink {
        private FunctionalExchange exchange;

        FunctionalExchangeWrapper() {
        }

        @Override
        public EObject getSource() {
            return this.exchange.getSource();
        }

        @Override
        public EObject getTarget() {
            return this.exchange.getTarget();
        }

        @Override
        public Port getSourcePort() {
            if (this.exchange.getSource() instanceof Port) {
                return (Port)this.exchange.getSource();
            }
            return null;
        }

        @Override
        public Port getTargetPort() {
            if (this.exchange.getTarget() instanceof Port) {
                return (Port)this.exchange.getTarget();
            }
            return null;
        }

        public Collection<Port> getSourcePorts() {
            return Collections.singletonList(this.getSourcePort());
        }

        public Collection<Port> getTargetPorts() {
            return Collections.singletonList(this.getTargetPort());
        }

        @Override
        public Part getSourcePart() {
            return null;
        }

        @Override
        public Part getTargetPart() {
            return null;
        }

        @Override
        public ModelElement getData() {
            return this.exchange;
        }

        @Override
        public void setData(EObject obj) {
            if (obj instanceof FunctionalExchange) {
                this.exchange = (FunctionalExchange)obj;
            }
        }

        @Override
        public ComponentExchangeKind getKind() {
            return null;
        }
    }

    private class PhysicalLinkWrapper
    implements AbstractLink {
        private PhysicalLink link;

        PhysicalLinkWrapper() {
        }

        @Override
        public EObject getSource() {
            if (!this.link.getLinkEnds().isEmpty()) {
                return (EObject)this.link.getLinkEnds().get(0);
            }
            return null;
        }

        @Override
        public EObject getTarget() {
            if (this.link.getLinkEnds().size() > 1) {
                return (EObject)this.link.getLinkEnds().get(1);
            }
            return null;
        }

        @Override
        public Port getSourcePort() {
            return PhysicalLinkExt.getSourcePort((PhysicalLink)this.link);
        }

        @Override
        public Port getTargetPort() {
            return PhysicalLinkExt.getTargetPort((PhysicalLink)this.link);
        }

        @Override
        public Collection<? extends Port> getSourcePorts() {
            return Collections.singletonList(this.getSourcePort());
        }

        @Override
        public Collection<? extends Port> getTargetPorts() {
            return Collections.singletonList(this.getTargetPort());
        }

        @Override
        public Part getSourcePart() {
            return PhysicalLinkExt.getSourcePart((PhysicalLink)this.link);
        }

        @Override
        public Part getTargetPart() {
            return PhysicalLinkExt.getTargetPart((PhysicalLink)this.link);
        }

        @Override
        public ComponentExchangeKind getKind() {
            return null;
        }

        @Override
        public ModelElement getData() {
            return this.link;
        }

        @Override
        public void setData(EObject obj) {
            if (obj instanceof PhysicalLink) {
                this.link = (PhysicalLink)obj;
            }
        }
    }

    private class PortAllocationWrapper
    implements AbstractLink {
        private Allocation exchange;

        PortAllocationWrapper() {
        }

        @Override
        public EObject getSource() {
            return this.exchange.getSourceElement();
        }

        @Override
        public EObject getTarget() {
            return this.exchange.getTargetElement();
        }

        @Override
        public Port getSourcePort() {
            if (this.exchange.getSourceElement() instanceof Port) {
                return (Port)this.exchange.getSourceElement();
            }
            return null;
        }

        @Override
        public Port getTargetPort() {
            if (this.exchange.getTargetElement() instanceof Port) {
                return (Port)this.exchange.getTargetElement();
            }
            return null;
        }

        @Override
        public Collection<? extends Port> getSourcePorts() {
            return Collections.singletonList(this.getSourcePort());
        }

        @Override
        public Collection<? extends Port> getTargetPorts() {
            return Collections.singletonList(this.getTargetPort());
        }

        @Override
        public Part getSourcePart() {
            return null;
        }

        @Override
        public Part getTargetPart() {
            return null;
        }

        @Override
        public ModelElement getData() {
            return this.exchange;
        }

        @Override
        public void setData(EObject obj) {
            if (obj instanceof Allocation) {
                this.exchange = (Allocation)obj;
            }
        }

        @Override
        public ComponentExchangeKind getKind() {
            return null;
        }
    }
}

