/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingWithInterpreterHelper;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.style.BorderedStyleDescription;
import org.eclipse.sirius.diagram.description.style.EdgeStyleDescription;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.SimpleOrientedGraph;
import org.polarsys.capella.core.commands.preferences.service.ScopedCapellaPreferencesStore;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalChainContainer;
import org.polarsys.capella.core.data.fa.ControlNode;
import org.polarsys.capella.core.data.fa.ControlNodeKind;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.ReferenceHierarchyContext;
import org.polarsys.capella.core.data.fa.SequenceLink;
import org.polarsys.capella.core.data.fa.SequenceLinkEnd;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.FunctionalChainAbstractCapabilityInvolvement;
import org.polarsys.capella.core.data.oa.OperationalProcess;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ExchangeItemExt;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.model.helpers.SequenceLinkEndExt;
import org.polarsys.capella.core.model.helpers.SequenceLinkExt;
import org.polarsys.capella.core.model.helpers.graph.InternalLinksGraph;
import org.polarsys.capella.core.model.helpers.graph.InvolvementGraph;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.ColorManager;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.ShapeUtil;
import org.polarsys.capella.core.sirius.analysis.accelerators.SelectOrCreateFunctionalExchangeDialog;
import org.polarsys.capella.core.sirius.analysis.cache.DEdgeIconCache;
import org.polarsys.capella.core.sirius.analysis.cache.FunctionalChainCache;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.helpers.FunctionalChainReferenceHierarchyHelper;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class FunctionalChainServices {
    public static final Integer THICK_BORDER_SOURCE_FUNCTION = 4;
    public static final Integer THICK_BORDER_TARGET_FUNCTION = 4;
    public static final Integer THICK_EDGE_FUNCTIONAL_CHAIN = 4;
    public static final String INCOMPLETE_FUNCTIONAL_CHAIN_LABEL = "incomplete";
    public static final String INVALID_FUNCTIONAL_CHAIN_LABEL = "invalid";
    public static final String FCR_CONTAINER_COLLAPSED_INDICATOR = " [+]";
    public static final String IT = "IT";
    private static FunctionalChainServices singleton = null;

    public static FunctionalChainServices getFunctionalChainServices() {
        if (singleton == null) {
            singleton = new FunctionalChainServices();
        }
        return singleton;
    }

    public Collection<FunctionalChainInvolvementLink> getAllFunctionalChainInvolvementLinks(FunctionalChain chain) {
        HashSet<FunctionalChainInvolvementLink> result = new HashSet<FunctionalChainInvolvementLink>();
        this.getAllFunctionalChainInvolvementLinks(chain, result);
        return result;
    }

    private void getAllFunctionalChainInvolvementLinks(FunctionalChain chain, Collection<FunctionalChainInvolvementLink> linksAcumulator) {
        for (FunctionalChainInvolvement involvement : chain.getOwnedFunctionalChainInvolvements()) {
            FunctionalChain referencedChain;
            if (involvement instanceof FunctionalChainInvolvementLink) {
                linksAcumulator.add((FunctionalChainInvolvementLink)involvement);
                continue;
            }
            if (!(involvement instanceof FunctionalChainReference) || (referencedChain = ((FunctionalChainReference)involvement).getReferencedFunctionalChain()) == null) continue;
            this.getAllFunctionalChainInvolvementLinks(referencedChain, linksAcumulator);
        }
    }

    public Collection<EObject> getFunctionalChainSources(FunctionalChain chain) {
        InvolvementGraph g = FunctionalChainCache.getInstance().getInvolvementGraph(chain);
        InternalLinksGraph linksGraph = FunctionalChainCache.getInstance().getInternalLinksGraph(g);
        return linksGraph.getEdges().values().stream().map(e -> (FunctionPort)((InternalLinksGraph.InternalLinkNode)e.getSource()).getSemantic()).collect(Collectors.toSet());
    }

    public Collection<EObject> getFunctionalChainTargets(FunctionalChain chain) {
        InvolvementGraph g = FunctionalChainCache.getInstance().getInvolvementGraph(chain);
        InternalLinksGraph linksGraph = FunctionalChainCache.getInstance().getInternalLinksGraph(g);
        return linksGraph.getEdges().values().stream().map(e -> (FunctionPort)((InternalLinksGraph.InternalLinkNode)e.getTarget()).getSemantic()).collect(Collectors.toSet());
    }

    public Collection<EObject> getFunctionalChainsToDisplays(EObject chain, DSemanticDiagram diagram) {
        HashMap<FunctionalChain, DNode> functionalChains = this.getDisplayedFunctionalChains((DDiagram)diagram);
        return functionalChains.keySet();
    }

    public AbstractFunction getBestFunction(AbstractFunction element, Collection<? extends EObject> elements) {
        AbstractFunction current = element;
        while (current != null) {
            if (current instanceof AbstractFunction && elements.contains(current)) {
                return current;
            }
            current = current.eContainer();
        }
        return null;
    }

    public List<FunctionalChain> getFunctionalChainsToInsert(EObject context, DDiagram currentDiagram, List<FunctionalChain> allFunctionalChains) {
        ArrayList<FunctionalChain> returnedList = new ArrayList<FunctionalChain>();
        for (DDiagramElement anObject : DiagramServices.getDiagramServices().getDiagramElements((EObject)currentDiagram)) {
            if (!(anObject.getTarget() instanceof AbstractFunction)) continue;
            AbstractFunction aFunction = (AbstractFunction)anObject.getTarget();
            for (FunctionalChain aFunctionalChain : allFunctionalChains) {
                Set involvedFunctions = FunctionalChainExt.getFlatInvolvedElements((FunctionalChain)aFunctionalChain, (EClass)FaPackage.Literals.ABSTRACT_FUNCTION);
                if (returnedList.contains(aFunctionalChain)) continue;
                if (involvedFunctions.contains(aFunction)) {
                    returnedList.add(aFunctionalChain);
                    continue;
                }
                for (AbstractFunction aSubFunction : FunctionExt.getAllAbstractFunctions((AbstractFunction)aFunction)) {
                    if (!involvedFunctions.contains(aSubFunction)) continue;
                    returnedList.add(aFunctionalChain);
                }
            }
        }
        return returnedList;
    }

    public void updateFunctionalChainStyles(DDiagram diagram) {
        EObject target;
        RGBValues color;
        HashMap<FunctionalChain, DNode> functionalChains = this.getDisplayedFunctionalChains(diagram);
        HashMapSet<DSemanticDecorator, RGBValues> colors = new HashMapSet<DSemanticDecorator, RGBValues>();
        HashMap<DEdge, Set<FunctionalChain>> coloredLinks = new HashMap<DEdge, Set<FunctionalChain>>();
        ArrayList<DEdge> internalLinks = new ArrayList<DEdge>();
        for (Map.Entry<FunctionalChain, DNode> entry : functionalChains.entrySet()) {
            FunctionalChain chain = entry.getKey();
            DNode chainView = entry.getValue();
            this.updateFunctionalChainNodeColor(chainView, functionalChains.values());
            InvolvementGraph graph = FunctionalChainCache.getInstance().getInvolvementGraph(chain);
            color = ShapeUtil.getNodeColorStyle(chainView);
            if (color == null) continue;
            for (InvolvementGraph.InvolvementNode node : graph.getNodes().values()) {
                if (!graph.isInvolvingFunction(node) || !graph.isStartingFunction(node) && !graph.isEndingFunction(node)) continue;
                AbstractFunction function = graph.getInvolvedFunction(node);
                Collection<DSemanticDecorator> views = this.getBestDisplayedFunctionNode(function, diagram);
                for (DSemanticDecorator view : views) {
                    colors.put(view, color);
                }
            }
            for (InvolvementGraph.InvolvementEdge edge : graph.getEdges().values()) {
                DSemanticDecorator view;
                FunctionalExchange semantic = null;
                if (graph.isInvolvingFunctionalExchange(edge)) {
                    semantic = graph.getInvolvedFunctionalExchange(edge);
                } else if (graph.isSequenceLink(edge)) {
                    semantic = graph.getSequenceLink(edge);
                }
                if (semantic == null) continue;
                view = DiagramServices.getDiagramServices().getDiagramElements((DRepresentation)diagram, (EObject)semantic).iterator();
                while (view.hasNext()) {
                    DSemanticDecorator view2 = (DSemanticDecorator)view.next();
                    colors.put(view2, color);
                    if (!(semantic instanceof FunctionalExchange) || !(view2 instanceof DEdge)) continue;
                    Set chains = coloredLinks.computeIfAbsent((DEdge)view2, k -> new HashSet());
                    chains.add(chain);
                }
            }
            if (chain instanceof OperationalProcess) continue;
            InternalLinksGraph linksGraph = FunctionalChainCache.getInstance().getInternalLinksGraph(graph);
            for (InternalLinksGraph.InternalLinkEdge edge : linksGraph.getEdges().values()) {
                DEdge link;
                FunctionPort source = (FunctionPort)((InternalLinksGraph.InternalLinkNode)edge.getSource()).getSemantic();
                FunctionPort target2 = (FunctionPort)((InternalLinksGraph.InternalLinkNode)edge.getTarget()).getSemantic();
                DDiagramElement sourceNode = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)source);
                DDiagramElement targetNode = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)target2);
                if (sourceNode == null || targetNode == null || (link = this.createInternalLink((EdgeTarget)sourceNode, (EdgeTarget)targetNode, chain)) == null) continue;
                internalLinks.add(link);
            }
        }
        for (DEdge link : internalLinks) {
            ArrayList<RGBValues> chainColors = new ArrayList<RGBValues>();
            for (EObject fc : link.getSemanticElements()) {
                if (!functionalChains.containsKey(fc)) continue;
                color = ShapeUtil.getNodeColorStyle(functionalChains.get(fc));
                chainColors.add(color);
            }
            this.customizeFunctionalChainEdgeStyle(link, chainColors.size() == 1 ? (RGBValues)chainColors.get(0) : ShapeUtil.getBlackColor());
        }
        for (DDiagramElement view : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            target = view.getTarget();
            if (!(target instanceof AbstractFunction)) continue;
            if (colors.containsKey(view)) {
                this.customizeSourceFunctionStyle(view, ShapeUtil.getColor((Collection<RGBValues>)colors.get(view)));
                continue;
            }
            this.resetFunctionStyle(view);
        }
        this.customizeFunctionalExchangeEdgeLabels(coloredLinks, functionalChains);
        for (DDiagramElement view : diagram.getEdges()) {
            target = view.getTarget();
            if (!(target instanceof FunctionalExchange) && !(target instanceof SequenceLink)) continue;
            if (colors.containsKey(view)) {
                this.customizeFunctionalChainEdgeStyle((DEdge)view, ShapeUtil.getColor((Collection<RGBValues>)colors.get(view)));
                continue;
            }
            this.resetFunctionalExchangeStyle((DEdge)view);
            this.resetFunctionalExchangeEdgeLabels((DEdge)view);
        }
    }

    public void customizeFunctionalExchangeEdgeLabels(Map<DEdge, Set<FunctionalChain>> coloredLinks, Map<FunctionalChain, DNode> displayedFCs) {
        for (Map.Entry<DEdge, Set<FunctionalChain>> entry : coloredLinks.entrySet()) {
            DEdge edge = entry.getKey();
            Set<FunctionalChain> chains = entry.getValue();
            List fcColors = chains.stream().map(displayedFCs::get).map(ShapeUtil::getNodeColorStyle).collect(Collectors.toList());
            if (fcColors.size() > 1) {
                DEdgeIconCache.getInstance().setIcon(edge, fcColors.stream().collect(Collectors.toList()));
                DEdgeIconCache.getInstance().setLabel(edge, DiagramServices.getDiagramServices().getOverlappedLabels(chains.stream().map(AbstractNamedElement::getName).collect(Collectors.toList())));
            } else {
                DEdgeIconCache.getInstance().removeIcon(edge);
                DEdgeIconCache.getInstance().setLabel(edge, "");
            }
            DiagramServices.getDiagramServices().refreshBeginEndLabels(edge);
            CapellaServices.getService().refreshElement((DRepresentationElement)edge);
        }
    }

    public void resetFunctionalExchangeEdgeLabels(DEdge edge) {
        DEdgeIconCache.getInstance().removeIcon(edge);
        DEdgeIconCache.getInstance().setLabel(edge, "");
        DiagramServices.getDiagramServices().refreshBeginEndLabels(edge);
        CapellaServices.getService().refreshElement((DRepresentationElement)edge);
    }

    public HashMap<FunctionalChain, DNode> getDisplayedFunctionalChains(DDiagram diagram) {
        HashMap<FunctionalChain, DNode> functionalChainToNodeMap = new HashMap<FunctionalChain, DNode>();
        for (DDiagramElement aNode : diagram.getOwnedDiagramElements()) {
            if (!(aNode instanceof DNode) || !(aNode.getTarget() instanceof FunctionalChain)) continue;
            functionalChainToNodeMap.put((FunctionalChain)aNode.getTarget(), (DNode)aNode);
        }
        return functionalChainToNodeMap;
    }

    public Set<FunctionalChain> getDisplayedFunctionalChainsOnDiagram(DDiagram diagram) {
        HashSet<FunctionalChain> functionalChains = new HashSet<FunctionalChain>();
        for (DDiagramElement aNode : diagram.getOwnedDiagramElements()) {
            if (!(aNode instanceof DNode) || !(aNode.getTarget() instanceof FunctionalChain)) continue;
            functionalChains.add((FunctionalChain)aNode.getTarget());
        }
        return functionalChains;
    }

    public Collection<EObject> getFCInternalLinkSemanticElements(DEdge view) {
        Set<FunctionalChain> displayedChains = this.getDisplayedFunctionalChainsOnDiagram(view.getParentDiagram());
        return view.getSemanticElements().stream().filter(x -> displayedChains.contains(x)).collect(Collectors.toList());
    }

    public boolean isValidInternalLinkEdge(FunctionalChain chain, EdgeTarget currentSourceNode, EdgeTarget currentTargetNode) {
        if (currentSourceNode == null || currentSourceNode.getIncomingEdges().isEmpty()) {
            return false;
        }
        if (currentTargetNode == null || currentTargetNode.getOutgoingEdges().isEmpty()) {
            return false;
        }
        if (!this.hasVisibleEdge((EList<DEdge>)currentSourceNode.getIncomingEdges())) {
            return false;
        }
        if (!this.hasVisibleEdge((EList<DEdge>)currentTargetNode.getOutgoingEdges())) {
            return false;
        }
        EObject sourceParent = currentSourceNode.eContainer();
        EObject targetParent = currentTargetNode.eContainer();
        if (sourceParent == null || targetParent == null || !sourceParent.equals(targetParent)) {
            return false;
        }
        InvolvementGraph g = FunctionalChainCache.getInstance().getInvolvementGraph(chain);
        InternalLinksGraph g2 = FunctionalChainCache.getInstance().getInternalLinksGraph(g);
        if (!g2.hasInternalLink(((DDiagramElement)currentSourceNode).getTarget(), ((DDiagramElement)currentTargetNode).getTarget())) {
            return false;
        }
        DDiagram diagram = ((DDiagramElement)currentSourceNode).getParentDiagram();
        DEdge anotherEdge = DiagramServices.getDiagramServices().findInternalLinkEdge(diagram, currentSourceNode, currentTargetNode, this.getInternLinkEdgeMapping(diagram));
        boolean hasAnotherEdge = anotherEdge != null && !chain.equals(anotherEdge.getTarget());
        return !hasAnotherEdge;
    }

    private boolean hasVisibleEdge(EList<DEdge> edges) {
        for (DEdge edge : edges) {
            if (DiagramServices.getDiagramServices().isHidden((DDiagramElement)edge) || DiagramServices.getDiagramServices().isFiltered((DDiagramElement)edge)) continue;
            return true;
        }
        return false;
    }

    protected Collection<FunctionalExchange> getFlatPreviousFunctionalExchanges(FunctionalChain fc, FunctionalChainInvolvement fci) {
        HashSet<FunctionalExchange> result = new HashSet<FunctionalExchange>();
        for (FunctionalChainInvolvement involvment : FunctionalChainExt.getFlatPreviousExchangeInvolvements((FunctionalChainInvolvement)fci)) {
            if (!(involvment.getInvolved() instanceof FunctionalExchange)) continue;
            result.add((FunctionalExchange)involvment.getInvolved());
        }
        return result;
    }

    protected Collection<FunctionalExchange> getFlatNextFunctionalExchanges(FunctionalChain fc, FunctionalChainInvolvement fci) {
        HashSet<FunctionalExchange> result = new HashSet<FunctionalExchange>();
        for (FunctionalChainInvolvement involvment : FunctionalChainExt.getFlatNextExchangeInvolvements((FunctionalChainInvolvement)fci)) {
            if (!(involvment.getInvolved() instanceof FunctionalExchange)) continue;
            result.add((FunctionalExchange)involvment.getInvolved());
        }
        return result;
    }

    public DEdge createInternalLink(EdgeTarget sourceNode, EdgeTarget targetNode, FunctionalChain fc) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceNode);
        EdgeMapping mapping = this.getInternLinkEdgeMapping(diagram);
        DEdge newEdge = DiagramServices.getDiagramServices().findInternalLinkEdge(diagram, sourceNode, targetNode, mapping);
        if (newEdge == null && this.isValidInternalLinkEdge(fc, sourceNode, targetNode)) {
            DiagramServices.getDiagramServices().createEdge(mapping, sourceNode, targetNode, (EObject)fc);
            newEdge = DiagramServices.getDiagramServices().findInternalLinkEdge(diagram, sourceNode, targetNode, mapping);
        }
        if (newEdge != null && !newEdge.getSemanticElements().contains((Object)fc)) {
            newEdge.getSemanticElements().add((Object)fc);
        }
        return newEdge;
    }

    public EdgeMapping getInternLinkEdgeMapping(DDiagram diagram) {
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, MappingConstantsHelper.getInternLinkEdgeMapping(diagram));
    }

    public void resetFunctionalExchangeStyle(DEdge aEdge) {
        EdgeStyleDescription desc;
        String defaultStyleSize;
        EdgeStyle edgeStyle;
        Integer currentSize;
        DiagramElementMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(aEdge);
        if (mapping != null && (currentSize = (edgeStyle = aEdge.getOwnedStyle()).getSize()) != null && currentSize.equals(THICK_EDGE_FUNCTIONAL_CHAIN) && ShapeUtil.isCustomisation((Style)edgeStyle, (EStructuralFeature)DiagramPackage.Literals.EDGE_STYLE__SIZE) && (defaultStyleSize = (desc = (EdgeStyleDescription)this.getMappingHelper((DSemanticDecorator)aEdge).getBestStyleDescription(mapping, aEdge.getTarget(), (EObject)aEdge, aEdge.eContainer(), CapellaServices.getService().getDiagramContainer((EObject)aEdge))).getSizeComputationExpression()) != null && ShapeUtil.resetEdgeThickStyle(aEdge, Integer.valueOf(defaultStyleSize))) {
            ShapeUtil.resetEdgeColorStyle(aEdge, ShapeUtil.getDefaultColor((DSemanticDecorator)aEdge, (EObject)desc, desc.getStrokeColor()));
        }
    }

    public boolean resetFunctionStyle(DDiagramElement functionNode) {
        boolean result = false;
        String defaultStyleSize = null;
        Integer currentSize = null;
        BorderedStyle style = null;
        if (functionNode instanceof AbstractDNode) {
            AbstractDNode node = (AbstractDNode)functionNode;
            BorderedStyleDescription desc = (BorderedStyleDescription)this.getMappingHelper((DSemanticDecorator)functionNode).getBestStyleDescription(functionNode.getDiagramElementMapping(), functionNode.getTarget(), (EObject)functionNode, functionNode.eContainer(), CapellaServices.getService().getDiagramContainer((EObject)functionNode));
            if (desc != null) {
                defaultStyleSize = desc.getBorderSizeComputationExpression();
                style = (BorderedStyle)ShapeUtil.getCurrentStyle((DDiagramElement)node);
                if (style != null) {
                    currentSize = style.getBorderSize();
                }
                if (currentSize != null && defaultStyleSize != null && (currentSize.equals(THICK_BORDER_SOURCE_FUNCTION) || currentSize.equals(THICK_BORDER_TARGET_FUNCTION) || currentSize.equals(defaultStyleSize)) && ShapeUtil.resetBorderStyle(node, Integer.valueOf(desc.getBorderSizeComputationExpression())) && ShapeUtil.resetBorderColorStyle(node, ShapeUtil.getDefaultColor((DSemanticDecorator)node, (EObject)desc, desc.getBorderColor()))) {
                    result = true;
                }
            }
        }
        return result;
    }

    public void customizeFunctionalChainEdgeStyle(DEdge edge, RGBValues color) {
        String defaultSize;
        EdgeStyleDescription desc;
        EdgeStyle edgeStyle = edge.getOwnedStyle();
        Integer currentSize = edgeStyle.getSize();
        DiagramElementMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(edge);
        if (mapping != null && (desc = (EdgeStyleDescription)this.getMappingHelper((DSemanticDecorator)edge).getBestStyleDescription(mapping, edge.getTarget(), (EObject)edge, edge.eContainer(), CapellaServices.getService().getDiagramContainer((EObject)edge))) != null && (defaultSize = desc.getSizeComputationExpression()) != null && currentSize != null && (currentSize.equals(Integer.valueOf(defaultSize)) || currentSize.equals(THICK_EDGE_FUNCTIONAL_CHAIN))) {
            this.customizeEdgeStyle(edge, color);
        }
    }

    public void customizeInternalLinksEdgeStyle(DEdge edge, RGBValues color) {
        this.customizeEdgeStyle(edge, color);
    }

    public void customizeEdgeStyle(DEdge edge, RGBValues color) {
        RGB rgbColor = new RGB(color.getRed(), color.getGreen(), color.getBlue());
        ShapeUtil.setEdgeColorStyle(edge, rgbColor);
        ShapeUtil.setEdgeThickStyle(edge, THICK_EDGE_FUNCTIONAL_CHAIN);
    }

    public void customizeFunctionStyle(DDiagramElement functionNode, RGBValues color) {
        RGB rgbColor = new RGB(color.getRed(), color.getGreen(), color.getBlue());
        if (functionNode instanceof AbstractDNode) {
            ShapeUtil.setBorderColorStyle((AbstractDNode)functionNode, rgbColor);
        }
    }

    public void customizeSourceFunctionStyle(DDiagramElement functionNode, RGBValues color) {
        this.customizeFunctionStyle(functionNode, color);
        if (functionNode instanceof AbstractDNode) {
            ShapeUtil.setBorderStyle((AbstractDNode)functionNode, THICK_BORDER_SOURCE_FUNCTION);
        }
    }

    public void customizeTargetFunctionStyle(DDiagramElement functionNode, RGBValues color) {
        this.customizeFunctionStyle(functionNode, color);
        if (functionNode instanceof AbstractDNode) {
            ShapeUtil.setBorderStyle((AbstractDNode)functionNode, THICK_BORDER_TARGET_FUNCTION);
        }
    }

    public Collection<DSemanticDecorator> getBestDisplayedFunctionNode(AbstractFunction function, DDiagram diagram) {
        AbstractFunction semantic = function;
        Collection<DSemanticDecorator> elements = DiagramServices.getDiagramServices().getDiagramElements((DRepresentation)diagram, (EObject)function);
        while (elements.isEmpty() && semantic != null) {
            elements = DiagramServices.getDiagramServices().getDiagramElements((DRepresentation)diagram, (EObject)semantic);
            semantic = semantic.eContainer();
        }
        return elements;
    }

    public boolean isCompleteFunctionalChain(FunctionalChain fc, DDiagram diagram) {
        Set functionalExchangesOnTheChain = FunctionalChainExt.getFlatFunctionalExchanges((FunctionalChain)fc);
        int numberOfVisibleRelatedFEEdges = 0;
        for (DEdge anEdge : diagram.getEdges()) {
            EObject edgeTarget;
            if (!anEdge.isVisible() || !((edgeTarget = anEdge.getTarget()) instanceof FunctionalExchange) || !functionalExchangesOnTheChain.contains(edgeTarget)) continue;
            ++numberOfVisibleRelatedFEEdges;
        }
        return numberOfVisibleRelatedFEEdges == functionalExchangesOnTheChain.size();
    }

    public boolean isFCRegion(EObject view) {
        return view instanceof AbstractDNode && "FC_FunctionalChainStacked".equals(((AbstractDNode)view).getDiagramElementMapping().getName());
    }

    public String getFCInvolvmentLinkLabel(FunctionalChainInvolvementLink involvementLink, DDiagram diagram) {
        String label = "";
        InvolvedElement involved = involvementLink.getInvolved();
        if (involved instanceof FunctionalExchange) {
            FunctionalExchange functionalExchange = (FunctionalExchange)involvementLink.getInvolved();
            label = functionalExchange.getName();
            Set filterNames = diagram.getActivatedFilters().stream().map(IdentifiedElement::getName).collect(Collectors.toSet());
            boolean showExchangeItems = filterNames.contains("show.exchange.items.filter");
            boolean showExchangeItemsParameters = filterNames.contains("show.exchange.items.parameters.filter");
            boolean showFEExchangeItems = filterNames.contains("show.functional.exchanges.exchange.items.filter");
            if (showExchangeItems || showFEExchangeItems) {
                StringBuilder sb = new StringBuilder();
                if (showFEExchangeItems) {
                    sb.append(label);
                    sb.append("[");
                }
                EList exchangedItemsForLabel = involvementLink.getExchangedItems().isEmpty() ? functionalExchange.getExchangedItems() : involvementLink.getExchangedItems();
                String exchangedItemsLabel = exchangedItemsForLabel.stream().map(ei -> ExchangeItemExt.getEILabel((AbstractExchangeItem)ei, (boolean)showExchangeItemsParameters).toString()).collect(Collectors.joining(", "));
                sb.append(exchangedItemsLabel);
                if (showFEExchangeItems) {
                    sb.append("]");
                }
                label = sb.toString();
            }
        } else if (involved instanceof AbstractFunction) {
            AbstractFunction function = (AbstractFunction)involved;
            label = function.getName();
        }
        return label;
    }

    public String getFunctionalChainLabel(FunctionalChain chain, DDiagram diagram) {
        boolean displayIncompleteLabel = false;
        boolean displayInvalidLabel = false;
        if (chain instanceof OperationalProcess) {
            displayIncompleteLabel = ScopedCapellaPreferencesStore.getBoolean((String)"org.polarsys.capella.core.sirius.analysis.preferences.diagrams.operationalprocess.label.incomplete", (IProject)PreferencesHelper.getProject((EObject)chain));
            displayInvalidLabel = ScopedCapellaPreferencesStore.getBoolean((String)"org.polarsys.capella.core.sirius.analysis.preferences.diagrams.operationalprocess.label.invalid", (IProject)PreferencesHelper.getProject((EObject)chain));
        } else {
            displayIncompleteLabel = ScopedCapellaPreferencesStore.getBoolean((String)"org.polarsys.capella.core.sirius.analysis.preferences.diagrams.functionalchain.label.incomplete", (IProject)PreferencesHelper.getProject((EObject)chain));
            displayInvalidLabel = ScopedCapellaPreferencesStore.getBoolean((String)"org.polarsys.capella.core.sirius.analysis.preferences.diagrams.functionalchain.label.invalid", (IProject)PreferencesHelper.getProject((EObject)chain));
        }
        ArrayList<String> chainStatusLabels = new ArrayList<String>();
        if (displayIncompleteLabel && !this.isCompleteFunctionalChain(chain, diagram)) {
            chainStatusLabels.add(INCOMPLETE_FUNCTIONAL_CHAIN_LABEL);
        }
        if (displayInvalidLabel && !FunctionalChainExt.isFunctionalChainValid((FunctionalChain)chain)) {
            chainStatusLabels.add(INVALID_FUNCTIONAL_CHAIN_LABEL);
        }
        String chainLabel = EObjectExt.getText((EObject)chain);
        String chainStatusLabel = chainStatusLabels.isEmpty() ? "" : chainStatusLabels.stream().collect(Collectors.joining(", ", " (", ")"));
        return String.valueOf(chainLabel) + chainStatusLabel;
    }

    public void updateFunctionalChainNodeColor(DNode fcNode, Collection<DNode> visibleFunctionalChains) {
        RGBValues color = ShapeUtil.getNodeColorStyle(fcNode);
        ColorManager colorManager = ColorManager.getInstance();
        List<RGB> colorList = colorManager.getColorList();
        boolean changeColor = false;
        if (ShapeUtil.isSameColor(color, colorManager.getGrayColor())) {
            changeColor = true;
        }
        for (DNode aFc : visibleFunctionalChains) {
            if (aFc.equals(fcNode)) continue;
            RGBValues nodeColor = ShapeUtil.getNodeColorStyle(aFc);
            if (ShapeUtil.isSameColor(nodeColor, color)) {
                changeColor = true;
            }
            ShapeUtil.removeColorFromList(nodeColor, colorList);
        }
        if (!changeColor) {
            return;
        }
        if (!colorList.isEmpty()) {
            ShapeUtil.setColorStyle(fcNode, colorList.get(0));
        }
    }

    public List<FunctionalExchange> getAvailableExchanges(EObject context, AbstractFunction source, AbstractFunction target) {
        ArrayList<FunctionalExchange> returnedFunctionalExchanges = new ArrayList<FunctionalExchange>();
        List incoming = FunctionExt.getIncomingExchange((AbstractFunction)target);
        List outgoing = FunctionExt.getOutGoingExchange((AbstractFunction)source);
        for (FunctionalExchange aFunctionalExchange : incoming) {
            if (!outgoing.contains(aFunctionalExchange)) continue;
            returnedFunctionalExchanges.add(aFunctionalExchange);
        }
        return returnedFunctionalExchanges;
    }

    public List<FunctionalChainInvolvement> getPreviousInvolvements(FunctionalChainInvolvement involvement) {
        return involvement.getPreviousFunctionalChainInvolvements();
    }

    public EObject createFunctionalChain(EObject context, List<EObject> views) {
        if (!views.isEmpty()) {
            ArrayList<EObject> newList = new ArrayList<EObject>();
            AbstractFunction aFunction = null;
            for (EObject aSelectedElement : views) {
                if (!(aSelectedElement instanceof DDiagramElement) || ((DDiagramElement)aSelectedElement).getTarget() == null) continue;
                newList.add(((DDiagramElement)aSelectedElement).getTarget());
                if (aFunction != null || !(((DDiagramElement)aSelectedElement).getTarget() instanceof FunctionalExchange)) continue;
                AbstractFunction aSourceFunction = FunctionExt.getIncomingAbstractFunction((FunctionalExchange)((FunctionalExchange)((DDiagramElement)aSelectedElement).getTarget()));
                aFunction = FunctionExt.getRootFunction((AbstractFunction)aSourceFunction);
            }
            if (aFunction != null) {
                EObject diagramContainer = ((DSemanticDiagram)CapellaServices.getService().getDiagramContainer(views.get(0))).getTarget();
                FunctionalChain newFC = diagramContainer instanceof AbstractFunctionalChainContainer ? FunctionalChainExt.createFunctionalChain((AbstractFunctionalChainContainer)((AbstractFunctionalChainContainer)diagramContainer), newList) : FunctionalChainExt.createFunctionalChain(aFunction, newList);
                return newFC;
            }
        }
        return context;
    }

    public void removeFunctionalChainAbstractCapabilityInvolvement(AbstractCapability capability, EObject target) {
        HashSet<FunctionalChainAbstractCapabilityInvolvement> toRemove = new HashSet<FunctionalChainAbstractCapabilityInvolvement>();
        for (FunctionalChainAbstractCapabilityInvolvement inv : capability.getOwnedFunctionalChainAbstractCapabilityInvolvements()) {
            if (!inv.getInvolved().equals(target)) continue;
            toRemove.add(inv);
        }
        for (FunctionalChainAbstractCapabilityInvolvement involvement : toRemove) {
            involvement.destroy();
        }
    }

    public FunctionalChainAbstractCapabilityInvolvement createFunctionalChainAbstractCapabilityInvolvement(AbstractCapability capability, FunctionalChain target) {
        return FunctionalChainExt.createFunctionalChainAbstractCapabilityInvolvement((AbstractCapability)capability, (FunctionalChain)target);
    }

    public boolean isValidFunctionalChainSelection(EObject context, List<EObject> views) {
        SimpleOrientedGraph graph = new SimpleOrientedGraph();
        if (!views.isEmpty()) {
            for (EObject aSelectedElement : views) {
                if (!(aSelectedElement instanceof DEdge) || ((DEdge)aSelectedElement).getTarget() == null || !(((DEdge)aSelectedElement).getTarget() instanceof FunctionalExchange)) continue;
                FunctionalExchange aSelectedExchange = (FunctionalExchange)((DEdge)aSelectedElement).getTarget();
                AbstractFunction sourceFunction = FunctionExt.getIncomingAbstractFunction((FunctionalExchange)aSelectedExchange);
                AbstractFunction targetFunction = FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)aSelectedExchange);
                graph.addNode((Object)sourceFunction, (Object)targetFunction);
            }
            if (!graph.isEmpty()) {
                return graph.isValid();
            }
            return false;
        }
        return false;
    }

    public List<AbstractFunction> computeFCIFunctionScope(EObject container) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)container);
        if (architecture != null) {
            return FunctionExt.getAllAbstractFunctions((BlockArchitecture)architecture);
        }
        return Collections.emptyList();
    }

    protected Set<FunctionalExchange> getAllFunctionalExchanges(DNode node) {
        return DiagramServices.getDiagramServices().getAllEdges((EdgeTarget)node).stream().map(DSemanticDecorator::getTarget).filter(FunctionalChainInvolvementLink.class::isInstance).map(link -> ((FunctionalChainInvolvementLink)link).getInvolved()).filter(FunctionalExchange.class::isInstance).map(FunctionalExchange.class::cast).collect(Collectors.toSet());
    }

    public Collection<FunctionalExchange> computeFCIFunctionalExchangeAndFunctionScope(DNode node) {
        Set<FunctionalExchange> existingInvolvedFunctionalExchanges = this.getAllFunctionalExchanges(node);
        FunctionalChainInvolvementFunction selectedFunction = (FunctionalChainInvolvementFunction)node.getTarget();
        LinkedHashSet<FunctionalExchange> possibleFunctionalExchanges = new LinkedHashSet<FunctionalExchange>();
        possibleFunctionalExchanges.addAll(FunctionalChainExt.getFlatIncomingExchanges((FunctionalChainInvolvement)selectedFunction));
        possibleFunctionalExchanges.addAll(FunctionalChainExt.getFlatOutgoingExchanges((FunctionalChainInvolvement)selectedFunction));
        possibleFunctionalExchanges.removeAll(existingInvolvedFunctionalExchanges);
        return possibleFunctionalExchanges;
    }

    public boolean isValidFCILinkExchange(DNode sourceView, DNode targetView) {
        EObject source = sourceView.getTarget();
        EObject target = targetView.getTarget();
        if (source instanceof FunctionalChainInvolvementFunction && target instanceof FunctionalChainInvolvementFunction) {
            FunctionalChainInvolvementFunction sourceFunction = (FunctionalChainInvolvementFunction)source;
            FunctionalChainInvolvementFunction targetFunction = (FunctionalChainInvolvementFunction)target;
            Collection commonExchanges = FunctionalChainExt.getFlatCommonFunctionalExchanges((FunctionalChainInvolvement)sourceFunction, (FunctionalChainInvolvement)targetFunction);
            return !commonExchanges.isEmpty() && !this.doesConnectionExist((EdgeTarget)targetView, (EdgeTarget)sourceView, new HashSet<EdgeTarget>());
        }
        return false;
    }

    public boolean isValidFCILinkFunction(FunctionalChainInvolvementFunction source, EdgeTarget sourceView, FunctionalChainInvolvementFunction target, EdgeTarget targetView) {
        return sourceView != targetView && this.isSameFunctionInvolved((FunctionalChainInvolvement)source, (FunctionalChainInvolvement)target) && !this.isSameFunctionalChain((FunctionalChainInvolvement)source, (FunctionalChainInvolvement)target);
    }

    public boolean isSameFunctionInvolved(FunctionalChainInvolvement sourceInvolvement, FunctionalChainInvolvement targetInvolvement) {
        return sourceInvolvement.getInvolved() == targetInvolvement.getInvolved();
    }

    public boolean isSameFunctionalChain(FunctionalChainInvolvement sourceInvolvement, FunctionalChainInvolvement targetInvolvement) {
        return sourceInvolvement.eContainer() == targetInvolvement.eContainer();
    }

    public List<FunctionalChainReference> computeFCReferenceHierarchy(EdgeTarget view, FunctionalChain endFunctionalChain) {
        return FunctionalChainReferenceHierarchyHelper.computeHierarchy(view, endFunctionalChain);
    }

    public FunctionalChain computeContainerFunctionalChain(EdgeTarget sourceView, EdgeTarget targetView) {
        return FunctionalChainReferenceHierarchyHelper.computeContainerFunctionalChain(sourceView, targetView);
    }

    public boolean isValidFCIFunctionalChain(DSemanticDecorator context) {
        return true;
    }

    public boolean isValidFCInvolveFunction(DSemanticDecorator context) {
        return true;
    }

    public boolean isValidFCIFunctionalExchangeAndFunction(FunctionalChainInvolvement involvement) {
        return involvement instanceof FunctionalChainInvolvementFunction;
    }

    public Collection<EObject> computeFCILinkScope(FunctionalChainInvolvement sourceInvolvement, FunctionalChainInvolvement targetInvolvement) {
        return new ArrayList<EObject>(FunctionalChainExt.getFlatCommonFunctionalExchanges((FunctionalChainInvolvement)sourceInvolvement, (FunctionalChainInvolvement)targetInvolvement));
    }

    public Collection<FunctionalChain> computeFCIFunctionalChainScope(DSemanticDecorator diagram) {
        EObject sourceChain = diagram.getTarget();
        if (!(sourceChain instanceof FunctionalChain)) {
            return Collections.emptyList();
        }
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)sourceChain);
        if (architecture == null) {
            return Collections.emptyList();
        }
        List possibleChains = FunctionalChainExt.getAllFunctionalChains((BlockArchitecture)architecture);
        ArrayList<FunctionalChain> scope = new ArrayList<FunctionalChain>();
        for (FunctionalChain possibleChain : possibleChains) {
            Set childrenChains;
            if (possibleChain.equals(sourceChain) || (childrenChains = FunctionalChainExt.getFlatInvolvementsOf((FunctionalChain)possibleChain, (EClass)FaPackage.Literals.FUNCTIONAL_CHAIN).stream().map(Involvement::getInvolved).collect(Collectors.toSet())).contains(sourceChain)) continue;
            scope.add(possibleChain);
        }
        return scope;
    }

    public boolean doesConnectionExist(EdgeTarget currentNode, EdgeTarget goalNode, Set<EdgeTarget> visitedNodes) {
        if (visitedNodes.contains(currentNode)) {
            return false;
        }
        if (currentNode.equals(goalNode)) {
            return true;
        }
        visitedNodes.add(currentNode);
        for (DEdge edge : currentNode.getOutgoingEdges()) {
            EdgeTarget nextNode;
            EObject edgeTarget = edge.getTarget();
            if (!(edgeTarget instanceof FunctionalChainInvolvementLink) || !this.doesConnectionExist(nextNode = edge.getTargetNode(), goalNode, visitedNodes)) continue;
            return true;
        }
        return false;
    }

    public MappingWithInterpreterHelper getMappingHelper(DSemanticDecorator semanticDecorator) {
        return new MappingWithInterpreterHelper(SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semanticDecorator.getTarget()));
    }

    public DNodeContainer getFCContainerOfFCRContainer(DDiagramElement fcRefContainer) {
        if (fcRefContainer != null) {
            return fcRefContainer.eContents().stream().filter(DNodeContainer.class::isInstance).map(DNodeContainer.class::cast).findFirst().orElse(null);
        }
        return null;
    }

    public String getFunctionalChainReferenceLabel(DNodeContainer fcrContainer) {
        StringBuilder labelBuilder = new StringBuilder();
        if (fcrContainer != null) {
            DNodeContainer fcContainer;
            InvolvedElement fc;
            FunctionalChainReference fcr = (FunctionalChainReference)fcrContainer.getTarget();
            InvolvedElement involvedElement = fc = fcr != null ? fcr.getInvolved() : null;
            if (fc != null) {
                labelBuilder.append(fc.getLabel());
            }
            if (this.isContainerCollapsed(fcContainer = this.getFCContainerOfFCRContainer((DDiagramElement)fcrContainer))) {
                labelBuilder.append(FCR_CONTAINER_COLLAPSED_INDICATOR);
            }
        }
        return labelBuilder.toString();
    }

    public boolean isContainerCollapsed(DNodeContainer container) {
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)container);
        if (gmfNode != null) {
            for (Object subNode : gmfNode.getChildren()) {
                if (!(subNode instanceof Node)) continue;
                for (Object style : ((Node)subNode).getStyles()) {
                    if (!(style instanceof DrawerStyle)) continue;
                    return ((DrawerStyle)style).isCollapsed();
                }
            }
        }
        return false;
    }

    public boolean isInCollapsedHierarchy(DDiagramElement diagramElement) {
        if (diagramElement != null) {
            boolean containerCollapsed;
            EObject parent = diagramElement.eContainer();
            if (parent instanceof DNodeContainer && (containerCollapsed = this.isContainerCollapsed((DNodeContainer)parent))) {
                return true;
            }
            if (parent instanceof DDiagram) {
                return false;
            }
            return this.isInCollapsedHierarchy((DDiagramElement)parent);
        }
        return false;
    }

    public boolean canCreateFCILEdge(ReferenceHierarchyContext link, DDiagramElement sourceView, EObject source, DDiagramElement targetView, EObject target) {
        DNodeContainer fcContainer;
        if (source == null || target == null) {
            return false;
        }
        if (sourceView == null || targetView == null) {
            return false;
        }
        if (source.equals(target)) {
            return false;
        }
        if (sourceView.equals(targetView)) {
            return false;
        }
        if (sourceView instanceof DNodeContainer && source instanceof FunctionalChainReference && !this.isContainerCollapsed(fcContainer = this.getFCContainerOfFCRContainer(sourceView))) {
            return false;
        }
        if (targetView instanceof DNodeContainer && target instanceof FunctionalChainReference && !this.isContainerCollapsed(fcContainer = this.getFCContainerOfFCRContainer(targetView))) {
            return false;
        }
        return this.checkRefHierarchyOfLink(link, sourceView, targetView);
    }

    public boolean canCreateLinksEdge(DEdge sourceEdge, DEdge targetEdge) {
        List<FunctionalChainReference> sourceNode2Hierarchy;
        EdgeTarget sourceNode1 = sourceEdge.getSourceNode();
        EdgeTarget sourceNode2 = targetEdge.getSourceNode();
        List<FunctionalChainReference> sourceNode1Hierarchy = FunctionalChainReferenceHierarchyHelper.computeHierarchy(sourceNode1);
        if (!sourceNode1Hierarchy.equals(sourceNode2Hierarchy = FunctionalChainReferenceHierarchyHelper.computeHierarchy(sourceNode2))) {
            return false;
        }
        EdgeTarget targetNode1 = sourceEdge.getTargetNode();
        EdgeTarget targetNode2 = targetEdge.getTargetNode();
        List<FunctionalChainReference> targetNode1Hierarchy = FunctionalChainReferenceHierarchyHelper.computeHierarchy(targetNode1);
        List<FunctionalChainReference> targetNode2Hierarchy = FunctionalChainReferenceHierarchyHelper.computeHierarchy(targetNode2);
        return targetNode1Hierarchy.equals(targetNode2Hierarchy);
    }

    public List<ReferenceHierarchyContext> getLinksEdgeTargets(ReferenceHierarchyContext source) {
        if (source instanceof SequenceLink) {
            SequenceLink sequenceLink = (SequenceLink)source;
            return new ArrayList<ReferenceHierarchyContext>((Collection<ReferenceHierarchyContext>)sequenceLink.getLinks());
        }
        return Collections.emptyList();
    }

    public boolean checkRefHierarchyOfLink(ReferenceHierarchyContext link, DDiagramElement sourceView, DDiagramElement targetView) {
        EObject parentTargetHierarchyContainer;
        EObject topSourceHierarchyContainer = FunctionalChainReferenceHierarchyHelper.getDiagramElementForTopHierarchy((List<FunctionalChainReference>)link.getSourceReferenceHierarchy(), sourceView);
        if (topSourceHierarchyContainer == null) {
            return false;
        }
        EObject topTargetHierarchyContainer = FunctionalChainReferenceHierarchyHelper.getDiagramElementForTopHierarchy((List<FunctionalChainReference>)link.getTargetReferenceHierarchy(), targetView);
        if (topTargetHierarchyContainer == null) {
            return false;
        }
        EObject parentSourceHierarchyContainer = topSourceHierarchyContainer.eContainer();
        return parentSourceHierarchyContainer == (parentTargetHierarchyContainer = topTargetHierarchyContainer.eContainer());
    }

    public String getControlNodeLabel(ControlNode controlNode) {
        return controlNode.getKind() == ControlNodeKind.ITERATE ? IT : controlNode.getKind().getLiteral();
    }

    public String getSequenceLinkLabel(SequenceLink sequenceLink, DDiagram diagram) {
        Set filterNames;
        boolean mergeFESL;
        String label = "";
        if (sequenceLink.getCondition() != null) {
            String constraint = CapellaServices.getService().getConstraintLabel(sequenceLink.getCondition());
            String string = label = constraint.isEmpty() ? "" : "[" + constraint + "]";
        }
        if (mergeFESL = (filterNames = diagram.getActivatedFilters().stream().map(IdentifiedElement::getName).collect(Collectors.toSet())).contains("merge.associated.functional.exchange.involvements.and.sequence.links.without.control.node.filter")) {
            String labelFe = sequenceLink.getLinks().stream().filter(x -> x.getInvolved() instanceof FunctionalExchange).map(x -> ((FunctionalExchange)x.getInvolved()).getName()).collect(Collectors.joining(", "));
            label = labelFe.isEmpty() ? label : String.valueOf(label) + " " + labelFe;
        }
        return label;
    }

    public Collection<SequenceLink> getAllSequenceLinks(FunctionalChain chain) {
        HashSet<SequenceLink> result = new HashSet<SequenceLink>();
        this.getAllSequenceLinks(chain, result);
        return result;
    }

    private void getAllSequenceLinks(FunctionalChain chain, Collection<SequenceLink> linksAcumulator) {
        if (chain != null) {
            linksAcumulator.addAll((Collection<SequenceLink>)chain.getOwnedSequenceLinks());
            for (FunctionalChainInvolvement involvement : chain.getOwnedFunctionalChainInvolvements()) {
                if (!(involvement instanceof FunctionalChainReference)) continue;
                FunctionalChain referencedChain = ((FunctionalChainReference)involvement).getReferencedFunctionalChain();
                this.getAllSequenceLinks(referencedChain, linksAcumulator);
            }
        }
    }

    public boolean isValidSequenceLink(SequenceLinkEnd source, SequenceLinkEnd target) {
        FunctionalChainInvolvement targetInvolvement;
        FunctionalChainInvolvement sourceInvolvement;
        if (source == target) {
            return false;
        }
        if (source instanceof FunctionalChainInvolvement && target instanceof FunctionalChainInvolvement && this.isSameFunctionInvolved(sourceInvolvement = (FunctionalChainInvolvement)source, targetInvolvement = (FunctionalChainInvolvement)target)) {
            return false;
        }
        return !this.doesConnectionExistBetweenSequenceLinkEnds(target, source, new HashSet<SequenceLinkEnd>());
    }

    public boolean isValidLinks(ReferenceHierarchyContext source, ReferenceHierarchyContext target) {
        return this.isValidAssociation(source, target) || this.isValidAssociation(target, source);
    }

    private boolean isValidAssociation(ReferenceHierarchyContext first, ReferenceHierarchyContext second) {
        SequenceLink seqLink;
        FunctionalChainInvolvementLink link;
        if (first instanceof SequenceLink && second instanceof FunctionalChainInvolvementLink && (link = (FunctionalChainInvolvementLink)second).getInvolved() instanceof FunctionalExchange && !(seqLink = (SequenceLink)first).getLinks().contains((Object)second)) {
            Set slClosestFCIFSources = SequenceLinkExt.findClosestSemanticFCIFunctionsAsSources((SequenceLink)seqLink);
            Set slClosestFCIFTargets = SequenceLinkExt.findClosestSemanticFCIFunctionsAsTargets((SequenceLink)seqLink);
            return slClosestFCIFSources.contains(link.getSource()) && slClosestFCIFTargets.contains(link.getTarget());
        }
        return false;
    }

    public boolean doesConnectionExistBetweenSequenceLinkEnds(SequenceLinkEnd currentSequenceLinkEnd, SequenceLinkEnd goalSequenceLinkEnd, Set<SequenceLinkEnd> visitedSequenceLinkEnds) {
        if (visitedSequenceLinkEnds.contains(currentSequenceLinkEnd)) {
            return false;
        }
        if (currentSequenceLinkEnd.equals(goalSequenceLinkEnd)) {
            return true;
        }
        if (currentSequenceLinkEnd instanceof ControlNode && ((ControlNode)currentSequenceLinkEnd).getKind() == ControlNodeKind.ITERATE) {
            return false;
        }
        HashSet<SequenceLinkEnd> visitedSequenceLinkEndsCopy = new HashSet<SequenceLinkEnd>(visitedSequenceLinkEnds);
        visitedSequenceLinkEndsCopy.add(currentSequenceLinkEnd);
        for (SequenceLink nextSequenceLink : SequenceLinkEndExt.getOutgoingSequenceLinks((SequenceLinkEnd)currentSequenceLinkEnd)) {
            if (!this.doesConnectionExistBetweenSequenceLinkEnds(nextSequenceLink.getTarget(), goalSequenceLinkEnd, visitedSequenceLinkEndsCopy)) continue;
            return true;
        }
        return false;
    }

    private void findFlatClosestFCIFunctionViewsAsTarget(DEdge seqLinkEdge, List<DNode> closestFCIFunctionViews, boolean ignoreFunctionsInCollapseHierarchy) {
        EdgeTarget targetNode = seqLinkEdge.getTargetNode();
        if (targetNode instanceof DNode && ((DNode)targetNode).getTarget() instanceof FunctionalChainInvolvementFunction) {
            if (!ignoreFunctionsInCollapseHierarchy || !this.isInCollapsedHierarchy((DDiagramElement)targetNode)) {
                closestFCIFunctionViews.add((DNode)targetNode);
            }
        } else {
            targetNode.getOutgoingEdges().stream().filter(e -> e.getTarget() instanceof SequenceLink).forEach(s -> this.findFlatClosestFCIFunctionViewsAsTarget((DEdge)s, closestFCIFunctionViews, ignoreFunctionsInCollapseHierarchy));
        }
    }

    public List<DNode> findFlatClosestFCIFunctionViewsAsTarget(DEdge seqLinkEdge, boolean ignoreFunctionsInCollapseHierarchy) {
        ArrayList<DNode> closestFCIFunctionViews = new ArrayList<DNode>();
        this.findFlatClosestFCIFunctionViewsAsTarget(seqLinkEdge, closestFCIFunctionViews, ignoreFunctionsInCollapseHierarchy);
        return closestFCIFunctionViews;
    }

    private void findFlatClosestFCIFunctionViewsAsSource(DEdge seqLinkEdge, List<DNode> closestFCIFunctionViews, boolean ignoreFunctionsInCollapseHierarchy) {
        EdgeTarget sourceNode = seqLinkEdge.getSourceNode();
        if (sourceNode instanceof DNode && ((DNode)sourceNode).getTarget() instanceof FunctionalChainInvolvementFunction) {
            if (!ignoreFunctionsInCollapseHierarchy || !this.isInCollapsedHierarchy((DDiagramElement)sourceNode)) {
                closestFCIFunctionViews.add((DNode)sourceNode);
            }
        } else {
            sourceNode.getIncomingEdges().stream().filter(e -> e.getTarget() instanceof SequenceLink).forEach(s -> this.findFlatClosestFCIFunctionViewsAsSource((DEdge)s, closestFCIFunctionViews, ignoreFunctionsInCollapseHierarchy));
        }
    }

    public List<DNode> findFlatClosestFCIFunctionViewsAsSource(DEdge seqLinkEdge, boolean ignoreFunctionsInCollapseHierarchy) {
        ArrayList<DNode> firstLevelViews = new ArrayList<DNode>();
        this.findFlatClosestFCIFunctionViewsAsSource(seqLinkEdge, firstLevelViews, ignoreFunctionsInCollapseHierarchy);
        return firstLevelViews;
    }

    private void findFirstLevelFCIFOrFCRViewsAsSource(DEdge edge, Set<DSemanticDecorator> firstLevelViews) {
        EdgeTarget edgeTarget = edge.getSourceNode();
        if (edgeTarget instanceof DSemanticDecorator) {
            DSemanticDecorator decorator = (DSemanticDecorator)edgeTarget;
            EObject target = decorator.getTarget();
            if (target instanceof FunctionalChainInvolvementFunction || target instanceof FunctionalChainReference) {
                firstLevelViews.add(decorator);
            } else {
                edgeTarget.getIncomingEdges().stream().forEach(incomingEdge -> this.findFirstLevelFCIFOrFCRViewsAsSource((DEdge)incomingEdge, firstLevelViews));
            }
        }
    }

    public Set<DSemanticDecorator> findFirstLevelFCIFOrFCRViewsAsSource(DEdge edge) {
        HashSet<DSemanticDecorator> firstLevelViews = new HashSet<DSemanticDecorator>();
        this.findFirstLevelFCIFOrFCRViewsAsSource(edge, firstLevelViews);
        return firstLevelViews;
    }

    private void findFirstLevelFCIFOrFCRViewsAsTarget(DEdge edge, Set<DSemanticDecorator> firstLevelViews) {
        EdgeTarget edgeTarget = edge.getTargetNode();
        if (edgeTarget instanceof DSemanticDecorator) {
            DSemanticDecorator decorator = (DSemanticDecorator)edgeTarget;
            EObject target = decorator.getTarget();
            if (target instanceof FunctionalChainInvolvementFunction || target instanceof FunctionalChainReference) {
                firstLevelViews.add(decorator);
            } else {
                edgeTarget.getOutgoingEdges().stream().forEach(outgoingEdge -> this.findFirstLevelFCIFOrFCRViewsAsTarget((DEdge)outgoingEdge, firstLevelViews));
            }
        }
    }

    public Set<DSemanticDecorator> findFirstLevelFCIFOrFCRViewsAsTarget(DEdge edge) {
        HashSet<DSemanticDecorator> closestFCIFunctionViews = new HashSet<DSemanticDecorator>();
        this.findFirstLevelFCIFOrFCRViewsAsTarget(edge, closestFCIFunctionViews);
        return closestFCIFunctionViews;
    }

    public Set<AbstractFunction> getFunctionsFromFCIFDNodes(List<DNode> fcifNodes) {
        return fcifNodes.stream().map(DSemanticDecorator::getTarget).map(FunctionalChainInvolvementFunction.class::cast).map(Involvement::getInvolved).map(AbstractFunction.class::cast).collect(Collectors.toSet());
    }

    public List<DNode> getFCIFViewsInvolvingFunction(List<DNode> fcifViews, AbstractFunction function) {
        return fcifViews.stream().filter(s -> ((FunctionalChainInvolvementFunction)s.getTarget()).getInvolved().equals(function)).collect(Collectors.toList());
    }

    public EObject accelerateOnSequenceLinkEdge(DEdge seqLinkEdge) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String messageDialogTitle = "Accelerator Information";
        List<DNode> availableSourceFCIFViews = this.findFlatClosestFCIFunctionViewsAsSource(seqLinkEdge, true);
        if (availableSourceFCIFViews.isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)messageDialogTitle, (String)"There is not any Functional Chain Involvement Function as source for the selected sequence link or they are all in collapsed container.");
            return null;
        }
        List<DNode> availableTargetFCIFViews = this.findFlatClosestFCIFunctionViewsAsTarget(seqLinkEdge, true);
        if (availableTargetFCIFViews.isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)messageDialogTitle, (String)"There is not any Functional Chain Involvement Function as target for the selected sequence link or they are all in collapsed container.");
            return null;
        }
        Set<AbstractFunction> availableSourceFunctions = this.getFunctionsFromFCIFDNodes(availableSourceFCIFViews);
        Set<AbstractFunction> availableTargetFunctions = this.getFunctionsFromFCIFDNodes(availableTargetFCIFViews);
        HashSet<FunctionalExchange> availableFEs = new HashSet<FunctionalExchange>();
        for (AbstractFunction sourceFunction : availableSourceFunctions) {
            for (AbstractFunction targetFunction : availableTargetFunctions) {
                List commonEdges = FunctionExt.getOutGoingExchange((AbstractFunction)sourceFunction);
                commonEdges.retainAll(FunctionExt.getIncomingExchange((AbstractFunction)targetFunction));
                availableFEs.addAll(commonEdges);
            }
        }
        SelectOrCreateFunctionalExchangeDialog dialog = new SelectOrCreateFunctionalExchangeDialog(shell, availableFEs, availableSourceFunctions, availableTargetFunctions);
        int returnCode = dialog.open();
        SelectOrCreateFunctionalExchangeDialog.NewFEData newFEData = null;
        AbstractFunction feSource = null;
        AbstractFunction feTarget = null;
        FunctionalExchange involvedFE = null;
        if (returnCode == 5) {
            newFEData = dialog.getCreation();
            feSource = newFEData.getSource();
            feTarget = newFEData.getTarget();
        }
        if (returnCode == 10) {
            involvedFE = dialog.getSelection().stream().findFirst().orElse(null);
            feSource = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)involvedFE);
            feTarget = FunctionalExchangeExt.getTargetFunction((FunctionalExchange)involvedFE);
        }
        List<DNode> possibleSourceFCIFNodes = this.getFCIFViewsInvolvingFunction(availableSourceFCIFViews, feSource);
        List<DNode> possibleTargetFCIFNodes = this.getFCIFViewsInvolvingFunction(availableTargetFCIFViews, feTarget);
        int sourceSize = possibleSourceFCIFNodes.size();
        int targetSize = possibleTargetFCIFNodes.size();
        if (sourceSize > 1 || targetSize > 1) {
            MessageDialog.openInformation((Shell)shell, (String)messageDialogTitle, (String)"Impossible to create Functional Chain Involvement Link due to ambiguity of source and target");
        }
        if (sourceSize == 1 && targetSize == 1) {
            if (newFEData != null) {
                involvedFE = FunctionalExchangeExt.createFunctionalExchange((ActivityNode)feSource, (ActivityNode)feTarget);
                involvedFE.setName(newFEData.getName());
                ((AbstractFunction)feSource.eContainer()).getOwnedFunctionalExchanges().add((Object)involvedFE);
            }
            DNode sourceFCIFNode = possibleSourceFCIFNodes.get(0);
            DNode targetFCIFNode = possibleTargetFCIFNodes.get(0);
            this.createFCILink(sourceFCIFNode, targetFCIFNode, involvedFE, seqLinkEdge);
        }
        return seqLinkEdge;
    }

    public EObject accelerateOnFCILEdge(FunctionalChainInvolvementLink link) {
        if (link != null) {
            FunctionalChainExt.createSequenceLink((FunctionalChainInvolvementLink)link);
        }
        return link;
    }

    public FunctionalChainInvolvementLink createFCILink(DNode sourceFCIF, DNode targetFCIF, FunctionalExchange functionalExchange, DEdge sequenceLinkEdge) {
        SequenceLink sequenceLink = (SequenceLink)sequenceLinkEdge.getTarget();
        FunctionalChain commonFC = this.computeContainerFunctionalChain((EdgeTarget)sourceFCIF, (EdgeTarget)targetFCIF);
        FunctionalChainInvolvementLink newFCIL = FunctionalChainExt.createInvolvementLink((FunctionalChain)commonFC, (InvolvedElement)functionalExchange);
        newFCIL.setSource((FunctionalChainInvolvementFunction)sourceFCIF.getTarget());
        newFCIL.setTarget((FunctionalChainInvolvementFunction)targetFCIF.getTarget());
        newFCIL.getSourceReferenceHierarchy().addAll(this.computeFCReferenceHierarchy((EdgeTarget)sourceFCIF, commonFC));
        newFCIL.getTargetReferenceHierarchy().addAll(this.computeFCReferenceHierarchy((EdgeTarget)targetFCIF, commonFC));
        sequenceLink.getLinks().add((Object)newFCIL);
        return newFCIL;
    }

    public boolean checkDeleteConditionFCD(EObject element) {
        return !(element instanceof FunctionalChain);
    }

    public boolean controlNodeLinkedToCollapsedFCR(DNode controlNode) {
        EList incomingSequenceLinks = controlNode.getIncomingEdges();
        EList outgoingSequenceLinks = controlNode.getOutgoingEdges();
        for (DEdge outgoingSeqLink : outgoingSequenceLinks) {
            EdgeTarget targetNode = outgoingSeqLink.getTargetNode();
            if (!(targetNode instanceof DNodeContainer) || !(((DNodeContainer)targetNode).getTarget() instanceof FunctionalChainReference)) continue;
            return true;
        }
        for (DEdge incomingSeqLink : incomingSequenceLinks) {
            EdgeTarget sourceNode = incomingSeqLink.getSourceNode();
            if (!(sourceNode instanceof DNodeContainer) || !(((DNodeContainer)sourceNode).getTarget() instanceof FunctionalChainReference)) continue;
            return true;
        }
        return false;
    }

    public boolean isFEWithAssociatedSL(DEdge edge) {
        if (edge.getTarget() instanceof FunctionalChainInvolvementLink) {
            FunctionalChainInvolvementLink fcil = (FunctionalChainInvolvementLink)edge.getTarget();
            List listSL = EObjectExt.getReferencers((EObject)fcil, (EReference)FaPackage.Literals.SEQUENCE_LINK__LINKS);
            for (SequenceLink sl : listSL) {
                if (fcil.getSource() != sl.getSource() || fcil.getTarget() != sl.getTarget()) continue;
                return true;
            }
        }
        return false;
    }
}

