/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.activator;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.refresh.RepresentationTimeStampInformationSupplier;
import org.eclipse.sirius.business.api.refresh.RepresentationTimeStampInformationSupplierRegistry;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.ui.RefreshHelper;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.polarsys.capella.core.sirius.analysis.activator.CapellaMessages;
import org.polarsys.capella.core.sirius.analysis.helpers.DDiagramHelper;
import org.polarsys.capella.core.sirius.analysis.preferences.DiagramProcessChainPathPreferenceInitializer;
import org.polarsys.capella.core.sirius.analysis.preferences.TitleBlockPreferencesInitializer;
import org.polarsys.capella.core.sirius.analysis.titleblock.TitleBlockRepresentationTimeStampInfoProvider;
import org.polarsys.capella.core.sirius.analysis.tool.ActivityEditorUpdater;

public class SiriusViewActivator
extends AbstractUIPlugin {
    public static final String ID = "org.polarsys.capella.core.sirius.analysis";
    private static SiriusViewActivator instance;
    private Set<Viewpoint> viewpoints;
    private Predicate<Notification> considerCollapseStateForAutomaticRefreshPredicate;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.viewpoints = new HashSet<Viewpoint>();
        this.viewpoints.addAll(ViewpointRegistry.getInstance().registerFromPlugin("/org.polarsys.capella.core.sirius.analysis/description/common.odesign"));
        this.viewpoints.addAll(ViewpointRegistry.getInstance().registerFromPlugin("/org.polarsys.capella.core.sirius.analysis/description/oa.odesign"));
        this.viewpoints.addAll(ViewpointRegistry.getInstance().registerFromPlugin("/org.polarsys.capella.core.sirius.analysis/description/context.odesign"));
        this.viewpoints.addAll(ViewpointRegistry.getInstance().registerFromPlugin("/org.polarsys.capella.core.sirius.analysis/description/logical.odesign"));
        this.viewpoints.addAll(ViewpointRegistry.getInstance().registerFromPlugin("/org.polarsys.capella.core.sirius.analysis/description/physical.odesign"));
        this.viewpoints.addAll(ViewpointRegistry.getInstance().registerFromPlugin("/org.polarsys.capella.core.sirius.analysis/description/EPBS.odesign"));
        Messages.ArrangeBorderNodesAction_actionText = CapellaMessages.ArrangeBorderNodesAction_actionText;
        Messages.ArrangeBorderNodesAction_commandLabel = CapellaMessages.ArrangeBorderNodesAction_commandLabel;
        Messages.ArrangeBorderNodesAction_toolbarActionText = CapellaMessages.ArrangeBorderNodesAction_toolbarActionText;
        new DiagramProcessChainPathPreferenceInitializer();
        new TitleBlockPreferencesInitializer();
        this.considerCollapseStateForAutomaticRefreshPredicate = notification -> {
            Option optionalDDiagram;
            if (notification != null && NotationPackage.eINSTANCE.getDrawerStyle_Collapsed().equals(notification.getFeature()) && notification.getNotifier() instanceof EObject && (optionalDDiagram = new EObjectQuery((EObject)notification.getNotifier()).getParentDiagram()).some()) {
                DDiagram diagram = (DDiagram)optionalDDiagram.get();
                return DDiagramHelper.isFCD(diagram) || DDiagramHelper.isOPD(diagram);
            }
            return false;
        };
        RefreshHelper.registerImpactingNotification(this.considerCollapseStateForAutomaticRefreshPredicate);
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().addActivityManagerListener((IActivityManagerListener)new ActivityEditorUpdater());
        RepresentationTimeStampInformationSupplierRegistry.INSTANCE.add((RepresentationTimeStampInformationSupplier)new TitleBlockRepresentationTimeStampInfoProvider());
    }

    public void stop(BundleContext context) throws Exception {
        if (this.viewpoints != null) {
            for (Viewpoint viewpoint : this.viewpoints) {
                ViewpointRegistry.getInstance().disposeFromPlugin(viewpoint);
            }
            this.viewpoints.clear();
        }
        if (this.considerCollapseStateForAutomaticRefreshPredicate != null) {
            RefreshHelper.unregisterImpactingNotification(this.considerCollapseStateForAutomaticRefreshPredicate);
            this.considerCollapseStateForAutomaticRefreshPredicate = null;
        }
    }

    public static SiriusViewActivator getInstance() {
        return instance;
    }
}

