/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.properties;

import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.flexibility.properties.property.AbstractProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IEditableProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.libraries.properties.LibraryManagerModel;

public class ReferencesProperty
extends AbstractProperty
implements IEditableProperty {
    LibraryManagerModel model = null;

    public Object getValue(IPropertyContext context_p) {
        if (this.model == null) {
            this.model = (LibraryManagerModel)context_p.getSource();
        }
        return this.model;
    }

    public IStatus validate(Object newValue_p, IPropertyContext context_p) {
        if (!this.model.getUnsavedModels().isEmpty()) {
            String unsavedTxt = this.model.getUnsavedModels().stream().map(m -> m.getIdentifier().getName()).collect(Collectors.joining(", "));
            return new Status(4, "org.polarsys.capella.core.libraries", NLS.bind((String)"There is other unsaved session(s) ({0}), this may lead to inconsistencies,\n You should save others sessions before manage references.", (Object)unsavedTxt));
        }
        boolean unsavedModel = this.model.isUnsavedRootModel();
        if (unsavedModel) {
            return new Status(2, "org.polarsys.capella.core.libraries", "The session is unsaved. Manage references will save the session.");
        }
        if (!this.model.getUnresolvableReferencedLibraries().isEmpty()) {
            String unresolvableLibs = this.model.getUnresolvableReferencedLibraries().stream().map(m -> m.getIdentifier().getName()).collect(Collectors.joining(", "));
            return new Status(4, "org.polarsys.capella.core.libraries", NLS.bind((String)"The following libraries are not properly referenced: ({0}). This may lead to inconsistencies.\n You should uncheck these dependencies, click OK and reference them again using the same wizard.", (Object)unresolvableLibs));
        }
        if (!this.model.getCycles().isEmpty()) {
            Collection<IModel> cycle = this.model.getCycles().iterator().next();
            String cycleLibTxt = cycle.stream().map(m -> m.getIdentifier().getName()).collect(Collectors.joining(" "));
            return new Status(4, "org.polarsys.capella.core.libraries", String.valueOf(this.model.getCycles().size()) + " cycles found. First one is [" + cycleLibTxt + "]");
        }
        return Status.OK_STATUS;
    }

    public Object getType() {
        return Object.class;
    }

    public Object toType(Object value_p, IPropertyContext context_p) {
        return value_p;
    }

    public void setValue(IPropertyContext context_p) {
        IModel.Edit rootModel = this.model.getRootModel();
        Collection<IModel> newReferencedLibraries = this.model.getReferencedLibrariesByRootModel();
        Collection<IModel> initialReferencedLibraries = this.model.getInitialReferencedLibrariesByRootModel();
        for (IModel library : newReferencedLibraries) {
            if (initialReferencedLibraries.contains(library)) continue;
            rootModel.addReference(library);
        }
        for (IModel library : initialReferencedLibraries) {
            if (newReferencedLibraries.contains(library)) continue;
            rootModel.removeReference(library);
        }
    }
}

