/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkCategory;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.ComponentPortAllocation;
import org.polarsys.capella.core.model.helpers.PhysicalLinkExt;

public class PhysicalLinkCategoryExt {
    public static Collection<PhysicalLink> getCoveredPhysicalLinks(PhysicalLinkCategory category) {
        HashSet<PhysicalLink> coveredLinks = new HashSet<PhysicalLink>();
        coveredLinks.addAll((Collection<PhysicalLink>)category.getLinks());
        for (PhysicalLink link : category.getLinks()) {
            coveredLinks.addAll(PhysicalLinkExt.getDelegatedPhysicalLinks(link));
        }
        return coveredLinks;
    }

    public static Collection<ComponentPortAllocation> getCoveredComponentPortAllocations(PhysicalLinkCategory category) {
        HashSet<ComponentPortAllocation> cpa = new HashSet<ComponentPortAllocation>();
        EList links = category.getLinks();
        for (PhysicalLink pl : links) {
            PhysicalPort sourcePhysicalPort = pl.getSourcePhysicalPort();
            cpa.addAll((Collection<ComponentPortAllocation>)sourcePhysicalPort.getOwnedComponentPortAllocations());
            PhysicalPort targetPhysicalPort = pl.getTargetPhysicalPort();
            cpa.addAll((Collection<ComponentPortAllocation>)targetPhysicalPort.getOwnedComponentPortAllocations());
        }
        return cpa;
    }
}

