/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.association;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.information.AggregationKind;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.model.helpers.PropertyExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class AssociationTargetClassPropertyIsKey
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Property) {
            Property prop = (Property)eObj;
            Association association = PropertyExt.getRegardingAssociation((CapellaElement)prop);
            if (association == null) {
                return ctx.createSuccessStatus();
            }
            if (prop.getAggregationKind() != AggregationKind.ASSOCIATION || !association.getNavigableMembers().contains((Object)prop)) {
                return ctx.createSuccessStatus();
            }
            AbstractType abstractType = prop.getAbstractType();
            if (abstractType instanceof Class) {
                ArrayList<Class> allSuperGenEles = new ArrayList<Class>(0);
                Class cls = (Class)abstractType;
                allSuperGenEles.add(cls);
                allSuperGenEles.addAll(GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)cls));
                for (GeneralizableElement generalizableElement : allSuperGenEles) {
                    if (!(generalizableElement instanceof Classifier)) continue;
                    Classifier classifier = (Classifier)generalizableElement;
                    EList ownedFeatures = classifier.getOwnedFeatures();
                    for (Feature feature : ownedFeatures) {
                        Property pro;
                        if (!(feature instanceof Property) || !(pro = (Property)feature).isIsPartOfKey()) continue;
                        return ctx.createSuccessStatus();
                    }
                }
                return ctx.createFailureStatus(new Object[]{prop.getName()});
            }
        }
        return ctx.createSuccessStatus();
    }
}

