/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.semantic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.model.semantic.SimplifiedCapellaMetadata;

public class FilteredSimplifiedCapellaMetaData
implements SimplifiedCapellaMetadata {
    public static final String NAME_PACKAGE_FILTER_ELEMENT = "packageFilter";
    public static final String ATTRIBUTE_NS_URI = "nsURI";
    public static final String EXTENSION_SEMANTIC_METADATA = "semanticMetadata";
    private Collection<String> packageFilters;
    private Set<EPackage> unfilteredEPackages;
    private final SimplifiedCapellaMetadata delegate;

    public FilteredSimplifiedCapellaMetaData(SimplifiedCapellaMetadata delegate) {
        this.delegate = delegate;
        this.reloadFilteredPackagesFromRegistry();
    }

    @Override
    public boolean isNavigable(EStructuralFeature feature) {
        return this.isFiltered(feature.getEContainingClass().getEPackage()) ? false : this.delegate.isNavigable(feature);
    }

    @Override
    public boolean isContainment(EReference eReference) {
        return this.delegate.isContainment(eReference);
    }

    @Override
    public EReference getContainment(EReference eReference) {
        return this.delegate.getContainment(eReference);
    }

    @Override
    public void setContainment(EReference eReference, EReference eContainmentReference) {
        this.delegate.setContainment(eReference, eContainmentReference);
    }

    @Override
    public boolean isSemantic(EClassifier eClassifier) {
        return this.isFiltered(eClassifier.getEPackage()) ? false : this.delegate.isSemantic(eClassifier);
    }

    @Override
    public boolean isSemantic(EStructuralFeature eStructuralFeature) {
        return this.isFiltered(((EClass)eStructuralFeature.eContainer()).getEPackage()) ? false : this.delegate.isSemantic(eStructuralFeature);
    }

    @Override
    public void setSemantic(EClassifier eClassifier, boolean semantic) {
        this.delegate.setSemantic(eClassifier, semantic);
    }

    @Override
    public void setNavigable(EStructuralFeature feature, boolean navigable) {
        this.delegate.setNavigable(feature, navigable);
    }

    @Override
    public String getSimplifiedNsPrefix(EPackage ePackage) {
        return this.delegate.getSimplifiedNsPrefix(ePackage);
    }

    @Override
    public String getSimplifiedNsURI(EPackage ePackage) {
        return this.delegate.getSimplifiedNsURI(ePackage);
    }

    @Override
    public String getSimplifiedName(ENamedElement eNamedElement) {
        return this.delegate.getSimplifiedName(eNamedElement);
    }

    @Override
    public boolean isProcessAnnotations(EPackage ePackage) {
        return this.delegate.isProcessAnnotations(ePackage);
    }

    @Override
    public void setProcessAnnotations(EPackage ePackage, boolean semantic) {
        this.delegate.setProcessAnnotations(ePackage, semantic);
    }

    @Override
    public boolean isExcludeFrom(EStructuralFeature feature, String processor) {
        return this.delegate.isExcludeFrom(feature, processor);
    }

    private boolean isFiltered(EPackage ePackage) {
        if (this.unfilteredEPackages.contains(ePackage)) {
            return false;
        }
        for (String packageFilter : this.packageFilters) {
            if (!ePackage.getNsURI().equals(packageFilter)) continue;
            return true;
        }
        this.unfilteredEPackages.add(ePackage);
        return false;
    }

    private void reloadFilteredPackagesFromRegistry() {
        this.packageFilters = new ArrayList<String>();
        this.unfilteredEPackages = Collections.synchronizedSet(new HashSet());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.capella.core.model.semantic", EXTENSION_SEMANTIC_METADATA);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String nsURI;
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (NAME_PACKAGE_FILTER_ELEMENT.equals(e.getName()) && (nsURI = e.getAttribute(ATTRIBUTE_NS_URI)) != null) {
                this.packageFilters.add(nsURI);
            }
            ++n2;
        }
    }
}

