/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.semantic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.polarsys.capella.common.data.activity.ActivityPackage;
import org.polarsys.capella.common.data.behavior.BehaviorPackage;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.libraries.LibrariesPackage;
import org.polarsys.capella.common.re.RePackage;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.requirement.RequirementPackage;
import org.polarsys.capella.core.data.sharedmodel.SharedmodelPackage;
import org.polarsys.capella.core.model.semantic.LogHelper;
import org.polarsys.capella.core.model.semantic.SimplifiedCapellaMetadata;

public class SemanticModelUtil {
    @Deprecated
    public static final String SEMANTIC = "http://www.polarsys.org/capella/semantic";
    @Deprecated
    public static final String KEY_CONTAINMENT = "feature";
    protected Logger logger;
    private static final SemanticModelUtil semanticInstance = new SemanticModelUtil(SimplifiedCapellaMetadata.INSTANCE, null);
    private final EcoreSwitch<Boolean> ecoreSwitch;
    private final Set<EModelElement> messageSent = new HashSet<EModelElement>();
    protected final SimplifiedCapellaMetadata metadata;

    @Deprecated
    public static SemanticModelUtil newSemanticInstance(Logger logger) {
        return SemanticModelUtil.create(SimplifiedCapellaMetadata.INSTANCE, logger);
    }

    public static SemanticModelUtil getInstance() {
        return semanticInstance;
    }

    @Deprecated
    public static SemanticModelUtil getSemantic() {
        return semanticInstance;
    }

    public static SemanticModelUtil create(SimplifiedCapellaMetadata metadata, Logger logger) {
        return new SemanticModelUtil(metadata, logger);
    }

    SemanticModelUtil(SimplifiedCapellaMetadata metadata, Logger logger) {
        this.ecoreSwitch = new EcoreSwitch<Boolean>(){

            public Boolean caseEStructuralFeature(EStructuralFeature feature) {
                return SemanticModelUtil.this.metadata.isNavigable(feature);
            }

            public Boolean caseEClassifier(EClassifier clazz) {
                return SemanticModelUtil.this.metadata.isSemantic(clazz);
            }

            public Boolean defaultCase(EObject e) {
                return Boolean.TRUE;
            }
        };
        this.logger = logger;
        this.metadata = metadata;
    }

    public final boolean isSemanticContainment(EReference reference) {
        return this.metadata.isContainment(reference);
    }

    public EStructuralFeature eContainingFeature(EObject element) throws NoContainmentException {
        EStructuralFeature containingFeature = element.eContainingFeature();
        if (containingFeature == null) {
            return null;
        }
        if (this.metadata.isNavigable(containingFeature)) {
            return containingFeature;
        }
        containingFeature = null;
        EObject container = element.eContainer();
        if (container != null) {
            EList allContainments = container.eClass().getEAllReferences();
            for (EReference candidate : allContainments) {
                if (!container.eIsSet((EStructuralFeature)candidate) || candidate.isContainment() || !this.metadata.isNavigable((EStructuralFeature)candidate) || !this.metadata.isContainment(candidate) || !candidate.getEReferenceType().isSuperTypeOf(element.eClass())) continue;
                if (candidate.isMany()) {
                    if (!((List)container.eGet((EStructuralFeature)candidate)).contains(element)) continue;
                    containingFeature = candidate;
                    break;
                }
                if (container.eGet((EStructuralFeature)candidate) != element) continue;
                containingFeature = candidate;
                break;
            }
            if (containingFeature == null) {
                throw new NoContainmentException();
            }
        }
        return containingFeature;
    }

    public List<EObject> eContents(EObject element) {
        LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
        for (EReference ref : element.eClass().getEAllReferences()) {
            if (this.metadata.isNavigable((EStructuralFeature)ref) && this.metadata.isContainment(ref)) {
                Object children = element.eGet((EStructuralFeature)ref);
                if (children == null) continue;
                if (ref.isMany()) {
                    for (EObject e : (List)children) {
                        if (this.metadata.isSemantic((EClassifier)e.eClass())) {
                            if (result.add(e)) continue;
                            this.logDuplicateContainment(element, e, ref);
                            continue;
                        }
                        this.logNonSemanticClass(e.eClass());
                    }
                    continue;
                }
                if (this.metadata.isSemantic((EClassifier)((EObject)children).eClass())) {
                    if (result.add((EObject)children)) continue;
                    this.logDuplicateContainment(element, (EObject)children, ref);
                    continue;
                }
                this.logNonSemanticClass(((EObject)children).eClass());
                continue;
            }
            if (!ref.isContainment() || this.logger == null || !this.logger.isDebugEnabled() || this.messageSent.contains(ref)) continue;
            this.messageSent.add((EModelElement)ref);
            this.logger.debug((Object)("[Semantic M2] Filtering non-navigable children: " + LogHelper.makeFeatureDescription((EStructuralFeature)ref)));
        }
        return new ArrayList<EObject>(result);
    }

    private void logNonSemanticClass(EClass eClass) {
        if (this.logger != null && this.logger.isDebugEnabled() && !this.messageSent.contains(eClass)) {
            this.logger.debug((Object)("[Semantic M2] Filtering instances of non-semantic class: " + eClass.getName()));
        }
    }

    public List<EReference> getEAllReferences(EClass clazz) {
        ArrayList<EReference> result = new ArrayList<EReference>();
        for (EReference ref : clazz.getEAllReferences()) {
            if (this.metadata.isNavigable((EStructuralFeature)ref)) {
                result.add(ref);
                continue;
            }
            if (this.logger == null || !this.logger.isDebugEnabled() || this.messageSent.contains(ref)) continue;
            this.messageSent.add((EModelElement)ref);
            this.logger.debug((Object)("[Semantic M2] Filtering non-navigable reference: " + LogHelper.makeFeatureDescription((EStructuralFeature)ref)));
        }
        return result;
    }

    public List<EAttribute> getEAllAttributes(EClass clazz) {
        ArrayList<EAttribute> result = new ArrayList<EAttribute>();
        for (EAttribute attrib : clazz.getEAllAttributes()) {
            if (this.metadata.isNavigable((EStructuralFeature)attrib)) {
                result.add(attrib);
                continue;
            }
            if (this.logger == null || !this.logger.isDebugEnabled() || this.messageSent.contains(attrib)) continue;
            this.messageSent.add((EModelElement)attrib);
            this.logger.debug((Object)("[Semantic M2] Filtering non-navigable attribute: " + LogHelper.makeFeatureDescription((EStructuralFeature)attrib)));
        }
        return result;
    }

    public List<EStructuralFeature> getEStructuralFeatures(EClass clazz) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        for (EStructuralFeature feature : clazz.getEStructuralFeatures()) {
            if (!this.metadata.isNavigable(feature)) continue;
            result.add(feature);
        }
        return result;
    }

    public boolean isVisible(EModelElement element) {
        return (Boolean)this.ecoreSwitch.doSwitch((EObject)element);
    }

    private void logDuplicateContainment(EObject parent, EObject child, EReference one) {
        if (this.logger != null) {
            this.logger.error((Object)("[Semantic M2] Containment error: " + child));
            this.logger.error((Object)("[Semantic M2] Containment error: " + child.eContainingFeature()));
            this.logger.error((Object)("[Semantic M2] Containment error: " + one));
        }
    }

    public List<EClass> getAllCapellaSemanticClasses() {
        ArrayList<EClass> capellaSemanticClasses = new ArrayList<EClass>();
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)CsPackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)CtxPackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)EpbsPackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)FaPackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)InformationPackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)InteractionPackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)LaPackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)CapellacommonPackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)CapellacorePackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)CapellamodellerPackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)OaPackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)PaPackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)RequirementPackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)SharedmodelPackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)ActivityPackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)BehaviorPackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)ModellingcorePackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)LibrariesPackage.eINSTANCE));
        capellaSemanticClasses.addAll(this.getSemanticClasses((EPackage)RePackage.eINSTANCE));
        return capellaSemanticClasses;
    }

    public List<EStructuralFeature> getAllCapellaSemanticStructuralFeatures() {
        ArrayList<EStructuralFeature> capellaSemanticStructuralFeatures = new ArrayList<EStructuralFeature>();
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)CsPackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)CtxPackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)EpbsPackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)FaPackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)InformationPackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)InteractionPackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)LaPackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)CapellacommonPackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)CapellacorePackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)CapellamodellerPackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)OaPackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)PaPackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)RequirementPackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)SharedmodelPackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)ActivityPackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)BehaviorPackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)ModellingcorePackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)LibrariesPackage.eINSTANCE));
        capellaSemanticStructuralFeatures.addAll(this.getSemanticStructuralFeatures((EPackage)RePackage.eINSTANCE));
        return capellaSemanticStructuralFeatures;
    }

    public List<EClass> getSemanticClasses(EPackage ePackage) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        EList classifiers = ePackage.getEClassifiers();
        for (EClassifier classifer : classifiers) {
            if (!(classifer instanceof EClass) || !this.metadata.isSemantic(classifer)) continue;
            result.add((EClass)classifer);
        }
        EList subPackages = ePackage.getESubpackages();
        for (EPackage subPkg : subPackages) {
            result.addAll(this.getSemanticClasses(subPkg));
        }
        return result;
    }

    public List<EStructuralFeature> getSemanticStructuralFeatures(EPackage ePackage) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        EList classifiers = ePackage.getEClassifiers();
        for (EClassifier classifer : classifiers) {
            if (!(classifer instanceof EClass)) continue;
            for (EStructuralFeature structuralFeature : ((EClass)classifer).getEStructuralFeatures()) {
                if (!this.metadata.isSemantic(structuralFeature)) continue;
                result.add(structuralFeature);
            }
        }
        EList subPackages = ePackage.getESubpackages();
        for (EPackage subPkg : subPackages) {
            result.addAll(this.getSemanticStructuralFeatures(subPkg));
        }
        return result;
    }

    public static class NoContainmentException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

