/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.linkedtext.ui;

import com.google.common.base.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ValueSpecification;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.linkedtext.ui.DefaultLinkedTextResolver;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextDocument;
import org.polarsys.capella.common.ui.providers.MDEAdapterFactoryLabelProvider;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.information.datavalue.AbstractExpressionValue;
import org.polarsys.capella.core.data.information.datavalue.OpaqueExpression;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;

public abstract class CapellaEmbeddedLinkedTextEditorInput
implements LinkedTextDocument.Input {
    private final EObject documentBase;
    private ILabelProvider labelProvider;
    private static final LinkedTextDocument.Resolver _resolver = new DefaultLinkedTextResolver((Predicate)new Predicate<Resource>(){

        public boolean apply(Resource res) {
            return CapellaResourceHelper.isCapellaResource((Resource)res);
        }
    });

    public CapellaEmbeddedLinkedTextEditorInput(EObject documentBase) {
        this.documentBase = documentBase;
    }

    public Object getDocumentBase() {
        return this.documentBase;
    }

    public ILabelProvider getLabelProvider() {
        if (this.labelProvider == null && this.documentBase != null) {
            this.labelProvider = new MDEAdapterFactoryLabelProvider(){

                public String getText(Object object) {
                    if (object instanceof AbstractNamedElement) {
                        String name = ((AbstractNamedElement)object).getName();
                        if (name != null && name.length() > 0) {
                            return name;
                        }
                        return "[Unnamed " + ((EObject)object).eClass().getName() + "]";
                    }
                    return super.getText(object);
                }
            };
            ((AdapterFactoryLabelProvider)this.labelProvider).setFireLabelUpdateNotifications(true);
        }
        return this.labelProvider;
    }

    public LinkedTextDocument.Resolver getResolver() {
        return _resolver;
    }

    public void dispose() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
    }

    public static String getDefaultText(Constraint constraint) {
        return CapellaEmbeddedLinkedTextEditorInput.getDefaultText(constraint, constraint.getName());
    }

    public static String getDefaultText(Constraint contraint, String defaultName) {
        String result = defaultName;
        if (result == null || result.isEmpty()) {
            ValueSpecification vspec = contraint.getOwnedSpecification();
            if (vspec instanceof OpaqueExpression) {
                OpaqueExpression exp = (OpaqueExpression)vspec;
                if (!exp.getLanguages().isEmpty() && !exp.getBodies().isEmpty()) {
                    if ("capella:linkedText".equals(exp.getLanguages().get(0))) {
                        Readonly input = new Readonly((EObject)exp, (String)exp.getBodies().get(0));
                        result = LinkedTextDocument.load((LinkedTextDocument.Input)input).get();
                        input.dispose();
                    } else {
                        result = (String)exp.getBodies().get(0);
                    }
                }
            } else if (vspec instanceof AbstractExpressionValue) {
                result = EObjectLabelProviderHelper.getText((Object)vspec);
            }
        }
        return result == null ? "" : result;
    }

    public static class Readonly
    extends CapellaEmbeddedLinkedTextEditorInput {
        final String text;

        public Readonly(EObject documentBase, String text) {
            super(documentBase);
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String linkedText) {
            throw new UnsupportedOperationException();
        }
    }
}

