/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.transposer.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.polarsys.kitalpha.cadence.core.api.CadenceLauncher;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.WorkflowActivityParameter;
import org.polarsys.kitalpha.transposer.TransposerCorePlugin;
import org.polarsys.kitalpha.transposer.analyzer.api.IAnalyzer;
import org.polarsys.kitalpha.transposer.analyzer.generic.GenericAnalyzer;
import org.polarsys.kitalpha.transposer.analyzer.graph.Graph;
import org.polarsys.kitalpha.transposer.analyzer.graph.Vertex;
import org.polarsys.kitalpha.transposer.api.ITransposer;
import org.polarsys.kitalpha.transposer.api.ITransposerWorkflow;
import org.polarsys.kitalpha.transposer.api.TransposerConfiguration;
import org.polarsys.kitalpha.transposer.generic.GenericContext;
import org.polarsys.kitalpha.transposer.rules.handler.RuleHandlerPlugin;
import org.polarsys.kitalpha.transposer.rules.handler.api.IRulesHandler;
import org.polarsys.kitalpha.transposer.rules.handler.business.GenericRulesHandler;
import org.polarsys.kitalpha.transposer.rules.handler.exceptions.mappings.purposes.NonExistingPurposeException;
import org.polarsys.kitalpha.transposer.rules.handler.exceptions.rules.RuleExecutionException;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.scheduler.api.IScheduler;
import org.polarsys.kitalpha.transposer.scheduler.api.ITransposerTask;
import org.polarsys.kitalpha.transposer.scheduler.generic.GenericScheduler;

public class GenericTransposer
implements ITransposer,
ITransposerWorkflow {
    protected IRulesHandler _rulesHandler;
    protected IAnalyzer _analyzer;
    protected IScheduler _scheduler;
    protected IContext _context;
    protected ActivityParameters _cadenceParameters = new ActivityParameters();

    public GenericTransposer(String purpose_p, String mappingId_p) {
        this.setUp(purpose_p, mappingId_p);
    }

    @Override
    public IAnalyzer getAnalyzer() {
        return this._analyzer;
    }

    @Override
    public IRulesHandler getRulesHandler() {
        return this._rulesHandler;
    }

    @Override
    public IScheduler getScheduler() {
        return this._scheduler;
    }

    public void transpose(Collection<Object> selection_p, IProgressMonitor monitor_p) {
        this.transpose(selection_p, null, null, monitor_p);
    }

    @Override
    public void transpose(Collection<Object> selection_p, Comparator<Vertex<?>> comparator_p, IProgressMonitor monitor_p) {
        this.transpose(selection_p, null, comparator_p, monitor_p);
    }

    @Override
    public void transpose(Collection<Object> selection_p, TransposerConfiguration configuration_p, Comparator<Vertex<?>> comparator_p, IProgressMonitor monitor_p) {
        try {
            Collection sources;
            ArrayList<Object> analysisSources = new ArrayList<Object>();
            this.checkCancel(monitor_p);
            this.callPreAnalysisActivities(selection_p, analysisSources, configuration_p, monitor_p);
            this.checkCancel(monitor_p);
            if ((analysisSources == null || analysisSources.isEmpty()) && (sources = this._rulesHandler.getDomainHelper().getAnalysisSources(selection_p)) != null && !sources.isEmpty()) {
                analysisSources.addAll(sources);
            }
            Graph graph = this.getAnalyzer().analyze(analysisSources, selection_p, monitor_p);
            this.checkCancel(monitor_p);
            this.callPreSchedulingActivities(graph, configuration_p, monitor_p);
            this.checkCancel(monitor_p);
            this.getScheduler().setModel(graph);
            this.getScheduler().schedule(comparator_p, monitor_p);
            List scheduledTasks = this.getScheduler().getScheduleResult();
            this.checkCancel(monitor_p);
            this.callPreExecutionActivities(scheduledTasks, configuration_p, monitor_p);
            this.checkCancel(monitor_p);
            if (monitor_p != null) {
                monitor_p.beginTask("Transposer Tasks Execution", scheduledTasks.size());
            }
            for (ITransposerTask scheduledTask : scheduledTasks) {
                Vertex v = (Vertex)scheduledTask.getTaskContent();
                try {
                    this.getRulesHandler().apply(v.getContent(), scheduledTask.isCompletelyTransposable(), monitor_p);
                    this.checkCancel(monitor_p);
                }
                catch (RuleExecutionException e) {
                    TransposerCorePlugin.getDefault().logError("org.polarsys.kitalpha.transposer", String.valueOf(RuleExecutionException.class.getSimpleName()) + " on " + e.getMessage(), e.getCause());
                }
                if (monitor_p == null) continue;
                monitor_p.worked(1);
            }
            this.checkCancel(monitor_p);
            this.callPostExecutionActivities(configuration_p, monitor_p);
            this.checkCancel(monitor_p);
            if (monitor_p != null) {
                monitor_p.done();
            }
        }
        catch (OperationCanceledException e) {
            TransposerCorePlugin.getDefault().logInfo("org.polarsys.kitalpha.transposer", "Transposer execution canceled.", e);
        }
        catch (Exception e) {
            TransposerCorePlugin.getDefault().logError("org.polarsys.kitalpha.transposer", "Error happens during Transposer execution.", e);
        }
    }

    private void checkCancel(IProgressMonitor monitor_p) throws OperationCanceledException {
        if (monitor_p.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void callPreAnalysisActivities(Collection<Object> selection_p, Collection<Object> analysisSources_p, TransposerConfiguration configuration_p, IProgressMonitor monitor_p) {
        if (configuration_p == null) {
            return;
        }
        this._cadenceParameters.addParameter(new GenericParameter("TransposerInitialSelection", selection_p, "List of selected elements before Transposer's launch"));
        this._cadenceParameters.addParameter(new GenericParameter("TransposerSelection", selection_p, "List of selected elements before Transposer's launch"));
        this._cadenceParameters.addParameter(new GenericParameter("TransposerAnalysisSources", analysisSources_p, "List to store object required to start the analysis"));
        this._cadenceParameters.addParameter(new GenericParameter("TransposerContext", (Object)this._context, "Context used during rules execution"));
        this._cadenceParameters.addParameter(new GenericParameter("TransposerDomainHelper", (Object)this._rulesHandler.getDomainHelper(), "Domain Helper used by Transposer"));
        this._cadenceParameters.addParameter(new GenericParameter("TransposerProgressMonitor", (Object)monitor_p, "Current Progress Monitor"));
        this.complementActivitiesParameters(configuration_p.getPreAnalysisActivities());
        IStatus cadenceStatus = null;
        try {
            cadenceStatus = CadenceLauncher.cadence((String)"org.polarsys.kitalpha.transposer.workflow", (String)"org.polarsys.kitalpha.transposer.before.analysis", (WorkflowActivityParameter)configuration_p.getPreAnalysisActivities(), (IProgressMonitor)monitor_p);
        }
        catch (Exception e) {
            MultiStatus status = new MultiStatus("org.polarsys.kitalpha.transposer.rules.handler", 4, "Error happens in Transposer during Cadence call for pre-analysis activities execution.", (Throwable)e);
            status.add(cadenceStatus);
            RuleHandlerPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private void complementActivitiesParameters(WorkflowActivityParameter activities_p) {
        if (activities_p == null) {
            return;
        }
        for (String key : activities_p.getActivitiesID()) {
            if (this._cadenceParameters == null || this._cadenceParameters.getParameters().isEmpty()) continue;
            for (GenericParameter p : this._cadenceParameters.getParameters()) {
                activities_p.addParameter(key, p);
            }
        }
    }

    private void callPreSchedulingActivities(Graph graph_p, TransposerConfiguration configuration_p, IProgressMonitor monitor_p) {
        if (configuration_p == null) {
            return;
        }
        this._cadenceParameters.addParameter(new GenericParameter("TransposerAnalysisGraph", (Object)graph_p, "Computed analysis graph"));
        this.complementActivitiesParameters(configuration_p.getPreSchedulingActivities());
        IStatus cadenceStatus = null;
        try {
            cadenceStatus = CadenceLauncher.cadence((String)"org.polarsys.kitalpha.transposer.workflow", (String)"org.polarsys.kitalpha.transposer.before.scheduling", (WorkflowActivityParameter)configuration_p.getPreSchedulingActivities(), (IProgressMonitor)monitor_p);
        }
        catch (Exception e) {
            MultiStatus status = new MultiStatus("org.polarsys.kitalpha.transposer.rules.handler", 4, "Error happens in Transposer during Cadence call for pre-scheduling activities execution.", (Throwable)e);
            status.add(cadenceStatus);
            RuleHandlerPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private void callPreExecutionActivities(Collection<ITransposerTask<Vertex<?>>> sortedTasks_p, TransposerConfiguration configuration_p, IProgressMonitor monitor_p) {
        if (configuration_p == null) {
            return;
        }
        this._cadenceParameters.addParameter(new GenericParameter("TransposerSortedTasks", sortedTasks_p, "Computed and sorted tasks list"));
        this._cadenceParameters.addParameter(new GenericParameter("TransposerTransposableObjects", this.getElements(sortedTasks_p), "Transposable elements"));
        this.complementActivitiesParameters(configuration_p.getPreExecutionActivities());
        IStatus cadenceStatus = null;
        try {
            cadenceStatus = CadenceLauncher.cadence((String)"org.polarsys.kitalpha.transposer.workflow", (String)"org.polarsys.kitalpha.transposer.before.rule.execution", (WorkflowActivityParameter)configuration_p.getPreExecutionActivities(), (IProgressMonitor)monitor_p);
        }
        catch (Exception e) {
            MultiStatus status = new MultiStatus("org.polarsys.kitalpha.transposer.rules.handler", 4, "Error happens in Transposer during Cadence call for pre-execution activities execution.", (Throwable)e);
            status.add(cadenceStatus);
            RuleHandlerPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private void callPostExecutionActivities(TransposerConfiguration configuration_p, IProgressMonitor monitor_p) {
        if (configuration_p == null) {
            return;
        }
        this.complementActivitiesParameters(configuration_p.getPostExecutionActivities());
        IStatus cadenceStatus = null;
        try {
            cadenceStatus = CadenceLauncher.cadence((String)"org.polarsys.kitalpha.transposer.workflow", (String)"org.polarsys.kitalpha.transposer.after.rule.execution", (WorkflowActivityParameter)configuration_p.getPostExecutionActivities(), (IProgressMonitor)monitor_p);
        }
        catch (Exception e) {
            MultiStatus status = new MultiStatus("org.polarsys.kitalpha.transposer.rules.handler", 4, "Error happens in Transposer during Cadence call for post-execution activities execution.", (Throwable)e);
            status.add(cadenceStatus);
            RuleHandlerPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    public void initAnalyzer() {
        this._analyzer = new GenericAnalyzer(this._rulesHandler);
    }

    public void initRulesHandler(String purpose_p, String mappingId_p) {
        try {
            this._rulesHandler = this.getRulesHandler(purpose_p, mappingId_p);
            if (this._rulesHandler.getContext() == null) {
                this._rulesHandler.setContext((IContext)new GenericContext());
            }
            this.initContext();
        }
        catch (NonExistingPurposeException e) {
            TransposerCorePlugin.getDefault().logError("org.polarsys.kitalpha.transposer", e.getMessage(), e);
        }
    }

    protected IRulesHandler getRulesHandler(String purpose_p, String mappingId_p) throws NonExistingPurposeException {
        return new GenericRulesHandler(purpose_p, mappingId_p);
    }

    protected void initContext() {
        this._context = this._rulesHandler.getContext();
    }

    public void initScheduler() {
        this._scheduler = new GenericScheduler();
    }

    protected void setUp(String purpose_p, String mappingId_p) {
        this.initRulesHandler(purpose_p, mappingId_p);
        this.initAnalyzer();
        this.initScheduler();
    }

    @Override
    public void dispose() {
        if (this.getAnalyzer() != null) {
            this.getAnalyzer().dispose();
        }
        if (this.getScheduler() != null) {
            this.getScheduler().dispose();
        }
        if (this.getRulesHandler() != null) {
            this.getRulesHandler().dispose();
        }
        this._context = null;
        this._analyzer = null;
        this._rulesHandler = null;
        this._scheduler = null;
    }

    private Set<?> getElements(Collection<ITransposerTask<Vertex<?>>> sortedTasks_p) {
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        for (ITransposerTask<Vertex<?>> task : sortedTasks_p) {
            set.add(((Vertex)task.getTaskContent()).getContent());
        }
        return set;
    }
}

