/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.ui.sirius;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.cs.PhysicalPathReference;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.data.interaction.InteractionUse;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.preferences.Activator;

public class DoubleClickBehaviourUtil {
    public static final DoubleClickBehaviourUtil INSTANCE = new DoubleClickBehaviourUtil();

    private DoubleClickBehaviourUtil() {
    }

    public boolean shouldOpenRelatedDiagramsOnDoubleClick(EObject source) {
        boolean navigateOnDoubleClick = Activator.getDefault().getPreferenceStore().getBoolean("org.polarsys.capella.core.commands.preferences.ui.sirius.diagrams.navigate.doubleclick");
        return navigateOnDoubleClick && (source instanceof FunctionalChain || source instanceof FunctionalChainReference || source instanceof PhysicalPath || source instanceof PhysicalPathReference || source instanceof InteractionUse || source instanceof Scenario);
    }

    public EObject getTargetSemanticElement(EObject target) {
        if (target instanceof FunctionalChainReference) {
            target = ((FunctionalChainReference)target).getReferencedFunctionalChain();
        } else if (target instanceof PhysicalPathReference) {
            target = ((PhysicalPathReference)target).getReferencedPhysicalPath();
        } else if (target instanceof InteractionUse) {
            target = ((InteractionUse)target).getReferencedScenario();
        }
        return target;
    }
}

