/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.util;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.polarsys.capella.core.commands.preferences.internalization.l10n.PreferencesUIMessages;
import org.polarsys.capella.core.commands.preferences.model.CategoryPreferences;
import org.polarsys.capella.core.commands.preferences.model.IItemNode;

public class ItemDetailsHelper {
    private static final String BOLD_START = "<b>";
    private static final String BOLD_END = "</b>";
    static final String PLATFORM_NEWLINE = System.getProperty("line.separator");
    static final String ALSO_IN_CATEGORIES = String.valueOf(PLATFORM_NEWLINE) + PLATFORM_NEWLINE + PreferencesUIMessages.prefs_constraints_also;
    static final String CONSTRAINT_DESCRIPTION_PATTERN = PreferencesUIMessages.prefs_description_constraint;
    static final String ERROR_CONSTRAINT_DESCRIPTION_PATTERN = PreferencesUIMessages.prefs_description_constraint_error;
    static final String NO_CONSTRAINT_DESCRIPTION = PreferencesUIMessages.prefs_no_description_constraint;

    public static String formatItemDescription(IItemNode constraint, CategoryPreferences selectedCategory, List<? super StyleRange> styles) {
        String description = constraint.getDescription();
        if (description == null) {
            description = NO_CONSTRAINT_DESCRIPTION;
        }
        String messagePattern = CONSTRAINT_DESCRIPTION_PATTERN;
        String text = NLS.bind((String)messagePattern, (Object[])new Object[]{constraint.getId(), description});
        Collection<CategoryPreferences> categories = constraint.getCategories();
        if (categories.size() > 1) {
            text = String.valueOf(text) + ItemDetailsHelper.getOtherCategories(selectedCategory, categories);
        }
        if (constraint.isMandatory()) {
            text = MessageFormat.format(PreferencesUIMessages.prefs_mandatory_constraint, text);
        }
        return ItemDetailsHelper.parseStyles(text, styles);
    }

    private static String getOtherCategories(CategoryPreferences selected, Collection<? extends CategoryPreferences> categories) {
        StringBuffer result = new StringBuffer(64);
        result.append(ALSO_IN_CATEGORIES);
        for (CategoryPreferences categoryPreferences : categories) {
            if (categoryPreferences == selected) continue;
            result.append(PLATFORM_NEWLINE);
            result.append(categoryPreferences.getQualifiedName());
        }
        return result.toString();
    }

    private static String parseStyles(String text, List<? super StyleRange> styles) {
        int pos = -1;
        int lastPos = 0;
        StringBuffer result = new StringBuffer(text.length());
        while (lastPos < text.length()) {
            pos = text.indexOf(BOLD_START, lastPos);
            if (pos < 0) break;
            result.append(text.substring(lastPos, pos));
            lastPos = pos + BOLD_START.length();
            pos = text.indexOf(BOLD_END, lastPos);
            if (pos < 0) {
                pos = text.length();
            }
            styles.add((StyleRange)new StyleRange(result.length(), pos - lastPos, null, null, 1));
            result.append(text.substring(lastPos, pos));
            lastPos = Math.min(pos + BOLD_END.length(), text.length());
        }
        result.append(text.substring(lastPos, text.length()));
        return result.toString();
    }
}

