/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.common.validation.statetransition;

import com.google.common.collect.Collections2;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacommon.FinalState;
import org.polarsys.capella.core.data.capellacommon.Mode;
import org.polarsys.capella.core.data.capellacommon.Pseudostate;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.common.validation.statetransition.Utils;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;

public class MDCHK_State_Mode_Hierarchy
extends AbstractModelConstraint {
    public boolean isMixedHierarchyAllowed() {
        return CapellaModelPreferencesPlugin.getDefault().isMixedModeStateAllowed();
    }

    public IStatus validate(IValidationContext ctx) {
        if (this.isMixedHierarchyAllowed()) {
            return ctx.createSuccessStatus();
        }
        State state = (State)ctx.getTarget();
        if (state instanceof Pseudostate || state instanceof FinalState) {
            return ctx.createSuccessStatus();
        }
        EList regions = state.getInvolverRegions();
        for (Region region : regions) {
            EList ownedStates = region.getOwnedStates();
            Collection states = Collections2.filter((Collection)ownedStates, Utils.getPredicate(CapellacommonPackage.eINSTANCE.getState()));
            Collection modes = Collections2.filter((Collection)ownedStates, Utils.getPredicate(CapellacommonPackage.eINSTANCE.getMode()));
            if (modes.size() == 0 || states.size() == 0) continue;
            return this.createFailureStatus(ctx, state);
        }
        return this.checkStateHierarchy(ctx, state);
    }

    private IStatus createFailureStatus(IValidationContext ctx, State state) {
        if (state instanceof Mode) {
            return ctx.createFailureStatus(new Object[]{"Mode", state.getName(), "State"});
        }
        return ctx.createFailureStatus(new Object[]{"State", state.getName(), "Mode"});
    }

    private IStatus checkStateHierarchy(IValidationContext ctx, State state) {
        for (Region region : state.getOwnedRegions()) {
            for (AbstractState subState : region.getOwnedStates()) {
                if (subState instanceof Mode && !(state instanceof Mode)) {
                    return this.createFailureStatus(ctx, state);
                }
                if (subState.eClass() != CapellacommonPackage.eINSTANCE.getState() || !(state instanceof Mode)) continue;
                return this.createFailureStatus(ctx, state);
            }
        }
        return ctx.createSuccessStatus();
    }
}

