/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.properties.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.polarsys.capella.common.flexibility.properties.PropertyChangeListener;
import org.polarsys.capella.common.flexibility.properties.PropertyChangedEvent;
import org.polarsys.capella.common.flexibility.properties.property.IDefaultValueProperty;
import org.polarsys.capella.common.flexibility.properties.schema.ICompoundProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IEditableProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IModifiedProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;

public class PropertyContext
implements IPropertyContext {
    private static final String GLOBAL_LISTENER = "global_listener";
    Object source;
    boolean shouldNotify;
    IProperties properties;
    HashMap<IProperty, Object> propertyValues;
    Map<String, LinkedList<PropertyChangeListener>> listenersMap;

    public PropertyContext(IProperties properties) {
        this.properties = properties;
        this.shouldNotify = true;
        this.propertyValues = new HashMap();
        this.listenersMap = new HashMap<String, LinkedList<PropertyChangeListener>>();
    }

    public PropertyContext(IProperties properties, Object source) {
        this(properties);
        this.source = source;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public void setSource(Object source) {
        this.source = source;
        this.propertyValues.clear();
        for (IProperty property : this.getProperties().getAllItems()) {
            this.notifyListeners(property);
        }
    }

    public void notifyListeners(IProperty property) {
        LinkedList<PropertyChangeListener> globalListeners;
        PropertyChangedEvent event = new PropertyChangedEvent(property, this);
        LinkedList<PropertyChangeListener> propertyChangeListener = new LinkedList<PropertyChangeListener>();
        LinkedList<PropertyChangeListener> propetyListeners = this.listenersMap.get(property.getId());
        if (propetyListeners != null) {
            propertyChangeListener.addAll(propetyListeners);
        }
        if ((globalListeners = this.listenersMap.get(GLOBAL_LISTENER)) != null) {
            propertyChangeListener.addAll(globalListeners);
        }
        for (PropertyChangeListener listener : propertyChangeListener) {
            listener.update(event);
        }
        ArrayList<ICompoundProperty> updated = new ArrayList<ICompoundProperty>();
        this.shouldNotify = false;
        if (this.properties != null) {
            block1: for (IProperty iProperty : this.properties.getAllItems()) {
                if (!(iProperty instanceof ICompoundProperty)) continue;
                ICompoundProperty cProperty = (ICompoundProperty)iProperty;
                String[] stringArray = cProperty.getRelatedProperties();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    if (id.equals(property.getId())) {
                        cProperty.updatedValue(property, this);
                        this.setCurrentValue(cProperty, cProperty.getValue(this));
                        updated.add(cProperty);
                        continue block1;
                    }
                    ++n2;
                }
            }
        }
        this.shouldNotify = true;
        for (IProperty iProperty : updated) {
            this.notifyListeners(iProperty);
        }
    }

    @Override
    public Object getCurrentValue(IProperty property) {
        if (!this.isModified(property) || !this.propertyValues.containsKey(property)) {
            return this.getDefaultValue(property);
        }
        return this.propertyValues.get(property);
    }

    @Override
    public Object getDefaultValue(IProperty property) {
        if (property == null) {
            return null;
        }
        return property.getValue(this);
    }

    @Override
    public boolean isModified() {
        return !this.propertyValues.isEmpty();
    }

    @Override
    public boolean isModified(IProperty property) {
        if (property instanceof IModifiedProperty) {
            return ((IModifiedProperty)((Object)property)).isModified(this);
        }
        return this.propertyValues.containsKey(property);
    }

    @Override
    public void setCurrentValue(IProperty property, Object value) {
        if (property == null) {
            return;
        }
        this.propertyValues.put(property, property.toType(value, this));
        if (this.shouldNotify) {
            this.notifyListeners(property);
        }
    }

    @Override
    public void write(IProperty property) {
        if (property instanceof IEditableProperty) {
            ((IEditableProperty)property).setValue(this);
        }
    }

    @Override
    public void writeAll() {
        if (this.properties != null) {
            for (IProperty property : this.properties.getAllItems()) {
                if (!this.isModified(property) || !(property instanceof IEditableProperty)) continue;
                ((IEditableProperty)property).setValue(this);
            }
        }
    }

    @Override
    public IProperties getProperties() {
        return this.properties;
    }

    @Override
    public void setDefaults() {
        if (this.properties != null) {
            for (IProperty property : this.properties.getAllItems()) {
                if (!(property instanceof IEditableProperty) || !(property instanceof IDefaultValueProperty)) continue;
                this.setCurrentValue(property, ((IDefaultValueProperty)property).getDefaultValue(this));
            }
        }
    }

    @Override
    public void unregisterListener(PropertyChangeListener listener) {
        for (List list : this.listenersMap.values()) {
            list.remove(listener);
        }
    }

    @Override
    public Collection<Object> getSourceAsList() {
        return this.getSourceAsList(null);
    }

    @Override
    public void registerListener(PropertyChangeListener listener) {
        this.registerListener(GLOBAL_LISTENER, listener);
    }

    @Override
    public void registerListener(PropertyChangeListener listener, IProperty property) {
        this.registerListener(property.getId(), listener);
    }

    private void registerListener(String id, PropertyChangeListener listener) {
        LinkedList<PropertyChangeListener> listenersList = this.listenersMap.get(id);
        if (listenersList == null) {
            listenersList = new LinkedList();
            this.listenersMap.put(id, listenersList);
        }
        listenersList.add(listener);
    }

    @Override
    public Collection<Object> getSourceAsList(Class clazz) {
        ArrayList<Object> sources = new ArrayList<Object>();
        Object source = this.getSource();
        if (source instanceof Collection) {
            for (Object object : (Collection)source) {
                if (clazz != null && !clazz.isInstance(object)) continue;
                sources.add(object);
            }
        } else if (clazz == null || clazz.isInstance(source)) {
            sources.add(source);
        }
        return sources;
    }
}

