/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.metric.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.ui.metric.dialog.MetricLabelProvider;

public class MetricTree<T> {
    private MetricTree<T> parent = null;
    private List<MetricTree<T>> children = new ArrayList<MetricTree<T>>();
    private T element;
    private int count = 0;

    public MetricTree(T element, MetricTree<T> parent) {
        this.element = element;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public T getElement() {
        return this.element;
    }

    public int getCount() {
        return this.count;
    }

    public void increaseCount(int count) {
        this.count += count;
    }

    public MetricTree<T> getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public List<MetricTree<T>> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void addChild(MetricTree<T> child) {
        this.children.add(child);
    }

    public void clear() {
        this.parent = null;
        this.element = null;
        if (this.getChildren() != null) {
            for (MetricTree<T> current : this.getChildren()) {
                current.clear();
            }
            this.children.clear();
        }
    }

    public List<MetricTree<T>> getLeafs() {
        ArrayList<MetricTree<T>> leafs = new ArrayList<MetricTree<T>>();
        Stack<MetricTree<T>> stack = new Stack<MetricTree<T>>();
        stack.push(this);
        while (!stack.isEmpty()) {
            MetricTree tree = (MetricTree)stack.pop();
            if (tree.getChildren().isEmpty()) {
                leafs.add(tree);
                continue;
            }
            stack.addAll(tree.getChildren());
        }
        return leafs;
    }

    public void sortChildren() {
        MetricLabelProvider labelProvider = new MetricLabelProvider();
        this.children.sort((obj1, obj2) -> {
            String text2;
            String text1 = labelProvider.getText(obj1);
            if (text1.equals(text2 = labelProvider.getText(obj2))) {
                return ((EObject)obj1.getElement()).eClass().getInstanceTypeName().compareTo(((EObject)obj2.getElement()).eClass().getInstanceTypeName());
            }
            return text1.compareTo(text2);
        });
    }
}

