/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.fastlinker;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.LightMarkerRegistry;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewPlugin;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.links.helpers.LinksCommandRegistry;
import org.polarsys.capella.core.model.links.helpers.commands.AbstractCreateLinksCommand;
import org.polarsys.capella.core.ui.fastlinker.FastLinkerActivator;
import org.polarsys.capella.core.ui.fastlinker.FastLinkerState;
import org.polarsys.capella.core.ui.fastlinker.Messages;
import org.polarsys.capella.core.ui.fastlinker.view.FastLinkerView;

public class FastLinkerManager {
    protected final FastLinkerState currentState = new FastLinkerState();
    protected final List<AbstractCreateLinksCommand> firstToSecondCommands = new ArrayList<AbstractCreateLinksCommand>();
    protected final List<AbstractCreateLinksCommand> secondToFirstCommands = new ArrayList<AbstractCreateLinksCommand>();

    protected Collection getElementToPut(Collection originalElement) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object elem : originalElement) {
            if (CsPackage.Literals.PART.isInstance((Object)originalElement)) {
                ret.add(((Part)elem).getAbstractType());
                continue;
            }
            ret.add(elem);
        }
        return ret;
    }

    public static EClass getCommonType(Collection<? extends EObject> elements) {
        EClass result = null;
        if (!elements.isEmpty()) {
            ArrayList<EClass> common = new ArrayList<EClass>(FastLinkerManager.getSuperTypes(elements.iterator().next().eClass()));
            for (EObject eObject : elements) {
                common.retainAll(FastLinkerManager.getSuperTypes(eObject.eClass()));
            }
            if (!common.isEmpty()) {
                result = (EClass)common.get(common.size() - 1);
            }
        }
        return result;
    }

    private static List<EClass> getSuperTypes(EClass cls) {
        EList allButSelf = cls.getEAllSuperTypes();
        ArrayList<EClass> result = new ArrayList<EClass>(allButSelf.size() + 1);
        result.addAll((Collection<EClass>)allButSelf);
        result.add(cls);
        return Collections.unmodifiableList(result);
    }

    public boolean acceptElementInFastLinker(Collection elementToPut) {
        if (!this.putInFastLinkerPreconditionsRespected(elementToPut)) {
            return false;
        }
        Collection modelElementToPut = this.getElementToPut(elementToPut);
        FastLinkerState futureState = this.currentState.getPreviewState(modelElementToPut);
        if (futureState == null) {
            return false;
        }
        this.firstToSecondCommands.clear();
        this.secondToFirstCommands.clear();
        if (futureState.firstElement != null && futureState.secondElement == null && !futureState.firstElement.isEmpty()) {
            EClass commonSuperType = FastLinkerManager.getCommonType(elementToPut);
            LinksCommandRegistry linksCommandRegistryInstance = LinksCommandRegistry.getInstance();
            if (linksCommandRegistryInstance.containsCommandForSourceType(commonSuperType) || linksCommandRegistryInstance.containsCommandForTargetType(commonSuperType)) {
                return true;
            }
        } else if (!futureState.firstElement.isEmpty() && !futureState.secondElement.isEmpty()) {
            EClass firstSuperType = FastLinkerManager.getCommonType(futureState.firstElement);
            EClass secondSuperType = FastLinkerManager.getCommonType(futureState.secondElement);
            if (LinksCommandRegistry.getInstance().containsCommandForSourceTargetTypes(firstSuperType, secondSuperType) || LinksCommandRegistry.getInstance().containsCommandForSourceTargetTypes(secondSuperType, firstSuperType)) {
                this.firstToSecondCommands.addAll(LinksCommandRegistry.getInstance().getExecutableCommands(futureState.firstElement, futureState.secondElement));
                this.secondToFirstCommands.addAll(LinksCommandRegistry.getInstance().getExecutableCommands(futureState.secondElement, futureState.firstElement));
                if (!this.firstToSecondCommands.isEmpty() || !this.secondToFirstCommands.isEmpty()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean putInFastLinkerPreconditionsRespected(Collection elementToPut) {
        if (elementToPut == null || elementToPut.isEmpty()) {
            return false;
        }
        for (Object it : elementToPut) {
            if (it instanceof ModelElement) continue;
            return false;
        }
        return FastLinkerManager.getCommonType(elementToPut) != null;
    }

    public void pinModelElement(Collection elementToPin) {
        this.currentState.pinModelElement(elementToPin);
        this.showFastLinkerView().update();
    }

    public void clearFastLinker() {
        this.currentState.clear();
        this.showFastLinkerView().update();
    }

    public FastLinkerState getCurrentState() {
        return this.currentState;
    }

    public List<AbstractCreateLinksCommand> getFirstToSecondCommands() {
        return Collections.unmodifiableList(this.firstToSecondCommands);
    }

    public List<AbstractCreateLinksCommand> getSecondToFirstCommands() {
        return Collections.unmodifiableList(this.secondToFirstCommands);
    }

    public FastLinkerView showFastLinkerView() {
        try {
            return (FastLinkerView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.polarsys.capella.core.ui.fastlinker.view", null, 2);
        }
        catch (PartInitException exception) {
            FastLinkerActivator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.core.ui.fastlinker", exception.getLocalizedMessage(), (Throwable)exception));
            return null;
        }
    }

    public void putElementInFastLinker(Collection elementToPut) {
        this.putElementInFastLinker(elementToPut, null);
    }

    public void putElementInFastLinker(Collection elementToPut, AbstractCreateLinksCommand cmd) {
        AbstractCreateLinksCommand commandToExecute;
        if (!this.putInFastLinkerPreconditionsRespected(elementToPut)) {
            return;
        }
        if (!(cmd == null || this.firstToSecondCommands.contains(cmd) && this.secondToFirstCommands.contains(cmd))) {
            throw new IllegalArgumentException("Command to execute must be amongst executable command(s).");
        }
        Collection modelElementToPut = this.getElementToPut(elementToPut);
        this.currentState.updateState(modelElementToPut);
        if (this.firstToSecondCommands.size() == 0 && this.secondToFirstCommands.size() == 0) {
            commandToExecute = null;
        } else if (1 == this.firstToSecondCommands.size() && this.secondToFirstCommands.size() == 0) {
            commandToExecute = this.firstToSecondCommands.get(0);
        } else if (this.firstToSecondCommands.size() == 0 && 1 == this.secondToFirstCommands.size()) {
            commandToExecute = this.secondToFirstCommands.get(0);
        } else if (cmd != null) {
            commandToExecute = cmd;
        } else {
            FastLinkerView fastLinkerView = this.showFastLinkerView();
            fastLinkerView.update();
            commandToExecute = fastLinkerView.chooseCommandToExecute(this.firstToSecondCommands, this.secondToFirstCommands);
        }
        if (commandToExecute != null) {
            Collection sources = commandToExecute.getSources();
            Collection targets = commandToExecute.getTargets();
            for (ModelElement src : sources) {
                for (ModelElement tgt : targets) {
                    commandToExecute.setSources(Collections.singleton(src));
                    commandToExecute.setTargets(Collections.singleton(tgt));
                    LinksCommandRegistry.getInstance().executeCommand((EObject)src, commandToExecute);
                    this.showCommandExecutedMessage(commandToExecute);
                }
            }
            this.currentState.setLinkCreated(commandToExecute.getLinkRepresentation());
        }
        this.showFastLinkerView().update();
    }

    public void showCommandExecutedMessage(AbstractCreateLinksCommand cmd) {
        EObject affectedObject;
        String informationMessage;
        EObject createdLinkObject = cmd.getCreatedLinkObject();
        String sourceName = cmd.getSource().getLabel();
        String targetName = cmd.getTarget().getLabel();
        if (createdLinkObject != null) {
            informationMessage = MessageFormat.format(Messages.FastLinkerManager_QualifiedLinkCommandReport, createdLinkObject.eClass().getName(), sourceName, targetName);
            affectedObject = createdLinkObject;
        } else {
            informationMessage = MessageFormat.format(Messages.FastLinkerManager_UnQualifiedLinkCommandReport, cmd.getLabel(), sourceName, targetName);
            affectedObject = cmd.getSource();
        }
        LightMarkerRegistry.getInstance().createMarker((IResource)ResourcesPlugin.getWorkspace().getRoot(), (Diagnostic)new BasicDiagnostic(Messages.FastLinker, 0, informationMessage, new Object[]{affectedObject}));
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.polarsys.capella.common.tools.report.appenders.reportlogview.logview", null, 2);
        }
        catch (PartInitException exception) {
            MarkerViewPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.common.tools.report.appenders.reportlogview", exception.getLocalizedMessage(), (Throwable)exception));
        }
    }

    public void updateCurrentState(Collection first, Collection second, Collection pinned) {
        this.currentState.updateState(first, second, pinned);
        this.showFastLinkerView().update();
    }
}

