/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario.fc2fs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.ExecutionEnd;
import org.polarsys.capella.core.data.interaction.ExecutionEvent;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.oa.OperationalProcess;
import org.polarsys.capella.core.diagram.helpers.naming.DiagramNamingConstants;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.model.helpers.refmap.Pair;
import org.polarsys.capella.core.model.utils.NamingHelper;
import org.polarsys.capella.core.projection.scenario.fc2fs.FC2FSExt;

public class FC2FSInitialization {
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe(FC2FSInitialization.class.getName());
    private boolean isLogEnabled = false;
    private Map<EObject, EObject> mapping;
    private List<InstanceRole> orderedInstRoles = new ArrayList<InstanceRole>();

    public FC2FSInitialization() {
        this.isLogEnabled = FC2FSExt.isLogEnabled();
    }

    public void execute(Collection<FunctionalChain> funcChains) {
        ArrayList<Pair<FunctionalChain, Scenario>> fc2ScenarioPairs = new ArrayList<Pair<FunctionalChain, Scenario>>();
        boolean isMsgWithReply = FC2FSExt.isCreateMsgWithReply(funcChains.iterator().next());
        for (FunctionalChain fc : funcChains) {
            this.logInfo("Looking up existing Scenarios...");
            Collection<Scenario> availableInitializedScenarios = FC2FSExt.getAvailableInitializedScenarios(fc);
            if (!availableInitializedScenarios.isEmpty()) {
                if (!MessageDialog.openQuestion((Shell)FC2FSExt.getActiveShell(), (String)"Confirm Initialization", (String)("Are you sure you want to initialize new Scenario for " + fc.getName() + "? Initialized Scenario(s) found."))) continue;
                this.doExecute(fc, isMsgWithReply, fc2ScenarioPairs);
                continue;
            }
            this.doExecute(fc, isMsgWithReply, fc2ScenarioPairs);
        }
        if (!fc2ScenarioPairs.isEmpty()) {
            this.logInfo("Adding created Scenario to the model");
            FC2FSExt.addToModel(fc2ScenarioPairs);
            this.logInfo("Initialization finished");
        }
    }

    private void doExecute(FunctionalChain fc, boolean isMsgWithReply, Collection<Pair<FunctionalChain, Scenario>> fc2ScenarioPairs) {
        this.logInfo("Perform initialization from " + fc.eClass().getName() + " " + fc.getName());
        Scenario scenario = this.toScenario(fc);
        for (AbstractFunction func : FunctionalChainExt.getFlatFunctions((FunctionalChain)fc)) {
            this.toInstanceRole(func, scenario);
        }
        if (isMsgWithReply) {
            this.createSequenceMessagesWithReply(fc, scenario);
        } else {
            this.createSequenceMessages(fc, scenario);
        }
        this.logInfo("Reordering InstanceRoles...");
        this.logInfo("Old order: " + NamingHelper.toString((Collection)scenario.getOwnedInstanceRoles()));
        this.reorderInstanceRoles(scenario);
        this.logInfo("New order: " + NamingHelper.toString((Collection)scenario.getOwnedInstanceRoles()));
        fc2ScenarioPairs.add((Pair<FunctionalChain, Scenario>)new Pair((Object)fc, (Object)scenario));
    }

    private void reorderInstanceRoles(Scenario scenario) {
        int position = 0;
        for (InstanceRole instRole : this.orderedInstRoles) {
            scenario.getOwnedInstanceRoles().move(position, (Object)instRole);
            ++position;
        }
    }

    private void createSequenceMessagesWithReply(FunctionalChain fc, Scenario scenario) {
        this.logInfo("Functional Chain with return branch is enabled");
        for (FunctionalChainInvolvement fci : FunctionalChainExt.getFlatInvolvementsOf((FunctionalChain)fc, (EClass)FaPackage.Literals.FUNCTIONAL_EXCHANGE)) {
            FunctionalExchange fe = (FunctionalExchange)fci.getInvolved();
            SequenceMessage sequenceMessage = this.createSequenceMessage(scenario, fe, MessageKind.ASYNCHRONOUS_CALL);
            MessageEnd sendingEnd = this.createSendingEnd(scenario, fe, sequenceMessage);
            MessageEnd receivingEnd = this.createReceivingEnd(scenario, fe, sequenceMessage);
            this.createEventSentOperation(scenario, fe, sendingEnd);
            this.createEventReceiptOperation(scenario, fe, receivingEnd);
            SequenceMessage replyMessage = this.createSequenceMessage(scenario, fe, MessageKind.REPLY);
            MessageEnd replySendingEnd = this.createSendingEnd(scenario, fe, replyMessage);
            MessageEnd replyReceivingEnd = this.createReceivingEnd(scenario, fe, replyMessage);
            this.createEventSentOperation(scenario, fe, replySendingEnd);
            this.createEventReceiptOperation(scenario, fe, replyReceivingEnd);
            this.createExecution(scenario, (InteractionFragment)receivingEnd, (InteractionFragment)replySendingEnd);
        }
    }

    private void createSequenceMessages(FunctionalChain fc, Scenario scenario) {
        this.logInfo("Functional Chain without return branch is enabled");
        for (FunctionalChainInvolvement fci : FunctionalChainExt.getFlatInvolvementsOf((FunctionalChain)fc, (EClass)FaPackage.Literals.FUNCTIONAL_EXCHANGE)) {
            FunctionalExchange fe = (FunctionalExchange)fci.getInvolved();
            SequenceMessage sequenceMessage = this.createSequenceMessage(scenario, fe, MessageKind.ASYNCHRONOUS_CALL);
            if (fci instanceof FunctionalChainInvolvementLink) {
                sequenceMessage.getExchangedItems().addAll((Collection)((FunctionalChainInvolvementLink)fci).getExchangedItems());
            }
            MessageEnd sendingEnd = this.createSendingEnd(scenario, fe, sequenceMessage);
            MessageEnd receivingEnd = this.createReceivingEnd(scenario, fe, sequenceMessage);
            ExecutionEnd execEnd = this.crreateExecutionEnd(scenario, receivingEnd);
            this.createExecution(scenario, (InteractionFragment)receivingEnd, (InteractionFragment)execEnd);
            this.createEventSentOperation(scenario, fe, sendingEnd);
            this.createEventReceiptOperation(scenario, fe, receivingEnd);
            this.createExecutionEvent(scenario, execEnd);
        }
    }

    private Scenario toScenario(FunctionalChain fc) {
        Scenario scenario = InteractionFactory.eINSTANCE.createScenario(this.getDefaultScenarioName(fc));
        scenario.setKind(this.getScenarioKind(fc));
        TransfoLink trace = CapellacommonFactory.eINSTANCE.createTransfoLink();
        trace.setTargetElement((TraceableElement)fc);
        trace.setSourceElement((TraceableElement)scenario);
        scenario.getOwnedTraces().add((Object)trace);
        this.getMapping().put((EObject)fc, (EObject)scenario);
        this.logInfo("Create Scenario " + scenario.getName() + " of kind " + scenario.getKind());
        return scenario;
    }

    private String getDefaultScenarioName(FunctionalChain fc) {
        if (fc instanceof OperationalProcess) {
            return "[" + DiagramNamingConstants.ACTIVITY_SCENARIO_PREFIX + "] " + fc.getName();
        }
        return "[" + DiagramNamingConstants.FUNCTION_SCENARIO_PREFIX + "] " + fc.getName();
    }

    private ScenarioKind getScenarioKind(FunctionalChain fc) {
        if (fc instanceof OperationalProcess) {
            return ScenarioKind.INTERACTION;
        }
        return ScenarioKind.FUNCTIONAL;
    }

    private void toInstanceRole(AbstractFunction func, Scenario scenario) {
        EObject eObject = this.getMapping().get(func);
        if (eObject == null) {
            InstanceRole instanceRole = InteractionFactory.eINSTANCE.createInstanceRole(func.getName());
            scenario.getOwnedInstanceRoles().add((Object)instanceRole);
            instanceRole.setRepresentedInstance((AbstractInstance)func);
            this.getMapping().put((EObject)func, (EObject)instanceRole);
            this.logInfo("Create InstanceRole " + instanceRole.getName());
        }
    }

    private SequenceMessage createSequenceMessage(Scenario scenario, FunctionalExchange fe, MessageKind kind) {
        SequenceMessage sequenceMessage = InteractionFactory.eINSTANCE.createSequenceMessage(fe.getName());
        scenario.getOwnedMessages().add((Object)sequenceMessage);
        sequenceMessage.setKind(kind);
        this.logInfo("Create SequenceMessage " + sequenceMessage.getName() + " of kind " + kind);
        return sequenceMessage;
    }

    private MessageEnd createSendingEnd(Scenario scenario, FunctionalExchange fe, SequenceMessage sequenceMessage) {
        MessageEnd msgEnd = InteractionFactory.eINSTANCE.createMessageEnd("Send Call Message Call");
        scenario.getOwnedInteractionFragments().add((Object)msgEnd);
        sequenceMessage.setSendingEnd(msgEnd);
        if (sequenceMessage.getKind() == MessageKind.REPLY) {
            msgEnd.getCoveredInstanceRoles().add((Object)((InstanceRole)this.getMapping().get(this.getFunctionalExchangeTarget(fe))));
        } else {
            msgEnd.getCoveredInstanceRoles().add((Object)((InstanceRole)this.getMapping().get(this.getFunctionalExchangeSource(fe))));
        }
        return msgEnd;
    }

    private MessageEnd createReceivingEnd(Scenario scenario, FunctionalExchange fe, SequenceMessage sequenceMessage) {
        MessageEnd receiveEnd = InteractionFactory.eINSTANCE.createMessageEnd("Receive Call Message Call");
        scenario.getOwnedInteractionFragments().add((Object)receiveEnd);
        sequenceMessage.setReceivingEnd(receiveEnd);
        if (sequenceMessage.getKind() == MessageKind.REPLY) {
            receiveEnd.getCoveredInstanceRoles().add((Object)((InstanceRole)this.getMapping().get(this.getFunctionalExchangeSource(fe))));
        } else {
            receiveEnd.getCoveredInstanceRoles().add((Object)((InstanceRole)this.getMapping().get(this.getFunctionalExchangeTarget(fe))));
        }
        return receiveEnd;
    }

    private ExecutionEnd crreateExecutionEnd(Scenario scenario, MessageEnd receivingEnd) {
        ExecutionEnd execEnd = InteractionFactory.eINSTANCE.createExecutionEnd("endExec");
        scenario.getOwnedInteractionFragments().add((Object)execEnd);
        execEnd.getCoveredInstanceRoles().add((Object)((InstanceRole)receivingEnd.getCoveredInstanceRoles().get(0)));
        return execEnd;
    }

    private void createExecution(Scenario scenario, InteractionFragment start, InteractionFragment finish) {
        Execution exec = InteractionFactory.eINSTANCE.createExecution("execution");
        scenario.getOwnedTimeLapses().add((Object)exec);
        exec.setStart(start);
        exec.setFinish(finish);
    }

    private void createEventSentOperation(Scenario scenario, FunctionalExchange fe, MessageEnd sendingEnd) {
        EventSentOperation eventSentOp = InteractionFactory.eINSTANCE.createEventSentOperation("eventSentOp");
        scenario.getOwnedEvents().add((Object)eventSentOp);
        sendingEnd.setEvent((Event)eventSentOp);
        eventSentOp.setOperation((AbstractEventOperation)fe);
        EObject eObject = this.getMapping().get(this.getFunctionalExchangeSource(fe));
        if (eObject instanceof InstanceRole && !this.orderedInstRoles.contains(eObject)) {
            this.orderedInstRoles.add((InstanceRole)eObject);
        }
    }

    private void createEventReceiptOperation(Scenario scenario, FunctionalExchange fe, MessageEnd receivingEnd) {
        EventReceiptOperation eventReceiptOp = InteractionFactory.eINSTANCE.createEventReceiptOperation("eventReceiptOp");
        scenario.getOwnedEvents().add((Object)eventReceiptOp);
        receivingEnd.setEvent((Event)eventReceiptOp);
        eventReceiptOp.setOperation((AbstractEventOperation)fe);
    }

    private void createExecutionEvent(Scenario scenario, ExecutionEnd execEnd) {
        ExecutionEvent executionEvent = InteractionFactory.eINSTANCE.createExecutionEvent("executionEvent");
        scenario.getOwnedEvents().add((Object)executionEvent);
        execEnd.setEvent((Event)executionEvent);
    }

    private EObject getFunctionalExchangeSource(FunctionalExchange fe) {
        ActivityNode source = fe.getSource();
        return source instanceof AbstractFunction ? source : source.eContainer();
    }

    private EObject getFunctionalExchangeTarget(FunctionalExchange fe) {
        ActivityNode target = fe.getTarget();
        return target instanceof AbstractFunction ? target : target.eContainer();
    }

    private Map<EObject, EObject> getMapping() {
        if (this.mapping == null) {
            this.mapping = new HashMap<EObject, EObject>();
        }
        return this.mapping;
    }

    private void logInfo(String msg) {
        if (this.isLogEnabled) {
            logger.info((Object)msg);
        }
    }
}

