/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.preferences.configuration.project;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.polarsys.capella.core.preferences.configuration.project.ConfigurationProjectContentsLocationArea;
import org.polarsys.capella.core.preferences.configuration.project.NewModelWizardPage;
import org.polarsys.capella.core.preferences.configuration.project.ProjectContentsLocationArea;
import org.polarsys.capella.core.preferences.configuration.project.WizardProjectCreationPage;
import org.polarsys.capella.core.preferences.configuration.project.ui.wizards.ReferecedConfigurationProjectSelectionPage;
import org.polarsys.capella.core.preferences.project.configuration.project.ConfigurationPlugin;

public class ProjectWizard
extends BasicNewResourceWizard {
    private static final int STEP_TICK_COUNT = 100;
    private static final String CAPELLA_PROJECT_NATURE_ID = "org.polarsys.capella.project.nature";
    protected WizardProjectCreationPage _localProjectDescriptionPage;
    protected NewModelWizardPage _modelPage;
    private ReferecedConfigurationProjectSelectionPage referencersProjectsPage;
    public static ProjectScope projectScope;

    public void addPages() {
        this._localProjectDescriptionPage = this.createLocalProjectDescriptionPage();
        this.addPage((IWizardPage)this._localProjectDescriptionPage);
    }

    protected void createReferencersProjectsPages() {
        this.referencersProjectsPage = new ReferecedConfigurationProjectSelectionPage("Capella Configuration Project", "Referencers Capella Project", ConfigurationPlugin.getImageDescriptor("config_project_wizard.gif"), new String[]{CAPELLA_PROJECT_NATURE_ID});
        this.addPage((IWizardPage)this.referencersProjectsPage);
    }

    protected NewModelWizardPage createProjectModelPage() {
        NewModelWizardPage modelPage = new NewModelWizardPage("model.creation.page", null);
        modelPage.setDescription("Capella Configuration Project");
        modelPage.setTitle("Configuration Project");
        return modelPage;
    }

    protected WizardProjectCreationPage createLocalProjectDescriptionPage() {
        WizardProjectCreationPage mainPage = new WizardProjectCreationPage("CapellaProjNewPage", this.getSelection()){

            @Override
            protected ProjectContentsLocationArea handleDefaultProjectLocation(Composite parent_p) {
                return new ConfigurationProjectContentsLocationArea(this.getErrorReporter(), parent_p);
            }
        };
        mainPage.setInitialProjectName(null);
        mainPage.setDescription("Create a new project configuration");
        mainPage.setTitle("Capella Configuration Project");
        mainPage.setImageDescriptor(ConfigurationPlugin.getWizadrConfigurationProjectIcon());
        return mainPage;
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        return currentPage.isPageComplete();
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    int stepCount = 7;
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)("NewProjectWizard.CreateProject_Title" + ProjectWizard.this.getEclipseProjectName()), (int)(100 * stepCount));
                    try {
                        ProjectWizard.this.createNewEclipseProject(ProjectWizard.this.getEclipseProjectName(), (IProgressMonitor)progress.newChild(100));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    public IProject createNewEclipseProject(String projectName_p, IProgressMonitor monitor_p) throws Exception {
        IProject project = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor_p, (int)100);
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            project = workspaceRoot.getProject(projectName_p);
            if (!project.exists()) {
                IPath newPath;
                IPath defaultPath = Platform.getLocation();
                if (defaultPath.equals((Object)(newPath = this._localProjectDescriptionPage.getLocationPath()))) {
                    newPath = null;
                }
                IProjectDescription description = null;
                description = this.referencersProjectsPage != null && !this.referencersProjectsPage.getSelectedConfigurationsProjects().isEmpty() ? this.createProjectDescription(project, newPath, true) : this.createProjectDescription(project, newPath, false);
                project.create(description, (IProgressMonitor)progress.newChild(50));
            }
            progress.setWorkRemaining(50);
            project.open((IProgressMonitor)progress.newChild(50));
        }
        finally {
            progress.done();
        }
        return project;
    }

    public static void createFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                ProjectWizard.createFolder((IFolder)parent, force, local, null);
            }
            folder.create(force, local, monitor);
        }
    }

    public IProjectDescription createProjectDescription(IProject projectHandle_p, IPath projectPath_p, boolean hasReferencersProjects) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String name = projectHandle_p.getName();
        IProjectDescription description = workspace.newProjectDescription(name);
        if (projectPath_p != null) {
            description.setLocation(projectPath_p.append(name));
        }
        if (!description.hasNature("org.polarsys.capella.core.preferences.project.nature.configNature")) {
            String[] newNatures = new String[]{"org.polarsys.capella.core.preferences.project.nature.configNature"};
            description.setNatureIds(newNatures);
        }
        if (hasReferencersProjects) {
            this.addConfigurationProjectReferences(projectHandle_p, description);
        }
        return description;
    }

    private IProjectDescription addConfigurationProjectReferences(IProject project_p, IProjectDescription description) {
        List<IProject> selectedConfigurationProject = this.referencersProjectsPage.getSelectedConfigurationsProjects();
        try {
            Iterator<IProject> iterator = selectedConfigurationProject.iterator();
            while (iterator.hasNext()) {
                IProject element;
                IProject capellaProject = element = iterator.next();
                IProjectDescription capellaProjectDescription = capellaProject.getDescription();
                IProject[] referencesT = capellaProjectDescription.getReferencedProjects();
                ArrayList<IProject> references = new ArrayList<IProject>();
                IProject[] iProjectArray = referencesT;
                int n = referencesT.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject iProject = iProjectArray[n2];
                    references.add(iProject);
                    ++n2;
                }
                references.add(project_p);
                IProject[] referencedProjects = new IProject[references.size()];
                int i = 0;
                while (i < referencedProjects.length) {
                    referencedProjects[i] = (IProject)references.get(i);
                    ++i;
                }
                capellaProjectDescription.setReferencedProjects(referencedProjects);
                project_p.refreshLocal(2, null);
            }
        }
        catch (CoreException exception_p) {
            StringBuilder stringBuilder = new StringBuilder("ProjectWizard.addConfigurationProjectReferences(..) _ ");
        }
        return description;
    }

    protected String getEclipseProjectName() {
        return this._localProjectDescriptionPage.getProjectName();
    }
}

