/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.business.internal.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.query.legacy.AcceleoInterpreterPlugin;
import org.eclipse.sirius.query.legacy.business.internal.interpreter.AcceleoInterpreter;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;

public final class ENodeHelper {
    private ENodeHelper() {
    }

    public static Collection<EObject> getAsListOfEObjects(ENode enode) {
        ArrayList<EObject> result = null;
        try {
            result = (ArrayList<EObject>)enode.getAdapterValue(Collection.class);
        }
        catch (ENodeCastException eNodeCastException) {}
        if (result != null) {
            Iterator it = result.iterator();
            while (it.hasNext()) {
                Object cur = it.next();
                if (cur instanceof EObject) continue;
                it.remove();
            }
        } else {
            result = new ArrayList<EObject>();
        }
        return result;
    }

    public static Object getValue(ENode node, String s) {
        Object value = null;
        if (!node.isNull()) {
            try {
                if (node.isEObject()) {
                    value = node.getEObject();
                } else if (node.isString()) {
                    value = node.getString();
                } else if (node.isBoolean()) {
                    value = node.getBoolean();
                } else if (node.isDouble()) {
                    value = new Double(node.getDouble());
                } else if (node.isInt()) {
                    value = node.getInt();
                } else if (node.isList() && node.getList().size() > 0) {
                    value = node.getList().asList();
                }
            }
            catch (ENodeCastException e) {
                AcceleoInterpreterPlugin.getDefault().error(s, e);
            }
        }
        return value;
    }

    public static ENode evaluate(AcceleoInterpreter interpreter, EObject target, String expression) throws EvaluationException {
        ENode result = new ENode(null, null, true);
        try {
            if (!StringUtil.isEmpty((String)expression)) {
                result = interpreter.evaluateENode(target, expression);
            }
        }
        catch (EvaluationException e) {
            throw new EvaluationException((Throwable)e);
        }
        return result;
    }

    public static boolean getAsBoolean(ENode evaluate) {
        boolean adaptedBool = false;
        try {
            if (evaluate.isBoolean()) {
                return evaluate.getBoolean();
            }
            Boolean value = (Boolean)evaluate.getAdapterValue(Boolean.class);
            if (value != null) {
                adaptedBool = value;
            }
        }
        catch (ENodeCastException eNodeCastException) {}
        return adaptedBool;
    }

    public static EObject getAsEObject(ENode result) {
        EObject adaptedEObject = null;
        try {
            if (result.isEObject()) {
                return result.getEObject();
            }
            adaptedEObject = (EObject)result.getAdapterValue(EObject.class);
        }
        catch (ENodeCastException eNodeCastException) {}
        return adaptedEObject;
    }

    public static String getAsString(ENode result) {
        String adaptedEObject = null;
        try {
            if (result.isString()) {
                return result.getString();
            }
            adaptedEObject = (String)result.getAdapterValue(String.class);
        }
        catch (ENodeCastException eNodeCastException) {}
        return adaptedEObject;
    }

    public static Integer getAsInteger(ENode result) {
        Integer adaptedEObject = null;
        try {
            if (result.isInt()) {
                return result.getInt();
            }
            adaptedEObject = (Integer)result.getAdapterValue(Integer.TYPE);
        }
        catch (ENodeCastException eNodeCastException) {}
        return adaptedEObject;
    }
}

