/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.business.internal.interpreter;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.query.legacy.ecore.factories.EFactory;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeIterator;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeList;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.tools.format.Conventions;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;

public class ENodeServices {
    protected IScript script;
    private int trace = 0;

    public ENodeServices(IScript script) {
        this.script = script;
    }

    public ENode filter(ENode node, String type) throws ENodeCastException, FactoryException {
        if (node.isList()) {
            ENodeList res = new ENodeList();
            ENodeIterator it = node.getList().iterator();
            while (it.hasNext()) {
                ENode child = this.filter(it.next(), type);
                if (child.isNull()) continue;
                res.add(child);
            }
            return new ENode(res, node);
        }
        if (node.isEObject()) {
            if (EFactory.eInstanceOf(node.getEObject(), type)) {
                return node;
            }
            return new ENode(ENode.EMPTY, node);
        }
        return node;
    }

    @Deprecated
    public ENode cast(ENode node, String type) throws ENodeCastException, FactoryException {
        return this.filter(node, type);
    }

    public ENode sep(ENode node, String separator) throws ENodeCastException, FactoryException {
        if (node.isList()) {
            ENodeList list = node.getList();
            ENodeList res = new ENodeList();
            ENodeIterator it = list.iterator();
            if (it.hasNext()) {
                ENode element = it.next();
                boolean needSeparator = element.size() > 0;
                res.add(element);
                while (it.hasNext()) {
                    element = it.next();
                    if (needSeparator && element.size() > 0) {
                        res.add(new ENode(separator, node));
                        needSeparator = true;
                    } else if (!needSeparator) {
                        needSeparator = element.size() > 0;
                    }
                    res.add(element);
                }
            }
            return new ENode(res, node);
        }
        return node;
    }

    @Deprecated
    public ENode sepStr(ENode node, String separator) throws ENodeCastException, FactoryException {
        ENode result = this.sep(node, separator);
        result.asString();
        return result;
    }

    @Deprecated
    public ENode until(ENode node, String link, String type) throws ENodeCastException, FactoryException {
        EObject object = node.getEObject();
        while (object != null) {
            if (EFactory.eInstanceOf(object, type)) {
                return new ENode(object, node);
            }
            object = EFactory.eGetAsEObject(object, link);
        }
        return null;
    }

    public ENode current(ENode node) {
        return node;
    }

    public ENode current(ENode node, ENode arg) throws ENodeCastException {
        if (arg.isString()) {
            String type = arg.getString();
            int i = 0;
            Object value = this.script.contextAt(IScript.TEMPLATE_NODE, i);
            while (value != null) {
                ENode current = ENode.createTry(value, node);
                if (current != null && current.isEObject() && EFactory.eInstanceOf(current.getEObject(), type)) {
                    return current;
                }
                value = this.script.contextAt(IScript.TEMPLATE_NODE, ++i);
            }
        } else if (arg.isInt()) {
            Object value = this.script.contextAt(IScript.TEMPLATE_NODE, arg.getInt());
            return ENode.createTry(value, node);
        }
        return new ENode(ENode.EMPTY, node);
    }

    public ENode toString(ENode node) {
        node.asString();
        return node;
    }

    public ENode adapt(ENode node, String type) throws ENodeCastException {
        Class c = "EObject".equalsIgnoreCase(type) ? EObject.class : ("ENodeList".equalsIgnoreCase(type) ? ENodeList.class : ("String".equalsIgnoreCase(type) ? String.class : ("boolean".equalsIgnoreCase(type) ? Boolean.TYPE : ("int".equalsIgnoreCase(type) ? Integer.TYPE : ("double".equalsIgnoreCase(type) ? Double.TYPE : ("List".equalsIgnoreCase(type) ? List.class : ("ENode".equalsIgnoreCase(type) ? ENode.class : null)))))));
        ENode result = ENode.createTry(node.getAdapterValue(c), node);
        if (result != null) {
            return result;
        }
        return new ENode(ENode.EMPTY, node);
    }

    public ENode debug(ENode node) {
        return this.trace(node);
    }

    public ENode trace(ENode node) {
        return this.trace(node, "");
    }

    public ENode trace(ENode node, String template) {
        String prefix;
        ++this.trace;
        if (template != null && template.length() > 0) {
            try {
                prefix = String.valueOf(Conventions.formatString(template)) + '=' + Conventions.formatString(this.evaluate(node, template).toString());
            }
            catch (TemplateSyntaxException templateSyntaxException) {
                prefix = "";
            }
            catch (FactoryException factoryException) {
                prefix = "";
            }
        } else {
            prefix = "";
        }
        String marker = (String.valueOf(91 + this.trace) + "]          ").substring(0, 10);
        System.out.println(String.valueOf(marker) + prefix + ' ' + AcceleoGenMessages.getString("ENodeServices.TraceMessage", new Object[]{node.getType(), Conventions.formatString(node.toString())}));
        return node;
    }

    private ENode evaluate(ENode current, String call) throws TemplateSyntaxException, FactoryException {
        int pos = this.getBegin();
        call = call.replaceAll("'", "\\\"");
        TemplateExpression expression = TemplateExpression.fromString(this.computeCall(pos, call), new Int2(pos, pos + call.length()), this.script);
        try {
            return expression.evaluate(current, this.script, LaunchManager.create("run", true));
        }
        catch (ENodeException eNodeException) {
            return new ENode(ENode.EMPTY, current);
        }
    }

    private int getBegin() {
        Int2 pos = (Int2)this.script.contextPeek(IScript.ARGUMENT_POSITION);
        if (pos != null) {
            return pos.b();
        }
        return 0;
    }

    private String computeCall(int begin, String call) {
        if (begin > 0) {
            StringBuffer result = new StringBuffer("");
            int i = 0;
            while (i < begin) {
                result.append(' ');
                ++i;
            }
            result.append(call);
            return result.toString();
        }
        return call;
    }

    public int nSize(ENode node) {
        return node.size();
    }

    public ENode nGet(ENode node, int index) throws ENodeCastException, FactoryException {
        if (node.isList()) {
            ENodeList list = node.getList();
            ENode result = list.get(index);
            if (result != null) {
                return result;
            }
            return new ENode(ENode.EMPTY, node);
        }
        if (index == 0) {
            return node;
        }
        return new ENode(ENode.EMPTY, node);
    }

    public ENode nGet(ENode node, int begin, int end) throws ENodeCastException, FactoryException {
        if (node.isList()) {
            ENodeList list = node.getList();
            ENodeList result = new ENodeList();
            int i = begin;
            while (i < list.size() && (i < end || end == -1)) {
                ENode child = list.get(i);
                result.add(child);
                ++i;
            }
            return new ENode(result, node);
        }
        if (begin == 0 && (end > 0 || end == -1)) {
            return node;
        }
        return new ENode(ENode.EMPTY, node);
    }

    public ENode nFirst(ENode node) throws ENodeCastException, FactoryException {
        if (node.isList()) {
            ENodeList list = node.getList();
            ENode result = list.get(0);
            if (result != null) {
                return result;
            }
            return new ENode(ENode.EMPTY, node);
        }
        return node;
    }

    public ENode nLast(ENode node) throws ENodeCastException, FactoryException {
        if (node.isList()) {
            ENodeList list = node.getList();
            ENode result = list.get(list.size() - 1);
            if (result != null) {
                return result;
            }
            return new ENode(ENode.EMPTY, node);
        }
        return node;
    }

    @Deprecated
    public ENode minimize(ENode node) throws ENodeCastException {
        return this.nMinimize(node);
    }

    public ENode nMinimize(ENode node) throws ENodeCastException {
        if (node.isList()) {
            ENodeList result = new ENodeList(true);
            result.addAll(node.getList());
            return new ENode(result, node);
        }
        return node;
    }

    @Deprecated
    public ENode reverse(ENode node) throws ENodeCastException, FactoryException {
        return this.nReverse(node);
    }

    public ENode nReverse(ENode node) throws ENodeCastException, FactoryException {
        if (node.isList()) {
            ENodeList result = new ENodeList();
            ENodeIterator it = node.getList().iterator();
            while (it.hasNext()) {
                ENode child = it.next();
                if (child.isNull()) continue;
                result.add(0, child);
            }
            return new ENode(result, node);
        }
        return node;
    }

    public boolean nContains(ENode node, ENode element) throws ENodeCastException {
        if (node.isList()) {
            return node.getList().contains(element);
        }
        return node.equals(element);
    }

    @Deprecated
    public ENode sort(ENode node) throws ENodeCastException {
        return this.nMinimize(this.nSort(node));
    }

    public ENode nSort(ENode node) throws ENodeCastException {
        if (node.isList()) {
            node.getList().sort();
        }
        return node;
    }

    @Deprecated
    public ENode sort(ENode current, String call) throws ENodeCastException {
        return this.nMinimize(this.nSort(current, call));
    }

    public ENode nSort(ENode current, String call) throws ENodeCastException {
        if (!current.isList()) {
            return current;
        }
        TemplateExpression expr = this.compileExpression(call);
        if (expr == null) {
            return current;
        }
        ENode[][] elementsWithSortKeys = this.attachSortKeys(current.getList(), expr);
        Arrays.sort(elementsWithSortKeys, new Comparator<ENode[]>(){

            @Override
            public int compare(ENode[] pair1, ENode[] pair2) {
                ENode key1 = pair1[1];
                ENode key2 = pair2[1];
                return key1.compareTo(key2);
            }
        });
        ENodeList result = new ENodeList();
        ENode[][] eNodeArray = elementsWithSortKeys;
        int n = elementsWithSortKeys.length;
        int n2 = 0;
        while (n2 < n) {
            ENode[] elementsWithSortKey = eNodeArray[n2];
            result.add(elementsWithSortKey[0]);
            ++n2;
        }
        return new ENode(result, current);
    }

    private ENode[][] attachSortKeys(ENodeList elements, TemplateExpression expr) throws ENodeCastException {
        ENode[][] elementsWithSortKeys = new ENode[elements.size()][2];
        int i = 0;
        while (i < elementsWithSortKeys.length) {
            ENode element = elements.get(i);
            ENode sortKey = this.evaluate(element, expr);
            elementsWithSortKeys[i] = new ENode[]{element, sortKey};
            ++i;
        }
        return elementsWithSortKeys;
    }

    private TemplateExpression compileExpression(String call) {
        int pos = this.getBegin();
        call = call.replaceAll("'", "\\\"");
        try {
            return TemplateExpression.fromString(this.computeCall(pos, call), new Int2(pos, pos + call.length()), this.script);
        }
        catch (TemplateSyntaxException templateSyntaxException) {
            return null;
        }
    }

    private ENode evaluate(ENode current, TemplateExpression expr) {
        try {
            return expr.evaluate(current, this.script, LaunchManager.create("run", true));
        }
        catch (ENodeException eNodeException) {
            return new ENode(ENode.EMPTY, current);
        }
        catch (FactoryException factoryException) {
            return new ENode(ENode.EMPTY, current);
        }
    }
}

