/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.scripts;

import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxException;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.gen.template.scripts.ScriptDescriptor;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.TextSearch;

public class ScriptDescriptorFactory {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ScriptDescriptor createScriptDescriptor(String text, IScript script, Int2 limits) throws TemplateSyntaxException {
        String templateType = null;
        String templateName = null;
        String templateDescription = null;
        Int2 limitsFileTemplate = null;
        Int2 limitsPostExpression = null;
        Int2[] properties = TextSearch.getDefaultSearch().splitPositionsIn(text, limits.b(), limits.e(), TemplateConstants.SCRIPT_PROPERTIES_SEPARATORS, false, TemplateConstants.SPEC, TemplateConstants.INHIBS_SCRIPT_DECLA);
        int i = 0;
        while (i < properties.length) {
            String key = text.substring(properties[i].b(), properties[i].e());
            if (i + 1 >= properties.length) throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.MissingKeyValue", new Object[]{key}), script, properties[i].e());
            String value = text.substring(properties[i + 1].b(), properties[i + 1].e());
            if (value.length() < 2 || !value.startsWith(TemplateConstants.LITERAL[0]) || !value.endsWith(TemplateConstants.LITERAL[1])) throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.InvalidKeyValue", new Object[]{key}), script, properties[i].e());
            value = value.substring(1, value.length() - 1);
            if (key.equals(TemplateConstants.SCRIPT_TYPE)) {
                templateType = value;
            } else if (key.equals(TemplateConstants.SCRIPT_NAME)) {
                templateName = value;
            } else if (key.equals(TemplateConstants.SCRIPT_DESC)) {
                templateDescription = value;
            } else if (key.equals(TemplateConstants.SCRIPT_FILE)) {
                limitsFileTemplate = new Int2(properties[i + 1].b() + 1, properties[i + 1].e() - 1);
            } else {
                if (!key.equals(TemplateConstants.SCRIPT_POST)) throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.InvalidKey", new Object[]{key}), script, properties[i].b());
                limitsPostExpression = new Int2(properties[i + 1].b() + 1, properties[i + 1].e() - 1);
            }
            i += 2;
        }
        if (templateType == null) {
            throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.MissingType"), script, limits.b());
        }
        if (templateName == null) {
            throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.MissingName"), script, limits.b());
        }
        ScriptDescriptor res = new ScriptDescriptor(templateType, templateName, templateDescription, limitsFileTemplate, limitsPostExpression);
        res.setPos(limits);
        return res;
    }

    public Int2 searchScriptRegion(String text, String typeToSearch, String nameToSearch) {
        TemplateConstants.initConstants(text);
        ScriptDescriptor descriptor = null;
        int b = 0;
        Int2 end = new Int2(0, 0);
        while (end.e() > -1 && end.e() < text.length()) {
            Int2 begin = TextSearch.getDefaultSearch().indexOf(text, TemplateConstants.SCRIPT_BEGIN, end.e(), null, TemplateConstants.INHIBS_SCRIPT_CONTENT);
            if (begin.b() > -1) {
                if (descriptor != null && typeToSearch.equals(descriptor.getType()) && nameToSearch.equals(descriptor.getName())) {
                    return new Int2(b, begin.b());
                }
                end = TextSearch.getDefaultSearch().blockIndexEndOf(text, TemplateConstants.SCRIPT_BEGIN, TemplateConstants.SCRIPT_END, begin.b(), false, TemplateConstants.SPEC, TemplateConstants.INHIBS_SCRIPT_DECLA);
                if (end.e() == -1) {
                    descriptor = null;
                    continue;
                }
                try {
                    descriptor = this.createScriptDescriptor(text, null, new Int2(begin.e(), end.b()));
                    b = begin.b();
                }
                catch (TemplateSyntaxException templateSyntaxException) {
                    descriptor = null;
                }
                continue;
            }
            if (descriptor != null && typeToSearch.equals(descriptor.getType()) && nameToSearch.equals(descriptor.getName())) {
                return new Int2(b, text.length());
            }
            end = new Int2(text.length(), text.length());
        }
        return Int2.NOT_FOUND;
    }
}

