/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.tools;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sirius.query.legacy.tools.resources.AcceleoPlugin;
import org.osgi.framework.BundleContext;

public class AcceleoToolsPlugin
extends AcceleoPlugin {
    private static AcceleoToolsPlugin plugin;
    private ResourceBundle resourceBundle;
    private int errorsCount = 0;
    private int warningsCount = 0;

    @Override
    public String getID() {
        return "org.eclipse.sirius.query.legacy.tools";
    }

    public AcceleoToolsPlugin() {
        plugin = this;
    }

    public int getAcceleoLogCount(int lowestSeverity) {
        if (lowestSeverity == 4) {
            return this.errorsCount;
        }
        if (lowestSeverity == 2) {
            return this.warningsCount + this.errorsCount;
        }
        return 0;
    }

    public void newAcceleoLog(IStatus status) {
        if (status.getSeverity() == 4) {
            ++this.errorsCount;
        } else if (status.getSeverity() == 2) {
            ++this.warningsCount;
        }
    }

    public void newWarning() {
        ++this.warningsCount;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
    }

    public static AcceleoToolsPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = AcceleoToolsPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.sirius.query.legacy.tools.AcceleoToolsPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }
}

