/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util.pattern.helper;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.BooleanPropertyValue;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyValue;
import org.polarsys.capella.core.data.capellacore.FloatPropertyValue;
import org.polarsys.capella.core.data.capellacore.IntegerPropertyValue;
import org.polarsys.capella.core.data.capellacore.PropertyValueGroup;
import org.polarsys.capella.core.data.capellacore.PropertyValuePkg;
import org.polarsys.capella.core.data.capellacore.StringPropertyValue;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;

public class PropertyValueHelper {
    private PropertyValueHelper() {
    }

    public static String getStringValue(AbstractPropertyValue propertyValue) {
        String value = "";
        if (propertyValue instanceof EnumerationPropertyValue && ((EnumerationPropertyValue)propertyValue).getValue() != null) {
            value = ((EnumerationPropertyValue)propertyValue).getValue().getName();
        }
        if (propertyValue instanceof BooleanPropertyValue) {
            String string = value = ((BooleanPropertyValue)propertyValue).isValue() ? "True" : "False";
        }
        if (propertyValue instanceof StringPropertyValue) {
            value = ((StringPropertyValue)propertyValue).getValue();
        }
        if (propertyValue instanceof IntegerPropertyValue) {
            value = Integer.toString(((IntegerPropertyValue)propertyValue).getValue());
        }
        if (propertyValue instanceof FloatPropertyValue) {
            value = Float.toString(((FloatPropertyValue)propertyValue).getValue());
        }
        return value;
    }

    public static String getPVTable(CapellaElement element, int level, String projectName, String outputFolder) {
        StringBuilder result = new StringBuilder();
        EList appliedList = element.getAppliedPropertyValues();
        EList ownedList = element.getOwnedPropertyValues();
        BasicEList allPVList = new BasicEList();
        allPVList.addAll((Collection)appliedList.stream().filter(pv -> PropertyValueHelper.isInSystemEngineering((EObject)pv) || PropertyValueHelper.isInExternalPVPackage((EObject)pv)).collect(Collectors.toList()));
        allPVList.addAll((Collection)ownedList.stream().filter(arg_0 -> PropertyValueHelper.lambda$1((EList)allPVList, arg_0)).filter(pv -> PropertyValueHelper.isInSystemEngineering((EObject)pv) || PropertyValueHelper.isInExternalPVPackage((EObject)pv)).collect(Collectors.toList()));
        for (AbstractPropertyValue propertyValue : allPVList) {
            String basicname = propertyValue.getName();
            StringBuilder name = new StringBuilder();
            int i = 0;
            while (i < level) {
                name.append("&emsp;");
                ++i;
            }
            name.append(CapellaServices.getImageLinkFromElement((EObject)propertyValue, projectName, outputFolder));
            name.append(" ");
            name.append(basicname);
            String value = PropertyValueHelper.getStringValue(propertyValue);
            String description = propertyValue.getDescription();
            description = StringUtil.transformAREFString((EObject)propertyValue, description, projectName, outputFolder);
            String relation = "";
            if (ownedList.contains((Object)propertyValue)) {
                relation = String.valueOf(relation) + "Contained";
                if (appliedList.contains((Object)propertyValue)) {
                    relation = String.valueOf(relation) + " &amp; Applied";
                }
            } else {
                relation = String.valueOf(relation) + "Applied";
            }
            result.append(PropertyValueHelper.getPVRow(relation, name, value, description));
        }
        return result.toString();
    }

    public static String getPVGTable(CapellaElement element, int level, String projectName, String outputFolder) {
        BasicEList emptyList = new BasicEList();
        return PropertyValueHelper.getPVGTable(element, level, projectName, outputFolder, (List<CapellaElement>)emptyList);
    }

    public static String getPVGTable(CapellaElement element, int level, String projectName, String outputFolder, List<CapellaElement> alreadyGeneratedElements) {
        StringBuilder result = new StringBuilder();
        EList appliedGroupList = element.getAppliedPropertyValueGroups();
        EList ownedGroupList = element.getOwnedPropertyValueGroups();
        BasicEList allGroupList = new BasicEList();
        allGroupList.addAll((Collection)appliedGroupList.stream().filter(group -> PropertyValueHelper.isInSystemEngineering((EObject)group) || PropertyValueHelper.isInExternalPVPackage((EObject)group)).collect(Collectors.toList()));
        allGroupList.addAll((Collection)ownedGroupList.stream().filter(arg_0 -> PropertyValueHelper.lambda$4((EList)allGroupList, arg_0)).filter(group -> PropertyValueHelper.isInSystemEngineering((EObject)group) || PropertyValueHelper.isInExternalPVPackage((EObject)group)).collect(Collectors.toList()));
        for (PropertyValueGroup group2 : allGroupList) {
            String name = group2.getName();
            StringBuilder gname = new StringBuilder();
            int i = 0;
            while (i < level) {
                gname.append("&emsp;");
                ++i;
            }
            gname.append(CapellaServices.getImageLinkFromElement((EObject)group2, projectName, outputFolder));
            gname.append(" ");
            gname.append(name);
            String gvalue = "";
            String gdescription = group2.getDescription();
            gdescription = StringUtil.transformAREFString((EObject)group2, gdescription, projectName, outputFolder);
            String grelation = "";
            if (ownedGroupList.contains((Object)group2)) {
                grelation = String.valueOf(grelation) + "Contained";
                if (appliedGroupList.contains((Object)group2)) {
                    grelation = String.valueOf(grelation) + " &amp; Applied";
                }
            } else {
                grelation = String.valueOf(grelation) + "Applied";
            }
            result.append(PropertyValueHelper.getPVRow(grelation, gname, gvalue, gdescription));
            alreadyGeneratedElements.add(element);
            if (alreadyGeneratedElements.contains(group2)) continue;
            String tablePV = PropertyValueHelper.getPVTable((CapellaElement)group2, level + 1, projectName, outputFolder);
            result.append(tablePV);
            String tablePVG = PropertyValueHelper.getPVGTable((CapellaElement)group2, level + 1, projectName, outputFolder, alreadyGeneratedElements);
            result.append(tablePVG);
        }
        return result.toString();
    }

    public static boolean hasAppliedOrOwnedPropertyValues(CapellaElement element) {
        EList appliedPVList = element.getAppliedPropertyValues();
        EList appliedPVGList = element.getAppliedPropertyValueGroups();
        EList ownedPVList = element.getOwnedPropertyValues();
        EList ownedPVGList = element.getOwnedPropertyValueGroups();
        return !appliedPVList.isEmpty() || !appliedPVGList.isEmpty() || !ownedPVList.isEmpty() || !ownedPVGList.isEmpty();
    }

    private static String getPVRow(String relation, StringBuilder name, String value, String description) {
        StringBuilder result = new StringBuilder();
        result.append("<tr>");
        result.append("<td><i>");
        result.append(relation);
        result.append("</i></td>");
        result.append("<td>");
        result.append((CharSequence)name);
        result.append("</td>");
        result.append("<td>");
        result.append(value);
        result.append("</td>");
        result.append("<td>");
        result.append(description);
        result.append("</td>");
        result.append("</tr>");
        return result.toString();
    }

    private static boolean isInSystemEngineering(EObject elem) {
        EObject container = elem.eContainer();
        if (container != null) {
            return container instanceof SystemEngineering || PropertyValueHelper.isInSystemEngineering(container);
        }
        return false;
    }

    private static boolean isInExternalPVPackage(EObject elem) {
        if (elem.eContainer() != null) {
            if (elem.eContainer() instanceof AbstractPropertyValue || elem.eContainer() instanceof PropertyValueGroup || elem.eContainer() instanceof PropertyValuePkg) {
                return PropertyValueHelper.isInExternalPVPackage(elem.eContainer());
            }
            if (elem.eContainer() instanceof Project) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$1(EList eList, AbstractPropertyValue pv) {
        return !eList.contains((Object)pv);
    }

    private static /* synthetic */ boolean lambda$4(EList eList, PropertyValueGroup group) {
        return !eList.contains((Object)group);
    }
}

