/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.core.properties.fields;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.core.properties.Messages;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.helpers.LockHelper;

public class BasicElementGroup
extends AbstractSemanticField {
    protected Text nameTextField;
    protected Text summaryTextField;

    public BasicElementGroup(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        this(parent, widgetFactory, true, true);
    }

    public BasicElementGroup(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, boolean hasNameField, boolean hasSummaryField) {
        super(widgetFactory);
        Group textGroup = widgetFactory.createGroup(parent, "");
        textGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        textGroup.setLayoutData((Object)gd);
        if (hasNameField) {
            this.nameTextField = this.createTextField(textGroup, Messages.getString("NamedElement.NameLabel"));
        }
        if (hasSummaryField) {
            this.summaryTextField = this.createTextField(textGroup, Messages.getString("NamedElement.SummaryLabel"));
        }
    }

    private Text createTextField(Group textGroup, String textLabel) {
        this.widgetFactory.createCLabel((Composite)textGroup, textLabel);
        Text textField = this.widgetFactory.createText((Composite)textGroup, "");
        textField.addFocusListener((FocusListener)this);
        textField.addKeyListener((KeyListener)this);
        GridData gd = new GridData(768);
        gd.widthHint = 150;
        gd.heightHint = 20;
        textField.setLayoutData((Object)gd);
        return textField;
    }

    public void loadData(EObject semanticElement) {
        this.loadData(semanticElement, null);
        if (semanticElement != null) {
            if (this.nameTextField != null) {
                this.setTextValue(this.nameTextField, semanticElement, (EStructuralFeature)ModellingcorePackage.eINSTANCE.getAbstractNamedElement_Name());
            }
            if (this.summaryTextField != null) {
                this.setTextValue(this.summaryTextField, semanticElement, (EStructuralFeature)CapellacorePackage.eINSTANCE.getCapellaElement_Summary());
            }
        }
    }

    protected void fillTextField(Text textField) {
        if (textField.equals(this.nameTextField)) {
            this.setDataValue(this.semanticElement, (EStructuralFeature)ModellingcorePackage.eINSTANCE.getAbstractNamedElement_Name(), this.nameTextField.getText());
        } else if (textField.equals(this.summaryTextField)) {
            this.setDataValue(this.semanticElement, (EStructuralFeature)CapellacorePackage.eINSTANCE.getCapellaElement_Summary(), this.summaryTextField.getText());
        }
    }

    public void clearNameField() {
        if (this.nameTextField != null) {
            this.setDataValue(this.semanticElement, (EStructuralFeature)ModellingcorePackage.eINSTANCE.getAbstractNamedElement_Name(), "");
            this.nameTextField.setText("");
        }
    }

    public void enableNameField(boolean enabled) {
        if (this.nameTextField != null && !this.nameTextField.isDisposed()) {
            this.nameTextField.setEnabled(enabled);
        }
    }

    public void enableSummaryField(boolean enabled) {
        if (this.summaryTextField != null && !this.summaryTextField.isDisposed()) {
            this.summaryTextField.setEnabled(enabled);
        }
    }

    public void setEnabled(boolean enabled) {
        LockHelper.getInstance().enable((Control)this.nameTextField, enabled);
        LockHelper.getInstance().enable((Control)this.summaryTextField, enabled);
    }
}

