/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.ui.quickfix.generator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IMarkerResolution;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.model.helpers.SequenceMessageExt;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractMarkerResolutionGenerator;
import org.polarsys.capella.core.validation.ui.ide.quickfix.CapellaElementGoToResolver;
import org.polarsys.capella.core.validation.ui.ide.quickfix.DeleteCommandResolver;
import org.polarsys.capella.core.validation.ui.ide.quickfix.OpenAndShowInDiagramResolver;

public class DWF_DS_18_Resolutions
extends AbstractMarkerResolutionGenerator {
    protected IMarkerResolution[] doGetResolutions(IMarker marker) {
        NamedElement sequenceMessageTargetComponent;
        List modelElements = MarkerViewHelper.getModelElementsFromMarker((IMarker)marker);
        if (modelElements.size() < 1 || !(modelElements.get(0) instanceof SequenceMessage)) {
            return new IMarkerResolution[0];
        }
        SequenceMessage sequenceMessage = (SequenceMessage)modelElements.get(0);
        AbstractEventOperation invokedOperation = sequenceMessage.getInvokedOperation();
        if (invokedOperation == null) {
            return new IMarkerResolution[0];
        }
        ArrayList<Object> resolutions = new ArrayList<Object>();
        resolutions.add(new CapellaElementGoToResolver("Invoked Operation", (EObject)invokedOperation));
        NamedElement sequenceMessageSourceComponent = SequenceMessageExt.getSender((SequenceMessage)sequenceMessage);
        if (sequenceMessageSourceComponent != null) {
            resolutions.add(new CapellaElementGoToResolver("SequenceMessage source component", (EObject)sequenceMessageSourceComponent));
        }
        if ((sequenceMessageTargetComponent = SequenceMessageExt.getReceiver((SequenceMessage)sequenceMessage)) != null) {
            resolutions.add(new CapellaElementGoToResolver("SequenceMessage target component", (EObject)sequenceMessageTargetComponent));
        }
        Component exchangeSourceComponent = null;
        Component exchangeTargetComponent = null;
        if (invokedOperation instanceof FunctionalExchange) {
            AbstractFunction sourceFunction = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)((FunctionalExchange)invokedOperation));
            resolutions.add(new CapellaElementGoToResolver("Exchange source function", (EObject)sourceFunction));
            EList sourceFunctionAllocatingComponents = sourceFunction.getAllocationBlocks();
            if (!sourceFunctionAllocatingComponents.isEmpty()) {
                exchangeSourceComponent = (EObject)sourceFunction.getAllocationBlocks().get(0);
            }
            AbstractFunction targetFunction = FunctionalExchangeExt.getTargetFunction((FunctionalExchange)((FunctionalExchange)invokedOperation));
            resolutions.add(new CapellaElementGoToResolver("Exchange target function", (EObject)targetFunction));
            EList targetFunctionAllocatingComponents = targetFunction.getAllocationBlocks();
            if (!targetFunctionAllocatingComponents.isEmpty()) {
                exchangeTargetComponent = (EObject)targetFunction.getAllocationBlocks().get(0);
            }
        } else if (invokedOperation instanceof ComponentExchange) {
            exchangeSourceComponent = ComponentExchangeExt.getSourceComponent((ComponentExchange)((ComponentExchange)invokedOperation));
            exchangeTargetComponent = ComponentExchangeExt.getTargetComponent((ComponentExchange)((ComponentExchange)invokedOperation));
        }
        if (exchangeSourceComponent != null) {
            resolutions.add(new CapellaElementGoToResolver("Exchange source component", (EObject)exchangeSourceComponent));
        }
        if (exchangeTargetComponent != null) {
            resolutions.add(new CapellaElementGoToResolver("Exchange target component", (EObject)exchangeTargetComponent));
        }
        EObject scenario = sequenceMessage.eContainer();
        resolutions.add(new OpenAndShowInDiagramResolver(scenario, (EObject)sequenceMessage));
        Object elementToDelete = sequenceMessageSourceComponent == null || sequenceMessageTargetComponent == null ? sequenceMessage : SequenceMessageExt.getStartedExecution((SequenceMessage)sequenceMessage);
        resolutions.add(new DeleteCommandResolver("Delete Sequence Message", elementToDelete));
        return resolutions.toArray(new IMarkerResolution[0]);
    }

    protected String getRuleId() {
        return "org.polarsys.capella.core.data.interaction.validation.DWF_DS_18";
    }
}

