/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.merge.scope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.impl.scopes.RootedModelScope;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.core.transition.common.merge.MiscUtil;
import org.polarsys.capella.core.transition.common.merge.scope.IModelScopeFilter;

public class PartialRootedModelScope
extends RootedModelScope {
    protected final Set<EObject> _inScope;

    public PartialRootedModelScope(Collection<? extends EObject> elements) {
        super(MiscUtil.getRoots(elements));
        this._inScope = new FHashSet(elements, IEqualityTester.BY_REFERENCE);
    }

    public boolean add(EObject element) {
        return this.add(element, false);
    }

    protected List<EObject> retains(List<EObject> object) {
        object.retainAll(this._inScope);
        return object;
    }

    public boolean add(EObject element, boolean includeChildren) {
        boolean result = true;
        if (!EcoreUtil.isAncestor(this.getContents(), (EObject)element)) {
            result = super.add(element);
        }
        if (result) {
            this._inScope.add(element);
            if (includeChildren) {
                this.addAllChildrenToScope(element, null);
            }
        }
        return result;
    }

    public boolean add(EObject source, EReference reference, EObject value) {
        boolean result;
        List values;
        EObject previouslyContainedValue = null;
        if (!reference.isMany() && reference.isContainment() && !(values = this.get(source, reference)).isEmpty()) {
            previouslyContainedValue = (EObject)values.get(0);
        }
        if (result = super.add(source, reference, value)) {
            if (previouslyContainedValue != null) {
                this._inScope.remove(previouslyContainedValue);
            }
            this._inScope.add(value);
        }
        return result;
    }

    public void build(IModelScopeFilter filter) {
        this._inScope.clear();
        for (EObject root : super.getContents()) {
            if (filter != null && !filter.accepts(root)) continue;
            this._inScope.add(root);
            this.addAllChildrenToScope(root, filter);
        }
        ArrayList<EObject> scopeNotFiltered = new ArrayList<EObject>(this._inScope);
        for (EObject elt : scopeNotFiltered) {
            if (this.isMeaningfulWithin(elt, scopeNotFiltered)) continue;
            this._inScope.remove(elt);
        }
    }

    protected List<EObject> get(EObject source, EReference reference, boolean resolveProxies) {
        List originalValues = super.get(source, reference, resolveProxies);
        FArrayList result = new FArrayList((Collection)originalValues, IEqualityTester.BY_REFERENCE);
        this.retains((List<EObject>)result);
        return result;
    }

    protected void addAllChildrenToScope(EObject element, IModelScopeFilter filter) {
        TreeIterator technicalIterator = element.eAllContents();
        while (technicalIterator.hasNext()) {
            EObject child = (EObject)technicalIterator.next();
            if (filter == null || filter.accepts(child)) {
                this._inScope.add(child);
                continue;
            }
            technicalIterator.prune();
        }
    }

    public boolean covers(EObject element) {
        return this._inScope.contains(element);
    }

    public List<EObject> getContents() {
        FArrayList result = new FArrayList(IEqualityTester.BY_REFERENCE);
        result.addAll(super.getContents());
        this.retains((List<EObject>)result);
        return Collections.unmodifiableList(result);
    }

    public List<EObject> getContents(EObject element) {
        FArrayList result = new FArrayList((Collection)super.getContents(element), IEqualityTester.BY_REFERENCE);
        this.retains((List<EObject>)result);
        return Collections.unmodifiableList(result);
    }

    public boolean remove(EObject element) {
        boolean result = super.remove(element);
        this.removeFromScope(element);
        return result;
    }

    public void removeFromScope(EObject element) {
        this._inScope.remove(element);
        TreeIterator technicalIterator = element.eAllContents();
        while (technicalIterator.hasNext()) {
            EObject child = (EObject)technicalIterator.next();
            this._inScope.remove(child);
        }
    }

    protected boolean isMeaningfulWithin(EObject element, Collection<? extends EObject> contexts) {
        return true;
    }
}

