/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.transposer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarsys.capella.common.utils.graph.CycleDetectionUtils;
import org.polarsys.capella.common.utils.graph.IDirectedGraph;
import org.polarsys.capella.core.transition.common.exception.TransitionException;
import org.polarsys.capella.core.transition.common.transposer.ExtendedTopologicalSorter;
import org.polarsys.kitalpha.transposer.analyzer.graph.Edge;
import org.polarsys.kitalpha.transposer.analyzer.graph.Graph;
import org.polarsys.kitalpha.transposer.analyzer.graph.GraphElement;
import org.polarsys.kitalpha.transposer.analyzer.graph.Vertex;
import org.polarsys.kitalpha.transposer.scheduler.api.IScheduler;
import org.polarsys.kitalpha.transposer.scheduler.api.ITransposerTask;

public class ExtendedScheduler
implements IScheduler {
    protected ExtendedTopologicalSorter topologicalSorter;
    public Graph model;
    private Set<Vertex<?>> visited;
    private Set<Vertex<?>> notVisited;
    private Set<Edge<?>> backTracks;
    private List<ITransposerTask<Vertex<?>>> scheduleResult;
    private Set<LinkedList<Edge<?>>> foundCycles;

    public Graph getModel() {
        return this.model;
    }

    protected ExtendedTopologicalSorter getTopologicalSorter() {
        return this.topologicalSorter;
    }

    public void setModel(Graph model) {
        this.model = model;
    }

    protected void setTopologicalSorter(ExtendedTopologicalSorter topologicalScheduler) {
        this.topologicalSorter = topologicalScheduler;
    }

    public ExtendedScheduler() {
        this.init();
    }

    public ExtendedScheduler(Graph modelp) {
        this.setModel(modelp);
        this.init();
    }

    private void depthFirstVisitGlobal() {
        final List<GraphElement<?>> summits = this.getAllModelSummits();
        IDirectedGraph iDirectedGraph = new IDirectedGraph<GraphElement<?>>(){

            public Iterator<GraphElement<?>> getSucessors(GraphElement<?> source) {
                if (source instanceof Vertex) {
                    ExtendedScheduler.this.setVisited((Vertex)source);
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(((Vertex)source).getOutgoingEdges());
                    return arrayList.iterator();
                }
                Vertex target = ((Edge)source).getTarget();
                Iterator<Vertex> iterator = Collections.singletonList(target).iterator();
                return iterator;
            }

            public Iterator<GraphElement<?>> getNodes() {
                return summits.iterator();
            }
        };
        List cycles = CycleDetectionUtils.getCycles((IDirectedGraph)iDirectedGraph);
        for (List cycle : cycles) {
            LinkedList<Edge> edgeCycle = new LinkedList<Edge>();
            for (GraphElement graphElement : cycle) {
                if (!(graphElement instanceof Edge)) continue;
                edgeCycle.add((Edge)graphElement);
            }
            if (edgeCycle.isEmpty()) continue;
            this.foundCycles.add(edgeCycle);
        }
        this.identifyBacktracksFromCycles();
    }

    private List<GraphElement<?>> getAllModelSummits() {
        ArrayList summits = new ArrayList();
        for (Vertex vertex : this.model.getVertices()) {
            if (!vertex.isHotSpot()) continue;
            summits.add((GraphElement<?>)vertex);
        }
        return summits;
    }

    public Set<Edge<?>> getBackTracks() {
        return this.backTracks;
    }

    public Set<LinkedList<Edge<?>>> getFoundCycles() {
        return this.foundCycles;
    }

    public Set<Vertex<?>> getNotVisited() {
        return this.notVisited;
    }

    public List<ITransposerTask<Vertex<?>>> getScheduleResult() {
        return this.scheduleResult;
    }

    public Set<Vertex<?>> getVisited() {
        return this.visited;
    }

    private void identifyBacktracksFromCycles() {
        for (LinkedList<Edge<?>> currentCycle : this.foundCycles) {
            boolean bl;
            boolean bl2;
            if (currentCycle.size() == 1) {
                for (Edge edge : currentCycle) {
                    if (this.backTracks.contains(edge)) continue;
                    this.backTracks.add(edge);
                }
                continue;
            }
            if (currentCycle.size() == 2) {
                for (Edge edge : currentCycle) {
                    if (this.backTracks.contains(edge) || edge.isCritical()) continue;
                    this.backTracks.add(edge);
                }
                continue;
            }
            boolean bl3 = false;
            for (Edge edge : currentCycle) {
                if (!this.backTracks.contains(edge)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            boolean bl4 = false;
            Iterator iterator = currentCycle.iterator();
            while (iterator.hasNext() && !bl) {
                Edge currentEdge = (Edge)iterator.next();
                if (currentEdge.isCritical()) continue;
                this.backTracks.add(currentEdge);
                bl = true;
            }
            if (bl) continue;
            System.out.println("Unbreakable cycle " + currentCycle.size() + " elements)");
        }
    }

    private void init() {
        this.visited = new HashSet();
        this.notVisited = new HashSet();
        this.backTracks = new HashSet();
        this.foundCycles = new HashSet();
        this.scheduleResult = new LinkedList();
    }

    public void dispose() {
        this.visited = null;
        this.notVisited = null;
        this.backTracks = null;
        this.foundCycles = null;
        this.scheduleResult = null;
    }

    private boolean isVisited(Vertex<?> t) {
        return this.visited.contains(t);
    }

    private void markAllAsNotVisited() {
        this.notVisited.addAll((Collection<Vertex<?>>)this.model.getVertices());
        this.visited.clear();
    }

    public void schedule(Comparator<Vertex<?>> comparator, IProgressMonitor monitor) {
        this.init();
        this.markAllAsNotVisited();
        if (monitor != null) {
            monitor.beginTask("Transposer Scheduling", 3);
            monitor.subTask("Cycle search");
        }
        this.depthFirstVisitGlobal();
        HashSet vertices = new HashSet();
        vertices.addAll((Collection<Vertex<?>>)this.model.getVertices());
        try {
            this.setTopologicalSorter(new ExtendedTopologicalSorter(vertices, this.backTracks));
            this.getTopologicalSorter().sort(monitor);
            this.scheduleResult = this.getTopologicalSorter().getWork(monitor);
            this.getTopologicalSorter().dispose();
        }
        catch (TransitionException e) {
            e.printStackTrace();
        }
    }

    private void setVisited(Vertex<?> t) {
        if (!this.isVisited(t)) {
            this.visited.add(t);
            this.notVisited.remove(t);
        }
    }
}

