/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.generic.gdiffdata.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.diffmerge.generic.api.IComparison;
import org.eclipse.emf.diffmerge.generic.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.IMergePolicy;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GMatch;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GReferenceValuePresence;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GdiffdataPackage;
import org.eclipse.emf.diffmerge.generic.gdiffdata.impl.GValuePresenceImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public abstract class GReferenceValuePresenceImpl<E, A, R>
extends GValuePresenceImpl<E, A, R>
implements GReferenceValuePresence<E, A, R> {
    protected GMatch<E, A, R> valueMatch;

    protected GReferenceValuePresenceImpl() {
    }

    public GReferenceValuePresenceImpl(GMatch<E, A, R> elementMatch_p, R reference_p, E value_p, GMatch<E, A, R> valueMatch_p, Role presenceRole_p, boolean isOrder_p) {
        super(elementMatch_p, presenceRole_p, isOrder_p);
        assert (valueMatch_p != null || value_p != null);
        this.setValueMatch(valueMatch_p);
        this.setValue(value_p != null ? value_p : valueMatch_p.get(presenceRole_p));
        assert (this.getValue() != null);
        this.setReference(reference_p);
        this.elementMatch.addRelatedDifference(this);
    }

    @Override
    protected EClass eStaticClass() {
        return GdiffdataPackage.Literals.GREFERENCE_VALUE_PRESENCE;
    }

    @Override
    public GMatch<E, A, R> getValueMatch() {
        if (this.valueMatch != null && this.valueMatch.eIsProxy()) {
            InternalEObject oldValueMatch = (InternalEObject)this.valueMatch;
            this.valueMatch = (GMatch)this.eResolveProxy(oldValueMatch);
            if (this.valueMatch != oldValueMatch && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 13, (Object)oldValueMatch, this.valueMatch));
            }
        }
        return this.valueMatch;
    }

    public GMatch<E, A, R> basicGetValueMatch() {
        return this.valueMatch;
    }

    @Override
    public void setValueMatch(GMatch<E, A, R> newValueMatch) {
        GMatch<E, A, R> oldValueMatch = this.valueMatch;
        this.valueMatch = newValueMatch;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldValueMatch, this.valueMatch));
        }
    }

    @Override
    public abstract R getFeature();

    @Override
    public abstract void setReference(R var1);

    @Override
    public abstract void setValue(E var1);

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 13: {
                if (resolve) {
                    return this.getValueMatch();
                }
                return this.basicGetValueMatch();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 13: {
                this.setValueMatch((GMatch)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 13: {
                this.setValueMatch(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 13: {
                return this.valueMatch != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public IReferenceValuePresence<E> getOpposite() {
        IMatch valueMatch;
        IReferenceValuePresence<Object> result = null;
        Object opposite = this.getPresenceScope().mGetOppositeReference(this.getFeature());
        if (opposite != null && (valueMatch = this.getValueMatch()) != null) {
            result = valueMatch.getReferenceValueDifference(opposite, this.getElementMatch().get(this.getPresenceRole()));
        }
        return result;
    }

    @Override
    public IReferenceValuePresence<E> getSymmetrical() {
        IReferenceValuePresence result = null;
        if (!this.isManyFeature()) {
            Collection candidates = this.getElementMatch().getReferenceDifferences(this.getFeature());
            assert (candidates.size() <= 2);
            for (IReferenceValuePresence candidate : candidates) {
                if (candidate.getPresenceRole() != this.getAbsenceRole()) continue;
                result = candidate;
                break;
            }
        } else if (this.isOrder()) {
            result = this.getElementMatch().getReferenceOrderDifference(this.getFeature(), this.getAbsenceRole());
        }
        return result;
    }

    @Override
    public IReferenceValuePresence<E> getSymmetricalOwnership() {
        IReferenceValuePresence result = null;
        IMatch valueMatch = this.getValueMatch();
        if (valueMatch != null) {
            result = valueMatch.getOwnershipDifference(this.getAbsenceRole());
        }
        return result;
    }

    protected boolean hasStrongerOpposite() {
        boolean result = false;
        if (this.isManyFeature()) {
            ITreeDataScope presenceScope = this.getPresenceScope();
            Object opposite = presenceScope.mGetOppositeReference(this.getFeature());
            result = opposite != null && !presenceScope.mIsManyReference(opposite);
        }
        return result;
    }

    @Override
    public boolean isContainment() {
        return this.getPresenceScope().mIsContainmentReference(this.getFeature());
    }

    @Override
    public boolean isManyFeature() {
        return this.getPresenceScope().mIsManyReference(this.getFeature());
    }

    @Override
    public boolean isOppositeOf(IReferenceValuePresence<E> peer_p) {
        return this.getPresenceRole() == peer_p.getPresenceRole() && this.getPresenceScope().mGetOppositeReference(this.getFeature()) == peer_p.getFeature() && this.getElementMatch() == peer_p.getValueMatch() && this.getValueMatch() == peer_p.getElementMatch();
    }

    @Override
    public boolean isChangeableFeature() {
        return this.getPresenceScope().mIsChangeableReference(this.getFeature());
    }

    @Override
    public boolean isOutOfScope() {
        return this.getValueMatch() == null;
    }

    @Override
    public boolean isOwnership() {
        return !this.isOrder() && this.isContainment();
    }

    @Override
    public boolean isSymmetricalOwnershipTo(IReferenceValuePresence<E> peer_p) {
        return this.getAbsenceRole() == peer_p.getPresenceRole() && this.isOwnership() && peer_p.isOwnership() && this.getValueMatch() != null && this.getValueMatch() == peer_p.getValueMatch();
    }

    @Override
    public boolean isUnrelatedToContainmentTree() {
        return !this.isOwnership();
    }

    @Override
    protected void mergeOrder() {
        Object sourceHolder = this.getHolder();
        Object destinationHolder = this.getMatchOfHolder();
        R reference = this.getFeature();
        assert (sourceHolder != null && destinationHolder != null);
        assert (this.getFeature() != null);
        IEditableTreeDataScope absenceScope = this.getAbsenceScope();
        ITreeDataScope presenceScope = this.getPresenceScope();
        IMergePolicy mergePolicy = this.getComparison().getLastMergePolicy();
        Role destination = this.getAbsenceRole();
        IMatch holderMatch = this.getElementMatch();
        IComparison owningComparison = this.getComparison();
        List sourceValues = presenceScope.getReferenceValues(sourceHolder, reference);
        int i = sourceValues.size() - 1;
        while (i >= 0) {
            boolean coverValue;
            Object sourceValue = sourceValues.get(i);
            IMatch valueMatch = owningComparison.getMapping().getMatchFor(sourceValue, destination.opposite());
            boolean bl = coverValue = valueMatch != null || this.getFeature() != null && this.getComparison().getLastDiffPolicy().coverOutOfScopeValue(sourceValue, this.getFeature(), presenceScope);
            if (coverValue) {
                int index;
                Object destinationValue;
                Object e = destinationValue = valueMatch != null ? valueMatch.get(destination) : sourceValue;
                if (destinationValue != null && (index = mergePolicy.getDesiredValuePosition(owningComparison, destination, holderMatch, reference, sourceValue)) >= 0) {
                    List updatedDestinationValues = absenceScope.getReferenceValues(destinationHolder, reference);
                    int oldIndex = updatedDestinationValues.indexOf(destinationValue);
                    absenceScope.moveReferenceValue(destinationHolder, reference, index, oldIndex);
                }
            }
            --i;
        }
    }

    @Override
    protected void mergeValueAddition() {
        int index;
        boolean cloned;
        Object destinationValue;
        IEditableTreeDataScope<Object> absenceScope = this.getAbsenceScope();
        ITreeDataScope presenceScope = this.getPresenceScope();
        Object destinationHolder = this.getMatchOfHolder();
        IMatch valueMatch = this.getValueMatch();
        if (valueMatch == null) {
            destinationValue = this.getValue();
            cloned = false;
        } else if (valueMatch.isPartial()) {
            destinationValue = this.getComparison().getMapping().completeMatch(valueMatch);
            cloned = true;
        } else {
            destinationValue = valueMatch.get(this.getAbsenceRole());
            cloned = false;
        }
        assert (destinationHolder != null && destinationValue != null);
        boolean actuallyAdded = absenceScope.addReferenceValue(destinationHolder, this.getFeature(), destinationValue);
        IDiffPolicy<Object> diffPolicy = this.getComparison().getLastDiffPolicy();
        IMergePolicy<Object> mergePolicy = this.getComparison().getLastMergePolicy();
        if (diffPolicy != null && actuallyAdded && diffPolicy.considerOrderedReference(this.getFeature(), absenceScope) && (index = mergePolicy.getDesiredValuePosition(this.getComparison(), this.getAbsenceRole(), this.getElementMatch(), this.getFeature(), this.getValue())) >= 0) {
            absenceScope.moveReferenceValue(destinationHolder, this.getFeature(), index, -1);
        }
        if (cloned && actuallyAdded) {
            mergePolicy.setID(this.getValue(), presenceScope, destinationValue, absenceScope);
        }
    }

    @Override
    protected final void mergeValueRemoval() {
        if (this.isOutOfScope()) {
            this.getPresenceScope().removeReferenceValue(this.getHolder(), this.getFeature(), this.getValue());
        } else {
            this.mergeValueRemovalWithinScope();
        }
    }

    protected void mergeValueRemovalWithinScope() {
        ITreeDataScope presenceScope = this.getPresenceScope();
        if (this.getSymmetrical() == null && (!this.hasStrongerOpposite() || this.getValueMatch().isPartial())) {
            Object valueElement = this.getValue();
            if (this.isOwnership()) {
                this.getElementMatch().getMapping().disconnect(this.getPresenceRole(), valueElement);
            }
            if (this.getFeature() != null) {
                presenceScope.removeReferenceValue(this.getHolder(), this.getFeature(), valueElement);
            } else {
                presenceScope.remove(valueElement);
            }
            if (this.isOwnership() && !this.getComparison().getLastMergePolicy().bindPresenceToOwnership(presenceScope)) {
                for (Object child : presenceScope.getContents(valueElement)) {
                    presenceScope.add(child);
                }
            }
        }
    }
}

