/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.dnd.drag;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drag.IDragSourceContext;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drag.IDragSourceListener;
import org.eclipse.swt.dnd.DragSourceEvent;

public abstract class AbstractDragSourceListener
implements IDragSourceListener {
    private WeakReference<IDragSourceContext> context = null;
    private final String[] transferIds;

    public AbstractDragSourceListener(String[] transferIdArray) {
        assert (transferIdArray != null) : "transferIdArray cannot be null";
        assert (transferIdArray.length > 0) : "transferIdArray cannot be empty";
        this.transferIds = transferIdArray;
    }

    @Override
    public final boolean isDraggable(IDragSourceContext cntxt) {
        this.context = new WeakReference<IDragSourceContext>(cntxt);
        return this.isDraggable();
    }

    @Override
    public final String[] getSupportingTransferIds() {
        return this.transferIds;
    }

    public final void dragStart(DragSourceEvent event) {
        event.doit = true;
    }

    public void dragSetData(DragSourceEvent event) {
    }

    public void dragFinished(DragSourceEvent event) {
    }

    protected final IDragSourceContext getContext() {
        if (this.context == null) {
            return null;
        }
        return (IDragSourceContext)this.context.get();
    }

    protected abstract boolean isDraggable();

    protected final Object[] combineArraysInList(List list, Object[] resultingArrayType) {
        List<Object> listEntry = null;
        Iterator it = list.iterator();
        ArrayList<Object> results = new ArrayList<Object>();
        while (it.hasNext()) {
            listEntry = Arrays.asList((Object[])it.next());
            results.addAll(listEntry);
        }
        return results.toArray(resultingArrayType);
    }
}

