/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.aird;

import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.UnresolvedReferenceException;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileMigrationService;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.xml.sax.Attributes;

public class SiriusMigrationContribution
extends AbstractMigrationContribution {
    public static final String SIRIUS_VERSION = "VERSION";
    HashMap<Resource, String> versions = null;

    protected void addVersion(Resource resource, String version) {
        if (this.versions == null) {
            this.versions = new HashMap();
        }
        this.versions.put(resource, version);
    }

    @Override
    public void newResource(Resource resource, MigrationContext context) {
        super.newResource(resource, context);
        if (CapellaResourceHelper.isAirdResource((URI)resource.getURI())) {
            String version = (String)((XMLResource)resource).getDefaultLoadOptions().get(SIRIUS_VERSION);
            this.addVersion(resource, version);
        }
    }

    private boolean isAirdResource(Resource resource) {
        return this.versions != null && this.versions.containsKey(resource);
    }

    private String getLoadedVersion(Resource resource) {
        if (this.versions != null) {
            return this.versions.get(resource);
        }
        return null;
    }

    @Override
    public void dispose(MigrationContext context) {
        super.dispose(context);
        if (this.versions != null) {
            this.versions.clear();
            this.versions = null;
        }
    }

    @Override
    public void dispose(ExecutionManager manager, ResourceSet resourceSet, MigrationContext context) {
        super.dispose(manager, resourceSet, context);
        if (this.versions != null) {
            this.versions.clear();
            this.versions = null;
        }
    }

    @Override
    public String getQName(EObject peekObject, String typeQName, EStructuralFeature feature, Resource resource, XMLHelper helper, MigrationContext context) {
        if ("viewpoint:DRepresentationContainer".equals(typeQName)) {
            return "viewpoint:DView";
        }
        return super.getQName(peekObject, typeQName, feature, resource, helper, context);
    }

    @Override
    public boolean ignoreSetFeatureValue(EObject peekObject, EStructuralFeature feature, Object value, int position, XMLResource resource, MigrationContext context) {
        return super.ignoreSetFeatureValue(peekObject, feature, value, position, resource, context);
    }

    @Override
    public void endElement(EObject peekEObject, Attributes attribs, String uri, String localName, String name, Resource resource, MigrationContext context) {
        if (this.isAirdResource(resource)) {
            String version = this.getLoadedVersion(resource);
            RepresentationsFileMigrationService.getInstance().postXMLEndElement((Object)peekEObject, attribs, uri, name, name, version);
        }
    }

    @Override
    public Object getValue(EObject peekObject, EStructuralFeature feature, Object value, int position, Resource resource, MigrationContext context) {
        if (this.isAirdResource(resource)) {
            String version = this.getLoadedVersion(resource);
            return RepresentationsFileMigrationService.getInstance().getValue(peekObject, feature, value, version);
        }
        return super.getValue(peekObject, feature, value, position, resource, context);
    }

    @Override
    public EStructuralFeature getFeature(EObject peekObject, EStructuralFeature feature, Resource resource, MigrationContext context) {
        return null;
    }

    @Override
    public void updateElement(EObject peekObject, String typeName, EObject result, EStructuralFeature feature, Resource resource, MigrationContext context) {
        if (this.isAirdResource(resource)) {
            String version = this.getLoadedVersion(resource);
            RepresentationsFileMigrationService.getInstance().updateCreatedObject(result, version);
        }
    }

    @Override
    public IStatus handleError(XMIException e, Resource resource, MigrationContext context) {
        if (e instanceof UnresolvedReferenceException) {
            return new Status(2, "org.polarsys.capella.core.data.migration", e.getMessage());
        }
        return null;
    }
}

