/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.sirius.validation.ddiagram;

import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.diagram.tools.internal.validation.constraints.ImagePathWrappingStatus;
import org.polarsys.capella.common.helpers.validation.ConstraintStatusDiagnostic;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public class ImagePathRemoveResolver
extends AbstractCapellaMarkerResolution {
    protected Logger _logger = ReportManagerRegistry.getInstance().subscribe("Model Validation");

    public boolean removeImagePathInRichText(final EObject eObject, String featurename, String imagePath, TransactionalEditingDomain ted) {
        EAttribute eAttribute;
        Object stringObj;
        boolean fixSucceeded = false;
        Optional<EAttribute> eAttributeOpt = eObject.eClass().getEAllAttributes().stream().filter(attr -> featurename.equals(attr.getName())).findFirst();
        if (eAttributeOpt.isPresent() && (stringObj = eObject.eGet((EStructuralFeature)(eAttribute = eAttributeOpt.get()))) instanceof String) {
            final String htmlText = (String)stringObj;
            final String imgRegex = "<img\\s+[^>]*?src\\s*=\\s*(\"|')" + imagePath + "(\"|')[^>]*?>";
            ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                protected void doExecute() {
                    String newHtmlText = htmlText.replaceAll(imgRegex, "");
                    eObject.eSet((EStructuralFeature)eAttribute, (Object)newHtmlText);
                }
            });
            fixSucceeded = true;
        }
        return fixSucceeded;
    }

    public void run(IMarker marker_p) {
        List modelElements = this.getModelElements(marker_p);
        if (modelElements.size() < 1) {
            return;
        }
        EObject target = (EObject)modelElements.get(0);
        Optional sessionOpt = Session.of((EObject)target);
        Diagnostic diagnostic = MarkerViewHelper.getDiagnostic((IMarker)marker_p);
        ImagePathWrappingStatus imagePathStatus = null;
        if (diagnostic instanceof ConstraintStatusDiagnostic && ((ConstraintStatusDiagnostic)diagnostic).getConstraintStatus() instanceof ImagePathWrappingStatus) {
            imagePathStatus = (ImagePathWrappingStatus)((ConstraintStatusDiagnostic)diagnostic).getConstraintStatus();
        }
        if (imagePathStatus != null && sessionOpt.isPresent()) {
            String notReachableImagePath = imagePathStatus.getNotReachableImagePath();
            TransactionalEditingDomain ted = ((Session)sessionOpt.get()).getTransactionalEditingDomain();
            boolean fixSucceeded = FileProvider.getDefault().exists((IPath)new Path(notReachableImagePath), sessionOpt.get());
            if (!fixSucceeded) {
                EAttribute eAttribute = imagePathStatus.getEAttribute();
                fixSucceeded = this.removeImagePathInRichText(target, eAttribute.getName(), notReachableImagePath, ted);
            }
            if (fixSucceeded) {
                try {
                    marker_p.delete();
                }
                catch (CoreException exception_p) {
                    this._logger.error((Object)("Exception while deleting marker : " + exception_p.toString()));
                }
            }
        }
    }
}

