/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.cs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.AbstractPathInvolvedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.LogicalComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.model.helpers.PhysicalPathExt;
import org.polarsys.capella.core.model.utils.ListExt;

public class GetAvailable_PhysicalPath_AllocatedComponentExchanges
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<EObject> getAvailableElements(CapellaElement element) {
        ArrayList<EObject> availableElements = new ArrayList<CapellaElement>();
        if (element instanceof PhysicalPath) {
            availableElements.addAll(this.getRule_MQRY_PhysicalPath_AllocatedComponentExchanges_12((PhysicalPath)element));
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_PhysicalPath_AllocatedComponentExchanges_12(PhysicalPath element) {
        AbstractType pc;
        AbstractPathInvolvedElement involvedElt;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        ArrayList<Component> terminalPCs = new ArrayList<Component>();
        for (PhysicalPathInvolvement first : PhysicalPathExt.getFlatFirstPhysicalPathInvolvments((PhysicalPath)element)) {
            involvedElt = first.getInvolvedElement();
            if (!(involvedElt instanceof Part) || !((pc = ((Part)involvedElt).getAbstractType()) instanceof Component) || terminalPCs.contains(pc)) continue;
            terminalPCs.add((Component)pc);
        }
        for (PhysicalPathInvolvement last : PhysicalPathExt.getFlatLastPhysicalPathInvolvments((PhysicalPath)element)) {
            involvedElt = last.getInvolvedElement();
            if (!(involvedElt instanceof Part) || !((pc = ((Part)involvedElt).getAbstractType()) instanceof Component) || terminalPCs.contains(pc)) continue;
            terminalPCs.add((Component)pc);
        }
        for (Component firstPC : terminalPCs) {
            for (Component lastPC : terminalPCs) {
                if (firstPC.equals(lastPC)) continue;
                for (CapellaElement exchange : this.getAvailableExchanges(firstPC, lastPC)) {
                    if (availableElements.contains(exchange)) continue;
                    availableElements.add(exchange);
                }
            }
        }
        return availableElements;
    }

    protected List<CapellaElement> getAvailableExchanges(Component sourceComponent, Component targetComponent) {
        AbstractType abstractType;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        ArrayList<Component> sourceDeployedElements = new ArrayList<Component>(1);
        ArrayList<Component> targetDeployedElements = new ArrayList<Component>(1);
        Collection sourceComponents = ComponentExt.getAllSubUsedComponents((Component)sourceComponent);
        sourceComponents.add(sourceComponent);
        Collection targetComponents = ComponentExt.getAllSubUsedComponents((Component)targetComponent);
        targetComponents.add(targetComponent);
        for (Component component : sourceComponents) {
            if (component instanceof SystemComponent) {
                sourceDeployedElements.add(component);
                continue;
            }
            if (component instanceof LogicalComponent) {
                sourceDeployedElements.addAll(LogicalComponentExt.getAllSubComponents((LogicalComponent)((LogicalComponent)component)));
                continue;
            }
            if (!(component instanceof PhysicalComponent)) continue;
            for (AbstractTypedElement abstractTypedElement : component.getAbstractTypedElements()) {
                if (!(abstractTypedElement instanceof Part)) continue;
                for (DeployableElement deployableElement : PartExt.getAllDeployableElements((Part)((Part)abstractTypedElement))) {
                    if (!(deployableElement instanceof Part) || !((abstractType = ((Part)deployableElement).getAbstractType()) instanceof Component)) continue;
                    sourceDeployedElements.add((Component)abstractType);
                }
            }
        }
        for (Component component : targetComponents) {
            if (component instanceof SystemComponent) {
                targetDeployedElements.add(component);
                continue;
            }
            if (component instanceof LogicalComponent) {
                targetDeployedElements.addAll(LogicalComponentExt.getAllSubComponents((LogicalComponent)((LogicalComponent)component)));
                continue;
            }
            if (!(component instanceof PhysicalComponent)) continue;
            for (AbstractTypedElement abstractTypedElement : component.getAbstractTypedElements()) {
                if (!(abstractTypedElement instanceof Part)) continue;
                for (DeployableElement deployableElement : PartExt.getAllDeployableElements((Part)((Part)abstractTypedElement))) {
                    if (!(deployableElement instanceof Part) || !((abstractType = ((Part)deployableElement).getAbstractType()) instanceof Component)) continue;
                    targetDeployedElements.add((Component)abstractType);
                }
            }
        }
        availableElements.addAll(PhysicalComponentExt.findConnectionsBetweenPhysicalComponentes(sourceDeployedElements, targetDeployedElements));
        availableElements.addAll(PhysicalComponentExt.findConnectionsBetweenPhysicalComponentes(targetDeployedElements, sourceDeployedElements));
        return availableElements;
    }
}

