/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.epbs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.model.utils.ListExt;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class GetAvailable_ConfigurationItem_RealizedPhysicalArtifacts
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<EObject> getAvailableElements(CapellaElement element) {
        SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)element);
        List<Object> availableElements = new ArrayList<EObject>();
        if (systemEngineering == null) {
            return availableElements;
        }
        if (element instanceof ConfigurationItem) {
            ConfigurationItem currentCI = (ConfigurationItem)element;
            availableElements.addAll(this.getRule_MQRY_ConfigurationItem_ImplementedPC_11(currentCI, systemEngineering));
            availableElements.addAll(this.getRule_MQRY_ConfigurationItem_ImplementedPLink_11(currentCI));
            availableElements.addAll(this.getRule_MQRY_ConfigurationItem_ImplementedPPort_11(currentCI));
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_ConfigurationItem_ImplementedPC_11(ConfigurationItem currentConfigurationItem, SystemEngineering systemEngineering) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        PhysicalArchitecture physicalArch = SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)systemEngineering);
        if (physicalArch != null) {
            availableElements.addAll(BlockArchitectureExt.getAllComponents((BlockArchitecture)physicalArch));
        }
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_ConfigurationItem_ImplementedPLink_11(ConfigurationItem configurationItem) {
        return this.getElementsFromBlockArchitecture(configurationItem, CsPackage.Literals.PHYSICAL_LINK);
    }

    private List<CapellaElement> getRule_MQRY_ConfigurationItem_ImplementedPPort_11(ConfigurationItem configurationItem) {
        return this.getElementsFromBlockArchitecture(configurationItem, CsPackage.Literals.PHYSICAL_PORT);
    }

    private List<CapellaElement> getElementsFromBlockArchitecture(ConfigurationItem configurationItem, EClass cls) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        EPBSArchitecture arch = (EPBSArchitecture)SystemEngineeringExt.getRootBlockArchitecture((ModelElement)configurationItem);
        if (arch != null) {
            for (BlockArchitecture block : arch.getAllocatedArchitectures()) {
                TreeIterator allContents = EcoreUtil.getAllContents((EObject)block, (boolean)false);
                while (allContents.hasNext()) {
                    EObject object = (EObject)allContents.next();
                    if (!object.eClass().equals(cls)) continue;
                    availableElements.add((CapellaElement)object);
                }
            }
        }
        return availableElements;
    }
}

