/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CatalogElementKind implements Enumerator
{
    REC(0, "REC", "REC"),
    RPL(1, "RPL", "RPL"),
    REC_RPL(2, "REC_RPL", "REC_RPL"),
    GROUPING(3, "GROUPING", "GROUPING");

    public static final int REC_VALUE = 0;
    public static final int RPL_VALUE = 1;
    public static final int REC_RPL_VALUE = 2;
    public static final int GROUPING_VALUE = 3;
    private static final CatalogElementKind[] VALUES_ARRAY;
    public static final List<CatalogElementKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CatalogElementKind[]{REC, RPL, REC_RPL, GROUPING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CatalogElementKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CatalogElementKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CatalogElementKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CatalogElementKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CatalogElementKind get(int value) {
        switch (value) {
            case 0: {
                return REC;
            }
            case 1: {
                return RPL;
            }
            case 2: {
                return REC_RPL;
            }
            case 3: {
                return GROUPING;
            }
        }
        return null;
    }

    private CatalogElementKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

