/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.layout.vertical;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.LostMessageEnd;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.AbstractSequenceLayout;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.AbstractSequenceOrderingLayout;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.EventEndToPositionFunction;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.LayoutConstants;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceElementQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.query.SequenceMessageViewQuery;
import org.eclipse.sirius.diagram.sequence.ordering.CompoundEventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class SequenceVerticalLayout
extends AbstractSequenceOrderingLayout<ISequenceElement, Range, EventEnd> {
    protected final Map<EventEnd, Message> creators;
    protected final Map<EventEnd, Message> destructors;
    protected final Map<EventEnd, LostMessageEnd> losts;
    protected final List<LostMessageEnd> unconnectedLostEnds;
    protected final List<EventEnd> toolCreatedEnds = new ArrayList<EventEnd>();
    protected final Multimap<EventEnd, ISequenceEvent> endToISequencEvents;
    protected final Multimap<ISequenceEvent, EventEnd> iSequenceEventsToEventEnds;
    protected final Function<EventEnd, Collection<ISequenceEvent>> eventEndToSequenceEvents = new Function<EventEnd, Collection<ISequenceEvent>>(){

        public Collection<ISequenceEvent> apply(EventEnd from) {
            return SequenceVerticalLayout.this.endToISequencEvents.get((Object)from);
        }
    };
    protected Range timeRange;
    private final Function<Lifeline, Integer> instanceRoleHeight = new Function<Lifeline, Integer>(){

        public Integer apply(Lifeline from) {
            InstanceRole irep = from.getInstanceRole();
            if (irep != null) {
                return ((Size)irep.getNotationNode().getLayoutConstraint()).getHeight();
            }
            return 0;
        }
    };
    private final Ordering<Lifeline> heightOrdering = Ordering.natural().onResultOf(this.instanceRoleHeight);
    private final Function<ISequenceEvent, Option<Range>> oldRangeFunction = new Function<ISequenceEvent, Option<Range>>(){

        public Option<Range> apply(ISequenceEvent from) {
            Range range = (Range)SequenceVerticalLayout.this.oldLayoutData.get(from);
            if (range == null) {
                range = Range.emptyRange();
            }
            return Options.newSome((Object)range);
        }
    };
    private final Function<ISequenceEvent, Option<Range>> oldFlaggedRange = new Function<ISequenceEvent, Option<Range>>(){

        public Option<Range> apply(ISequenceEvent from) {
            Rectangle rect = (Rectangle)SequenceVerticalLayout.this.oldFlaggedLayoutData.get(from);
            Range result = null;
            if (rect != null) {
                result = RangeHelper.verticalRange(rect);
            }
            return Options.newSome(result);
        }
    };
    private final Function<EventEnd, Integer> eventEndOldPosition = new EventEndToPositionFunction(this.eventEndToSequenceEvents, this.oldRangeFunction){

        @Override
        protected Integer getOldPositionFromRange(SingleEventEnd see, ISequenceEvent ise) {
            Integer oldPos = super.getOldPositionFromRange(see, ise);
            if (ise instanceof Message && !ise.isLogicallyInstantaneous() && see != null) {
                Message smep = (Message)ise;
                Edge notationView = smep.getNotationEdge();
                SequenceMessageViewQuery query = new SequenceMessageViewQuery(notationView);
                oldPos = see.isStart() ? query.getFirstPointVerticalPosition(true) : query.getLastPointVerticalPosition(true);
            }
            return oldPos;
        }
    };
    private final Function<EventEnd, Integer> eventEndOldFlaggedPosition = new EventEndToPositionFunction(this.eventEndToSequenceEvents, this.oldFlaggedRange);

    public SequenceVerticalLayout(SequenceDiagram sequenceDiagram) {
        super(sequenceDiagram);
        this.iSequenceEventsToEventEnds = LinkedHashMultimap.create();
        this.endToISequencEvents = HashMultimap.create();
        this.creators = new HashMap<EventEnd, Message>();
        this.destructors = new HashMap<EventEnd, Message>();
        this.losts = new HashMap<EventEnd, LostMessageEnd>();
        this.unconnectedLostEnds = new ArrayList<LostMessageEnd>();
    }

    @Override
    protected void init(boolean pack) {
        this.initSortedEventEnds(pack);
        this.initLifelinesOldLayoutData();
        this.initTimeBounds(pack);
        this.registerEventEnds();
        this.lookForUnconnectedLostEnd();
        this.checkOrderingSync();
    }

    @Override
    protected Range getOldLayoutData(ISequenceElement ise) {
        Range verticalRange = Range.emptyRange();
        if (ise instanceof ISequenceEvent) {
            verticalRange = ((ISequenceEvent)ise).getVerticalRange();
            if (ise instanceof Message) {
                Message msg = (Message)ise;
                ISequenceElementQuery query = null;
                ISequenceNode sourceElement = msg.getSourceElement();
                ISequenceNode targetElement = msg.getTargetElement();
                if (sourceElement instanceof LostMessageEnd && AbstractSequenceLayout.createdFromTool((LostMessageEnd)sourceElement)) {
                    query = new ISequenceElementQuery(sourceElement);
                } else if (targetElement instanceof LostMessageEnd && AbstractSequenceLayout.createdFromTool((LostMessageEnd)targetElement)) {
                    query = new ISequenceElementQuery(targetElement);
                }
                if (query != null && query.hasAbsoluteBoundsFlag()) {
                    Rectangle flag = query.getFlaggedAbsoluteBounds();
                    verticalRange = new Range(flag.y, flag.y);
                }
            }
        }
        return verticalRange;
    }

    @Override
    protected boolean applyComputedLayout(Map<? extends ISequenceElement, Range> finalRanges, boolean pack) {
        Range newRange;
        boolean applied = false;
        Iterable keySet = Iterables.filter(finalRanges.keySet(), ISequenceEvent.class);
        for (ISequenceEvent ise : Iterables.filter((Iterable)keySet, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(Message.class)))) {
            newRange = finalRanges.get(ise);
            ise.setVerticalRange(newRange);
            applied = true;
        }
        for (Message smep : Iterables.filter((Iterable)keySet, Message.class)) {
            newRange = finalRanges.get(smep);
            smep.setVerticalRange(newRange);
            applied = true;
        }
        applied = this.layoutUnconnectedLostMessageEnd() || applied;
        return applied;
    }

    @Override
    protected Map<? extends ISequenceElement, Range> computeLayout(boolean pack) {
        LinkedHashMap<ISequenceEvent, Range> sequenceEventRanges = new LinkedHashMap<ISequenceEvent, Range>();
        Map<EventEnd, Integer> endLocations = this.computeEndBounds(pack);
        Map<ISequenceEvent, Range> basicRanges = this.computeBasicRanges(endLocations);
        Map<ISequenceEvent, Range> punctualEventRanges = this.computePunctualEventsGraphicalRanges(endLocations, pack);
        Map<ISequenceEvent, Range> lifelinesRanges = this.computeLifelineRanges(endLocations);
        sequenceEventRanges.putAll(lifelinesRanges);
        sequenceEventRanges.putAll(basicRanges);
        sequenceEventRanges.putAll(punctualEventRanges);
        return sequenceEventRanges;
    }

    @Override
    protected void dispose() {
        this.creators.clear();
        this.destructors.clear();
        this.losts.clear();
        this.unconnectedLostEnds.clear();
        this.toolCreatedEnds.clear();
        this.endToISequencEvents.clear();
        this.iSequenceEventsToEventEnds.clear();
        super.dispose();
    }

    private Map<ISequenceEvent, Range> computePunctualEventsGraphicalRanges(Map<EventEnd, Integer> endLocations, boolean pack) {
        LinkedHashMap<ISequenceEvent, Range> sequenceEventsToRange = new LinkedHashMap<ISequenceEvent, Range>();
        if (pack) {
            for (EventEnd cee : Iterables.filter((Iterable)this.semanticOrdering, EventEndHelper.PUNCTUAL_COMPOUND_EVENT_END)) {
                if (!endLocations.containsKey(cee) || !this.endToISequencEvents.containsKey((Object)cee)) continue;
                int loc = endLocations.get(cee);
                Collection ises = this.endToISequencEvents.get((Object)cee);
                if (!Iterables.any((Iterable)ises, (Predicate)Predicates.instanceOf(State.class)) || ises.size() != 1) continue;
                State ise = (State)ises.iterator().next();
                int midSize = this.getAbstractNodeEventVerticalSize(cee, ise, ises, pack) / 2;
                sequenceEventsToRange.put(ise, new Range(loc - midSize, loc + midSize));
            }
        }
        return sequenceEventsToRange;
    }

    private Map<EventEnd, Integer> computeEndBounds(boolean pack) {
        LinkedHashMap<EventEnd, Integer> result = new LinkedHashMap<EventEnd, Integer>();
        if (this.semanticOrdering == null || this.semanticOrdering.isEmpty()) {
            return result;
        }
        int currentY = this.timeRange.getLowerBound();
        EventEnd endBefore = null;
        for (EventEnd end : this.semanticOrdering) {
            currentY = this.computeLocation(currentY, end, endBefore, pack, result);
            result.put(end, currentY);
            endBefore = end;
        }
        return result;
    }

    private int getGapFromCommonSequenceEvent(EventEnd end, Collection<ISequenceEvent> commonIses, boolean pack, int genericGap) {
        int beforeGap = genericGap;
        if (commonIses.isEmpty()) {
            return beforeGap;
        }
        ISequenceEvent commonIse = commonIses.iterator().next();
        if (commonIse instanceof Message && ((Message)commonIse).isReflective()) {
            beforeGap = 10;
        } else if (commonIse instanceof AbstractNodeEvent) {
            beforeGap = Math.max(genericGap, this.getAbstractNodeEventVerticalSize(end, (AbstractNodeEvent)commonIse, commonIses, pack));
        } else if (commonIse instanceof InteractionUse) {
            beforeGap = 50;
        } else if (commonIse instanceof Operand) {
            beforeGap = 60;
        }
        return beforeGap;
    }

    private int getAbstractNodeEventVerticalSize(EventEnd end, AbstractNodeEvent ise, Collection<ISequenceEvent> commonIses, boolean pack) {
        int vSize = 0;
        if (pack) {
            DNode execution = (DNode)ise.getNotationView().getElement();
            int specifiedVSize = this.getSpecifiedVSize(execution);
            if (specifiedVSize != 0) {
                vSize = specifiedVSize;
            }
        } else {
            Range range;
            Rectangle rect;
            vSize = this.isFlagguedByRefreshExtension(end, commonIses) ? ((rect = (Rectangle)this.oldFlaggedLayoutData.get(ise)) != null ? rect.height : 30) : ((range = (Range)this.oldLayoutData.get(ise)) != null ? range.width() : 30);
        }
        return vSize;
    }

    private Map<ISequenceEvent, Range> computeBasicRanges(Map<EventEnd, Integer> endLocations) {
        LinkedHashMap<ISequenceEvent, Range> sequenceEventsToRange = new LinkedHashMap<ISequenceEvent, Range>();
        Predicate notMoved = Predicates.not((Predicate)Predicates.in(sequenceEventsToRange.keySet()));
        for (EventEnd sortedEnd : this.semanticOrdering) {
            Predicate frames = Predicates.and((Predicate)notMoved, (Predicate)Predicates.or((Predicate)Predicates.instanceOf(CombinedFragment.class), (Predicate)Predicates.instanceOf(InteractionUse.class)));
            for (ISequenceEvent ise : Iterables.filter((Iterable)this.endToISequencEvents.get((Object)sortedEnd), (Predicate)frames)) {
                this.computeFinalRange(endLocations, sequenceEventsToRange, ise);
            }
        }
        for (EventEnd sortedEnd : this.semanticOrdering) {
            Predicate operands = Predicates.and((Predicate)notMoved, (Predicate)Predicates.instanceOf(Operand.class));
            for (ISequenceEvent ise : Iterables.filter((Iterable)this.endToISequencEvents.get((Object)sortedEnd), (Predicate)operands)) {
                this.computeFinalRange(endLocations, sequenceEventsToRange, ise);
            }
        }
        for (EventEnd sortedEnd : this.semanticOrdering) {
            for (ISequenceEvent ise : Iterables.filter((Iterable)this.endToISequencEvents.get((Object)sortedEnd), (Predicate)notMoved)) {
                this.computeFinalRange(endLocations, sequenceEventsToRange, ise);
            }
        }
        return sequenceEventsToRange;
    }

    private void computeFinalRange(Map<EventEnd, Integer> endLocations, Map<ISequenceEvent, Range> sequenceEventsToRange, ISequenceEvent ise) {
        Collection ends = this.iSequenceEventsToEventEnds.get((Object)ise);
        if (ends.size() == 2) {
            Iterator it = ends.iterator();
            EventEnd start = (EventEnd)it.next();
            EventEnd finish = (EventEnd)it.next();
            Range newRange = this.getNewRange(ise, start, finish, endLocations);
            sequenceEventsToRange.put(ise, newRange);
        } else if (ends.size() == 1 && ise.isLogicallyInstantaneous() && (ise instanceof Message || EventEndHelper.PUNCTUAL_COMPOUND_EVENT_END.apply((Object)((EventEnd)ends.iterator().next())))) {
            Iterator it = ends.iterator();
            EventEnd middle = (EventEnd)it.next();
            Range newRange = this.getNewRange(ise, middle, middle, endLocations);
            sequenceEventsToRange.put(ise, newRange);
        }
    }

    private Range getNewRange(ISequenceEvent event, EventEnd start, EventEnd end, Map<EventEnd, Integer> endLocations) {
        int upperBound;
        Range oldRange = this.oldLayoutData.containsKey(event) ? (Range)this.oldLayoutData.get(event) : Range.emptyRange();
        int lowerBound = endLocations.containsKey(start) ? endLocations.get(start).intValue() : oldRange.getLowerBound();
        int n = upperBound = endLocations.containsKey(end) ? endLocations.get(end).intValue() : oldRange.getUpperBound();
        if (event.isLogicallyInstantaneous() && start == end) {
            upperBound = (lowerBound -= oldRange.width() / 2) + oldRange.width();
        }
        this.updateTimerange(upperBound);
        return new Range(lowerBound, upperBound);
    }

    private Map<ISequenceEvent, Range> computeLifelineRanges(Map<EventEnd, Integer> endLocations) {
        LinkedHashMap<ISequenceEvent, Range> sequenceEventsToRange = new LinkedHashMap<ISequenceEvent, Range>();
        int endOfLife = this.timeRange.getUpperBound() + 50;
        this.layoutLifelinesWithoutCreation(sequenceEventsToRange);
        this.layoutCreatedLifelines(endLocations, sequenceEventsToRange);
        this.layoutDestructedLifelines(endLocations, sequenceEventsToRange);
        this.layoutNonDestructedLifelines(sequenceEventsToRange, Math.max(endOfLife, 200));
        return sequenceEventsToRange;
    }

    private void layoutLifelinesWithoutCreation(Map<ISequenceEvent, Range> sequenceEventsToRange) {
        for (ISequenceEvent iSequenceEvent : this.getLifeLinesWithoutCreation()) {
            int newLBound;
            InstanceRole instanceRole;
            Range oldRange = (Range)this.oldLayoutData.get(iSequenceEvent);
            Option<Lifeline> parentLifeline = iSequenceEvent.getLifeline();
            if (!parentLifeline.some() || (instanceRole = ((Lifeline)parentLifeline.get()).getInstanceRole()) == null || (newLBound = this.getLifelineMinLowerBound(instanceRole)) == oldRange.getLowerBound()) continue;
            sequenceEventsToRange.put(iSequenceEvent, new Range(newLBound, oldRange.getUpperBound()));
        }
    }

    private void layoutCreatedLifelines(Map<EventEnd, Integer> endLocations, Map<ISequenceEvent, Range> sequenceEventsToRange) {
        for (Message smep : this.creators.values()) {
            Iterator it;
            EventEnd first;
            Collection ends = this.iSequenceEventsToEventEnds.get((Object)smep);
            if (ends.isEmpty() || !endLocations.containsKey(first = (EventEnd)(it = ends.iterator()).next())) continue;
            int endMove = endLocations.get(first);
            int vGap = this.getTargetFigureMidHeight(smep);
            Lifeline lep = (Lifeline)smep.getTargetElement().getLifeline().get();
            Range oldRange = sequenceEventsToRange.containsKey(lep) ? sequenceEventsToRange.get(lep) : (Range)this.oldLayoutData.get(lep);
            sequenceEventsToRange.put(lep, new Range(endMove + vGap, endMove + vGap + oldRange.width()));
        }
    }

    private void layoutDestructedLifelines(Map<EventEnd, Integer> endLocations, Map<ISequenceEvent, Range> sequenceEventsToRange) {
        for (Message smep : this.destructors.values()) {
            Collection ends = this.iSequenceEventsToEventEnds.get((Object)smep);
            if (ends.isEmpty()) continue;
            Iterator it = ends.iterator();
            EventEnd first = (EventEnd)it.next();
            int endMove = endLocations.get(first);
            int vGap = this.getTargetFigureMidHeight(smep);
            int newY = endMove - vGap;
            Lifeline lep = (Lifeline)((EndOfLife)smep.getTargetElement()).getLifeline().get();
            Range oldRange = sequenceEventsToRange.containsKey(lep) ? sequenceEventsToRange.get(lep) : (Range)this.oldLayoutData.get(lep);
            sequenceEventsToRange.put(lep, new Range(oldRange.getLowerBound(), newY));
        }
    }

    private void layoutNonDestructedLifelines(Map<ISequenceEvent, Range> sequenceEventsToRange, int endOfLife) {
        for (ISequenceEvent iSequenceEvent : this.getLifeLinesWithoutDestruction()) {
            Range currentRange;
            Range range = currentRange = sequenceEventsToRange.containsKey(iSequenceEvent) ? sequenceEventsToRange.get(iSequenceEvent) : (Range)this.oldLayoutData.get(iSequenceEvent);
            if (currentRange.getUpperBound() == endOfLife) continue;
            sequenceEventsToRange.put(iSequenceEvent, new Range(currentRange.getLowerBound(), endOfLife));
        }
    }

    private int computeLocation(int currentY, EventEnd end, EventEnd endBefore, boolean pack, Map<EventEnd, Integer> alreadyComputedLocations) {
        int location = currentY;
        Collection<ISequenceEvent> commonIses = this.getCommonISequenceEvent(endBefore, end);
        if (this.shouldMove(commonIses)) {
            int newMinY = this.getMinY(endBefore, end, commonIses, pack, location, alreadyComputedLocations);
            if (pack) {
                location = newMinY;
            } else {
                int oldPosition = this.getOldStablePosition(currentY, end);
                int rangeStableY = this.getRangeStablePosition(currentY, end, alreadyComputedLocations);
                int deltaStableY = this.getDeltaStablePosition(currentY, end, alreadyComputedLocations);
                location = Math.max(newMinY, Math.max(oldPosition, Math.max(deltaStableY, rangeStableY)));
            }
        }
        return location;
    }

    private int getOldStablePosition(int currentY, EventEnd end) {
        int oldPosition = currentY;
        if (this.flaggedEnds.contains(end) || this.toolCreatedEnds.contains(end)) {
            oldPosition = (Integer)this.eventEndOldPosition.apply((Object)end);
        }
        if (this.isFlagguedByRefreshExtension(end, this.endToISequencEvents.get((Object)end))) {
            oldPosition = (Integer)this.eventEndOldFlaggedPosition.apply((Object)end);
        }
        return oldPosition;
    }

    private int getRangeStablePosition(int currentY, EventEnd end, Map<EventEnd, Integer> alreadyComputedLocations) {
        int rangeStabilityPos = currentY;
        Collection ises = this.endToISequencEvents.get((Object)end);
        for (ISequenceEvent ise : ises) {
            SingleEventEnd see;
            if (ise.isLogicallyInstantaneous() || (see = EventEndHelper.getSingleEventEnd(end, (EObject)ise.getSemanticTargetElement().get())).isStart() || ise instanceof Message && !Iterables.isEmpty((Iterable)Iterables.filter((Iterable)this.iSequenceEventsToEventEnds.get((Object)ise), CompoundEventEnd.class))) continue;
            int startLocation = this.getStartLocation(ise, alreadyComputedLocations);
            Option oldRange = (Option)this.oldRangeFunction.apply((Object)ise);
            if (this.isFlagguedByRefreshExtension(end, Collections.singleton(ise))) {
                oldRange = (Option)this.oldFlaggedRange.apply((Object)ise);
            }
            int width = oldRange.some() ? ((Range)oldRange.get()).width() : 0;
            rangeStabilityPos = Math.max(rangeStabilityPos, startLocation + width);
        }
        return rangeStabilityPos;
    }

    private boolean isFlagguedByRefreshExtension(EventEnd end, Collection<ISequenceEvent> ises) {
        if (this.flaggedEnds.contains(end)) {
            for (ISequenceEvent ise : ises) {
                Rectangle flaggedAbsoluteBounds = new ISequenceElementQuery(ise).getFlaggedAbsoluteBounds();
                if (flaggedAbsoluteBounds.x != LayoutConstants.EXTERNAL_CHANGE_FLAG.x) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldMove(Collection<ISequenceEvent> commonIses) {
        boolean shouldMove = true;
        if (!commonIses.isEmpty()) {
            ISequenceEvent commonIse = commonIses.iterator().next();
            shouldMove = !commonIse.isLogicallyInstantaneous();
        }
        return shouldMove;
    }

    private int getMinY(EventEnd endBefore, EventEnd end, Collection<ISequenceEvent> commonIses, boolean pack, int currentLocation, Map<EventEnd, Integer> alreadyComputedLocations) {
        int genericGap;
        int minGap = genericGap = this.getGenericGap(endBefore, end, pack);
        if (!commonIses.isEmpty()) {
            int commonIseGap;
            minGap = commonIseGap = this.getGapFromCommonSequenceEvent(end, commonIses, pack, genericGap);
        } else {
            boolean operands = Iterables.any((Iterable)((Iterable)this.eventEndToSequenceEvents.apply((Object)end)), (Predicate)Predicates.instanceOf(Operand.class));
            if (operands) {
                minGap = this.getGapBeforeOperandEnd(endBefore, end, currentLocation, genericGap, alreadyComputedLocations);
            }
        }
        return currentLocation + minGap;
    }

    private int getGenericGap(EventEnd endBefore, EventEnd end, boolean pack) {
        State state;
        int beforeGap = 0;
        if (endBefore != null) {
            State predState;
            Collection endBeforeEvents = (Collection)this.eventEndToSequenceEvents.apply((Object)endBefore);
            beforeGap = pack ? 20 : 5;
            Iterable predStates = Iterables.filter((Iterable)endBeforeEvents, State.class);
            if (EventEndHelper.PUNCTUAL_COMPOUND_EVENT_END.apply((Object)endBefore) && endBeforeEvents.size() == 1 && Iterables.size((Iterable)predStates) == 1 && (predState = (State)Iterables.getOnlyElement((Iterable)predStates)).isLogicallyInstantaneous()) {
                beforeGap += this.getAbstractNodeEventVerticalSize(endBefore, predState, endBeforeEvents, pack) / 2;
            }
            if (Iterables.any((Iterable)endBeforeEvents, (Predicate)Predicates.instanceOf(InteractionUse.class)) && endBefore instanceof SingleEventEnd && ((SingleEventEnd)endBefore).isStart()) {
                beforeGap = 25;
            }
            if (Iterables.any((Iterable)((Iterable)this.eventEndToSequenceEvents.apply((Object)end)), (Predicate)Predicates.instanceOf(InteractionUse.class)) && end instanceof SingleEventEnd && !((SingleEventEnd)end).isStart()) {
                beforeGap = 25;
            }
            if (this.creators.keySet().contains(endBefore)) {
                beforeGap = pack ? (beforeGap += this.getTargetFigureMidHeight(this.creators.get(endBefore)) + 30 - 20) : (beforeGap += this.getTargetFigureMidHeight(this.creators.get(endBefore)));
            } else if (this.losts.containsKey(endBefore)) {
                beforeGap += this.losts.get((Object)endBefore).getBounds().height / 2;
            }
        } else {
            int n = beforeGap = pack ? 30 : 10;
        }
        if (this.destructors.keySet().contains(end)) {
            beforeGap += this.getTargetFigureMidHeight(this.destructors.get(end));
        } else if (this.losts.containsKey(end)) {
            beforeGap += this.losts.get((Object)end).getBounds().height / 2;
        }
        Collection endEvents = (Collection)this.eventEndToSequenceEvents.apply((Object)end);
        Iterable states = Iterables.filter((Iterable)endEvents, State.class);
        if (EventEndHelper.PUNCTUAL_COMPOUND_EVENT_END.apply((Object)end) && endEvents.size() == 1 && Iterables.size((Iterable)states) == 1 && (state = (State)Iterables.getOnlyElement((Iterable)states)).isLogicallyInstantaneous()) {
            beforeGap += this.getAbstractNodeEventVerticalSize(endBefore, state, endEvents, pack) / 2;
        }
        return beforeGap;
    }

    private int getGapBeforeOperandEnd(EventEnd endBefore, EventEnd end, int currentLocation, int genericGap, Map<EventEnd, Integer> alreadyComputedLocations) {
        int beforeGap = genericGap;
        Iterable operands = Iterables.filter((Iterable)((Iterable)this.eventEndToSequenceEvents.apply((Object)end)), Operand.class);
        if (!Iterables.isEmpty((Iterable)operands) && endBefore instanceof SingleEventEnd) {
            if (Iterables.any((Iterable)((Iterable)this.eventEndToSequenceEvents.apply((Object)endBefore)), (Predicate)Predicates.instanceOf(CombinedFragment.class)) && ((SingleEventEnd)endBefore).isStart()) {
                beforeGap = 30;
            } else {
                Operand op = this.selectEndedOperand(end, operands);
                if (op != null) {
                    int startLoc = this.getStartLocation(op, alreadyComputedLocations);
                    int minEndLoc = startLoc + 60;
                    beforeGap = Math.max(minEndLoc - currentLocation, genericGap);
                }
            }
        }
        return beforeGap;
    }

    private Operand selectEndedOperand(EventEnd end, Iterable<Operand> operands) {
        Operand op = null;
        if (end instanceof CompoundEventEnd) {
            for (SingleEventEnd see : ((CompoundEventEnd)end).getEventEnds()) {
                if (see.isStart()) continue;
                EObject semanticEvent = see.getSemanticEvent();
                for (Operand opp : operands) {
                    EObject eObject = (EObject)opp.getSemanticTargetElement().get();
                    if (semanticEvent == null || !semanticEvent.equals(eObject)) continue;
                    op = opp;
                }
            }
        }
        return op;
    }

    private int getStartLocation(ISequenceEvent ise, Map<EventEnd, Integer> alreadyComputedLocations) {
        Collection ends = this.iSequenceEventsToEventEnds.get((Object)ise);
        for (EventEnd end : ends) {
            SingleEventEnd see = EventEndHelper.getSingleEventEnd(end, (EObject)ise.getSemanticTargetElement().get());
            if (!see.isStart() || !alreadyComputedLocations.containsKey(end)) continue;
            return alreadyComputedLocations.get(end);
        }
        return 0;
    }

    private boolean layoutUnconnectedLostMessageEnd() {
        boolean applied = false;
        for (LostMessageEnd lme : this.unconnectedLostEnds) {
            LayoutConstraint layoutConstraint;
            if (!SequenceVerticalLayout.createdFromTool(lme)) continue;
            ISequenceElementQuery query = new ISequenceElementQuery(lme);
            int y = query.getFlaggedAbsoluteBounds().y;
            if (y == -1 || !((layoutConstraint = lme.getNotationNode().getLayoutConstraint()) instanceof Location)) continue;
            Rectangle bounds = lme.getProperLogicalBounds();
            ((Location)layoutConstraint).setY(y - bounds.height / 2);
            applied = true;
        }
        return applied;
    }

    private void initSortedEventEnds(boolean pack) {
        SequenceDDiagram sequenceDDiagram = (SequenceDDiagram)this.sequenceDiagram.getNotationDiagram().getElement();
        this.graphicalOrdering.addAll(sequenceDDiagram.getGraphicalOrdering().getEventEnds());
        this.semanticOrdering.addAll(sequenceDDiagram.getSemanticOrdering().getEventEnds());
    }

    private void initLifelinesOldLayoutData() {
        ArrayList<Lifeline> lifelines = new ArrayList<Lifeline>();
        lifelines.addAll(this.sequenceDiagram.getAllLifelines());
        for (ISequenceEvent iSequenceEvent : lifelines) {
            this.oldLayoutData.put(iSequenceEvent, this.getOldLayoutData(iSequenceEvent));
        }
    }

    private void lookForUnconnectedLostEnd() {
        ArrayList<LostMessageEnd> allLostMessageEnds = new ArrayList<LostMessageEnd>(this.sequenceDiagram.getAllLostMessageEnds());
        ArrayList<LostMessageEnd> discoveredLostEnds = new ArrayList<LostMessageEnd>();
        for (Message knownMsgs : Iterables.filter((Iterable)this.iSequenceEventsToEventEnds.keySet(), Message.class)) {
            ISequenceNode targetElement;
            ISequenceNode sourceElement = knownMsgs.getSourceElement();
            if (sourceElement instanceof LostMessageEnd) {
                discoveredLostEnds.add((LostMessageEnd)sourceElement);
            }
            if (!((targetElement = knownMsgs.getTargetElement()) instanceof LostMessageEnd)) continue;
            discoveredLostEnds.add((LostMessageEnd)targetElement);
        }
        Iterables.removeAll(allLostMessageEnds, discoveredLostEnds);
        this.unconnectedLostEnds.addAll(allLostMessageEnds);
    }

    protected void initTimeBounds(boolean pack) {
        int minTimeBounds;
        int startTime = minTimeBounds = this.getMinTimeBounds();
        int endTime = this.getMaxTimeBounds(pack, minTimeBounds) - 50;
        this.timeRange = new Range(startTime, Math.max(startTime, endTime));
    }

    private int getMaxTimeBounds(boolean pack, int minTimeBounds) {
        int max = this.getSpecifiedMaxTimeBounds(minTimeBounds);
        if (!pack) {
            Iterable<Lifeline> lifelinesWithoutDestruction = this.getLifeLinesWithoutDestruction();
            Predicate<Lifeline> isMaxRangeCandidate = new Predicate<Lifeline>(){

                public boolean apply(Lifeline input) {
                    InstanceRole irep = input.getInstanceRole();
                    if (irep != null) {
                        return irep.getBounds().getLocation().y <= 50;
                    }
                    return false;
                }
            };
            ArrayList lifelinesToConsider = Lists.newArrayList((Iterable)Iterables.filter(lifelinesWithoutDestruction, (Predicate)isMaxRangeCandidate));
            Ordering maxOrdering = Ordering.natural().onResultOf(Functions.compose(RangeHelper.upperBoundFunction(), ISequenceEvent.VERTICAL_RANGE));
            if (!lifelinesToConsider.isEmpty()) {
                Lifeline lep = (Lifeline)maxOrdering.max((Iterable)lifelinesToConsider);
                max = lep.getVerticalRange().getUpperBound();
            }
        }
        return max;
    }

    private int getSpecifiedMaxTimeBounds(int minTimeBounds) {
        List<Lifeline> allLifelines = this.sequenceDiagram.getAllLifelines();
        int timeBounds = 200;
        for (Lifeline lep : allLifelines) {
            DDiagramElement dde = (DDiagramElement)lep.getNotationNode().getElement();
            if (!(dde instanceof DNode) || !Lifeline.viewpointElementPredicate().apply((Object)dde)) continue;
            DNode node = (DNode)dde;
            int specifiedVSize = this.getSpecifiedVSize(node);
            int endOfLifeVsize = this.getSpecifiedEndOfLifeVSize(node);
            timeBounds = Math.max(200, minTimeBounds + specifiedVSize - endOfLifeVsize / 2);
        }
        return timeBounds;
    }

    private int getSpecifiedEndOfLifeVSize(DNode node) {
        int endOfLifeVsize = 0;
        ArrayList endOfLifes = Lists.newArrayList((Iterable)Iterables.filter((Iterable)node.getOwnedBorderedNodes(), (Predicate)new Predicate<DNode>(){

            public boolean apply(DNode input) {
                return input.isVisible() && EndOfLife.viewpointElementPredicate().apply((Object)input);
            }
        }));
        if (!endOfLifes.isEmpty()) {
            endOfLifeVsize = this.getSpecifiedVSize((DNode)endOfLifes.iterator().next());
        }
        return endOfLifeVsize;
    }

    protected int getSpecifiedVSize(DNode node) {
        return new DNodeQuery((DNode)node).getDefaultDimension().height;
    }

    private int getMinTimeBounds() {
        Predicate<Lifeline> isMinRangeCandidate;
        int min = 100;
        Iterable<Lifeline> lifelinesWithoutCreation = this.getLifeLinesWithoutCreation();
        ArrayList lifelinesToConsider = Lists.newArrayList((Iterable)Iterables.filter(lifelinesWithoutCreation, (Predicate)(isMinRangeCandidate = new Predicate<Lifeline>(){

            public boolean apply(Lifeline input) {
                InstanceRole irep = input.getInstanceRole();
                if (irep != null) {
                    return irep.getBounds().getLocation().y <= 50;
                }
                return false;
            }
        })));
        if (!lifelinesToConsider.isEmpty()) {
            Lifeline lep = (Lifeline)this.heightOrdering.max((Iterable)lifelinesToConsider);
            min = 50 + (Integer)this.instanceRoleHeight.apply((Object)lep);
        }
        return min;
    }

    protected int getTargetFigureMidHeight(Message mover) {
        int midHeight = 0;
        if (mover != null && mover.getTargetElement() != null) {
            midHeight = mover.getTargetElement().getBounds().height / 2;
        }
        return midHeight;
    }

    protected void updateTimerange(int upperBound) {
        if (upperBound > this.timeRange.getUpperBound()) {
            this.timeRange = new Range(this.timeRange.getLowerBound(), upperBound);
        }
    }

    protected int getLifelineMinLowerBound(InstanceRole irep) {
        int vGap = 50;
        return vGap += irep.getBounds().height;
    }

    protected void registerEventEnds() {
        for (EventEnd end : new ArrayList(this.semanticOrdering)) {
            this.registerEventEnd(end);
        }
        Collections.sort(this.flaggedEnds, Ordering.natural().onResultOf(this.eventEndOldFlaggedPosition));
    }

    private void registerEventEnd(EventEnd end) {
        List<EObject> semanticEvents = EventEndHelper.getSemanticEvents(end);
        LinkedHashSet<ISequenceEvent> eventParts = new LinkedHashSet<ISequenceEvent>();
        for (EObject semanticEvent : semanticEvents) {
            eventParts.addAll(ISequenceElementAccessor.getEventsForSemanticElement(this.sequenceDiagram, semanticEvent));
        }
        if (eventParts.isEmpty()) {
            LinkedHashSet<DDiagramElement> ddes = new LinkedHashSet<DDiagramElement>();
            for (EObject semanticEvent : semanticEvents) {
                ddes.addAll(ISequenceElementAccessor.getDiagramElementsForSemanticElement(this.sequenceDiagram, semanticEvent));
            }
            if (!ddes.isEmpty()) {
                this.semanticOrdering.clear();
                this.graphicalOrdering.clear();
            }
        }
        boolean flagged = false;
        boolean toolCreated = false;
        boolean toolSemanticCreated = false;
        boolean lost = false;
        for (ISequenceEvent ise : eventParts) {
            Range oldData = this.getOldLayoutData(ise);
            this.oldLayoutData.put(ise, oldData);
            this.endToISequencEvents.put((Object)end, (Object)ise);
            this.iSequenceEventsToEventEnds.put((Object)ise, (Object)end);
            ISequenceElementQuery query = new ISequenceElementQuery(ise);
            if (query.hasAbsoluteBoundsFlag()) {
                Rectangle flaggedAbsoluteBounds = query.getFlaggedAbsoluteBounds();
                if (LayoutConstants.TOOL_CREATION_FLAG.equals((Object)flaggedAbsoluteBounds)) {
                    toolCreated = true;
                } else if (LayoutConstants.TOOL_CREATION_FLAG_FROM_SEMANTIC.equals((Object)flaggedAbsoluteBounds)) {
                    toolSemanticCreated = true;
                } else {
                    if (flaggedAbsoluteBounds.height == -1) {
                        flaggedAbsoluteBounds.setHeight(0);
                    }
                    this.oldFlaggedLayoutData.put(ise, flaggedAbsoluteBounds);
                    flagged = true;
                }
            }
            if (!(ise instanceof Message)) continue;
            Message smep = (Message)ise;
            ISequenceNode targetElement = smep.getTargetElement();
            if (targetElement instanceof InstanceRole) {
                this.creators.put(end, smep);
            } else if (targetElement instanceof EndOfLife) {
                this.destructors.put(end, smep);
            } else if (targetElement instanceof LostMessageEnd) {
                lost = true;
                this.losts.put(end, (LostMessageEnd)targetElement);
            }
            ISequenceNode sourceElement = smep.getSourceElement();
            if (!(sourceElement instanceof LostMessageEnd)) continue;
            lost = true;
            this.losts.put(end, (LostMessageEnd)sourceElement);
        }
        if (flagged && !toolCreated) {
            this.flaggedEnds.add(end);
        } else if (this.isSafeToolCreation(end)) {
            if (toolCreated) {
                this.toolCreatedEnds.add(end);
            } else if (toolSemanticCreated && (end instanceof SingleEventEnd && ((SingleEventEnd)end).isStart() || lost)) {
                this.toolCreatedEnds.add(end);
            }
        }
    }

    private boolean isSafeToolCreation(EventEnd end) {
        boolean safe = !(end instanceof CompoundEventEnd);
        safe = safe || EventEndHelper.PUNCTUAL_COMPOUND_EVENT_END.apply((Object)end);
        for (Message msg : Iterables.filter((Iterable)this.endToISequencEvents.get((Object)end), Message.class)) {
            boolean bl = safe = safe || msg.getSourceElement() instanceof LostMessageEnd || msg.getTargetElement() instanceof LostMessageEnd;
        }
        return safe;
    }

    protected Collection<ISequenceEvent> getCommonISequenceEvent(EventEnd end1, EventEnd end2) {
        if (end1 == null || end2 == null) {
            return Collections.emptyList();
        }
        Collection ises1 = this.endToISequencEvents.get((Object)end1);
        Collection ises2 = this.endToISequencEvents.get((Object)end2);
        ArrayList<ISequenceEvent> commonIses = new ArrayList<ISequenceEvent>(ises2);
        Iterables.retainAll(commonIses, (Collection)ises1);
        return commonIses;
    }

    @Override
    protected Function<EventEnd, Integer> getOldPosition() {
        return this.eventEndOldPosition;
    }

    @Override
    protected Function<EventEnd, Integer> getOldFlaggedPosition() {
        return this.eventEndOldFlaggedPosition;
    }
}

