/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.validation.part;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class ComponentPkg_RootComponentPart
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof ComponentPkg) {
            ComponentPkg pkg = (ComponentPkg)eObj;
            BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)eObj);
            if (!(architecture instanceof OperationalAnalysis) && BlockArchitectureExt.getComponentPkg((BlockArchitecture)architecture, (boolean)false) == eObj) {
                ArrayList parts = new ArrayList();
                if (architecture.getSystem() != null) {
                    parts.addAll(((ComponentPkg)eObj).getOwnedParts());
                    parts.retainAll((Collection<?>)architecture.getSystem().getRepresentingParts());
                    if (parts.isEmpty()) {
                        return ctx.createFailureStatus(new Object[]{pkg.getName(), pkg.eClass().getName()});
                    }
                } else {
                    return ctx.createFailureStatus(new Object[]{pkg.getName(), pkg.eClass().getName()});
                }
            }
        }
        return ctx.createSuccessStatus();
    }
}

