/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.project.internal;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.team.core.RepositoryProvider;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.commands.preferences.service.AbstractPreferencesInitializer;
import org.polarsys.capella.core.platform.sirius.ui.project.CapellaProjectActivator;
import org.polarsys.capella.core.platform.sirius.ui.project.internal.RunInWorkspaceJob;

public class MonitorFileSyncJob
extends RunInWorkspaceJob {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    JobChangeAdapter adapter;

    public MonitorFileSyncJob() {
        super("Monitor File Sync Job");
        this.setSystem(true);
        this.adapter = new JobChangeAdapter(){

            public void done(IJobChangeEvent event_p) {
                IPreferenceStore prefStore;
                long delay = 15L;
                CapellaProjectActivator activator = CapellaProjectActivator.getDefault();
                if (activator != null && (prefStore = activator.getPreferenceStore()) != null) {
                    delay = AbstractPreferencesInitializer.getInt((String)"FileSyncMonitoringDelay", (boolean)false);
                }
                MonitorFileSyncJob.this.schedule(1000L * delay);
            }
        };
    }

    public void addChangeAdapter() {
        this.addJobChangeListener((IJobChangeListener)this.adapter);
    }

    public void removeChangeAdapter() {
        this.removeJobChangeListener((IJobChangeListener)this.adapter);
    }

    @Override
    public IStatus runInWorkspace(final IProgressMonitor monitor_p) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            workspaceRoot.accept(new IResourceVisitor(){

                public boolean visit(IResource resource_p) throws CoreException {
                    boolean cr = true;
                    switch (resource_p.getType()) {
                        case 4: {
                            boolean bl = cr = RepositoryProvider.getProvider((IProject)((IProject)resource_p)) != null;
                            if (!cr) break;
                            MonitorFileSyncJob.this.resynchronize(monitor_p, resource_p);
                            break;
                        }
                        case 2: {
                            MonitorFileSyncJob.this.resynchronize(monitor_p, resource_p);
                            break;
                        }
                        case 1: {
                            cr = false;
                            MonitorFileSyncJob.this.resynchronize(monitor_p, resource_p);
                        }
                    }
                    return cr;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    protected void resynchronize(IProgressMonitor monitor_p, IResource resource_p) throws CoreException {
        if (!resource_p.isSynchronized(0)) {
            resource_p.refreshLocal(0, monitor_p);
            String message = String.valueOf(resource_p.getFullPath().toString()) + " resynchronized from local file system";
            CapellaProjectActivator.getDefault().log(1, message, null);
            if (__logger.isInfoEnabled()) {
                __logger.info((Object)new EmbeddedMessage(message, "User Interface"));
            }
        }
    }
}

