/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.validation.sequenceMessage;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.model.helpers.SequenceMessageExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class SequenceMessageExchangeItems
extends AbstractValidationRule {
    private static final String EXCHANGE_ITEMS_NAMES_LIST_SEPARATOR = new String(new char[]{'L'});

    public IStatus validate(IValidationContext ctx_p) {
        EMFEventType eType = ctx_p.getEventType();
        if (EMFEventType.NULL != eType) {
            return ctx_p.createSuccessStatus();
        }
        EObject eObj = ctx_p.getTarget();
        if (!(eObj instanceof SequenceMessage)) {
            return ctx_p.createSuccessStatus();
        }
        SequenceMessage element = (SequenceMessage)eObj;
        if (element.getKind() == MessageKind.REPLY) {
            return ctx_p.createSuccessStatus();
        }
        if (element.getInvokedOperation() == null) {
            return ctx_p.createSuccessStatus();
        }
        Collection invalidExchangeItems = SequenceMessageExt.getInvalidExchangeItems((SequenceMessage)element);
        if (!invalidExchangeItems.isEmpty()) {
            ArrayList<String> invalidExchangeItemsNames = new ArrayList<String>(invalidExchangeItems.size());
            for (AbstractExchangeItem abstractExchangeItem : invalidExchangeItems) {
                invalidExchangeItemsNames.add(abstractExchangeItem.getName());
            }
            return ctx_p.createFailureStatus(new Object[]{element.getName(), StringUtils.join(invalidExchangeItemsNames, (String)EXCHANGE_ITEMS_NAMES_LIST_SEPARATOR), invalidExchangeItemsNames.size() > 1 ? "are" : "is"});
        }
        return ctx_p.createSuccessStatus();
    }
}

