/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.capella.common.tools.report.util.LogExt;
import org.polarsys.capella.core.data.migration.AbstractMigrationRunnable;
import org.polarsys.capella.core.data.migration.Messages;
import org.polarsys.capella.core.data.migration.MigrationHelpers;
import org.polarsys.capella.core.data.migration.MigrationJob;
import org.polarsys.capella.core.data.migration.context.MigrationContext;

public class MigrationJobScheduler {
    LinkedList<AbstractMigrationRunnable> _runnables;
    IProgressMonitor _monitor;

    public void run(LinkedList<AbstractMigrationRunnable> runnables, final MigrationContext context, final boolean runInJob, final boolean checkVersion) {
        this._runnables = new LinkedList<AbstractMigrationRunnable>(runnables);
        if (this._runnables.isEmpty()) {
            this.logStatus(context, Status.CANCEL_STATUS);
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                MigrationJobScheduler.this._monitor = monitor;
                MigrationJobScheduler.this._monitor.beginTask(context.getName(), MigrationJobScheduler.this._runnables.size());
                context.setProgressMonitor(MigrationJobScheduler.this._monitor);
                if (runInJob) {
                    MigrationJobScheduler.this.executeNextJob(Status.OK_STATUS, context, checkVersion);
                } else {
                    IStatus status = Status.OK_STATUS;
                    try {
                        for (AbstractMigrationRunnable runnable : MigrationJobScheduler.this._runnables) {
                            context.setProgressMonitor((IProgressMonitor)SubMonitor.convert((IProgressMonitor)MigrationJobScheduler.this._monitor, (int)1));
                            status = runnable.run(context, checkVersion);
                            if (MigrationJobScheduler.this.checkStatusOK(status, context)) continue;
                            MigrationJobScheduler.this._runnables.clear();
                            return;
                        }
                    }
                    finally {
                        MigrationJobScheduler.this.logStatus(context, status);
                        MigrationHelpers.getInstance().dispose(context);
                    }
                }
            }
        };
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        Shell shell = win != null ? win.getShell() : null;
        try {
            new ProgressMonitorDialog(shell).run(true, true, op);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected boolean checkStatusOK(IStatus status, MigrationContext context) {
        return (status == null || status.isOK()) && !context.getProgressMonitor().isCanceled();
    }

    protected void executeNextJob(IStatus status, final MigrationContext context, final boolean checkVersion) {
        if (this.checkStatusOK(status, context)) {
            if (!this._runnables.isEmpty()) {
                AbstractMigrationRunnable firstJob = this._runnables.removeFirst();
                MigrationJob job = new MigrationJob(firstJob, context, checkVersion);
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        IStatus jobStatus = event.getResult();
                        IStatus internalStatus = (IStatus)event.getJob().getProperty(MigrationJob.RESULT_PROPERTY);
                        if (internalStatus != null && !internalStatus.isOK()) {
                            jobStatus = internalStatus;
                        }
                        MigrationJobScheduler.this.executeNextJob(jobStatus, context, checkVersion);
                    }
                });
                context.setProgressMonitor((IProgressMonitor)SubMonitor.convert((IProgressMonitor)this._monitor, (int)1));
                job.schedule();
                try {
                    job.join();
                }
                catch (InterruptedException exception) {
                    exception.printStackTrace();
                }
            } else {
                this.logStatus(context, status);
                MigrationHelpers.getInstance().dispose(context);
            }
        } else {
            this.logStatus(context, status);
            MigrationHelpers.getInstance().dispose(context);
            this._runnables.clear();
        }
    }

    protected void logStatus(MigrationContext context, IStatus status) {
        if (status.isOK()) {
            status = new Status(1, "org.polarsys.capella.core.data.migration", NLS.bind((String)Messages.MigrationAction_MigrationOK, (Object)context.getName()));
        }
        StatusManager.getManager().handle(status, 1);
        LogExt.log((String)"Model Management", (IStatus)status);
        if (!(context.isSkipConfirmation() || status.getSeverity() != 4 && status.getSeverity() != 2)) {
            StatusManager.getManager().handle(status, 4);
        }
    }
}

