/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.ecore.factories;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.query.legacy.ecore.AcceleoEcoreMessages;
import org.eclipse.sirius.query.legacy.ecore.AcceleoEcorePlugin;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.ecore.tools.ETools;

public class EFactory {
    protected Object factoryImpl = null;
    protected String id = "";
    protected ClassLoader loader;

    protected String getId() {
        return this.id;
    }

    public EFactory(String factoryId, EPackage ePackage, ClassLoader loader) {
        this.factoryImpl = ePackage.getEFactoryInstance();
        this.id = factoryId;
        this.loader = loader;
    }

    public EFactory(String factoryId, String factoryShortName, ClassLoader loader) throws FactoryException {
        this.loader = loader;
        this.init(factoryId, factoryShortName, loader);
    }

    private void init(String factoryId, String factoryShortName, ClassLoader loader) throws FactoryException {
        if (factoryId != null && factoryShortName != null && factoryId.length() > 0 && factoryShortName.length() > 0) {
            String rPackageImplClassName = String.valueOf(factoryId) + '.' + factoryShortName + "Package";
            try {
                Class<?> rPackageImplClass = Class.forName(rPackageImplClassName, true, loader);
                Field rPackageImplField = rPackageImplClass.getField("eINSTANCE");
                Method rPackageImplGetRessourcesFactoryMethod = rPackageImplClass.getMethod("get" + factoryShortName + "Factory", new Class[0]);
                Object packageImpl = rPackageImplField.get(null);
                this.factoryImpl = rPackageImplGetRessourcesFactoryMethod.invoke(packageImpl, new Object[0]);
                this.id = factoryId;
            }
            catch (Exception e) {
                throw new FactoryException(AcceleoEcoreMessages.getString("EFactory.UnexpectedException", new Object[]{e.getMessage()}));
            }
        } else {
            String factoryName = String.valueOf(factoryId) + ".impl." + factoryShortName + "FactoryImpl";
            throw new FactoryException(AcceleoEcoreMessages.getString("EFactory.UnresolvedFactory", new Object[]{factoryName}));
        }
    }

    public String getPath() {
        return this.id;
    }

    public EObject eCreate(String name) throws FactoryException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        try {
            String createName = "create" + name.substring(0, 1).toUpperCase() + name.substring(1);
            EObject eObject = (EObject)EFactory.eCall(this.factoryImpl, createName, null);
            return eObject;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private static Object eCall(Object object, String name, Object arg) throws FactoryException {
        try {
            Object[] objectArray;
            Class[] classArray;
            Class<?> clazz = object.getClass();
            if (arg != null) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = arg.getClass();
            } else {
                classArray = new Class[]{};
            }
            Method method = clazz.getMethod(name, classArray);
            if (arg != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = arg;
            } else {
                objectArray = new Object[]{};
            }
            return method.invoke(object, objectArray);
        }
        catch (Exception e) {
            throw new FactoryException(e.getMessage());
        }
    }

    public static void eSet(EObject object, String name, Object arg) throws FactoryException {
        EStructuralFeature feature = EFactory.eStructuralFeature(object, name);
        EFactory.eSet(object, feature, arg);
    }

    private static void eSet(EObject object, EStructuralFeature feature, Object arg) throws FactoryException {
        if (!EFactory.eSetEnum(object, feature, arg)) {
            object.eSet(feature, arg);
        }
    }

    private static boolean eSetEnum(EObject object, EStructuralFeature feature, Object arg) {
        if (feature != null && feature.getEType() instanceof EEnum && arg instanceof String) {
            try {
                arg = EFactory.eEnumValue(object, feature, arg);
                object.eSet(feature, arg);
            }
            catch (Exception e) {
                AcceleoEcorePlugin.getDefault().log(e, false);
            }
            return true;
        }
        return false;
    }

    private static Object eEnumValue(EObject object, EStructuralFeature feature, Object arg) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> c;
        String className = ETools.getEClassifierPath(feature.getEType());
        try {
            c = object.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            c = Class.forName(className);
        }
        Method m = c.getMethod("get", String.class);
        return m.invoke(c, arg);
    }

    public static void eSet(EObject object, String name, Object arg, ClassLoader loader) throws FactoryException {
        EStructuralFeature feature = EFactory.eStructuralFeature(object, name);
        if (feature != null && feature.getEType() instanceof EEnum && arg instanceof String) {
            try {
                Class<?> c = loader.loadClass(ETools.getEClassifierPath(feature.getEType()));
                Method m = c.getMethod("get", String.class);
                arg = m.invoke(c, arg);
                object.eSet(feature, arg);
            }
            catch (Exception e) {
                AcceleoEcorePlugin.getDefault().log(e, false);
            }
        } else {
            object.eSet(feature, arg);
        }
    }

    public static void eAdd(EObject object, String name, Object arg) throws FactoryException {
        EStructuralFeature feature = EFactory.eStructuralFeature(object, name);
        Object list = object.eGet(feature);
        if (list != null && list instanceof List) {
            if (arg != null) {
                if (feature != null && feature.getEType() instanceof EEnum && arg instanceof String) {
                    try {
                        arg = EFactory.eEnumValue(object, feature, arg);
                        ((List)list).add(arg);
                    }
                    catch (Exception e) {
                        AcceleoEcorePlugin.getDefault().log(e, false);
                    }
                } else {
                    ((List)list).add(arg);
                }
            }
        } else {
            EFactory.eSet(object, feature, arg);
        }
    }

    public static void eRemove(EObject object, String name, Object arg) throws FactoryException {
        EStructuralFeature feature = EFactory.eStructuralFeature(object, name);
        Object list = object.eGet(feature);
        if (list != null && list instanceof List) {
            if (arg != null) {
                if (feature != null && feature.getEType() instanceof EEnum && arg instanceof String) {
                    try {
                        arg = EFactory.eEnumValue(object, feature, arg);
                        ((List)list).remove(arg);
                    }
                    catch (Exception e) {
                        AcceleoEcorePlugin.getDefault().log(e, false);
                    }
                } else {
                    ((List)list).remove(arg);
                }
            }
        } else {
            EFactory.eSet(object, name, null);
        }
    }

    public static Object eGet(EObject object, String name) throws FactoryException {
        return EFactory.eGet(object, name, true);
    }

    public static Object eGet(EObject object, String name, boolean adpatEnum) throws FactoryException {
        Object result;
        EStructuralFeature feature = EFactory.doGetFeature(object, name);
        if (feature != null) {
            result = object.eGet(feature);
        } else {
            try {
                result = EFactory.eCall(object, name, null);
            }
            catch (FactoryException factoryException) {
                throw new FactoryException(AcceleoEcoreMessages.getString("EFactory.UnresolvedLink", new Object[]{name, object.eClass().getName()}));
            }
        }
        if (result != null && result instanceof Enumerator) {
            if (adpatEnum) {
                return ((Enumerator)result).getLiteral();
            }
            return result;
        }
        if (result != null && result instanceof BasicEList) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object next : (BasicEList)result) {
                if (adpatEnum && next instanceof Enumerator) {
                    list.add(((Enumerator)next).getLiteral());
                    continue;
                }
                list.add((String)next);
            }
            return list;
        }
        return result;
    }

    public static EStructuralFeature eStructuralFeature(EObject object, String name) throws FactoryException {
        EStructuralFeature structuralFeature = object.eClass().getEStructuralFeature(name);
        if (structuralFeature != null) {
            return structuralFeature;
        }
        throw new FactoryException(AcceleoEcoreMessages.getString("EFactory.UnresolvedLink", new Object[]{name, object.eClass().getName()}));
    }

    public static EObject eGetAsEObject(EObject object, String name) throws FactoryException {
        Object eGet = EFactory.eGet(object, name);
        if (eGet != null && eGet instanceof EObject) {
            return (EObject)eGet;
        }
        return null;
    }

    public static String eGetAsString(EObject object, String name) throws FactoryException {
        Object eGet = EFactory.eGet(object, name);
        if (eGet != null) {
            return eGet.toString();
        }
        return null;
    }

    public static Boolean eGetAsBoolean(EObject object, String name) throws FactoryException {
        Object eGet = EFactory.eGet(object, name);
        if (eGet != null && eGet instanceof Boolean) {
            return (Boolean)eGet;
        }
        return null;
    }

    public static Integer eGetAsInteger(EObject object, String name) throws FactoryException {
        Object eGet = EFactory.eGet(object, name);
        if (eGet != null && eGet instanceof Integer) {
            return (Integer)eGet;
        }
        return null;
    }

    public static List eGetAsList(EObject object, String name) throws FactoryException {
        Object eGet = EFactory.eGet(object, name);
        if (eGet != null) {
            if (eGet instanceof List) {
                return (List)eGet;
            }
            BasicEList list = new BasicEList(1);
            list.add(eGet);
            return list;
        }
        return null;
    }

    public static boolean eInstanceOf(EObject object, String name) {
        if (object == null) {
            return name == null;
        }
        if ("EObject".equals(name) || "ecore.EObject".equals(name)) {
            return true;
        }
        return EFactory.eInstanceOf(object.eClass(), name);
    }

    private static boolean eInstanceOf(EClass eClass, String name) {
        String endsWith;
        if (name.indexOf(46) == -1 && name.equals(eClass.getName())) {
            return true;
        }
        String instanceClassName = String.valueOf('.') + eClass.getInstanceClassName();
        if (instanceClassName.endsWith(endsWith = String.valueOf('.') + name)) {
            return true;
        }
        for (EClass eSuperClass : eClass.getESuperTypes()) {
            if (!EFactory.eInstanceOf(eSuperClass, name)) continue;
            return true;
        }
        return false;
    }

    public static boolean eValid(EObject object, String name) {
        try {
            EFactory.eGet(object, name);
            return true;
        }
        catch (FactoryException factoryException) {
            return false;
        }
    }

    private static EStructuralFeature doGetFeature(EObject object, String name) {
        return object.eClass().getEStructuralFeature(name);
    }
}

