/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.ecore.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.sirius.query.legacy.ecore.AcceleoEcoreMessages;
import org.eclipse.sirius.query.legacy.ecore.AcceleoEcorePlugin;
import org.eclipse.sirius.query.legacy.tools.plugins.AcceleoMetamodelProvider;
import org.eclipse.sirius.query.legacy.tools.resources.Resources;

public class ETools {
    private static Map ecore2EPackage = new WeakHashMap();
    private static Map ecore2OldModificationStamp = new HashMap();

    public static String getURI(EObject object) {
        if (object == null) {
            return "";
        }
        if (object.eResource() != null) {
            return object.eResource().getURIFragment(object);
        }
        StringBuffer result = new StringBuffer("//");
        ArrayList<String> uriFragmentPath = new ArrayList<String>();
        EObject container = object.eContainer();
        while (container != null) {
            uriFragmentPath.add(((InternalEObject)container).eURIFragmentSegment((EStructuralFeature)object.eContainmentFeature(), object));
            object = container;
            container = object.eContainer();
        }
        int size = uriFragmentPath.size();
        if (size > 0) {
            int i = size - 1;
            while (true) {
                result.append((String)uriFragmentPath.get(i));
                if (i == 0) break;
                result.append('/');
                --i;
            }
        }
        return result.toString();
    }

    public static EObject validate(EObject root, boolean blocker, String message) {
        if (root != null && !root.getClass().getName().startsWith("org.eclipse.uml2") && Diagnostician.INSTANCE.validate(root).getSeverity() != 0) {
            AcceleoEcorePlugin.getDefault().log(message, blocker);
            if (blocker) {
                return null;
            }
        }
        return root;
    }

    public static EPackage uri2EPackage(String path) {
        return ETools.uri2EPackage(path, true);
    }

    public static EPackage uri2EPackage(String path, boolean forceReload) {
        if (path != null && path.length() > 0) {
            EPackage regValue = EPackage.Registry.INSTANCE.getEPackage(path = path.trim());
            if (regValue != null) {
                return regValue;
            }
            return ETools.ecore2EPackage(path, forceReload);
        }
        return null;
    }

    private static EPackage ecore2EPackage(String path, boolean forceReload) {
        Path ecorePath = new Path(path);
        if (ecorePath.segmentCount() >= 2) {
            path = ecorePath.removeFileExtension().addFileExtension("ecore").toString();
            IFile ecoreFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
            if (ecoreFile != null && ecoreFile.exists()) {
                if (forceReload) {
                    return ETools.subEcore2EPackage(path, false);
                }
                EPackage ePackage = (EPackage)ecore2EPackage.get(path);
                Double newModificationStamp = new Double(ecoreFile.getModificationStamp());
                Double oldModificationStamp = (Double)ecore2OldModificationStamp.get(path);
                if (ePackage == null || oldModificationStamp == null || oldModificationStamp.doubleValue() != newModificationStamp.doubleValue()) {
                    ePackage = ETools.subEcore2EPackage(path, false);
                    ecore2EPackage.put(path, ePackage);
                    ecore2OldModificationStamp.put(path, newModificationStamp);
                }
                return ePackage;
            }
            File file = AcceleoMetamodelProvider.getDefault().getFile((IPath)new Path(path));
            if (file != null && file.exists()) {
                path = file.getAbsolutePath();
                if (forceReload) {
                    return ETools.subEcore2EPackage(path, true);
                }
                EPackage ePackage = (EPackage)ecore2EPackage.get(path);
                if (ePackage == null) {
                    ePackage = ETools.subEcore2EPackage(path, true);
                    ecore2EPackage.put(path, ePackage);
                    ecore2OldModificationStamp.put(path, null);
                }
                return ePackage;
            }
            return null;
        }
        return null;
    }

    private static EPackage subEcore2EPackage(String path, boolean isExternal) {
        EObject result;
        URI ecoreURI = isExternal ? URI.createFileURI((String)path) : Resources.createPlatformResourceURI(path);
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        reg.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        ResourceSetImpl ecoreResourceSet = new ResourceSetImpl();
        Resource ecoreResource = ecoreResourceSet.getResource(ecoreURI, true);
        EObject eObject = result = ecoreResource.getContents().size() > 0 ? (EObject)ecoreResource.getContents().get(0) : null;
        if (result instanceof EPackage) {
            EPackage regValue;
            String nsURI = ETools.getNsURI((EPackage)result);
            if (nsURI != null && (regValue = EPackage.Registry.INSTANCE.getEPackage(nsURI)) != null) {
                return regValue;
            }
            return (EPackage)ETools.validate((EObject)((EPackage)result), false, AcceleoEcoreMessages.getString("ETools.ModelValidationNeeded", new Object[]{path}));
        }
        return null;
    }

    private static String getNsURI(EPackage p) {
        String pNsURI = p.getNsURI();
        if (pNsURI != null && pNsURI.length() > 0) {
            return pNsURI;
        }
        if (p.getESubpackages().size() == 1) {
            return ETools.getNsURI((EPackage)p.getESubpackages().get(0));
        }
        return null;
    }

    public static EClassifier[] computeAllClassifiers(EPackage ePackage) {
        List classifiers = ETools.computeAllClassifiersList(ePackage);
        return classifiers.toArray(new EClassifier[0]);
    }

    public static List computeAllClassifiersList(EPackage ePackage) {
        return ETools.computeAllClassifiersList(ePackage, false);
    }

    public static List computeAllClassifiersList(EPackage ePackage, boolean classOnly) {
        BasicEList classifiers = new BasicEList();
        if (ePackage != null) {
            ETools.computeAllClassifiersList(ePackage, (List)classifiers, classOnly);
        }
        return classifiers;
    }

    private static void computeAllClassifiersList(EPackage ePackage, List all, boolean classOnly) {
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (!classOnly) {
                all.add(classifier);
                continue;
            }
            if (!(classifier instanceof EClass) || ((EClass)classifier).isAbstract() || ((EClass)classifier).isInterface()) continue;
            all.add(classifier);
        }
        Iterator packages = ePackage.getESubpackages().iterator();
        while (packages.hasNext()) {
            ETools.computeAllClassifiersList((EPackage)packages.next(), all, classOnly);
        }
    }

    public static EClassifier getEClassifier(EPackage ePackage, String name) {
        if (ePackage == null || name == null) {
            return null;
        }
        name = name.trim();
        EClass get = null;
        if (name.equals("EObject") || name.equals("ecore.EObject")) {
            get = EcorePackage.eINSTANCE.getEObject();
        }
        Iterator classifiers = ePackage.getEClassifiers().iterator();
        while (get == null && classifiers.hasNext()) {
            String endsWith;
            EClassifier classifier = (EClassifier)classifiers.next();
            String instanceClassName = String.valueOf('.') + ETools.getEClassifierPath(classifier);
            if (!instanceClassName.endsWith(endsWith = String.valueOf('.') + name)) continue;
            get = classifier;
        }
        Iterator packages = ePackage.getESubpackages().iterator();
        while (get == null && packages.hasNext()) {
            EClassifier classifier = ETools.getEClassifier((EPackage)packages.next(), name);
            if (classifier == null) continue;
            get = classifier;
        }
        return get;
    }

    public static EStructuralFeature getEStructuralFeature(EClassifier currentEClassifier, String name) {
        if (currentEClassifier != null && currentEClassifier instanceof EClass) {
            return ETools.getEStructuralFeature((EClass)currentEClassifier, name);
        }
        return null;
    }

    public static EStructuralFeature getEStructuralFeature(EClass currentEClass, String name) {
        name = name.trim();
        if (currentEClass != null) {
            return currentEClass.getEStructuralFeature(name);
        }
        return null;
    }

    public static String getEClassifierFactoryName(EClassifier eClassifier) {
        return String.valueOf(ETools.getEClassifierFactoryShortName(eClassifier)) + "Factory";
    }

    public static String getEClassifierFactoryShortName(EClassifier eClassifier) {
        EPackage p;
        String name;
        if (eClassifier != null && (name = (p = eClassifier.getEPackage()).getName()) != null && name.length() > 0) {
            return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    public static String getEClassifierPath(EClassifier eClassifier) {
        block1: {
            block2: {
                if (eClassifier == null) break block1;
                instanceClassName = eClassifier.getInstanceClassName();
                name = eClassifier.getName();
                if (eClassifier.getEPackage() == null) break block2;
                container = eClassifier.getEPackage();
                if (container == null || instanceClassName == null || !instanceClassName.endsWith(String.valueOf(container.getName()) + '.' + name)) ** GOTO lbl10
                return instanceClassName;
lbl-1000:
                // 1 sources

                {
                    name = String.valueOf(container.getName()) + '.' + name;
                    container = container.getESuperPackage();
lbl10:
                    // 2 sources

                    ** while (container != null)
                }
            }
            return name;
        }
        return null;
    }

    public static String getEClassifierShortPath(EClassifier eClassifier) {
        String name = eClassifier.getName();
        if (eClassifier.getEPackage() != null) {
            name = String.valueOf(eClassifier.getEPackage().getName()) + '.' + name;
        }
        return name;
    }

    public static EPackage createPackageHierarchy(String path) {
        EPackage ePackage = null;
        if (path != null && path.length() > 0) {
            EcorePackage p = EcorePackageImpl.init();
            EcoreFactory factory = p.getEcoreFactory();
            EPackage parent = null;
            StringTokenizer st = new StringTokenizer(path, ".");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                EPackage child = factory.createEPackage();
                child.setName(name);
                if (parent != null) {
                    parent.getESubpackages().add((Object)child);
                } else {
                    ePackage = child;
                }
                parent = child;
            }
        }
        return ePackage;
    }

    public static EPackage getEPackage(EPackage parent, String path) {
        EPackage ePackage = parent;
        if (path != null && path.length() > 0) {
            StringTokenizer st = new StringTokenizer(path, ".");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                boolean found = false;
                Iterator subPackages = ePackage.getESubpackages().iterator();
                while (!found && subPackages.hasNext()) {
                    EPackage subPackage = (EPackage)subPackages.next();
                    if (!subPackage.getName().equals(name)) continue;
                    found = true;
                    ePackage = subPackage;
                }
                if (found) continue;
                return null;
            }
        }
        return ePackage;
    }

    public static boolean ofType(EClassifier classifier, String type) {
        if (classifier instanceof EClass) {
            return ETools.ofType((EClass)classifier, type);
        }
        return ETools.ofClass(classifier, type);
    }

    public static boolean ofType(EClass eClass, String type) {
        if ("EObject".equalsIgnoreCase(type) || "ecore.EObject".equalsIgnoreCase(type) || ETools.ofClass((EClassifier)eClass, type)) {
            return true;
        }
        for (EClassifier superType : eClass.getESuperTypes()) {
            if (!ETools.ofType(superType, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean ofClass(EClassifier classifier, String type) {
        String path = ETools.getEClassifierPath(classifier);
        return (String.valueOf('.') + path).endsWith(String.valueOf('.') + type);
    }

    public static EObject loadXMI(String path) {
        return ETools.loadXMI(path, null);
    }

    public static EObject loadXMI(String path, String resourceFactoryExtension) {
        URI modelURI = Resources.createPlatformResourceURI(path);
        String fileExtension = modelURI.fileExtension();
        if (fileExtension == null || fileExtension.length() == 0) {
            fileExtension = "*";
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Object resourceFactory = resourceFactoryExtension != null ? reg.getExtensionToFactoryMap().get(resourceFactoryExtension) : reg.getExtensionToFactoryMap().get(fileExtension);
        if (resourceFactory != null) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, resourceFactory);
        } else {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
        }
        Resource modelResource = resourceSet.getResource(modelURI, true);
        return modelResource.getContents().size() > 0 ? (EObject)modelResource.getContents().get(0) : null;
    }
}

