/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.expressions;

import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeIterator;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeList;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.TextSearch;

public class ExpressionTools {
    public static ENode or(ENode e1, ENode e2) throws ENodeCastException {
        if (e1.isList()) {
            ENodeList res = new ENodeList();
            if (e2.isList()) {
                res.addAll(e1.getList());
                res.addAll(e2.getList());
            } else {
                res.addAll(e1.getList());
                res.add(e1);
            }
            return new ENode(res, e1);
        }
        if (e1.isBoolean() && e2.isBoolean()) {
            return new ENode(e1.getBoolean() || e2.getBoolean(), e1);
        }
        return new ENode((Boolean)e1.getAdapterValue(Boolean.TYPE) != false || (Boolean)e2.getAdapterValue(Boolean.TYPE) != false, e1);
    }

    public static ENode and(ENode e1, ENode e2) throws ENodeCastException {
        if (e1.isList()) {
            ENodeList res = new ENodeList();
            if (e2.isList()) {
                ENodeIterator it = e1.getList().iterator();
                while (it.hasNext()) {
                    ENode n1 = it.next();
                    if (!e2.getList().contains(n1)) continue;
                    res.add(n1);
                }
            } else {
                ENodeIterator it = e1.getList().iterator();
                while (it.hasNext()) {
                    ENode n1 = it.next();
                    if (!e2.equals(n1)) continue;
                    res.add(n1);
                }
            }
            return new ENode(res, e1);
        }
        if (e1.isBoolean() && e2.isBoolean()) {
            return new ENode(e1.getBoolean() && e2.getBoolean(), e1);
        }
        return new ENode((Boolean)e1.getAdapterValue(Boolean.TYPE) != false && (Boolean)e2.getAdapterValue(Boolean.TYPE) != false, e1);
    }

    public static ENode equals(ENode e1, ENode e2) throws ENodeCastException {
        return new ENode(e1.equals(e2), e1);
    }

    public static ENode notEquals(ENode e1, ENode e2) throws ENodeCastException {
        return new ENode(!e1.equals(e2), e1);
    }

    public static ENode add(ENode e1, ENode e2) throws ENodeCastException {
        if (e1.isList()) {
            ENodeList res = new ENodeList();
            if (e2.isList()) {
                res.addAll(e1.getList());
                res.addAll(e2.getList());
            } else {
                res.addAll(e1.getList());
                res.add(e2);
            }
            return new ENode(res, e1);
        }
        if (e2.isList()) {
            ENodeList res = new ENodeList();
            res.add(e1);
            res.addAll(e2.getList());
            return new ENode(res, e1);
        }
        if (e1.isInt() && e2.isInt()) {
            return new ENode(e1.getInt() + e2.getInt(), e1);
        }
        if (e1.isDouble() && e2.isDouble()) {
            return new ENode(e1.getDouble() + e2.getDouble(), e1);
        }
        if (e1.isDouble() && e2.isInt()) {
            return new ENode(e1.getDouble() + (double)e2.getInt(), e1);
        }
        if (e1.isInt() && e2.isDouble()) {
            return new ENode((double)e1.getInt() + e2.getDouble(), e1);
        }
        if (e1.isString() || e2.isString()) {
            ENode result = new ENode("", e1);
            result.append(e1);
            result.append(e2);
            return result;
        }
        if (e1.isNull()) {
            return e2;
        }
        if (e2.isNull()) {
            return e1;
        }
        ENodeList res = new ENodeList();
        res.add(e1);
        res.add(e2);
        return new ENode(res, e1);
    }

    public static ENode sub(ENode e1, ENode e2) throws ENodeCastException {
        if (e1.isList()) {
            ENodeList res = new ENodeList();
            res.addAll(e1.getList());
            if (e2.isList()) {
                ENodeIterator it = e2.getList().iterator();
                while (it.hasNext()) {
                    ENode n2 = it.next();
                    res.remove(n2);
                }
            } else {
                res.remove(e2);
            }
            return new ENode(res, e1);
        }
        if (e1.isInt() && e2.isInt()) {
            return new ENode(e1.getInt() - e2.getInt(), e1);
        }
        if (e1.isDouble() && e2.isDouble()) {
            return new ENode(e1.getDouble() - e2.getDouble(), e1);
        }
        if (e1.isDouble() && e2.isInt()) {
            return new ENode(e1.getDouble() - (double)e2.getInt(), e1);
        }
        if (e1.isInt() && e2.isDouble()) {
            return new ENode((double)e1.getInt() - e2.getDouble(), e1);
        }
        if (e1.isNull()) {
            return e1;
        }
        if (e2.isNull()) {
            return e1;
        }
        if (e1.isString()) {
            Int2[] positions = TextSearch.getDefaultSearch().allIndexOf(e1.getString(), e2.toString());
            if (positions.length == 0) {
                return e1;
            }
            String s1 = e1.getString();
            StringBuffer result = new StringBuffer(s1.substring(0, positions[0].b()));
            int i = 1;
            while (i < positions.length) {
                result.append(s1.substring(positions[i - 1].e(), positions[i].b()));
                ++i;
            }
            result.append(s1.substring(positions[positions.length - 1].e(), s1.length()));
            return new ENode(result.toString(), e1);
        }
        if (e1.isEObject()) {
            if (e1.equals(e2)) {
                return new ENode(ENode.EMPTY, e1);
            }
            return e1;
        }
        String expression = String.valueOf(e1.getType()) + ' ' + TemplateConstants.OPERATOR_SUB + ' ' + e2.getType();
        throw new ENodeCastException(AcceleoGenMessages.getString("ExpressionTools.InvalidExpression", new Object[]{expression}));
    }

    public static ENode div(ENode e1, ENode e2) throws ENodeCastException {
        if (e1.isInt() && e2.isInt()) {
            return new ENode(e1.getInt() / ExpressionTools.div0(e2.getInt()), e1);
        }
        if (e1.isDouble() && e2.isDouble()) {
            return new ENode(e1.getDouble() / ExpressionTools.div0(e2.getDouble()), e1);
        }
        if (e1.isDouble() && e2.isInt()) {
            return new ENode(e1.getDouble() / (double)ExpressionTools.div0(e2.getInt()), e1);
        }
        if (e1.isInt() && e2.isDouble()) {
            return new ENode((double)e1.getInt() / ExpressionTools.div0(e2.getDouble()), e1);
        }
        try {
            if (e2.isInt() || e2.isString() && e2.getString().indexOf(".") == -1) {
                return new ENode((Integer)e1.getAdapterValue(Integer.TYPE) / ExpressionTools.div0((Integer)e2.getAdapterValue(Integer.TYPE)), e1);
            }
        }
        catch (ENodeCastException eNodeCastException) {}
        try {
            if (e2.isDouble() || e2.isString()) {
                return new ENode((Double)e1.getAdapterValue(Double.TYPE) / ExpressionTools.div0((Double)e2.getAdapterValue(Double.TYPE)), e1);
            }
        }
        catch (ENodeCastException eNodeCastException) {}
        String expression = String.valueOf(e1.getType()) + ' ' + TemplateConstants.OPERATOR_DIV + ' ' + e2.getType();
        throw new ENodeCastException(AcceleoGenMessages.getString("ExpressionTools.InvalidExpression", new Object[]{expression}));
    }

    private static int div0(int i) throws ENodeCastException {
        if (i == 0) {
            throw new ENodeCastException(AcceleoGenMessages.getString("ExpressionTools.ZeroDivide"));
        }
        return i;
    }

    private static double div0(double d) throws ENodeCastException {
        if (d == 0.0) {
            throw new ENodeCastException(AcceleoGenMessages.getString("ExpressionTools.ZeroDivide"));
        }
        return d;
    }

    public static ENode mul(ENode e1, ENode e2) throws ENodeCastException {
        if (e1.isInt() && e2.isInt()) {
            return new ENode(e1.getInt() * e2.getInt(), e1);
        }
        if (e1.isDouble() && e2.isDouble()) {
            return new ENode(e1.getDouble() * e2.getDouble(), e1);
        }
        if (e1.isDouble() && e2.isInt()) {
            return new ENode(e1.getDouble() * (double)e2.getInt(), e1);
        }
        if (e1.isInt() && e2.isDouble()) {
            return new ENode((double)e1.getInt() * e2.getDouble(), e1);
        }
        try {
            if ((e1.isInt() || e1.isString() && e1.getString().indexOf(".") == -1) && (e2.isInt() || e2.isString() && e2.getString().indexOf(".") == -1)) {
                return new ENode((Integer)e1.getAdapterValue(Integer.TYPE) * (Integer)e2.getAdapterValue(Integer.TYPE), e1);
            }
        }
        catch (ENodeCastException eNodeCastException) {}
        try {
            if ((e1.isDouble() || e1.isString()) && (e2.isDouble() || e2.isString())) {
                return new ENode((Double)e1.getAdapterValue(Double.TYPE) * (Double)e2.getAdapterValue(Double.TYPE), e1);
            }
        }
        catch (ENodeCastException eNodeCastException) {}
        String expression = String.valueOf(e1.getType()) + ' ' + TemplateConstants.OPERATOR_MUL + ' ' + e2.getType();
        throw new ENodeCastException(AcceleoGenMessages.getString("ExpressionTools.InvalidExpression", new Object[]{expression}));
    }

    public static ENode sup(ENode e1, ENode e2) throws ENodeCastException {
        if (e1.isInt() && e2.isInt()) {
            return new ENode(e1.getInt() > e2.getInt(), e1);
        }
        if (e1.isDouble() && e2.isDouble()) {
            return new ENode(e1.getDouble() > e2.getDouble(), e1);
        }
        if (e1.isDouble() && e2.isInt()) {
            return new ENode(e1.getDouble() > (double)e2.getInt(), e1);
        }
        if (e1.isInt() && e2.isDouble()) {
            return new ENode((double)e1.getInt() > e2.getDouble(), e1);
        }
        if (e1.isString() && e2.isString()) {
            return new ENode(e1.getString().compareTo(e2.getString()) > 0, e1);
        }
        try {
            return new ENode((Double)e1.getAdapterValue(Double.TYPE) > (Double)e2.getAdapterValue(Double.TYPE), e1);
        }
        catch (ENodeCastException eNodeCastException) {
            String expression = String.valueOf(e1.toString()) + '>' + e2.toString() + " [" + e1.getType() + '>' + e2.getType() + ']';
            throw new ENodeCastException(AcceleoGenMessages.getString("ExpressionTools.AdapterNotFound", new Object[]{">", expression}));
        }
    }

    public static ENode supE(ENode e1, ENode e2) throws ENodeCastException {
        if (e1.isInt() && e2.isInt()) {
            return new ENode(e1.getInt() >= e2.getInt(), e1);
        }
        if (e1.isDouble() && e2.isDouble()) {
            return new ENode(e1.getDouble() >= e2.getDouble(), e1);
        }
        if (e1.isDouble() && e2.isInt()) {
            return new ENode(e1.getDouble() >= (double)e2.getInt(), e1);
        }
        if (e1.isInt() && e2.isDouble()) {
            return new ENode((double)e1.getInt() >= e2.getDouble(), e1);
        }
        if (e1.isString() && e2.isString()) {
            return new ENode(e1.getString().compareTo(e2.getString()) >= 0, e1);
        }
        try {
            return new ENode((Double)e1.getAdapterValue(Double.TYPE) >= (Double)e2.getAdapterValue(Double.TYPE), e1);
        }
        catch (ENodeCastException eNodeCastException) {
            String expression = String.valueOf(e1.toString()) + ">=" + e2.toString() + " [" + e1.getType() + ">=" + e2.getType() + ']';
            throw new ENodeCastException(AcceleoGenMessages.getString("ExpressionTools.AdapterNotFound", new Object[]{">=", expression}));
        }
    }

    public static ENode inf(ENode e1, ENode e2) throws ENodeCastException {
        if (e1.isInt() && e2.isInt()) {
            return new ENode(e1.getInt() < e2.getInt(), e1);
        }
        if (e1.isDouble() && e2.isDouble()) {
            return new ENode(e1.getDouble() < e2.getDouble(), e1);
        }
        if (e1.isDouble() && e2.isInt()) {
            return new ENode(e1.getDouble() < (double)e2.getInt(), e1);
        }
        if (e1.isInt() && e2.isDouble()) {
            return new ENode((double)e1.getInt() < e2.getDouble(), e1);
        }
        if (e1.isString() && e2.isString()) {
            return new ENode(e1.getString().compareTo(e2.getString()) < 0, e1);
        }
        try {
            return new ENode((Double)e1.getAdapterValue(Double.TYPE) < (Double)e2.getAdapterValue(Double.TYPE), e1);
        }
        catch (ENodeCastException eNodeCastException) {
            String expression = String.valueOf(e1.toString()) + '<' + e2.toString() + " [" + e1.getType() + '<' + e2.getType() + ']';
            throw new ENodeCastException(AcceleoGenMessages.getString("ExpressionTools.AdapterNotFound", new Object[]{"<", expression}));
        }
    }

    public static ENode infE(ENode e1, ENode e2) throws ENodeCastException {
        if (e1.isInt() && e2.isInt()) {
            return new ENode(e1.getInt() <= e2.getInt(), e1);
        }
        if (e1.isDouble() && e2.isDouble()) {
            return new ENode(e1.getDouble() <= e2.getDouble(), e1);
        }
        if (e1.isDouble() && e2.isInt()) {
            return new ENode(e1.getDouble() <= (double)e2.getInt(), e1);
        }
        if (e1.isInt() && e2.isDouble()) {
            return new ENode((double)e1.getInt() <= e2.getDouble(), e1);
        }
        if (e1.isString() && e2.isString()) {
            return new ENode(e1.getString().compareTo(e2.getString()) <= 0, e1);
        }
        try {
            return new ENode((Double)e1.getAdapterValue(Double.TYPE) <= (Double)e2.getAdapterValue(Double.TYPE), e1);
        }
        catch (ENodeCastException eNodeCastException) {
            String expression = String.valueOf(e1.toString()) + "<=" + e2.toString() + " [" + e1.getType() + "<=" + e2.getType() + ']';
            throw new ENodeCastException(AcceleoGenMessages.getString("ExpressionTools.AdapterNotFound", new Object[]{"<=", expression}));
        }
    }
}

