/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.widgets;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;
import org.polarsys.capella.common.ui.toolkit.internal.StringMatcher;
import org.polarsys.capella.common.ui.toolkit.widgets.Messages;

public class MdeFilteredList
extends Composite {
    private Table fList;
    ILabelProvider fLabelProvider;
    private boolean fMatchEmptyString = true;
    private boolean fIgnoreCase;
    private boolean fAllowDuplicates;
    private String fFilter = "";
    private TwoArrayQuickSorter fSorter;
    Object[] fElements = new Object[0];
    Label[] fLabels;
    Vector<Image> fImages = new Vector();
    int[] fFoldedIndices;
    int fFoldedCount;
    int[] fFilteredIndices;
    int fFilteredCount;
    private FilterMatcher fFilterMatcher = new DefaultFilterMatcher();
    Comparator fComparator;
    TableUpdateJob fUpdateJob;

    public MdeFilteredList(Composite parent, int style, ILabelProvider labelProvider, boolean ignoreCase, boolean allowDuplicates, boolean matchEmptyString) {
        super(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.fList = new Table((Composite)this, style);
        this.fList.setLayoutData((Object)new GridData(1808));
        this.fList.setFont(parent.getFont());
        this.fList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MdeFilteredList.this.fLabelProvider.dispose();
                if (MdeFilteredList.this.fUpdateJob != null) {
                    MdeFilteredList.this.fUpdateJob.cancel();
                }
            }
        });
        this.fLabelProvider = labelProvider;
        this.fIgnoreCase = ignoreCase;
        this.fSorter = new TwoArrayQuickSorter(new LabelComparator(ignoreCase));
        this.fAllowDuplicates = allowDuplicates;
        this.fMatchEmptyString = matchEmptyString;
    }

    public void setElements(Object[] elements) {
        if (elements == null) {
            this.fElements = new Object[0];
        } else {
            this.fElements = new Object[elements.length];
            System.arraycopy(elements, 0, this.fElements, 0, elements.length);
        }
        int length = this.fElements.length;
        this.fLabels = new Label[length];
        HashSet<Image> imageSet = new HashSet<Image>();
        int i = 0;
        while (i != length) {
            String text = this.fLabelProvider.getText(this.fElements[i]);
            Image image = this.fLabelProvider.getImage(this.fElements[i]);
            this.fLabels[i] = new Label(text, image);
            imageSet.add(image);
            ++i;
        }
        this.fImages.clear();
        this.fImages.addAll(imageSet);
        this.fSorter.sort(this.fLabels, this.fElements);
        this.fFilteredIndices = new int[length];
        this.fFoldedIndices = new int[length];
        this.updateList();
    }

    public boolean isEmpty() {
        return this.fElements == null || this.fElements.length == 0;
    }

    public void setFilterMatcher(FilterMatcher filterMatcher) {
        Assert.isNotNull((Object)filterMatcher);
        this.fFilterMatcher = filterMatcher;
    }

    public void setComparator(Comparator comparator) {
        Assert.isNotNull((Object)comparator);
        this.fComparator = comparator;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fList.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.fList.removeSelectionListener(listener);
    }

    public void setSelection(int[] selection) {
        if (selection == null || selection.length == 0) {
            this.fList.deselectAll();
        } else if (this.fUpdateJob == null) {
            this.fList.setSelection(selection);
            this.fList.notifyListeners(13, new Event());
        } else {
            this.fUpdateJob.updateSelection(selection);
        }
    }

    public int[] getSelectionIndices() {
        return this.fList.getSelectionIndices();
    }

    public int getSelectionIndex() {
        return this.fList.getSelectionIndex();
    }

    public void setSelection(Object[] elements) {
        if (elements == null || elements.length == 0) {
            this.fList.deselectAll();
            return;
        }
        if (this.fElements == null) {
            return;
        }
        int[] indices = new int[elements.length];
        int i = 0;
        while (i != elements.length) {
            int j = 0;
            while (j != this.fFoldedCount) {
                int max = j == this.fFoldedCount - 1 ? this.fFilteredCount : this.fFoldedIndices[j + 1];
                int l = this.fFoldedIndices[j];
                while (l != max) {
                    if (this.fElements[this.fFilteredIndices[l]].equals(elements[i])) {
                        indices[i] = j;
                        break;
                    }
                    ++l;
                }
                if (l != max) break;
                ++j;
            }
            if (j == this.fFoldedCount) {
                indices[i] = 0;
            }
            ++i;
        }
        this.setSelection(indices);
    }

    public Object[] getSelection() {
        if (this.fList.isDisposed() || this.fList.getSelectionCount() == 0) {
            return new Object[0];
        }
        int[] indices = this.fList.getSelectionIndices();
        Object[] elements = new Object[indices.length];
        int i = 0;
        while (i != indices.length) {
            elements[i] = this.fElements[this.fFilteredIndices[this.fFoldedIndices[indices[i]]]];
            ++i;
        }
        return elements;
    }

    public void setFilter(String filter) {
        this.fFilter = filter == null ? "" : filter;
        this.updateList();
    }

    private void updateList() {
        this.fFilteredCount = this.filter();
        this.fFoldedCount = this.fold();
        if (this.fUpdateJob != null) {
            this.fUpdateJob.cancel();
        }
        this.fUpdateJob = new TableUpdateJob(this.fList, this.fFoldedCount);
        if (PlatformUI.isWorkbenchRunning()) {
            this.fUpdateJob.schedule();
        } else {
            this.fUpdateJob.runInUIThread((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public String getFilter() {
        return this.fFilter;
    }

    public Object[] getFoldedElements(int index) {
        if (index < 0 || index >= this.fFoldedCount) {
            return new Object[0];
        }
        int start = this.fFoldedIndices[index];
        int count = index == this.fFoldedCount - 1 ? this.fFilteredCount - start : this.fFoldedIndices[index + 1] - start;
        Object[] elements = new Object[count];
        int i = 0;
        while (i != count) {
            elements[i] = this.fElements[this.fFilteredIndices[start + i]];
            ++i;
        }
        return elements;
    }

    private int fold() {
        if (this.fAllowDuplicates) {
            int i = 0;
            while (i != this.fFilteredCount) {
                this.fFoldedIndices[i] = i;
                ++i;
            }
            return this.fFilteredCount;
        }
        int k = 0;
        Label last = null;
        int i = 0;
        while (i != this.fFilteredCount) {
            int j = this.fFilteredIndices[i];
            Label current = this.fLabels[j];
            if (!current.equals(last)) {
                this.fFoldedIndices[k] = i;
                ++k;
                last = current;
            }
            ++i;
        }
        return k;
    }

    private int filter() {
        if (!(this.fFilter != null && this.fFilter.length() != 0 || this.fMatchEmptyString)) {
            return 0;
        }
        if (this.fFilter != null) {
            this.fFilterMatcher.setFilter(this.fFilter.trim(), this.fIgnoreCase, false);
        }
        int k = 0;
        int i = 0;
        while (i != this.fElements.length) {
            if (this.fFilterMatcher.match(this.fElements[i])) {
                this.fFilteredIndices[k++] = i;
            }
            ++i;
        }
        return k;
    }

    public boolean getAllowDuplicates() {
        return this.fAllowDuplicates;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.fAllowDuplicates = allowDuplicates;
    }

    public boolean getIgnoreCase() {
        return this.fIgnoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.fIgnoreCase = ignoreCase;
    }

    public boolean getMatchEmptyString() {
        return this.fMatchEmptyString;
    }

    public void setMatchEmptyString(boolean matchEmptyString) {
        this.fMatchEmptyString = matchEmptyString;
    }

    public ILabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
    }

    class DefaultFilterMatcher
    implements FilterMatcher {
        private StringMatcher fMatcher;

        DefaultFilterMatcher() {
        }

        @Override
        public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
            this.fMatcher = new StringMatcher(String.valueOf(pattern) + '*', ignoreCase, ignoreWildCards);
        }

        @Override
        public boolean match(Object element) {
            return this.fMatcher.match(MdeFilteredList.this.fLabelProvider.getText(element));
        }
    }

    public static interface FilterMatcher {
        public void setFilter(String var1, boolean var2, boolean var3);

        public boolean match(Object var1);
    }

    private static class Label {
        public final String string;
        public final Image image;

        public Label(String newString, Image image) {
            this.string = newString == null ? "" : newString;
            this.image = image;
        }

        public boolean equals(Label label) {
            if (label == null) {
                return false;
            }
            if (this.string == null && label.string != null) {
                return false;
            }
            if (this.string != null && !this.string.equals(label.string)) {
                return false;
            }
            if (this.image == null) {
                return label.image == null;
            }
            return this.image.equals((Object)label.image);
        }
    }

    private final class LabelComparator
    implements Comparator {
        private boolean labelIgnoreCase;

        LabelComparator(boolean ignoreCase) {
            this.labelIgnoreCase = ignoreCase;
        }

        public int compare(Object left, Object right) {
            Label leftLabel = (Label)left;
            Label rightLabel = (Label)right;
            int value = MdeFilteredList.this.fComparator == null ? (this.labelIgnoreCase ? leftLabel.string.compareToIgnoreCase(rightLabel.string) : leftLabel.string.compareTo(rightLabel.string)) : MdeFilteredList.this.fComparator.compare(leftLabel.string, rightLabel.string);
            if (value != 0) {
                return value;
            }
            if (leftLabel.image == null) {
                return rightLabel.image == null ? 0 : -1;
            }
            if (rightLabel.image == null) {
                return 1;
            }
            return MdeFilteredList.this.fImages.indexOf(leftLabel.image) - MdeFilteredList.this.fImages.indexOf(rightLabel.image);
        }
    }

    private class TableUpdateJob
    extends WorkbenchJob {
        final Table fTable;
        final int fCount;
        private int currentIndex;
        int[] indicesToSelect;
        private boolean readyForSelection;

        public TableUpdateJob(Table table, int count) {
            super(Messages.getString("FilteredList_UpdateJobName"));
            this.currentIndex = 0;
            this.readyForSelection = false;
            this.setSystem(true);
            this.fTable = table;
            this.fCount = count;
        }

        public boolean shouldSchedule() {
            return true;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.fTable.isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            int itemCount = this.fTable.getItemCount();
            if (this.fCount < itemCount) {
                this.fTable.setRedraw(false);
                this.fTable.remove(this.fCount, itemCount - 1);
                this.fTable.setRedraw(true);
                itemCount = this.fTable.getItemCount();
            }
            if (this.fCount == 0) {
                this.fTable.notifyListeners(13, new Event());
                return Status.OK_STATUS;
            }
            int iterations = Math.min(10, this.fCount - this.currentIndex);
            int i = 0;
            while (i < iterations) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                TableItem item = this.currentIndex < itemCount ? this.fTable.getItem(this.currentIndex) : new TableItem(this.fTable, 0);
                Label label = MdeFilteredList.this.fLabels[MdeFilteredList.this.fFilteredIndices[MdeFilteredList.this.fFoldedIndices[this.currentIndex]]];
                item.setText(label.string);
                item.setImage(label.image);
                ++this.currentIndex;
                ++i;
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (this.currentIndex < this.fCount) {
                this.schedule(100L);
            } else {
                if (this.indicesToSelect == null) {
                    if (this.fCount > 0) {
                        if (this.fTable.getSelectionIndices().length == 0) {
                            this.defaultSelect();
                        } else {
                            this.fTable.notifyListeners(13, new Event());
                        }
                    }
                } else {
                    this.selectAndNotify(this.indicesToSelect);
                }
                this.readyForSelection = true;
            }
            return Status.OK_STATUS;
        }

        void updateSelection(int[] indices) {
            this.indicesToSelect = indices;
            if (this.readyForSelection) {
                this.selectAndNotify(indices);
            }
        }

        private void defaultSelect() {
            this.selectAndNotify(new int[1]);
        }

        private void selectAndNotify(int[] indices) {
            if (this.fTable.isDisposed()) {
                return;
            }
            this.fTable.setSelection(indices);
            this.fTable.notifyListeners(13, new Event());
        }
    }

    protected static class TwoArrayQuickSorter {
        private Comparator fComparator;

        public TwoArrayQuickSorter(boolean ignoreCase) {
            this.fComparator = new StringComparator(ignoreCase);
        }

        public TwoArrayQuickSorter(Comparator comparator) {
            this.fComparator = comparator;
        }

        public void sort(Object[] keys, Object[] values) {
            if (keys == null || values == null) {
                Assert.isTrue((boolean)false, (String)"Either keys or values in null");
                return;
            }
            if (keys.length <= 1) {
                return;
            }
            this.internalSort(keys, values, 0, keys.length - 1);
        }

        private void internalSort(Object[] keys, Object[] values, int left, int right) {
            int l = left;
            int r = right;
            int original_left = l;
            int original_right = r;
            Object mid = keys[(l + r) / 2];
            while (true) {
                if (this.fComparator.compare(keys[l], mid) < 0) {
                    ++l;
                    continue;
                }
                while (this.fComparator.compare(mid, keys[r]) < 0) {
                    --r;
                }
                if (l <= r) {
                    TwoArrayQuickSorter.swap(keys, l, r);
                    TwoArrayQuickSorter.swap(values, l, r);
                    ++l;
                    --r;
                }
                if (l > r) break;
            }
            if (original_left < r) {
                this.internalSort(keys, values, original_left, r);
            }
            if (l < original_right) {
                this.internalSort(keys, values, l, original_right);
            }
        }

        private static final void swap(Object[] x, int a, int b) {
            Object t = x[a];
            x[a] = x[b];
            x[b] = t;
        }

        public static class StringComparator
        implements Comparator {
            private boolean fIgnoreCase;

            StringComparator(boolean ignoreCase) {
                this.fIgnoreCase = ignoreCase;
            }

            public int compare(Object left, Object right) {
                return this.fIgnoreCase ? ((String)left).compareToIgnoreCase((String)right) : ((String)left).compareTo((String)right);
            }
        }
    }
}

