/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.handlers.scope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.scope.IScopeFilter;
import org.polarsys.capella.core.transition.common.handlers.scope.IScopeHandler;
import org.polarsys.capella.core.transition.common.handlers.scope.IScopeRetriever;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class DefaultScopeHandler
implements IScopeHandler {
    Collection<IScopeFilter> childsFilters;
    Collection<IScopeRetriever> childsRetrievers;
    protected boolean excluding = true;

    public Collection<EObject> retrieveElements(EObject source, IContext context) {
        LinkedList<EObject> elements = new LinkedList<EObject>();
        if (this.childsRetrievers != null) {
            for (IScopeRetriever retriever : this.childsRetrievers) {
                Collection<? extends EObject> retrievedElements = retriever.retrieveRelatedElements(source, context);
                if (retrievedElements == null) continue;
                elements.addAll(retrievedElements);
            }
        }
        return elements;
    }

    protected boolean isExclusing() {
        return this.excluding;
    }

    public void setFilterExcluding(boolean excluding) {
        this.excluding = excluding;
    }

    @Override
    public boolean isInScope(EObject element, IContext context) {
        Collection<EObject> scope = this.getScope(context);
        return scope != null && scope.contains(element);
    }

    @Override
    public IStatus computeScope(Collection<EObject> bootstrap, IContext context) {
        Collection<EObject> scope = this.computeScopeInternal(bootstrap, context);
        ContextScopeHandlerHelper.getInstance(context).clear("TRANSITION_SCOPE", context);
        ContextScopeHandlerHelper.getInstance(context).addAll("TRANSITION_SCOPE", scope, context);
        return Status.OK_STATUS;
    }

    @Override
    public Collection<EObject> getScope(IContext context) {
        return ContextScopeHandlerHelper.getInstance(context).getCollection("TRANSITION_SCOPE", context);
    }

    protected Collection<EObject> computeScopeInternal(Collection<EObject> bootstrap, IContext context) {
        HashSet<EObject> _agenda = new HashSet<EObject>();
        LinkedList<EObject> agenda = new LinkedList<EObject>();
        HashSet<EObject> visited = new HashSet<EObject>();
        if (bootstrap != null) {
            for (EObject element : bootstrap) {
                if (!this.isValidScopeElement(element, context)) continue;
                agenda.add(element);
            }
        }
        while (!agenda.isEmpty()) {
            EObject currentElement = (EObject)agenda.removeFirst();
            if (currentElement == null || visited.contains(currentElement)) continue;
            visited.add(currentElement);
            _agenda.add(currentElement);
            Collection<EObject> relatedElements = this.retrieveElements(currentElement, context);
            if (relatedElements == null) continue;
            for (EObject relatedElement : relatedElements) {
                if (relatedElement == null || !this.isValidScopeElement(relatedElement, context)) continue;
                agenda.add(relatedElement);
            }
        }
        if (this.childsRetrievers != null) {
            for (IScopeRetriever retriever : this.childsRetrievers) {
                Collection<? extends EObject> retrievedElements = retriever.retrieveSharedElements(context);
                if (retrievedElements == null) continue;
                for (EObject eObject : retrievedElements) {
                    if (eObject == null || !this.isValidScopeElement(eObject, context)) continue;
                    _agenda.add(eObject);
                }
            }
        }
        return _agenda;
    }

    @Override
    public boolean isValidScopeElement(EObject element, IContext context) {
        if (this.excluding) {
            if (this.childsFilters != null) {
                for (IScopeFilter filter : this.childsFilters) {
                    if (filter.isValidScopeElement(element, context)) continue;
                    return false;
                }
            }
            return true;
        }
        if (this.childsFilters != null) {
            for (IScopeFilter filter : this.childsFilters) {
                if (!filter.isValidScopeElement(element, context)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IStatus init(IContext context) {
        if (this.childsFilters != null) {
            for (IScopeFilter filter : this.childsFilters) {
                filter.init(context);
            }
        }
        if (this.childsRetrievers != null) {
            for (IScopeRetriever retriever : this.childsRetrievers) {
                retriever.init(context);
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus dispose(IContext context) {
        if (this.childsFilters != null) {
            for (IScopeFilter filter : this.childsFilters) {
                filter.dispose(context);
            }
        }
        if (this.childsRetrievers != null) {
            for (IScopeRetriever retriever : this.childsRetrievers) {
                retriever.dispose(context);
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    public void addScopeFilter(IScopeFilter filter, IContext context) {
        if (filter != null) {
            if (this.childsFilters == null) {
                this.childsFilters = new ArrayList<IScopeFilter>();
            }
            this.childsFilters.add(filter);
        }
    }

    @Override
    public void addScopeRetriever(IScopeRetriever retriever, IContext context) {
        if (retriever != null) {
            if (this.childsRetrievers == null) {
                this.childsRetrievers = new ArrayList<IScopeRetriever>();
            }
            this.childsRetrievers.add(retriever);
        }
    }
}

