/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;

public class StructureExt {
    public static Component getRootComponent(Structure elementContainer) {
        Component comp = null;
        if (elementContainer != null) {
            EObject container = elementContainer.eContainer();
            if (container instanceof Component) {
                comp = (Component)container;
            } else if (container instanceof Structure) {
                comp = StructureExt.getRootComponent((Structure)container);
            }
        }
        return comp;
    }

    public static ComponentArchitecture getRootComponentArchitecture(Structure elementContainer) {
        ComponentArchitecture compArch = null;
        if (elementContainer != null) {
            EObject container = elementContainer.eContainer();
            if (container instanceof ComponentArchitecture) {
                compArch = (ComponentArchitecture)container;
            } else if (container instanceof Structure) {
                compArch = StructureExt.getRootComponentArchitecture((Structure)container);
            } else if (container instanceof Component) {
                compArch = ComponentExt.getRootComponentArchitecture((Component)container);
            }
        }
        return compArch;
    }

    public static BlockArchitecture getRootBlockArchitecture(Structure modelElement) {
        return BlockArchitectureExt.getRootBlockArchitecture((EObject)modelElement);
    }

    public static List<DataPkg> getDataPkgsFromParentHierarchy(Structure structure) {
        ArrayList<DataPkg> list = new ArrayList<DataPkg>(1);
        if (structure != null) {
            Component parentComp;
            BlockArchitecture compArch = StructureExt.getRootBlockArchitecture(structure);
            if (compArch != null) {
                DataPkg dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture(compArch);
                if (dataPkg != null) {
                    list.add(dataPkg);
                }
                if (compArch instanceof SystemEngineering) {
                    return list;
                }
                list.addAll(DataPkgExt.getDataPkgsFromBlockArchitectureParent(compArch));
            }
            if ((parentComp = StructureExt.getRootComponent(structure)) != null) {
                DataPkg dataPkg = parentComp.getOwnedDataPkg();
                if (dataPkg != null) {
                    list.add(dataPkg);
                }
                list.addAll(DataPkgExt.getDataPkgsFromComponentParent(parentComp));
            }
        }
        return list;
    }

    public static List<Interface> getOwnedInterfacesFromParentHierarchy(Structure classifier) {
        ArrayList<Interface> list = new ArrayList<Interface>(1);
        if (classifier != null) {
            Component parentComp;
            BlockArchitecture compArch = StructureExt.getRootBlockArchitecture(classifier);
            if (compArch != null) {
                list.addAll(InterfacePkgExt.getAllInterfaces(compArch.getOwnedInterfacePkg()));
                if (compArch instanceof SystemEngineering) {
                    return list;
                }
                list.addAll(InterfacePkgExt.getOwnedInterfacesFromBlockArchitectureParent(compArch));
            }
            if ((parentComp = StructureExt.getRootComponent(classifier)) != null) {
                list.addAll(InterfacePkgExt.getAllInterfaces(parentComp.getOwnedInterfacePkg()));
                list.addAll(InterfacePkgExt.getOwnedInterfacesFromComponentParent(parentComp));
            }
        }
        return list;
    }

    public static String getNewStructureName(Structure interfacePkg, EObject container) {
        return String.valueOf(CapellaElementExt.getName((EObject)interfacePkg)) + ' ' + '(' + "from" + ' ' + CapellaElementExt.getName(container) + ')';
    }
}

